//---------------------------------------------------------------------------
// win32x.cpp - a Borland C++Builder front end to some of the
//		functions in the Win32 SDK.
#include <vcl\vcl.h>
#pragma hdrstop
//---------------------------------------------------------------------------
AnsiString GetClassNameX(HWND handle)
/*
	Returns a window's class or empty string if not found
*/
{
	char *buff;
    UINT size;
    AnsiString result = "";
	// error trap
    if (handle==NULL || !IsWindow(handle))	return result;
    // first get required size of string
	#pragma warn -def	// disable warning about buff
	size = GetClassName(handle,buff,0);
	#pragma warn .def	// re-enable warnings
	// if window found and non-empty title
    if (size) {    // then build string and put path in it
    	buff = new char[size];
		GetClassName(handle,buff,size);
		result = AnsiString(buff);
	    // and release character string
	    delete [] buff;
    }
    return result;
}
//---------------------------------------------------------------------------
HWND GetFocusX(void)
/*
	Gets the handle of the window/component which currently has focus.
    Extends the win32 API GetFocus by working for windows owned by a
    different thread.  Returns NULL on failure.

    This code is due to Gregory A. Wolking of PC Magazine (kind of).
*/
{
	HWND result;
    DWORD fgProcessId;
    bool isAttached = false;

    DWORD fgId = GetWindowThreadProcessId(GetForegroundWindow(),&fgProcessId);
    DWORD myId = GetCurrentThreadId();
	// if thread of foreground window not this thread
    if (myId != fgId) {
	    // need to attach input
    	isAttached = AttachThreadInput(myId, fgId, true);
    }
    // now ready to get focus, regardless of which window is in foreground
	result = GetFocus();
    // clean-up
	if (isAttached)	AttachThreadInput(myId, fgId, false);
    return result;
}
//---------------------------------------------------------------------------
AnsiString GetFullPathNameX(AnsiString f)
/*
	Returns the full path and (long) file name from a short/incomplete
    path.  As it stands this routine should be able to handle any number
    of characters up to max(DWORD).
*/
{
	char *buff;
    DWORD size;
    AnsiString result;
    char *filepart;
    // first get required size of string
	#pragma warn -def	// disable warning about buff
	size = GetFullPathName(f.c_str(),0,buff,&filepart);
	#pragma warn .def	// re-enable warnings
    // then build string and put path in it
    buff = new char[size];
	GetFullPathName(f.c_str(),size,buff,&filepart);
	result = AnsiString(buff);
    // and release character string
    delete [] buff;
    return result;
}
/*
//---------------------------------------------------------------------------
// GetLongFileName() - intended to take a filename (which may or may not
// include a path) and convert it to a file/path in which each element of
// the path is in long name format.  this turned out to be a bit harder than
// I expected....
//
// after many travails and searches, the following code was adapted from an
// article on the MSDN library:
//
//      http://premium.microsoft.com/msdn/library/periodic/period97/f1/d3/s245b8.htm
//      Win32 Q & A
//      Jeffrey Richter
//
// thanks, Jeffrey; I was already headed toward this solution, but you saved me
// a few hours of coding and more than a few hairs!
//
// calling parameters:
//      filename - the file path and name of the file for which to retrieve the
//      long filename.
//
// return value:
//      the long filename as an AnsiString. on error, returns original filename.
//
AnsiString GetLongFileName(AnsiString filename)
{
LPSHELLFOLDER psfDesktop = 0;
ULONG chEaten = 0;
LPITEMIDLIST pidlShellItem = 0;
WCHAR szLongPath[_MAX_PATH] = { 0 };
WCHAR szShortPath[_MAX_PATH];
filename.WideChar(szShortPath, sizeof(szShortPath));

// get the desktop folder shell interface
HRESULT hr = ::SHGetDesktopFolder(&psfDesktop);
if (hr != NOERROR) return filename;

// get pidl for the short path
hr = psfDesktop->ParseDisplayName(0, 0, szShortPath, &chEaten,
        &pidlShellItem, 0);

// release the desktop IShellFolder interface
psfDesktop->Release();

// if we failed to parse the filename, return original value
if (hr != NOERROR) return filename;

// so far, so good; get the long filename
bool retval = ::SHGetPathFromIDListW(pidlShellItem, szLongPath);

// free the pidl allocated by ParseDisplayName
LPMALLOC pMalloc = 0;
if (::SHGetMalloc(&pMalloc) == NOERROR) {
        pMalloc->Free(pidlShellItem);
        pMalloc->Release();
        }

// if failed, return original string
if (!retval) return filename;

// everything worked, so return new path
return AnsiString(szLongPath);
}
*/
//---------------------------------------------------------------------------
AnsiString GetWindowsDirectoryX(void)
/*
	Returns the Windows root folder
*/
{
	char *buff;
    UINT size;
    AnsiString result;
    // first get required size of string
	#pragma warn -def	// disable warning about buff
	size = GetWindowsDirectory(buff,0);
	#pragma warn .def	// re-enable warnings
    // then build string and put path in it
    buff = new char[size];
	GetWindowsDirectory(buff,size);
	result = AnsiString(buff);
    // and release character string
    delete [] buff;
    return result;
}
//---------------------------------------------------------------------------
AnsiString GetWindowTextX(HWND handle)
/*
	Returns a window's title or empty string if not found
*/
{
	char *buff;
    UINT size;
    AnsiString result = "";
	// error trap
    if (handle==NULL || !IsWindow(handle))	return result;
    // first get required size of string
	size = GetWindowTextLength(handle);
	// if window found and non-empty title
    if (size++) {    // then build string (increment size for "\0")
    	buff = new char[size];
		GetWindowText(handle,buff,size);
		result = AnsiString(buff);
	    // and release character string
	    delete [] buff;
    }
    return result;
}
//---------------------------------------------------------------------------

