//---------------------------------------------------------------------------
// WinPos v1.0
//
// by Rik Blok
// February 26, 2000
//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#include <stdio.h>
#pragma hdrstop

#include "win32x.h"		// for GetWindowTextX()
//---------------------------------------------------------------------------
USERES("WinPos.res");
USEUNIT("\My Documents\CBuilder\Library\win32x.cpp");
//---------------------------------------------------------------------------
AnsiString globalName;
HWND handle;
typedef enum {MatchAll=0, MatchLeft, MatchRight, MatchMiddle} MatchType;
MatchType MatchPos;

//---------------------------------------------------------------------------
BOOL CALLBACK ListWindows(HWND hWnd, LPARAM lparam)
/*
	EnumWindowsCallback function to compare window.
    Uses global variables and saves window in handle.
*/
{
	// if no window specified then match first window enumerated
	if (globalName.IsEmpty()) {	// empty globalName always matches
    	handle = hWnd;
        return false;	// found, don't continue
    }

    // else, if text to match longer than window title then next
    AnsiString t = GetWindowTextX(hWnd);
    if (globalName.Length() > t.Length())
    	return true;	// not found, continue

    // else, if title perfect match then found
    if (globalName==t) {
		handle = hWnd;
        return false;	// found, don't continue
    }

	// else, if matching middle look for text in caption
    if (MatchPos==MatchMiddle) {
    	if (t.Pos(globalName)>0) {
        	handle = hWnd;
            return false;	// found, don't continue
        } else
        	return true;	// not found, continue
	}

    // else, match left or right
    int index;
    int count;
    switch (MatchPos) {
        case MatchLeft:
			index = 1;
            count = globalName.Length();
            break;
        case MatchRight:
			index = 1 + t.Length() - globalName.Length();
            count = globalName.Length();
    }
	if (globalName==t.SubString(index,count)) {
    	handle = hWnd;
        return false;	// found, don't continue
    } else
    	return true;	// not found, continue
}
//---------------------------------------------------------------------------
HWND FindWindowBA(AnsiString WindowName)
/*
	As FindWindow() but supports wildcard before and/or after text.
    Eg. FindWindowBA("*Notepad");
	Returns first window found matching criteria.
*/
{
	// set global variables before iterating through windows
	// strip off wildcards
    MatchPos = MatchAll;	// default
    if (!WindowName.IsEmpty()) {
    	int last = WindowName.Length();
    	MatchPos = MatchType((WindowName[last]=='*') + 2*(WindowName[1]=='*'));
        if (MatchPos==MatchRight || MatchPos==MatchMiddle)
        	WindowName = WindowName.SubString(2,(last--)-1);
        if (MatchPos==MatchLeft || MatchPos==MatchMiddle)
        	WindowName = WindowName.SubString(1,(last--)-1);
    }
	globalName = WindowName;
    handle = NULL;
    // ok, let's find it!
	EnumWindows((WNDENUMPROC)ListWindows,0);
	return handle;
}
//---------------------------------------------------------------------------//---------------------------------------------------------------------------
void usage(void)
// print usage message
{
	printf("\nWinPos - positions a window specified on the command-line");
	printf("\n");
	printf("\nUsage:");
	printf("\n\tWinPos \"window title\" xul yul [width height]");
    printf("\n");
	printf("\nwhere");
	printf("\n\"window title\" is the caption of the window to switch to");
	printf("\n               (use quotes if title contains space),");
	printf("\nxul and yul are the desired coordinates of the upper left");
	printf("\n            corner of the window,");
	printf("\nwidth (optional) is the desired width of the window, and");
	printf("\nheight (optional) is the desired height of the window.");
	printf("\n");
	printf("\nWildcards \"*\" are accepted at the beginning or end of the title");
	printf("\nto match substrings.");
	printf("\nIf the window is not found, an error code of 1 is returned.");
	printf("\n");
}
//---------------------------------------------------------------------------//---------------------------------------------------------------------------
int main(int argc, char **argv)
{
	if (argc!=4 && argc != 6) {	// must have exactly 3 or 5 parameters
		usage();
		return 1;
	}

	// try to match window title to handle
	AnsiString caption = argv[1];
	FindWindowBA(caption);		// sets global var. handle
	if (handle==NULL) return 1;	// failed, quit

	// try to get xul & yul
	int xul = atoi(argv[2]);
	int yul = atoi(argv[3]);

	// try to get width & height
	int width, height;
	if (argc==6) {
		width = atoi(argv[4]);
		height = atoi(argv[5]);
	}

	// resize?
	UINT uFlags = 0;
	if (argc==4)	uFlags = SWP_NOSIZE;	// don't resize

	SetWindowPos(handle, HWND_TOP, xul,yul, width,height, uFlags);
    SetForegroundWindow(handle);
	return 0;
}
//---------------------------------------------------------------------------
