/*
 * Decompiled with CFR 0.152.
 */
package gcalnotifier;

import gcalnotifier.Config;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class OptionsDlg
extends JDialog {
    private static final long serialVersionUID = 2877L;
    private boolean optionsChanged;
    private JButton cancelBtn;
    private JCheckBox cbQuitIfNoEvents;
    private JCheckBox cbWaitBeforeConnecting;
    private JComboBox comboRefreshPeriod;
    private JTextField edAccountName;
    private JTextField edAccountPwd;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JPanel jPanel1;
    private JButton saveBtn;

    public static final boolean showDlg() {
        try {
            OptionsDlg optionsDlg = new OptionsDlg();
            optionsDlg.setLocationRelativeTo(null);
            optionsDlg.setVisible(true);
            return optionsDlg.isOptionsChanged();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, "Error! " + exception.toString());
            return false;
        }
    }

    public OptionsDlg() {
        super((Frame)null, true);
        this.initComponents();
        this.optionsChanged = false;
    }

    public boolean isOptionsChanged() {
        return this.optionsChanged;
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.saveBtn = new JButton();
        this.cancelBtn = new JButton();
        this.jLabel1 = new JLabel();
        this.edAccountName = new JTextField();
        this.jLabel2 = new JLabel();
        this.edAccountPwd = new JTextField();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.comboRefreshPeriod = new JComboBox();
        this.cbQuitIfNoEvents = new JCheckBox();
        this.cbWaitBeforeConnecting = new JCheckBox();
        this.setDefaultCloseOperation(2);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Options"));
        this.saveBtn.setIcon(new ImageIcon(this.getClass().getResource("/gcalnotifier/calendar16.png")));
        this.saveBtn.setText("Save");
        this.saveBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OptionsDlg.this.saveBtnActionPerformed(actionEvent);
            }
        });
        this.cancelBtn.setText("Cancel");
        this.cancelBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OptionsDlg.this.cancelBtnActionPerformed(actionEvent);
            }
        });
        this.jLabel1.setFont(new Font("Arial", 1, 11));
        this.jLabel1.setText("Account name:");
        this.jLabel1.setToolTipText("Google Calendar account name (full email address) ");
        this.edAccountName.setText("myaccount@gmail.com");
        this.edAccountName.setToolTipText("Google Calendar account name (full email address) ");
        this.jLabel2.setFont(new Font("Arial", 1, 11));
        this.jLabel2.setText("Account password:");
        this.jLabel2.setToolTipText("Google Calendar account password ");
        this.edAccountPwd.setText("mypassword");
        this.edAccountPwd.setToolTipText("Google Calendar account password ");
        this.jLabel3.setFont(new Font("Arial", 1, 11));
        this.jLabel3.setText("Refresh period:");
        this.jLabel3.setToolTipText("The application refreshes the calendar automatically after the given hours elapsed.");
        this.jLabel4.setFont(new Font("Arial", 1, 11));
        this.jLabel4.setText("Quit, if no events:");
        this.jLabel4.setToolTipText("If set to `yes` and NO calendar events exist the application will quit after checking the calendar");
        this.jLabel5.setFont(new Font("Arial", 1, 11));
        this.jLabel5.setText("Wait before first connection:");
        this.jLabel5.setToolTipText("The application waits for approx. 2 minutes before connecting to the calendar. Useful, if your internet connection needs some time to establish.");
        this.comboRefreshPeriod.setModel(new DefaultComboBoxModel<String>(new String[]{"never", "1 hour", "2 hours", "4 hours", "8 hours"}));
        this.comboRefreshPeriod.setToolTipText("The application refreshes the calendar automatically after the given hours elapsed.");
        this.cbQuitIfNoEvents.setToolTipText("If set to `yes` and NO calendar events exist the application will quit after checking the calendar");
        this.cbQuitIfNoEvents.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OptionsDlg.this.cbQuitIfNoEventsActionPerformed(actionEvent);
            }
        });
        this.cbWaitBeforeConnecting.setToolTipText("The application waits for a minute before connecting the calendar. Useful, if internet connection needs some time to establish.");
        GroupLayout groupLayout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel1, GroupLayout.Alignment.LEADING).addComponent(this.jLabel2, GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.jLabel5).addGap(26, 26, 26).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cbWaitBeforeConnecting).addComponent(this.cbQuitIfNoEvents).addGroup(groupLayout.createSequentialGroup().addComponent(this.edAccountPwd, -1, 172, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)).addComponent(this.comboRefreshPeriod, 0, 172, Short.MAX_VALUE).addComponent(this.edAccountName, -2, 172, -2).addGroup(groupLayout.createSequentialGroup().addComponent(this.saveBtn).addGap(18, 18, 18).addComponent(this.cancelBtn))))).addGap(91, 91, 91)).addComponent(this.jLabel4).addComponent(this.jLabel3)).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.edAccountName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.edAccountPwd, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.comboRefreshPeriod, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.cbQuitIfNoEvents)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbWaitBeforeConnecting).addComponent(this.jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 15, Short.MAX_VALUE).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.saveBtn).addComponent(this.cancelBtn))));
        GroupLayout groupLayout2 = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -2, 381, -2));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void saveBtnActionPerformed(ActionEvent actionEvent) {
        String string = this.edAccountName.getText().trim();
        if (string.isEmpty() || !string.contains("@") || !string.contains(".")) {
            JOptionPane.showMessageDialog(this, "Please specify a valid account!", "", 0);
            this.edAccountName.requestFocus();
            return;
        }
        String string2 = this.edAccountPwd.getText().trim();
        if (string2.isEmpty()) {
            JOptionPane.showMessageDialog(this, "Please specify a valid password!", "", 0);
            this.edAccountPwd.requestFocus();
            return;
        }
        String string3 = (String)this.comboRefreshPeriod.getSelectedItem();
        int n = 0;
        try {
            n = Integer.parseInt("" + string3.charAt(0));
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean bl = Config.create(string, string2, n, this.cbQuitIfNoEvents.isSelected(), this.cbWaitBeforeConnecting.isSelected());
        if (bl) {
            this.optionsChanged = true;
            this.dispose();
        } else {
            JOptionPane.showMessageDialog(this, "Failed to create configuration file!", "", 0);
        }
    }

    private void cancelBtnActionPerformed(ActionEvent actionEvent) {
        int n = JOptionPane.showConfirmDialog(this, "Cancelling this dialog will prevent this application connecting to your calendar.\nAre you sure?", "", 0);
        if (n == 0) {
            this.dispose();
        }
    }

    private void cbQuitIfNoEventsActionPerformed(ActionEvent actionEvent) {
    }
}

