/*
 * Decompiled with CFR 0.152.
 */
package gcalnotifier;

import com.google.gdata.client.calendar.CalendarQuery;
import com.google.gdata.client.calendar.CalendarService;
import com.google.gdata.data.DateTime;
import com.google.gdata.data.calendar.CalendarEventEntry;
import com.google.gdata.data.calendar.CalendarEventFeed;
import com.google.gdata.data.extensions.When;
import gcalnotifier.Config;
import gcalnotifier.Misc;
import gcalnotifier.OptionsDlg;
import java.awt.Desktop;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.Timer;

public class GoogleCalendarNotifier {
    private static final String APP_NAME = "W Google Calendar Notifier v0.1";
    private static final String DEV_NAME = "Karoly Kalman";
    private static final String BUILD_DATE = "03/25/2010 15:44";
    private static final File HLP_FILE_NAME = new File("gcalnotifier.html");
    private static URI WWW_GOOGLE_COM = null;
    private TrayIcon trayIcon;
    private String eventsToday;
    private String eventsTodaySum;
    private String eventsTomorrow;
    private String eventsTomorrowSum;
    private String eventsAWeek;
    private String eventsAWeekSum;
    private boolean showNotification;
    private ActionListener taskPerformer;

    private String formatCalendarEventEntry(CalendarEventEntry calendarEventEntry) {
        StringBuilder stringBuilder = new StringBuilder(200);
        List list = calendarEventEntry.getTimes();
        Iterator iterator = list.iterator();
        if (iterator.hasNext()) {
            When when = (When)iterator.next();
            stringBuilder.append(when.getStartTime().toUiString().replace('-', '/'));
            stringBuilder.append(" - ");
        }
        stringBuilder.append(calendarEventEntry.getTitle().getPlainText());
        return stringBuilder.toString();
    }

    private String formatCalendarEventFeed(CalendarEventFeed calendarEventFeed) {
        StringBuilder stringBuilder = new StringBuilder(800);
        List list = calendarEventFeed.getEntries();
        for (CalendarEventEntry calendarEventEntry : list) {
            stringBuilder.append(this.formatCalendarEventEntry(calendarEventEntry));
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    private String getAllEvents() {
        StringBuilder stringBuilder = new StringBuilder(800);
        stringBuilder.append(this.eventsTodaySum);
        stringBuilder.append("\n");
        stringBuilder.append(this.eventsToday);
        stringBuilder.append("\n");
        stringBuilder.append(this.eventsTomorrowSum);
        stringBuilder.append("\n");
        stringBuilder.append(this.eventsTomorrow);
        stringBuilder.append("\n");
        stringBuilder.append(this.eventsAWeekSum);
        stringBuilder.append("\n");
        stringBuilder.append(this.eventsAWeek);
        return stringBuilder.toString();
    }

    private void displayInfoBaloon() {
        String string = this.getAllEvents();
        if (string.length() > 240) {
            string = string.substring(1, 235);
            string = string + "\n<more>";
        }
        this.trayIcon.displayMessage(APP_NAME, string, TrayIcon.MessageType.INFO);
    }

    public void initGUI() {
        try {
            if (SystemTray.isSupported()) {
                SystemTray systemTray = SystemTray.getSystemTray();
                Image image = Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/gcalnotifier/calendar16.png"));
                ActionListener actionListener = new ActionListener(){

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (actionEvent.getSource() == GoogleCalendarNotifier.this.trayIcon) {
                            Misc.showLargeDialog(GoogleCalendarNotifier.this.getAllEvents(), GoogleCalendarNotifier.APP_NAME);
                            return;
                        }
                        try {
                            String string = actionEvent.getActionCommand();
                            int n = Integer.parseInt(string);
                            switch (n) {
                                case 2: {
                                    System.exit(1);
                                    break;
                                }
                                case 3: {
                                    GoogleCalendarNotifier.this.refreshCalendar();
                                    if (!GoogleCalendarNotifier.this.showNotification) break;
                                    GoogleCalendarNotifier.this.displayInfoBaloon();
                                    break;
                                }
                                case 1: {
                                    GoogleCalendarNotifier.this.refreshCalendar();
                                    Misc.showLargeDialog(GoogleCalendarNotifier.this.getAllEvents(), GoogleCalendarNotifier.APP_NAME);
                                    break;
                                }
                                case 5: {
                                    Desktop.getDesktop().open(HLP_FILE_NAME);
                                    break;
                                }
                                case 4: {
                                    Desktop.getDesktop().browse(WWW_GOOGLE_COM);
                                }
                            }
                            if (!string.equals(4)) return;
                        }
                        catch (Exception exception) {
                            JOptionPane.showMessageDialog(null, "Error! " + exception.toString());
                        }
                    }
                };
                PopupMenu popupMenu = new PopupMenu();
                MenuItem menuItem = new MenuItem("Refresh & Show Events");
                menuItem.setActionCommand("1");
                menuItem.addActionListener(actionListener);
                popupMenu.add(menuItem);
                menuItem = new MenuItem("Refresh");
                menuItem.setActionCommand("3");
                menuItem.addActionListener(actionListener);
                popupMenu.add(menuItem);
                menuItem = new MenuItem("Open Manual");
                menuItem.setActionCommand("5");
                menuItem.addActionListener(actionListener);
                popupMenu.add(menuItem);
                menuItem = new MenuItem("Visit Google Calendar");
                menuItem.setActionCommand("4");
                menuItem.addActionListener(actionListener);
                popupMenu.add(menuItem);
                menuItem = new MenuItem("Quit");
                menuItem.setActionCommand("2");
                menuItem.addActionListener(actionListener);
                popupMenu.add(menuItem);
                this.trayIcon = new TrayIcon(image, APP_NAME, popupMenu);
                this.trayIcon.addActionListener(actionListener);
                systemTray.add(this.trayIcon);
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, "Error! " + exception.toString());
        }
    }

    private void refreshCalendar() {
        try {
            Config config = Config.getConfig();
            this.showNotification = false;
            CalendarService calendarService = new CalendarService("GoogleCalendarNotifier-10");
            calendarService.setUserCredentials(config.getAccountName(), config.getAccountPwd());
            URL uRL = new URL("http://www.google.com/calendar/feeds/" + config.getAccountName() + "/private/full");
            Calendar calendar = Calendar.getInstance();
            Calendar calendar2 = Calendar.getInstance();
            calendar2.add(5, 1);
            Calendar calendar3 = Calendar.getInstance();
            calendar3.add(5, 2);
            Calendar calendar4 = Calendar.getInstance();
            calendar4.add(5, 7);
            CalendarQuery calendarQuery = new CalendarQuery(uRL);
            calendarQuery.setMinimumStartTime(DateTime.parseDateTime((String)Misc.dayStart(calendar)));
            calendarQuery.setMaximumStartTime(DateTime.parseDateTime((String)Misc.dayEnd(calendar)));
            CalendarEventFeed calendarEventFeed = (CalendarEventFeed)calendarService.query(calendarQuery, CalendarEventFeed.class);
            int n = calendarEventFeed.getEntries().size();
            if (n > 0) {
                this.showNotification = true;
            }
            this.eventsTodaySum = "Events for today (" + n + ")\n";
            this.eventsToday = this.formatCalendarEventFeed(calendarEventFeed);
            calendarQuery.setMinimumStartTime(DateTime.parseDateTime((String)Misc.dayStart(calendar2)));
            calendarQuery.setMaximumStartTime(DateTime.parseDateTime((String)Misc.dayEnd(calendar2)));
            calendarEventFeed = (CalendarEventFeed)calendarService.query(calendarQuery, CalendarEventFeed.class);
            n = calendarEventFeed.getEntries().size();
            if (n > 0) {
                this.showNotification = true;
            }
            this.eventsTomorrowSum = "Events for tomorrow (" + n + ")\n";
            this.eventsTomorrow = this.formatCalendarEventFeed(calendarEventFeed);
            calendarQuery.setMinimumStartTime(DateTime.parseDateTime((String)Misc.dayStart(calendar3)));
            calendarQuery.setMaximumStartTime(DateTime.parseDateTime((String)Misc.dayEnd(calendar4)));
            calendarEventFeed = (CalendarEventFeed)calendarService.query(calendarQuery, CalendarEventFeed.class);
            n = calendarEventFeed.getEntries().size();
            if (n > 0) {
                this.showNotification = true;
            }
            this.eventsAWeekSum = "Events within 5 days (" + n + ")\n";
            this.eventsAWeek = this.formatCalendarEventFeed(calendarEventFeed);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, "Error! " + exception.toString());
            System.exit(51);
        }
    }

    private void startRefreshThread() {
        try {
            int n = Config.getConfig().getRefreshHours();
            if (n > 0) {
                n = n * 60 * 60 * 1000;
            }
            this.taskPerformer = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    GoogleCalendarNotifier.this.refreshCalendar();
                    GoogleCalendarNotifier.this.displayInfoBaloon();
                }
            };
            new Timer(n, this.taskPerformer).start();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, "Error! " + exception.toString());
        }
    }

    public static void main(String[] stringArray) {
        try {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    try {
                        boolean bl;
                        if (!Config.exists() && !(bl = OptionsDlg.showDlg())) {
                            System.exit(4);
                        }
                        Config config = null;
                        try {
                            config = new Config();
                        }
                        catch (Exception exception) {
                            JOptionPane.showMessageDialog(null, "An error occured while reading the configuration file.Please read the manual and try again!");
                            System.exit(3);
                        }
                        if (config.isWaitBeforeConnecting()) {
                            Thread.sleep(110000L);
                        }
                        GoogleCalendarNotifier googleCalendarNotifier = new GoogleCalendarNotifier();
                        googleCalendarNotifier.initGUI();
                        googleCalendarNotifier.refreshCalendar();
                        if (googleCalendarNotifier.showNotification) {
                            googleCalendarNotifier.displayInfoBaloon();
                        } else if (config.isQuitIfNoEvents()) {
                            System.exit(1);
                        }
                        googleCalendarNotifier.startRefreshThread();
                    }
                    catch (Exception exception) {
                        JOptionPane.showMessageDialog(null, "Error! " + exception.toString());
                        System.exit(50);
                    }
                }
            });
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
    }

    static {
        try {
            WWW_GOOGLE_COM = new URI("http://www.google.com/calendar/");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

