/*
 * Decompiled with CFR 0.152.
 */
package gcalnotifier;

import gcalnotifier.Misc;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.util.Properties;

public class Config {
    private static final String CFG_FILE_NAME = "gcalnotifier.cfg";
    private static final String ACCOUNT_NAME = "AccountName";
    private static final String ACCOUNT_PWD = "AccountPwd";
    private static final String REFRESH_HOURS = "RefreshHours";
    private static final String QUIT_IF_NO_EVENTS = "QuitIfNoEvents";
    private static final String WAIT_BEFORE_CONNECT = "WaitBeforeConnecting";
    private static final String YES = "yes";
    private static final String NO = "no";
    private static final int SHIFT_NUM = 5;
    private static Config self;
    private final String accountName;
    private final String accountPwd;
    private final boolean quitIfNoEvents;
    private final boolean waitBeforeConnecting;
    private final int refreshHours;

    public static final boolean exists() {
        try {
            File file = new File(CFG_FILE_NAME);
            return file.exists();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static final boolean create(String string, String string2, int n, boolean bl, boolean bl2) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(CFG_FILE_NAME)));
            Properties properties = new Properties();
            properties.setProperty(ACCOUNT_NAME, string);
            properties.setProperty(ACCOUNT_PWD, Misc.encryptShift(string2, 5));
            properties.setProperty(REFRESH_HOURS, "" + n);
            String string3 = bl ? YES : NO;
            properties.setProperty(QUIT_IF_NO_EVENTS, string3);
            string3 = bl2 ? YES : NO;
            properties.setProperty(WAIT_BEFORE_CONNECT, string3);
            properties.store(bufferedWriter, "");
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public Config() throws Exception {
        Properties properties = new Properties();
        properties.load(new FileInputStream(CFG_FILE_NAME));
        this.accountName = properties.getProperty(ACCOUNT_NAME, "");
        this.accountPwd = Misc.decryptShift(properties.getProperty(ACCOUNT_PWD, ""), 5);
        String string = properties.getProperty(QUIT_IF_NO_EVENTS, "");
        this.quitIfNoEvents = string.toLowerCase().equals(YES);
        string = properties.getProperty(WAIT_BEFORE_CONNECT, "");
        this.waitBeforeConnecting = string.toLowerCase().equals(YES);
        string = properties.getProperty(REFRESH_HOURS, "0");
        this.refreshHours = Integer.parseInt(string);
        self = this;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public String getAccountPwd() {
        return this.accountPwd;
    }

    public boolean isQuitIfNoEvents() {
        return this.quitIfNoEvents;
    }

    public int getRefreshHours() {
        return this.refreshHours;
    }

    public boolean isWaitBeforeConnecting() {
        return this.waitBeforeConnecting;
    }

    public static Config getConfig() {
        return self;
    }
}

