/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.model.atom;

import com.google.common.collect.Lists;
import com.google.gdata.client.CoreErrorDomain;
import com.google.gdata.client.GDataProtocol;
import com.google.gdata.client.Service;
import com.google.gdata.data.DateTime;
import com.google.gdata.data.IEntry;
import com.google.gdata.data.ILink;
import com.google.gdata.model.Element;
import com.google.gdata.model.ElementCreator;
import com.google.gdata.model.ElementKey;
import com.google.gdata.model.ElementMetadata;
import com.google.gdata.model.MetadataRegistry;
import com.google.gdata.model.QName;
import com.google.gdata.model.ValidationContext;
import com.google.gdata.model.atom.Author;
import com.google.gdata.model.atom.Category;
import com.google.gdata.model.atom.Content;
import com.google.gdata.model.atom.Contributor;
import com.google.gdata.model.atom.Kinds;
import com.google.gdata.model.atom.Link;
import com.google.gdata.model.atom.OtherContent;
import com.google.gdata.model.atom.OutOfLineContent;
import com.google.gdata.model.atom.Person;
import com.google.gdata.model.atom.Source;
import com.google.gdata.model.atom.TextContent;
import com.google.gdata.model.atompub.Control;
import com.google.gdata.model.atompub.Edited;
import com.google.gdata.model.batch.BatchId;
import com.google.gdata.model.batch.BatchInterrupted;
import com.google.gdata.model.batch.BatchOperation;
import com.google.gdata.model.batch.BatchStatus;
import com.google.gdata.model.gd.GdAttributes;
import com.google.gdata.model.gd.Partial;
import com.google.gdata.util.Namespaces;
import com.google.gdata.util.NotModifiedException;
import com.google.gdata.util.ServiceException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Entry
extends Element
implements IEntry {
    public static final ElementKey<Void, Entry> KEY = ElementKey.of(new QName(Namespaces.atomNs, "entry"), Entry.class);
    public static final ElementKey<String, Element> ID = Source.ID;
    public static final ElementKey<DateTime, Element> UPDATED = Source.UPDATED;
    public static final ElementKey<DateTime, Element> PUBLISHED = ElementKey.of(new QName(Namespaces.atomNs, "published"), DateTime.class, Element.class);
    public static final ElementKey<String, TextContent> TITLE = Source.TITLE;
    public static final ElementKey<String, TextContent> RIGHTS = Source.RIGHTS;
    public static final ElementKey<String, TextContent> SUMMARY = ElementKey.of(new QName(Namespaces.atomNs, "summary"), String.class, TextContent.class);
    protected EntryState state;

    public static void registerMetadata(MetadataRegistry registry) {
        if (registry.isRegistered(KEY)) {
            return;
        }
        registry.build(PUBLISHED);
        registry.build(SUMMARY);
        ElementCreator builder = registry.build(KEY).setCardinality(ElementMetadata.Cardinality.MULTIPLE);
        builder.addAttribute(GdAttributes.ETAG);
        builder.addAttribute(GdAttributes.KIND);
        builder.addAttribute(GdAttributes.FIELDS);
        builder.addElement(ID);
        builder.addElement(PUBLISHED);
        builder.addElement(UPDATED);
        builder.addElement(Edited.KEY);
        builder.addElement(Control.KEY);
        builder.addElement(Category.KEY);
        builder.addElement(TITLE);
        builder.addElement(SUMMARY);
        builder.addElement(RIGHTS);
        builder.addElement(Content.KEY).adapt("text", TextContent.KEY).adapt("other", OtherContent.KEY).adapt("out-of-line", OutOfLineContent.KEY);
        builder.addElement(Link.KEY);
        builder.addElement(Author.KEY);
        builder.addElement(Contributor.KEY);
        builder.addElement(Source.KEY);
        builder.addElement(BatchId.KEY);
        builder.addElement(BatchInterrupted.KEY);
        builder.addElement(BatchOperation.KEY);
        builder.addElement(BatchStatus.KEY);
        Partial.registerMetadata(registry);
        TextContent.registerMetadata(registry);
        OtherContent.registerMetadata(registry);
        OutOfLineContent.registerMetadata(registry);
    }

    public Entry() {
        this((ElementKey<?, ? extends Entry>)KEY);
    }

    protected Entry(ElementKey<?, ? extends Entry> key) {
        super(key);
        this.state = new EntryState();
    }

    protected Entry(ElementKey<?, ? extends Entry> key, Entry source) {
        super(key, source);
        this.state = source.state;
    }

    @Override
    public String getId() {
        return this.getElementValue(ID);
    }

    @Override
    public void setId(String v) {
        if (v != null && "-".equals(v)) {
            throw new IllegalArgumentException("Entry.id must not be equal to '-'.");
        }
        this.setElement(ID, v == null ? null : new Element(ID).setTextValue(v));
    }

    @Override
    public String getVersionId() {
        return this.state.versionId;
    }

    @Override
    public void setVersionId(String v) {
        this.state.versionId = v;
    }

    @Override
    public String getEtag() {
        return this.getAttributeValue(GdAttributes.ETAG);
    }

    @Override
    public void setEtag(String v) {
        this.setAttributeValue(GdAttributes.ETAG, (Object)v);
    }

    @Override
    public String getKind() {
        return this.getAttributeValue(GdAttributes.KIND);
    }

    @Override
    public void setKind(String v) {
        this.setAttributeValue(GdAttributes.KIND, (Object)v);
    }

    @Override
    public String getSelectedFields() {
        return this.getAttributeValue(GdAttributes.FIELDS);
    }

    @Override
    public void setSelectedFields(String v) {
        this.setAttributeValue(GdAttributes.FIELDS, (Object)v);
    }

    @Override
    public DateTime getPublished() {
        return this.getElementValue(PUBLISHED);
    }

    @Override
    public void setPublished(DateTime v) {
        if (v != null && v.getTzShift() == null) {
            throw new IllegalArgumentException("Entry.published must have a timezone.");
        }
        this.setElement(PUBLISHED, v == null ? null : new Element(PUBLISHED).setTextValue(v));
    }

    @Override
    public DateTime getUpdated() {
        return this.getElementValue(UPDATED);
    }

    @Override
    public void setUpdated(DateTime v) {
        if (v != null && v.getTzShift() == null) {
            throw new IllegalArgumentException("Entry.updated must have a timezone.");
        }
        this.setElement(UPDATED, v == null ? null : new Element(UPDATED).setTextValue(v));
    }

    @Override
    public DateTime getEdited() {
        return this.getElementValue(Edited.KEY);
    }

    @Override
    public void setEdited(DateTime v) {
        if (v != null && v.getTzShift() == null) {
            throw new IllegalArgumentException("Entry.edited must have a timezone.");
        }
        this.setElement(Edited.KEY, (Element)(v == null ? null : new Edited(v)));
    }

    public Set<Category> getCategories() {
        return this.getElementSet(Category.KEY);
    }

    public void addCategory(Category v) {
        this.addElement(Category.KEY, (Element)v);
    }

    public void clearCategories() {
        this.removeElement(Category.KEY);
    }

    @Override
    public TextContent getTitle() {
        return this.getElement(TITLE);
    }

    public void setTitle(TextContent v) {
        this.setElement(TITLE, (Element)v);
    }

    @Override
    public TextContent getSummary() {
        return this.getElement(SUMMARY);
    }

    public void setSummary(TextContent v) {
        this.setElement(SUMMARY, (Element)v);
    }

    public TextContent getRights() {
        return this.getElement(RIGHTS);
    }

    public void setRights(TextContent v) {
        this.setElement(RIGHTS, (Element)v);
    }

    @Override
    public Content getContent() {
        return this.getElement(Content.KEY);
    }

    public void setContent(Content v) {
        this.setElement(Content.KEY, (Element)v);
    }

    public void removeContent() {
        this.removeElement(Content.KEY);
    }

    public TextContent getTextContent() {
        Content content = this.getContent();
        if (content == null) {
            return null;
        }
        if (!(content instanceof TextContent)) {
            throw new IllegalStateException("Content object is not a TextContent");
        }
        return (TextContent)content;
    }

    public String getPlainTextContent() {
        TextContent content = this.getTextContent();
        return content == null ? null : content.getPlainText();
    }

    public List<Link> getLinks() {
        return this.getElements(Link.KEY);
    }

    public void addLink(Link v) {
        this.addElement(Link.KEY, (Element)v);
    }

    @Override
    public Link addLink(String rel, String type, String href) {
        try {
            Link link = new Link(rel, type, new URI(href));
            this.addLink(link);
            return link;
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public boolean removeLink(Link link) {
        return this.removeElement(Link.KEY, link);
    }

    @Override
    public void removeLinks() {
        this.removeElement(Link.KEY);
    }

    public List<Person> getAuthors() {
        return this.getElements(Author.KEY);
    }

    public void addAuthor(Person v) {
        this.addElement(Author.KEY, (Element)v);
    }

    public boolean removeAuthor(Person v) {
        return this.removeElement(Author.KEY, v);
    }

    public void clearAuthors() {
        this.removeElement(Author.KEY);
    }

    public List<Person> getContributors() {
        return this.getElements(Contributor.KEY);
    }

    public void addContributor(Person v) {
        this.addElement(Contributor.KEY, (Element)v);
    }

    public boolean removeContributor(Person v) {
        return this.removeElement(Contributor.KEY, v);
    }

    public void clearContributors() {
        this.removeElement(Contributor.KEY);
    }

    public Source getSource() {
        return this.getElement(Source.KEY);
    }

    public void setSource(Source v) {
        this.setElement(Source.KEY, (Element)v);
    }

    public void setDraft(Boolean v) {
        Control control = null;
        if (Boolean.TRUE.equals(v)) {
            control = new Control();
            control.setDraft(true);
        }
        this.setElement(Control.KEY, (Element)control);
    }

    public boolean isDraft() {
        Control control = this.getControl();
        return control != null && control.isDraft();
    }

    public Control getControl() {
        return this.getElement(Control.KEY);
    }

    public Entry setControl(Control value) {
        this.setElement(Control.KEY, (Element)value);
        return this;
    }

    public boolean hasControl() {
        return this.hasElement(Control.KEY);
    }

    @Override
    public void setService(Service s) {
        this.state.service = s;
    }

    public Service getService() {
        return this.state.service;
    }

    @Override
    public boolean getCanEdit() {
        return this.state.canEdit;
    }

    @Override
    public void setCanEdit(boolean v) {
        this.state.canEdit = v;
    }

    @Override
    public Link getLink(String rel, String type) {
        for (Link link : this.getLinks()) {
            if (!link.matches(rel, type)) continue;
            return link;
        }
        return null;
    }

    public List<Link> getLinks(String relToMatch, String typeToMatch) {
        ArrayList<Link> result = new ArrayList<Link>();
        for (Link link : this.getLinks()) {
            if (!link.matches(relToMatch, typeToMatch)) continue;
            result.add(link);
        }
        return result;
    }

    @Override
    public void removeLinks(String relToMatch, String typeToMatch) {
        ArrayList toRemove = Lists.newArrayList();
        for (Link link : this.getLinks()) {
            if (!link.matches(relToMatch, typeToMatch)) continue;
            toRemove.add(link);
        }
        for (Link link : toRemove) {
            this.removeLink(link);
        }
    }

    public void addHtmlLink(String htmlUri, String lang, String title) {
        Link link = new Link();
        link.setRel("alternate");
        link.setType(ILink.Type.HTML);
        link.setHref(htmlUri);
        if (lang != null) {
            link.setHrefLang(lang);
        }
        if (title != null) {
            link.setTitle(title);
        }
        this.addLink(link);
    }

    @Override
    public Link getSelfLink() {
        Link selfLink = this.getLink("self", ILink.Type.ATOM);
        return selfLink;
    }

    @Override
    public Link getEditLink() {
        Link editLink = this.getLink("edit", ILink.Type.ATOM);
        return editLink;
    }

    @Override
    public Link getMediaEditLink() {
        Link mediaLink = this.getLink("edit-media", null);
        return mediaLink;
    }

    @Override
    public Link getResumableEditMediaLink() {
        Link resumableEditMediaLink = this.getLink("http://schemas.google.com/g/2005#resumable-edit-media", null);
        return resumableEditMediaLink;
    }

    public Link getHtmlLink() {
        Link htmlLink = this.getLink("alternate", ILink.Type.HTML);
        return htmlLink;
    }

    public Entry getSelf() throws IOException, ServiceException {
        if (this.state.service == null) {
            throw new ServiceException(CoreErrorDomain.ERR.entryNotAssociated);
        }
        Link selfLink = this.getSelfLink();
        if (selfLink == null) {
            throw new UnsupportedOperationException("Entry cannot be retrieved");
        }
        URL entryUrl = selfLink.getHrefUri().toURL();
        try {
            String etag = this.getEtag();
            if (etag != null) {
                return (Entry)this.state.service.getEntry(entryUrl, this.getClass(), etag);
            }
            return (Entry)this.state.service.getEntry(entryUrl, this.getClass(), this.getEdited() != null ? this.getEdited() : this.getUpdated());
        }
        catch (NotModifiedException e) {
            return this;
        }
    }

    public Entry update() throws IOException, ServiceException {
        if (this.state.service == null) {
            throw new ServiceException(CoreErrorDomain.ERR.entryNotAssociated);
        }
        Link editLink = this.getEditLink();
        if (editLink == null) {
            throw new UnsupportedOperationException("Entry cannot be updated");
        }
        URL editUrl = editLink.getHrefUri().toURL();
        return this.state.service.update(editUrl, this);
    }

    public void delete() throws IOException, ServiceException {
        if (this.state.service == null) {
            throw new ServiceException(CoreErrorDomain.ERR.entryNotAssociated);
        }
        Link editLink = this.getEditLink();
        if (editLink == null) {
            throw new UnsupportedOperationException("Entry cannot be deleted");
        }
        URI editUrl = editLink.getHrefUri();
        String etag = this.getEtag();
        this.state.service.delete(editUrl, GDataProtocol.isWeakEtag(etag) ? null : etag);
    }

    @Override
    protected Element narrow(ElementMetadata<?, ?> metadata, ValidationContext vc) {
        String term = Kinds.getElementKind(this);
        if (term != null) {
            return this.adapt(this, metadata, term);
        }
        return super.narrow(metadata, vc);
    }

    protected static class EntryState {
        public String versionId;
        public Service service;
        public boolean canEdit = true;

        protected EntryState() {
        }
    }
}

