/*============================================================================*
 * REXX command: cdx - Change directory (extended).
 *
 * (C)Copyright IBM Corporation, 1991.                           Brian E. Yoder
 *
 * This program is a loose adaptation of the AIX 'cd' command.  It is an
 * extended version of OS/2's CD command.  See CDX.DOC file for information.
 *
 * The 'cdir' command is required within the current path.
 *
 * The performance isn't snappy -- AIX shell scripts, although admittedly
 * arcane in syntax, are absolutely astonishingly blindingly fast when
 * compared to REXX/BATCH files on OS/2.
 *
 * 04/30/91 - Created for OS/2.
 * 04/30/91 - Initial version 1.0.
 *============================================================================*/
 "@echo off"

/*----------------------------------------------------------------------------*
 * Store first argument: d:path of new directory
 *----------------------------------------------------------------------------*/
 parse arg newdir .

/*----------------------------------------------------------------------------*
 * Create a private queue.  Be sure it has nothing in it.
 *----------------------------------------------------------------------------*/
 rc=rxqueue("delete", cdir_q)
 qname=rxqueue("create", cdir_q)
 oldq=rxqueue("set", qname)

/*----------------------------------------------------------------------------*
 * Run the 'cdir' command.  It will put a line on the queue as follows:
 *    newpath  newdrive
 *
 *    The name of the c:path to change to is 'newpath'.  The (optional)
 *    drive to change to is 'newdrive'.
 *
 * If cdir fails, it sends no output to stdout.
 *----------------------------------------------------------------------------*/
 cmd = "cdir" newdir "| rxqueue cdir_q /fifo"
 cmd

/*----------------------------------------------------------------------------*
 * Get the output from the queue
 *----------------------------------------------------------------------------*/
 if queued() then
 do
    parse pull cdirout
    parse value cdirout with newpath newdrive

    "cd" newpath
    newdrive
    return(0)
 end

/*----------------------------------------------------------------------------*
 * If we got here, then 'cdir' sent nothing to stdout, so an error occurred.
 *----------------------------------------------------------------------------*/
 return(2)
