/*-------------------------------------------
  tclock.h
      KAZUBON  1997-1999
---------------------------------------------*/

#define _WIN32_IE 0x0300

#include <windows.h>
#include <windowsx.h>
#include <mmsystem.h>
#include <shlobj.h>
#include "resource.h"

// ^C֐p
#define malloc(s) GlobalAllocPtr(GHND,(s))
#define free(p) GlobalFreePtr(p);
int atoi(const char *p);
int _strnicmp(const char* d, const char* s, size_t n);
int _stricmp(const char* d, const char* s);

// main.c
void MyHelp(HWND hDlg, int id);

// PROPSHEET.C
void MyPropertySheet(void);

// alarm.c
void InitAlarm(void);
void CheckAlarm(HWND hwnd, SYSTEMTIME* st);
void EndAlarm(void);
BOOL PlayFile(HWND hwnd, char *fname, DWORD dwLoops);
void StopFile(void);
void OnMCINotify(HWND hwnd);
void GetFileAndOption(const char* command, char* fname, char* opt);
BOOL ExecFile(HWND hwnd, char* command);

// alarmday.c
int SetAlarmDay(HWND hDlg, int n);

// pageformat.c
void InitFormat(void);
void CreateFormat(char* s, int* checks);

// pagemouse.c
void OnDropFiles(HWND hwnd, HDROP hdrop);
void OnClick(HWND hwnd, UINT message, int fwKeys, int x, int y);

// deskcal.c
BOOL ExecDeskcal(HWND hwnd);
BOOL ExecFile(HWND hwnd, char* command);
void OnDeskcalTimer(HWND hwnd);
void InitWatchWallpaper(void);
void EndWatchWallpaper(void);
void CheckWallpaper(HWND hwnd, SYSTEMTIME* pt);

// timer.c
void DialogTimer(HWND hwnd);
void CheckTimer(HWND hwnd, SYSTEMTIME* st);
void EndTimer(void);
int OnQueryTimerInfo(HWND hwndSrc, HWND hwndDst, int num);
void StopTimer(HWND hwnd, int n);

// sntp.c
BOOL InitSyncTime(HWND hwnd);
void InitSyncTimeSetting(void);
void EndSyncTime(HWND hwnd);
void OnTimerSNTP(HWND hwnd, SYSTEMTIME* st);
void StartSyncTime(HWND hwndParent, char* pServer, int nto);
BOOL IsRASAPI(void);

// utl.c
int atox(const char *p);
void add_title(char *path, char* titile);
void del_title(char *path);
int ext_cmp(char *fname, char *ext);
void parse(char *dst, char *src, int n);
void parsechar(char *dst, char *src, char ch, int n);
void str0cat(char* dst, const char* src);
char* MyString(UINT id);
int MyMessageBox(HWND hwnd, char* msg, char* title, UINT uType, UINT uBeep);
int GetLocaleInfoWA(int ilang, LCTYPE LCType, char* dst, int n);
DWORDLONG M32x32to64(DWORD a, DWORD b);
void SetForegroundWindow98(HWND hwnd);
void WriteDebug(char* s);
int GetMyRegStr(char* section, char* entry, char* val, int cbData,
	char* defval);
LONG GetMyRegLong(char* section, char* entry, LONG defval);
LONG GetRegLong(HKEY rootkey, char*subkey, char* entry, LONG defval);
int GetRegStr(HKEY rootkey, char*subkey, char* entry,
	char* val, int cbData, char* defval);
BOOL SetMyRegStr(char* subkey, char* entry, char* val);
BOOL SetRegStr(HKEY rootkey, char* subkey, char* entry, char* val);
BOOL SetMyRegLong(char* subkey, char* entry, DWORD val);
BOOL DelMyReg(char* subkey, char* entry);
BOOL DelMyRegKey(char* subkey);

// O[oϐ
HANDLE hInst;   //CX^Xnh
HWND hwndMain;
HWND hwndClock; // ṽEBhE
HWND hwndSheet; //vpeBV[g
HWND hDlgTimer; //^C}[_CAO
HWND hwndSNTP;     // for synchronizing time
HWND hwndSNTPLog;  // for SNTP Log
HICON hIconTClock;
char mydir[MAX_PATH]; //EXÊfBNg
HICON hIconPlay, hIconStop, hIconDel;
extern BOOL bPlayingNonstop;

// TCDLL.DLLAPI
void WINAPI HookStart(HWND hwnd);
void WINAPI HookEnd(void);
int WINAPI CopyToShareBuf(const char* src);

// Macros

#define EnableDlgItem(hDlg,id,b) EnableWindow(GetDlgItem((hDlg),(id)),(b))
#define ShowDlgItem(hDlg,id,b) ShowWindow(GetDlgItem((hDlg),(id)),(b)?SW_SHOW:SW_HIDE)
#define SendPSChanged(hDlg) SendMessage(GetParent(hDlg),PSM_CHANGED,(WPARAM)(hDlg),0)

#define CBAddString(hDlg,id,lParam) SendDlgItemMessage((hDlg),(id),CB_ADDSTRING,0,(lParam))
#define CBDeleteString(hDlg,id, i) SendDlgItemMessage((hDlg),(id),CB_DELETESTRING,(i),0)
#define CBFindString(hDlg,id,s) SendDlgItemMessage((hDlg),(id),CB_FINDSTRING,0,(LPARAM)(s))
#define CBFindStringExact(hDlg,id,s) SendDlgItemMessage((hDlg),(id),CB_FINDSTRINGEXACT,0,(LPARAM)(s))
#define CBGetCount(hDlg,id) SendDlgItemMessage((hDlg),(id),CB_GETCOUNT,0,0)
#define CBGetCurSel(hDlg,id) SendDlgItemMessage((hDlg),(id),CB_GETCURSEL,0,0)
#define CBGetItemData(hDlg,id,i) SendDlgItemMessage((hDlg),(id),CB_GETITEMDATA,(i),0)
#define CBGetLBText(hDlg,id,i,s) SendDlgItemMessage((hDlg),(id),CB_GETLBTEXT,(i),(LPARAM)(s))
#define CBInsertString(hDlg,id,i,s) SendDlgItemMessage((hDlg),(id),CB_INSERTSTRING,(i),(LPARAM)(s))
#define CBResetContent(hDlg,id) SendDlgItemMessage((hDlg),(id),CB_RESETCONTENT,0,0)
#define CBSetCurSel(hDlg,id,i) SendDlgItemMessage((hDlg),(id),CB_SETCURSEL,(i),0)
#define CBSetItemData(hDlg,id,i,lParam) SendDlgItemMessage((hDlg),(id),CB_SETITEMDATA,(i),(lParam))

// A[p\
typedef struct _tagAlarmStruct
{
	BOOL bAlarm;
	int hour;
	int minute;
	char fname[1024];
	BOOL bHour12;
	BOOL bRepeat;
	BOOL bBlink;
	int days;
} ALARMSTRUCT;
typedef ALARMSTRUCT* PALARMSTRUCT;

