/*-------------------------------------------
@PROPSHEET.C
@@ݒpvpeBV[g̕\
@@KAZUBON 1997-1998
---------------------------------------------*/

#include "tclock.h"

int CALLBACK PropSheetProc(HWND hDlg, UINT uMsg, LPARAM  lParam);
LRESULT CALLBACK SubclassProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam);
void SetMyDialgPos(HWND hwnd);

//evpeBy[Wp_CAOvV[W
BOOL CALLBACK PageColorProc(HWND, UINT, WPARAM, LPARAM);
BOOL CALLBACK PageFormatProc(HWND, UINT, WPARAM, LPARAM);
BOOL CALLBACK PageAlarmProc(HWND, UINT, WPARAM, LPARAM);
BOOL CALLBACK PageMouseProc(HWND, UINT, WPARAM, LPARAM);
BOOL CALLBACK PageTaskbarProc(HWND, UINT, WPARAM, LPARAM);
BOOL CALLBACK PageSNTPProc(HWND, UINT, WPARAM, LPARAM);
BOOL CALLBACK PageMiscProc(HWND, UINT, WPARAM, LPARAM);
BOOL CALLBACK PageAboutProc(HWND, UINT, WPARAM, LPARAM);

void SetPropSheetPos(HWND hwnd);

static WNDPROC oldWndProc; //ȑÕEBhEvV[W̕ۑ
static int startpage = 0;  //ŏɕ\y[W

/*-------------------------------------------
@vpeBV[g̕\
---------------------------------------------*/
void MyPropertySheet(void)
{
	PROPSHEETPAGE psp[8];
	PROPSHEETHEADER psh;
	DLGPROC PageProc[8] = { PageColorProc, PageFormatProc,
		PageAlarmProc, PageMouseProc, PageTaskbarProc, PageSNTPProc,
		PageMiscProc, PageAboutProc };
	int i;
	
	if(hwndSheet && IsWindow(hwndSheet))
	{
		SetForegroundWindow98(hwndSheet); return;
	}
	
	//vpeBy[W̐ݒ
	for(i = 0; i < 8; i++)
	{
		memset(&psp[i], 0, sizeof(PROPSHEETPAGE));
	    psp[i].dwSize = sizeof(PROPSHEETPAGE);
		psp[i].dwFlags = PSP_HASHELP;
		psp[i].hInstance = hInst;
		psp[i].pszTemplate = MAKEINTRESOURCE(IDD_PAGECOLOR + i);
		psp[i].pfnDlgProc = PageProc[i];
	}
	
	//vpeBV[g̐ݒ
	memset(&psh, 0, sizeof(PROPSHEETHEADER));
	psh.dwSize = sizeof(PROPSHEETHEADER);
	//ACR\AppspgA
	//[hXAR[obNgAwv
	psh.dwFlags = PSH_USEICONID | PSH_PROPSHEETPAGE |
		PSH_MODELESS | PSH_USECALLBACK | PSH_HASHELP;
	psh.hInstance = hInst;
	psh.pszIcon = MAKEINTRESOURCE(IDI_ICON1);
	psh.pszCaption = MyString(IDS_PROPERTY);
	psh.nPages = 8;
	psh.nStartPage = startpage;
	psh.ppsp = psp;
	psh.pfnCallback = PropSheetProc;

	//vpeBV[g̕\
	//EBhEnhO[oϐɕۑ
	hwndSheet = (HWND)PropertySheet(&psh);
	SetForegroundWindow98(hwndSheet);
}

/*-------------------------------------------
@vpeBV[gpR[obN
---------------------------------------------*/
int CALLBACK PropSheetProc(HWND hDlg, UINT uMsg, LPARAM  lParam)
{
	LONG style;
	
	if(uMsg == PSCB_INITIALIZED)
	{
		//uHv{^
		style = GetWindowLong(hDlg, GWL_EXSTYLE);
		style ^= WS_EX_CONTEXTHELP;
		SetWindowLong(hDlg, GWL_EXSTYLE, style);
		
		//TuNX
		oldWndProc = (WNDPROC)SetWindowLong(hDlg, GWL_WNDPROC,
			(LONG)SubclassProc);
		
		SendMessage(hDlg, WM_SETICON, ICON_BIG, (LPARAM)hIconTClock);
	}
	return 0;
}

/*--------------------------------------------------
@vpeBV[gpTuNXEBhEvV[W
----------------------------------------------------*/
LRESULT CALLBACK SubclassProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	LRESULT l;
	
	switch(message)
	{
		case WM_SHOWWINDOW: // EBhEʂ̒S
			SetMyDialgPos(hwnd);
			return 0;
	}
	
	//ftHg̏
	l = CallWindowProc(oldWndProc, hwnd, message, wParam, lParam);
	
	switch(message)
	{
		case WM_COMMAND:
		{
			WORD id;
			id = LOWORD(wParam);
			//OKALZ{^ŕ
			if(id == IDOK || id == IDCANCEL)
			{
				MyHelp(hwnd, -1);
				startpage = SendMessage(
					(HWND)SendMessage(hwnd, PSM_GETTABCONTROL, 0, 0),
					TCM_GETCURSEL, 0, 0);
				if(startpage < 0) startpage = 0;
				DestroyWindow(hwnd);
				hwndSheet = NULL;
			}
			//uOKvuXVv{^ŎvXV
			if(id == IDOK || id == 0x3021)
			{
				InitAlarm();
				InitWatchWallpaper();
				PostMessage(hwndClock, WM_USER+1, 0, 0);
			}
			break;
		}
		//u~v{^ŃLZ
		case WM_SYSCOMMAND:
		{
			if((wParam & 0xfff0) == SC_CLOSE)
				PostMessage(hwnd, WM_COMMAND, IDCANCEL, 0);
			break;
		}
	}
	return l;
}

/*------------------------------------------------
@_CAO̕\ʒu
--------------------------------------------------*/
void SetMyDialgPos(HWND hwnd)
{
	HWND hwndTray;
	RECT rc, rcTray;
	int wscreen, hscreen, wProp, hProp;
	int x, y;

	GetWindowRect(hwnd, &rc);
	wProp = rc.right - rc.left;
	hProp = rc.bottom - rc.top;
	
	wscreen = GetSystemMetrics(SM_CXSCREEN);
	hscreen = GetSystemMetrics(SM_CYSCREEN);
	
	hwndTray = FindWindow("Shell_TrayWnd", NULL);
	if(hwndTray == NULL) return;
	GetWindowRect(hwndTray, &rcTray);
	if(rcTray.right - rcTray.left > 
		rcTray.bottom - rcTray.top)
	{
		x = wscreen - wProp - 32;
		if(rcTray.top < hscreen / 2)
			y = rcTray.bottom + 2;
		else
			y = rcTray.top - hProp - 32;
		if(y < 0) y = 0;
	}
	else
	{
		y = hscreen - hProp - 2;
		if(rcTray.left < wscreen / 2)
			x = rcTray.right + 2;
		else
			x = rcTray.left - wProp - 2;
		if(x < 0) x = 0;
	}

	MoveWindow(hwnd, x, y, wProp, hProp, FALSE);
}

