/*-------------------------------------------
  pagemouse.c
@@u}EXvvpeBy[W
@@KAZUBON 1997-1998
---------------------------------------------*/

#include "tclock.h"

static void OnInit(HWND hDlg);
static void OnApply(HWND hDlg);
static void OnSansho(HWND hDlg, WORD id);
static void OnDropFilesChange(HWND hDlg);
static void OnLClickChange(HWND hDlg);

static char section[] = "Mouse";
static char* entryclick[] = { "LClick", "LDblClick",
	"RClick", "RDblClick",
	"MClick", "MDblClick" };

/*------------------------------------------------
@u}EXvy[Wp_CAOvV[W
--------------------------------------------------*/
BOOL CALLBACK PageMouseProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch(message)
	{
		case WM_INITDIALOG:
			OnInit(hDlg);
			return TRUE;
		case WM_COMMAND:
		{
			WORD id, code;
			id = LOWORD(wParam); code = HIWORD(wParam);
			// ut@C̃hbvv
			if(id == IDC_DROPFILES &&
				code == CBN_SELCHANGE)
				OnDropFilesChange(hDlg);
			// u{^v
			else if(id == IDC_LCLICK &&
				code == CBN_SELCHANGE)
				OnLClickChange(hDlg);
			// GfBbg{bNXύX
			else if((id == IDC_DROPFILESAPP || id == IDC_LCLKFILE ||
				id == IDC_TOOLTIP) && code == EN_CHANGE)
				SendPSChanged(hDlg);
			// _uNbN/NbN
			else if(id == IDC_RADLDBLCLK || id == IDC_RADLCLK)
				SendPSChanged(hDlg);
			// u...v
			else if(id == IDC_DROPFILESAPPSANSHO ||
				id == IDC_LCLKFILESANSHO)
				OnSansho(hDlg, id);
			return TRUE;
		}
		case WM_NOTIFY:
			switch(((NMHDR *)lParam)->code)
			{
				case PSN_APPLY: OnApply(hDlg); break;
				case PSN_HELP: MyHelp(GetParent(hDlg), 4); break;
			}
			return TRUE;
	}
	return FALSE;
}

/*------------------------------------------------
@y[W̏
--------------------------------------------------*/
void OnInit(HWND hDlg)
{
	char s[1024];
	int button;
	int n;
	BOOL b;
	int i;
	HWND hDlgPage;
	HFONT hfont;

	for(i = IDS_NONE; i <= IDS_MOVETO; i++)
		CBAddString(hDlg, IDC_DROPFILES, (LPARAM)MyString(i));
	CBSetCurSel(hDlg, IDC_DROPFILES, 
		GetMyRegLong(section, "DropFiles", 0));
	GetMyRegStr(section, "DropFilesApp", s, 1024, "");
	SetDlgItemText(hDlg, IDC_DROPFILESAPP, s);
	
	button = 1;
	if(GetMyRegLong(section, entryclick[0], -1) >= 0) button = 0;
	if(GetMyRegLong(section, entryclick[1], -1) >= 0) button = 1;
	CheckDlgButton(hDlg, (button==1)?IDC_RADLDBLCLK:IDC_RADLCLK, TRUE);
	
	for(i = IDS_PROPDATE; i <= IDS_OPENFILE; i++)
		CBAddString(hDlg, IDC_LCLICK, (LPARAM)MyString(i));

	n = GetMyRegLong(section, entryclick[button], 0);
	if(n == 100) n = 7;
	CBSetCurSel(hDlg, IDC_LCLICK, n);
	
	b = GetMyRegLong("", "StartButtonHide", FALSE);
	if(b) b = GetMyRegLong("", "StartMenuClock", FALSE);
	// u^XNo[vy[ẂuvɃX^[gj[v
	// `FbNĂ邩ǂ
	hDlgPage = GetTopWindow(GetParent(hDlg));
	while(hDlgPage)
	{
		if(GetDlgItem(hDlgPage, IDC_STARTBTNHIDE))
		{
			b = IsDlgButtonChecked(hDlgPage, IDC_STARTBTNHIDE);
			if(b) b = IsDlgButtonChecked(hDlgPage, IDC_STARTMENUCLOCK);
			break;
		}
		hDlgPage = GetNextWindow(hDlgPage, GW_HWNDNEXT);
	}
	for(i = IDC_LABLCLK; i <= IDC_LCLKFILESANSHO; i++)
		EnableDlgItem(hDlg, i, !b);

	OnDropFilesChange(hDlg);
	OnLClickChange(hDlg);

	hfont = (HFONT)GetStockObject(DEFAULT_GUI_FONT);
	if(hfont)
		SendDlgItemMessage(hDlg, IDC_TOOLTIP, WM_SETFONT, (WPARAM)hfont, 0);
	
	GetMyRegStr("Tooltip", "Tooltip", s, 1024, "");
	if(s[0] == 0) strcpy(s, "\"TClock\" LDATE");
	SetDlgItemText(hDlg, IDC_TOOLTIP, s);
}

/*------------------------------------------------
@XV
--------------------------------------------------*/
void OnApply(HWND hDlg)
{
	char s[1024];
	char entryfile[20];
	int button;
	int n;
	
	n = CBGetCurSel(hDlg, IDC_DROPFILES);
	SetMyRegLong("", "DropFiles", n > 0);
	SetMyRegLong(section, "DropFiles", n);
	GetDlgItemText(hDlg, IDC_DROPFILESAPP, s, 1024);
	SetMyRegStr(section, "DropFilesApp", s);
	
	button = 1;
	if(IsDlgButtonChecked(hDlg, IDC_RADLCLK)) button = 0;
	
	n = CBGetCurSel(hDlg, IDC_LCLICK);
	if(n == 7) n = 100;
	SetMyRegLong(section, entryclick[button], n);
	DelMyReg(section, entryclick[(button == 0)?1:0]);
	
	GetDlgItemText(hDlg, IDC_LCLKFILE, s, 1024);
	if(n == 100)
	{
		strcpy(entryfile, entryclick[button]);
		strcat(entryfile, "File");
		SetMyRegStr(section, entryfile, s);
	}
	else if(n == 6)
	{
		SetMyRegStr(section, "ClipFormat", s);
	}
	
	GetDlgItemText(hDlg, IDC_TOOLTIP, s, 1024);
	SetMyRegStr("Tooltip", "Tooltip", s);
}

/*------------------------------------------------
@ut@C̃hbvv
--------------------------------------------------*/
void OnDropFilesChange(HWND hDlg)
{
	int i, n;
	n = CBGetCurSel(hDlg, IDC_DROPFILES);
	SetDlgItemText(hDlg, IDC_LABDROPFILESAPP,
		MyString(n >= 3?IDS_LABFOLDER:IDS_LABPROGRAM));
	for(i = IDC_LABDROPFILESAPP; i <= IDC_DROPFILESAPPSANSHO; i++)
		ShowDlgItem(hDlg, i, (2 <= n && n <= 4));
	SendPSChanged(hDlg);
}

/*------------------------------------------------
@u{^v
--------------------------------------------------*/
void OnLClickChange(HWND hDlg)
{
	char s[1024];
	int n;
	n = CBGetCurSel(hDlg, IDC_LCLICK);
	ShowDlgItem(hDlg, IDC_LABLCLKFILE, (n == 6||n == 7));
	ShowDlgItem(hDlg, IDC_LCLKFILE, (n == 6||n == 7));
	ShowDlgItem(hDlg, IDC_LCLKFILESANSHO, n == 7);
	if(n == 6)
	{
		GetMyRegStr(section, "ClipFormat", s, 1024, "");
		if(s[0] == 0) GetMyRegStr("", "Format", s, 1024, "");
		SetDlgItemText(hDlg, IDC_LCLKFILE, s);
		SetDlgItemText(hDlg, IDC_LABLCLKFILE, MyString(IDS_FORMAT));
	}
	else if(n == 7)
	{
		char entryfile[20];
		int button;
		
		button = 1;
		if(IsDlgButtonChecked(hDlg, IDC_RADLCLK)) button = 0;
		strcpy(entryfile, entryclick[button]);
		strcat(entryfile, "File");
		GetMyRegStr(section, entryfile, s, 1024, "");
		SetDlgItemText(hDlg, IDC_LCLKFILE, s);
		SetDlgItemText(hDlg, IDC_LABLCLKFILE, MyString(IDS_FILE));
	}
	SendPSChanged(hDlg);
}

/*------------------------------------------------
@u...v@t@C̎Q
--------------------------------------------------*/
void OnSansho(HWND hDlg, WORD id)
{
	int n;
	OPENFILENAME ofn;
	char filter[80];
	char fname[MAX_PATH], ftitle[MAX_PATH], initdir[MAX_PATH];
	
	if(id == IDC_DROPFILESAPPSANSHO)
	{
		n = CBGetCurSel(hDlg, IDC_DROPFILES);
		if(n >= 3)
		{
			BROWSEINFO bi;
			LPITEMIDLIST pidl;
			memset(&bi, 0, sizeof(BROWSEINFO));
			bi.hwndOwner = hDlg;
			bi.ulFlags = BIF_RETURNONLYFSDIRS;
			pidl = SHBrowseForFolder(&bi);
			if(pidl)
			{
				SHGetPathFromIDList(pidl, fname);
				SetDlgItemText(hDlg, id - 1, fname);
				PostMessage(hDlg, WM_NEXTDLGCTL, 1, FALSE);
				SendPSChanged(hDlg);
			}
			return;
		}
	}
	
	memset(&ofn, '\0', sizeof(OPENFILENAME));
	
	filter[0] = 0;
	if(id == IDC_DROPFILESAPPSANSHO)
	{
		str0cat(filter, MyString(IDS_PROGRAMFILE));
		str0cat(filter, "*.exe");
	}
	str0cat(filter, MyString(IDS_ALLFILE));
	str0cat(filter, "*.*");
	
	GetDlgItemText(hDlg, id - 1, initdir, MAX_PATH);
	if(initdir[0])
	{
		WIN32_FIND_DATA fd;
		HANDLE hfind;
		hfind = FindFirstFile(initdir, &fd);
		if(hfind != INVALID_HANDLE_VALUE)
		{
			FindClose(hfind);
			del_title(initdir);
		}
		else strcpy(initdir, mydir);
	}
	else strcpy(initdir, mydir);
	
	fname[0] = 0;
	ofn.lStructSize = sizeof(OPENFILENAME);
	ofn.hwndOwner = hDlg;
	ofn.hInstance = hInst;
	ofn.lpstrFilter = filter;
	ofn.lpstrFile= fname;
	ofn.nMaxFile = MAX_PATH;
	ofn.lpstrFileTitle = ftitle;
	ofn.nMaxFileTitle = MAX_PATH;
	ofn.lpstrInitialDir = initdir;
	ofn.Flags = OFN_HIDEREADONLY|OFN_EXPLORER|OFN_FILEMUSTEXIST;
	
	if(!GetOpenFileName(&ofn)) return;
	
	SetDlgItemText(hDlg, id - 1, ofn.lpstrFile);
	PostMessage(hDlg, WM_NEXTDLGCTL, 1, FALSE);
	SendPSChanged(hDlg);
}

/*------------------------------------------------
@t@ChbvꂽƂ̎ۂ̏
--------------------------------------------------*/
void OnDropFiles(HWND hwnd, HDROP hdrop)
{
	char fname[MAX_PATH], sname[MAX_PATH];
	char app[1024];
	SHFILEOPSTRUCT shfos;
	char *buf, *p;
	int i, num;
	int nType;
	
	nType = GetMyRegLong(section, "DropFiles", 0);
	
	num = DragQueryFile(hdrop, (UINT)-1, NULL, 0);
	if(num <= 0) return;
	buf = malloc(num*MAX_PATH);
	if(buf == NULL) return;
	p = buf;
	for(i = 0; i < num; i++)
	{
		DragQueryFile(hdrop, i, fname, MAX_PATH);
		if(nType == 1 || nType == 3 || nType == 4)  // ݔARs[Aړ
		{                             // '\0'ŋ؂ꂽt@C
			strcpy(p, fname); p += strlen(p) + 1;
		}
		else if(nType == 2) //vOŊJF
		{                   //Xy[Xŋ؂ꂽZt@C
			if(num > 1) GetShortPathName(fname, sname, MAX_PATH);
			else strcpy(sname, fname);
			strcpy(p, sname);
			p += strlen(p);
			if(num > 1 && i < num - 1) { *p = ' '; p++; }
		}
	}
	*p = 0;
	DragFinish(hdrop);
	
	GetMyRegStr(section, "DropFilesApp", app, 1024, "");
	
	if(nType == 1 || nType == 3 || nType == 4)  // ݔARs[Aړ
	{
		memset(&shfos, 0, sizeof(SHFILEOPSTRUCT));
		shfos.hwnd = NULL;
		if(nType == 1) shfos.wFunc = FO_DELETE;
		else if(nType == 3) shfos.wFunc = FO_COPY;
		else if(nType == 4) shfos.wFunc = FO_MOVE;
		shfos.pFrom = buf;
		if(nType == 3 || nType == 4) shfos.pTo = app;
		shfos.fFlags = FOF_ALLOWUNDO|FOF_NOCONFIRMATION;
		SHFileOperation(&shfos);
	}
	else if(nType == 2) //t@CŊJ
	{
		char command[MAX_PATH*2];
		
		strcpy(command, app);
		strcat(command, " ");
		strcat(command, buf);
		ExecFile(hwnd, command);
	}
	free(buf);
}

/*------------------------------------------------
@t@C̃NbN/_uNbN̎ۂ̏
--------------------------------------------------*/
void OnClick(HWND hwnd, UINT message, int fwKeys, int x, int y)
{
	HWND hwndTray;
	int nType;
	WPARAM wParam;
	int button;
	BOOL b;

	if(message == WM_LBUTTONDOWN) button = 0;
	else if(message == WM_LBUTTONDBLCLK) button = 1;
	else if(message == WM_RBUTTONDOWN) button = 2;
	else if(message == WM_RBUTTONDBLCLK) button = 3;
	else if(message == WM_MBUTTONDOWN) button = 4;
	else if(message == WM_MBUTTONDBLCLK) button = 5;
	else return;
	
	if(button == 0 || button == 1)
	{
		b = GetMyRegLong("", "StartButtonHide", FALSE);
		if(b) b = GetMyRegLong("", "StartMenuClock", FALSE);
		if(b) return;
	}
	
	nType = GetMyRegLong(section, entryclick[button], -1);
	if(nType < 0)
	{
		if(button == 1)
		{
			if(GetMyRegLong(section, entryclick[0], -1) >= 0)
				return;
			nType = 0;
		}
		else return;
	}

	if(0 <= nType && nType <= 3)
	{
		if(nType == 0) wParam = 408;      // tƎ̃vpeB
		else if(nType == 1) wParam = 506; // Windows̏I
		else if(nType == 2) wParam = 401; // t@Cw肵Ďs
		else if(nType == 3) wParam = 415; // ׂẴEBhEŏ
		hwndTray = FindWindow("Shell_TrayWnd", NULL);
		if(hwndTray) PostMessage(hwndTray, WM_COMMAND, wParam, 0);
	}
	else if(nType == 4)
		StartSyncTime(hwndMain, NULL, 0);
	else if(nType == 5)
		DialogTimer(hwndMain);
	else if(nType == 6)
		PostMessage(hwndClock, WM_COMMAND, 105, 0);
	
	else if(nType == 100) // t@CJ
	{
		char fname[1024];
		char entryfile[20];
		strcpy(entryfile, entryclick[button]);
		strcat(entryfile, "File");
		if(GetMyRegStr(section, entryfile, fname, 1024, "") > 0)
			ExecFile(hwnd, fname);
	}
}
