/*-------------------------------------------
  pagecolor.c
  "Color and Font" page
  KAZUBON 1997-1998
---------------------------------------------*/

#include "tclock.h"

static void OnInit(HWND hDlg);
static void OnApply(HWND hDlg);
static void InitColor(HWND hDlg);
static void OnMeasureItemColorCombo(LPARAM lParam);
static void OnDrawItemColorCombo(LPARAM lParam);
static void OnChooseColor(HWND hDlg, WORD id);
static void InitComboFont(HWND hDlg);
static void SetComboFontSize(HWND hDlg, int bInit);
static HFONT hfontb;  // for IDC_BOLD
static HFONT hfonti;  // for IDC_ITALIC

/*------------------------------------------------
  Dialog procedure
--------------------------------------------------*/
BOOL CALLBACK PageColorProc(HWND hDlg, UINT message,
	WPARAM wParam, LPARAM lParam)
{
	switch(message)
	{
		case WM_INITDIALOG:
			OnInit(hDlg);
			return TRUE;
		case WM_MEASUREITEM:
			OnMeasureItemColorCombo(lParam);
			return TRUE;
		case WM_DRAWITEM:
			OnDrawItemColorCombo(lParam);
			return TRUE;
		case WM_COMMAND:
		{
			WORD id, code;
			id = LOWORD(wParam); code = HIWORD(wParam);
			if((id == IDC_COLBACK || id == IDC_COLBACK2 ||
				id == IDC_COLFORE ||
				id == IDC_FONT || id == IDC_FONTSIZE) &&
				code == CBN_SELCHANGE)
			{
				if(id == IDC_FONT) SetComboFontSize(hDlg, FALSE);
				SendPSChanged(hDlg);
			}
			else if(id == IDC_CHOOSECOLBACK || id == IDC_CHOOSECOLBACK2 ||
				id == IDC_CHOOSECOLFORE)
				OnChooseColor(hDlg, id);
			else if(id == IDC_BOLD || id == IDC_ITALIC)
				SendPSChanged(hDlg);
			else if((id == IDC_CLOCKHEIGHT || id == IDC_CLOCKWIDTH ||
				id == IDC_VERTPOS || id == IDC_LINEHEIGHT)
				&& code == EN_CHANGE)
				SendPSChanged(hDlg);
			return TRUE;
		}
		case WM_NOTIFY:
			switch(((NMHDR *)lParam)->code)
			{
				case PSN_APPLY: OnApply(hDlg); break;
				case PSN_HELP: MyHelp(GetParent(hDlg), 1); break;
			}
			return TRUE;
		case WM_DESTROY:
			DeleteObject(hfontb);
			DeleteObject(hfonti);
			break;
	}
	return FALSE;
}

/*------------------------------------------------
  Initialize
--------------------------------------------------*/
void OnInit(HWND hDlg)
{
	HDC hdc;
	LOGFONT logfont;
	HFONT hfont;
	

	//uwiFvuFv̐ݒ
	InitColor(hDlg);
	
	//256Fȉ̂Ƃ́Au...v{^𖳌
	hdc = CreateIC("DISPLAY", NULL, NULL, NULL);
	if(GetDeviceCaps(hdc, BITSPIXEL) <= 8)
	{
		EnableDlgItem(hDlg, IDC_CHOOSECOLBACK, FALSE);
		EnableDlgItem(hDlg, IDC_CHOOSECOLFORE, FALSE);
	}
	DeleteDC(hdc);
	
	hfont = (HFONT)GetStockObject(DEFAULT_GUI_FONT);
	if(hfont)
		SendDlgItemMessage(hDlg, IDC_FONT, WM_SETFONT, (WPARAM)hfont, 0);
	
	//utHgv̐ݒ
	InitComboFont(hDlg);
	//utHgTCYv̐ݒ
	SetComboFontSize(hDlg, TRUE);
	
	//uBoldvuItalicv̐ݒ
	CheckDlgButton(hDlg, IDC_BOLD,
		GetMyRegLong("", "Bold", FALSE));
	CheckDlgButton(hDlg, IDC_ITALIC, 
		GetMyRegLong("", "Italic", FALSE));

	hfontb = (HFONT)SendMessage(hDlg, WM_GETFONT, 0, 0);
	GetObject(hfontb, sizeof(LOGFONT), &logfont);
	logfont.lfWeight = FW_BOLD;
	hfontb = CreateFontIndirect(&logfont);
	SendDlgItemMessage(hDlg, IDC_BOLD, WM_SETFONT, (WPARAM)hfontb, 0);

	logfont.lfWeight = FW_NORMAL;
	logfont.lfItalic = 1;
	hfonti = CreateFontIndirect(&logfont);
	SendDlgItemMessage(hDlg, IDC_ITALIC, WM_SETFONT, (WPARAM)hfonti, 0);

	SendDlgItemMessage(hDlg, IDC_SPINCHEIGHT, UDM_SETRANGE, 0,
		MAKELONG(32, -32));
	SendDlgItemMessage(hDlg, IDC_SPINCHEIGHT, UDM_SETPOS, 0,
		(int)(short)GetMyRegLong("", "ClockHeight", 0));
	SendDlgItemMessage(hDlg, IDC_SPINCWIDTH, UDM_SETRANGE, 0,
		MAKELONG(32, -32));
	SendDlgItemMessage(hDlg, IDC_SPINCWIDTH, UDM_SETPOS, 0,
		(int)(short)GetMyRegLong("", "ClockWidth", 0));
	SendDlgItemMessage(hDlg, IDC_SPINVPOS, UDM_SETRANGE, 0,
		MAKELONG(32, -32));
	SendDlgItemMessage(hDlg, IDC_SPINVPOS, UDM_SETPOS, 0,
		(int)(short)GetMyRegLong("", "VertPos", 0));
	SendDlgItemMessage(hDlg, IDC_SPINLHEIGHT, UDM_SETRANGE, 0,
		MAKELONG(32, -32));
	SendDlgItemMessage(hDlg, IDC_SPINLHEIGHT, UDM_SETPOS, 0,
		(int)(short)GetMyRegLong("", "LineHeight", 0));
}

/*------------------------------------------------
  Apply
--------------------------------------------------*/
void OnApply(HWND hDlg)
{
	DWORD dw;
	char s[80];
	
	//wiF̕ۑ
	dw = CBGetItemData(hDlg, IDC_COLBACK, CBGetCurSel(hDlg, IDC_COLBACK));
	SetMyRegLong("", "BackColor", dw);
	
//	dw = CBGetItemData(hDlg, IDC_COLBACK2, CBGetCurSel(hDlg, IDC_COLBACK2));
//	SetMyRegLong("", "BackColor2", dw);
	
	//F̕ۑ
	dw = CBGetItemData(hDlg, IDC_COLFORE, CBGetCurSel(hDlg, IDC_COLFORE));
	SetMyRegLong("", "ForeColor", dw);
	
	//tHg̕ۑ
	CBGetLBText(hDlg, IDC_FONT, CBGetCurSel(hDlg, IDC_FONT), s);
	SetMyRegStr("", "Font", s);
	
	//tHgTCY̕ۑ
	if(CBGetCount(hDlg, IDC_FONTSIZE) > 0)
	{
		CBGetLBText(hDlg, IDC_FONTSIZE, CBGetCurSel(hDlg, IDC_FONTSIZE), s);
		SetMyRegLong("", "FontSize", atoi(s));
	}
	else SetMyRegLong("", "FontSize", 9);

	//uBoldvuItalicv̕ۑ
	SetMyRegLong("", "Bold", IsDlgButtonChecked(hDlg, IDC_BOLD));
	SetMyRegLong("", "Italic", IsDlgButtonChecked(hDlg, IDC_ITALIC));
	
	SetMyRegLong("", "ClockHeight",
		SendDlgItemMessage(hDlg, IDC_SPINCHEIGHT, UDM_GETPOS, 0, 0));
	SetMyRegLong("", "ClockWidth",
		SendDlgItemMessage(hDlg, IDC_SPINCWIDTH, UDM_GETPOS, 0, 0));
	SetMyRegLong("", "VertPos",
		SendDlgItemMessage(hDlg, IDC_SPINVPOS, UDM_GETPOS, 0, 0));
	SetMyRegLong("", "LineHeight",
		SendDlgItemMessage(hDlg, IDC_SPINLHEIGHT, UDM_GETPOS, 0, 0));
}

/*------------------------------------------------
@uFvR{{bNX̏
--------------------------------------------------*/
void InitColor(HWND hDlg)
{
	COLORREF col;
	int i, j;
	WORD id;
	//WindowsftHg16F
	int rgb[16][3] = {{0,0,0}, {128,0,0}, {0,128,0}, {128,128,0},
		{0,0,128}, {128,0,128}, {0,128,128}, {192,192,192},
		{128,128,128}, {255,0,0}, {0,255,0}, {255,255,0},
		{0,0,255},{255,0,255}, {0,255,255}, {255,255,255}};
	
	for(i = 0; i < 3; i++)
	{
		if(i == 0) id = IDC_COLBACK;
		else if(i == 1) continue; //id = IDC_COLBACK2;
		else id = IDC_COLFORE;

		for(j = 0; j < 16; j++) //{16F
			CBAddString(hDlg, id,
				RGB(rgb[j][0], rgb[j][1], rgb[j][2]));
		//{^...F
		CBAddString(hDlg, id, 0x80000000|COLOR_3DFACE);
		CBAddString(hDlg, id, 0x80000000|COLOR_3DSHADOW);
		CBAddString(hDlg, id, 0x80000000|COLOR_3DHILIGHT);
		CBAddString(hDlg, id, 0x80000000|COLOR_BTNTEXT);
		
		//R{{bNX̐FI
		if(i == 0)
			col = GetMyRegLong("", "BackColor",
				0x80000000 | COLOR_3DFACE);
		else if(i == 1)
			col = GetMyRegLong("", "BackColor2",
				0x80000000 | COLOR_3DFACE);
		else
			col = GetMyRegLong("", "ForeColor",
				0x80000000 | COLOR_BTNTEXT);
		for(j = 0; j < 20; j++)
		{
			if(col == (COLORREF)CBGetItemData(hDlg, id, j))
				break;
		}
		if(j == 20) //20FɂȂƂ
			CBAddString(hDlg, id, col);
		CBSetCurSel(hDlg, id, j);
	}
}

/*------------------------------------------------
@uFvR{{bNX̍̐ݒ
--------------------------------------------------*/
void OnMeasureItemColorCombo(LPARAM lParam)
{
	LPMEASUREITEMSTRUCT pmis;
	
	pmis = (LPMEASUREITEMSTRUCT)lParam;
	pmis->itemHeight = 7 * HIWORD(GetDialogBaseUnits()) / 8;
}

/*------------------------------------------------
@uFvR{{bNX̃I[i[h[
--------------------------------------------------*/
void OnDrawItemColorCombo(LPARAM lParam)
{
	LPDRAWITEMSTRUCT pdis;
	HBRUSH hbr;
	COLORREF col;
	TEXTMETRIC tm;
	int i, y;
	static char text[4][80];
	
	if(text[0][0] == 0)
	{
		for(i = 0; i < 4; i++)
			strcpy(text[i], MyString(IDS_BTNFACE + i));
	}

	pdis = (LPDRAWITEMSTRUCT)lParam;
	
	col = pdis->itemData;
	if(col & 0x80000000) col = GetSysColor(col & 0x00ffffff);

	switch(pdis->itemAction)
	{
		case ODA_DRAWENTIRE:
		case ODA_SELECT:
		{
			hbr = CreateSolidBrush(col);
			FillRect(pdis->hDC, &pdis->rcItem, hbr);
			DeleteObject(hbr);

			//u{^...v\
			if(16 <= pdis->itemID && pdis->itemID <= 19)
			{
				SetBkMode(pdis->hDC, TRANSPARENT);
				GetTextMetrics(pdis->hDC, &tm);
				if(pdis->itemID == 19)
					SetTextColor(pdis->hDC, RGB(255,255,255));
				else
					SetTextColor(pdis->hDC, RGB(0,0,0));
				y = (pdis->rcItem.bottom - pdis->rcItem.top - tm.tmHeight)/2;
				TextOut(pdis->hDC, pdis->rcItem.left + 4, pdis->rcItem.top + y,
					text[pdis->itemID - 16], strlen(text[pdis->itemID - 16]));
			}
			if(!(pdis->itemState & ODS_FOCUS)) break;
		}
		case ODA_FOCUS:
		{
			if(pdis->itemState & ODS_FOCUS)
				hbr = CreateSolidBrush(0);
			else
				hbr = CreateSolidBrush(col);
			FrameRect(pdis->hDC, &pdis->rcItem, hbr);
			DeleteObject(hbr);
			break;
		}
	}
}

/*------------------------------------------------
@F̑I u...v{^
--------------------------------------------------*/
void OnChooseColor(HWND hDlg, WORD id)
{
	CHOOSECOLOR cc;
	COLORREF col, colarray[16];
	WORD idCombo;
	int i;
	
	idCombo = id - 1;
	
	//ŏɑI΂ĂF
	col = CBGetItemData(hDlg, idCombo, CBGetCurSel(hDlg, idCombo));
	if(col & 0x80000000) col = GetSysColor(col & 0x00ffffff);
	
	for(i = 0; i < 16; i++) colarray[i] = RGB(255,255,255);
	
	memset(&cc, 0, sizeof(CHOOSECOLOR));
	cc.lStructSize = sizeof(CHOOSECOLOR);
	cc.hwndOwner = hDlg;
	cc.hInstance = hInst;
	cc.rgbResult = col;
	cc.lpCustColors = colarray;
	cc.Flags = CC_FULLOPEN | CC_RGBINIT;
	
	if(!ChooseColor(&cc)) return;
	
	for(i = 0; i < 16; i++)
	{
		if(cc.rgbResult == (COLORREF)CBGetItemData(hDlg, idCombo, i))
			break;
	}
	if(i == 16) //{16Fł͂ȂƂ
	{
		if(CBGetCount(hDlg, idCombo) == 20)
			CBAddString(hDlg, idCombo, cc.rgbResult);
		else
			CBSetItemData(hDlg, idCombo, 20, cc.rgbResult);
		i = 20;
	}
	CBSetCurSel(hDlg, idCombo, i);
	
	PostMessage(hDlg, WM_NEXTDLGCTL, 1, FALSE);
	SendPSChanged(hDlg);
}

// QlFVisual C++ 4.x ̃TvWORDPADFORMATBA.CPP

BOOL CALLBACK EnumFontFamExProc(ENUMLOGFONTEX* pelf, 
	NEWTEXTMETRICEX* lpntm, int FontType, LPARAM hCombo);
BOOL CALLBACK EnumSizeProcEx(ENUMLOGFONTEX* pelf, 
	NEWTEXTMETRICEX* lpntm, int FontType, LPARAM hCombo);
int nFontSizes[] = 
	{8, 9, 10, 11, 12, 14, 16, 18, 20, 22, 24, 26, 28, 36, 48, 72};
int logpixelsy;

/*------------------------------------------------
   Initialization of "Font" combo box
--------------------------------------------------*/
void InitComboFont(HWND hDlg)
{
	HDC hdc;
	LOGFONT lf;
	HWND hcombo;
	char s[80];
	int i;
	
	hdc = GetDC(NULL);
	
	// Enumerate fonts and set in the combo box
	memset(&lf, 0, sizeof(LOGFONT));
	hcombo = GetDlgItem(hDlg, IDC_FONT);
	lf.lfCharSet = GetTextCharset(hdc);  // MS UI Gothic, ...
	EnumFontFamiliesEx(hdc, &lf,
		(FONTENUMPROC)EnumFontFamExProc, (LPARAM)hcombo, 0);
	lf.lfCharSet = OEM_CHARSET;   // Small Fonts, Terminal...
	EnumFontFamiliesEx(hdc, &lf,
		(FONTENUMPROC)EnumFontFamExProc, (LPARAM)hcombo, 0);
	lf.lfCharSet = DEFAULT_CHARSET;  // Arial, Courier, Times New Roman, ...
	EnumFontFamiliesEx(hdc, &lf,
		(FONTENUMPROC)EnumFontFamExProc, (LPARAM)hcombo, 0);
	ReleaseDC(NULL, hdc);
	
	if(GetMyRegStr("", "Font", s, 80, "") == 0)
	{
		HFONT hfont;
		hfont = (HFONT)GetStockObject(DEFAULT_GUI_FONT);
		if(hfont)
		{
			GetObject(hfont, sizeof(lf),(LPVOID)&lf);
			strcpy(s, lf.lfFaceName);
		}
	}
	i = CBFindStringExact(hDlg, IDC_FONT, s);
	if(i == LB_ERR) i = 0;
	CBSetCurSel(hDlg, IDC_FONT, i);
}

/*------------------------------------------------
@utHgTCYvR{{bNX̐ݒ
--------------------------------------------------*/
void SetComboFontSize(HWND hDlg, BOOL bInit)
{
	HDC hdc;
	char s[160];
	DWORD size;
	LOGFONT lf;
	int i;

	//ȑOsizeۑ
	if(bInit) // WM_INITDIALOĜƂ
	{
		size = GetMyRegLong("", "FontSize", 9);
		if(size == 0) size = 9;
	}
	else   // IDC_FONTύXꂽƂ
	{
		CBGetLBText(hDlg, IDC_FONTSIZE,
			CBGetCurSel(hDlg, IDC_FONTSIZE), (LPARAM)s);
		size = atoi(s);
	}
	
	CBResetContent(hDlg, IDC_FONTSIZE);
	
	hdc = GetDC(NULL);
	logpixelsy = GetDeviceCaps(hdc, LOGPIXELSY);
	
	// s = tHg
	CBGetLBText(hDlg, IDC_FONT, CBGetCurSel(hDlg, IDC_FONT), (LPARAM)s);
	
	//tHg̃TCY񋓂ăR{{bNXɓ
	memset(&lf, 0, sizeof(LOGFONT));
	strcpy(lf.lfFaceName, s);
	lf.lfCharSet = (BYTE)CBGetItemData(hDlg, IDC_FONT, CBGetCurSel(hDlg, IDC_FONT));
	EnumFontFamiliesEx(hdc, &lf, (FONTENUMPROC)EnumSizeProcEx,
		(LPARAM)GetDlgItem(hDlg, IDC_FONTSIZE), 0);
	
	//EnumFontFamilies(hdc, s,
	//	(FONTENUMPROC)EnumSizeProc, (LPARAM)GetDlgItem(hDlg, IDC_FONTSIZE));
	
	ReleaseDC(NULL, hdc);
	
	// sizeɋ߂̂I
	for(; size > 0; size--)
	{
		wsprintf(s, "%d", size);
		i = CBFindStringExact(hDlg, IDC_FONTSIZE, s);
		if(i != LB_ERR)
		{
			CBSetCurSel(hDlg, IDC_FONTSIZE, i); return;
		}
	}
	CBSetCurSel(hDlg, IDC_FONTSIZE, 0);
}

/*------------------------------------------------
  Callback function for enumerating fonts.
  To set a font name in the combo box.
--------------------------------------------------*/
BOOL CALLBACK EnumFontFamExProc(ENUMLOGFONTEX* pelf, 
	NEWTEXTMETRICEX* lpntm, int FontType, LPARAM hCombo)
{
	// if(FontType & RASTER_FONTTYPE) return 1;
	if(pelf->elfLogFont.lfFaceName[0] != '@' && 
		SendMessage((HWND)hCombo, CB_FINDSTRINGEXACT, 0, 
			(LPARAM)pelf->elfLogFont.lfFaceName) == LB_ERR)
	{
		int index;
		index = SendMessage((HWND)hCombo, CB_ADDSTRING, 0, (LPARAM)pelf->elfLogFont.lfFaceName);
		if(index >= 0)
			SendMessage((HWND)hCombo, CB_SETITEMDATA,
				index, (LPARAM)pelf->elfLogFont.lfCharSet);
	}
	return 1;
}

/*------------------------------------------------
@tHg̗񋓃R[obN
@R{{bNXɃtHgTCY
--------------------------------------------------*/
BOOL CALLBACK EnumSizeProcEx(ENUMLOGFONTEX* pelf, 
	NEWTEXTMETRICEX* lpntm, int FontType, LPARAM hCombo)
{
	char s[80];
	int num, i, count;
	
	//gD[^CvtHg܂́A
	//gD[^CvłX^tHgłȂꍇ
	if((FontType & TRUETYPE_FONTTYPE) || 
		!( (FontType & TRUETYPE_FONTTYPE) || (FontType & RASTER_FONTTYPE) ))
	{
		// nFontSizes̐̂܂ܓ
		for (i = 0; i < 16; i++)
		{
			wsprintf(s, "%d", nFontSizes[i]);
			SendMessage((HWND)hCombo, CB_ADDSTRING, 0, (LPARAM)s);
		}
		return FALSE;
	}
	
	//ȊȌꍇAPPĂ
	num = (lpntm->ntmTm.tmHeight - lpntm->ntmTm.tmInternalLeading) * 72 / logpixelsy;
	count = SendMessage((HWND)hCombo, CB_GETCOUNT, 0, 0);
	for(i = 0; i < count; i++)
	{
		SendMessage((HWND)hCombo, CB_GETLBTEXT, i, (LPARAM)s);
		if(num == atoi(s)) return TRUE;
		else if(num < atoi(s))
		{
			wsprintf(s, "%d", num);
			SendMessage((HWND)hCombo, CB_INSERTSTRING, i, (LPARAM)s);
			return TRUE;
		}
	}
	wsprintf(s, "%d", num);
	SendMessage((HWND)hCombo, CB_ADDSTRING, 0, (LPARAM)s);
	return TRUE;
}

