/*-------------------------------------------
  pagealarm.c
@@uA[vvpeBy[W
@@KAZUBON 1997-1998
---------------------------------------------*/

#include "tclock.h"

static void OnInit(HWND hDlg);
static void OnApply(HWND hDlg);
static void OnChangeAlarm(HWND hDlg);
static void OnChangeTime(HWND hDlg);
static void OnDay(HWND hDlg);
static void OnAlermJihou(HWND hDlg, WORD id);
static void On12Hour(HWND hDlg);
static void OnDelAlarm(HWND hDlg);
static void OnFileChange(HWND hDlg, WORD id);
static void OnTest(HWND hDlg, WORD id);
void OnSanshoAlarm(HWND hDlg, WORD id);
void GetMMFileExts(char* dst);
BOOL IsMMFile(char* fname);

static PALARMSTRUCT pAS = NULL;
static int curAlarm = 0, maxAlarm = 1;
static BOOL bPlaying = FALSE;

BOOL CALLBACK HookProcAlarm(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam);

/*------------------------------------------------
@uA[vy[Wp_CAOvV[W
--------------------------------------------------*/
BOOL CALLBACK PageAlarmProc(HWND hDlg, UINT message,
	WPARAM wParam, LPARAM lParam)
{
	switch(message)
	{
		case WM_INITDIALOG:
			OnInit(hDlg);
			return TRUE;
		case WM_COMMAND:
		{
			WORD id, code;
			id = LOWORD(wParam); code = HIWORD(wParam);
			// A[IR{{bNX
			if(id == IDC_COMBOALARM && code == CBN_SELCHANGE)
			{
				OnChangeAlarm(hDlg);
				SendPSChanged(hDlg);
			}
			//uװт炷vu炷v
			else if(id == IDC_ALARM || id == IDC_JIHOU)
				OnAlermJihou(hDlg, id);
			// AeLXg{bNX
			else if((id == IDC_HOURALARM || id == IDC_MINUTEALARM)
				&& code == EN_CHANGE)
			{
				OnChangeTime(hDlg);
				SendPSChanged(hDlg);
			}
			else if(id == IDC_ALARMDAY) // Day...
			{
				OnDay(hDlg);
			}
			// uTEhveLXg{bNX
			else if((id == IDC_FILEALARM || id == IDC_FILEJIHOU)
				&& code == EN_CHANGE)
			{
				OnFileChange(hDlg, id);
				SendPSChanged(hDlg);
			}
			// u...v
			else if(id == IDC_SANSHOALARM || id == IDC_SANSHOJIHOU)
			{
				OnSanshoAlarm(hDlg, id);
				OnFileChange(hDlg, (WORD)(id - 1));
				SendPSChanged(hDlg);
			}
			// u12Ԑv
			else if(id == IDC_12HOURALARM)
				On12Hour(hDlg);
			// uJԂvu_łv
			else if(id == IDC_REPEATALARM || id == IDC_REPEATJIHOU ||
				id == IDC_BLINKALARM || id == IDC_BLINKJIHOU)
				SendPSChanged(hDlg);
			// u~v
			else if(id == IDC_DELALARM)
				OnDelAlarm(hDlg);
			// TEh̃eXg
			else if(id == IDC_TESTALARM || id == IDC_TESTJIHOU)
				OnTest(hDlg, id);
			return TRUE;
		}
		case WM_NOTIFY:
			switch(((NMHDR *)lParam)->code)
			{
				case PSN_APPLY: OnApply(hDlg); break;
				case PSN_HELP: MyHelp(GetParent(hDlg), 3); break;
			}
			return TRUE;
		case WM_DESTROY:
			if(bPlaying) StopFile(); bPlaying = FALSE;
			if(pAS) free(pAS); pAS = NULL;
			break;
		case MM_MCINOTIFY:
		case MM_WOM_DONE:
			StopFile(); bPlaying = FALSE;
			SendDlgItemMessage(hDlg, IDC_TESTALARM, BM_SETIMAGE, IMAGE_ICON,
				(LPARAM)hIconPlay);
			SendDlgItemMessage(hDlg, IDC_TESTJIHOU, BM_SETIMAGE, IMAGE_ICON,
				(LPARAM)hIconPlay);
			return TRUE;
	}
	return FALSE;
}

/*------------------------------------------------
@y[W̏
--------------------------------------------------*/
void OnInit(HWND hDlg)
{
	char subkey[20], s[1024];
	int i;
	
	maxAlarm = GetMyRegLong("", "AlarmNum", 1);
	if(maxAlarm < 1) maxAlarm = 1;
	pAS = malloc(sizeof(ALARMSTRUCT) * maxAlarm);
	for(i = 0; i < maxAlarm; i++)
	{
		wsprintf(subkey, "Alarm%d", i + 1);
		
		pAS[i].bAlarm = GetMyRegLong(subkey, "Alarm", FALSE);
		pAS[i].hour = GetMyRegLong(subkey, "Hour", 12);
		pAS[i].minute = GetMyRegLong(subkey, "Minute", 0);
		GetMyRegStr(subkey, "File", pAS[i].fname, 1024, "");
		pAS[i].bHour12 = GetMyRegLong(subkey, "Hour12", TRUE);
		pAS[i].bRepeat = GetMyRegLong(subkey, "Repeat", FALSE);
		pAS[i].bBlink = GetMyRegLong(subkey, "Blink", FALSE);
		pAS[i].days = GetMyRegLong(subkey, "Days", 0x7f);
		
		wsprintf(s, "%02d:%02d", pAS[i].hour, pAS[i].minute);
		CBAddString(hDlg, IDC_COMBOALARM, (LPARAM)s);
	}
	CBAddString(hDlg, IDC_COMBOALARM, (LPARAM)MyString(IDS_ADDALARM));
	CBSetCurSel(hDlg, IDC_COMBOALARM, 0);
	
	CheckDlgButton(hDlg, IDC_JIHOU,
		GetMyRegLong("", "Jihou", FALSE));

	GetMyRegStr("", "JihouFile", s, 1024, "");
	SetDlgItemText(hDlg, IDC_FILEJIHOU, s);
	
	CheckDlgButton(hDlg, IDC_REPEATJIHOU,
		GetMyRegLong("", "JihouRepeat", FALSE));
	
	CheckDlgButton(hDlg, IDC_BLINKJIHOU,
		GetMyRegLong("", "JihouBlink", FALSE));
	
	curAlarm = 0;
	OnChangeAlarm(hDlg);
	OnAlermJihou(hDlg, IDC_JIHOU);
	
	SendDlgItemMessage(hDlg, IDC_TESTALARM, BM_SETIMAGE, IMAGE_ICON,
		(LPARAM)hIconPlay);
	OnFileChange(hDlg, IDC_FILEALARM);
	SendDlgItemMessage(hDlg, IDC_TESTJIHOU, BM_SETIMAGE, IMAGE_ICON,
		(LPARAM)hIconPlay);
	OnFileChange(hDlg, IDC_FILEJIHOU);
	
	SendDlgItemMessage(hDlg, IDC_DELALARM, BM_SETIMAGE, IMAGE_ICON,
		(LPARAM)hIconDel);
	
	bPlaying = FALSE;
}

/*------------------------------------------------
@XV
--------------------------------------------------*/
void OnApply(HWND hDlg)
{
	char subkey[10], s[1024];
	int i, n;
	
	n = CBGetCurSel(hDlg, IDC_COMBOALARM);
	pAS[n].bAlarm = IsDlgButtonChecked(hDlg, IDC_ALARM);
	pAS[n].hour = 
		SendDlgItemMessage(hDlg, IDC_SPINHOUR, UDM_GETPOS, 0, 0);
	pAS[n].minute =
		SendDlgItemMessage(hDlg, IDC_SPINMINUTE, UDM_GETPOS, 0, 0);
	GetDlgItemText(hDlg, IDC_FILEALARM, pAS[n].fname, MAX_PATH);
	pAS[n].bHour12 = IsDlgButtonChecked(hDlg, IDC_12HOURALARM);
	pAS[n].bRepeat = IsDlgButtonChecked(hDlg, IDC_REPEATALARM);
	pAS[n].bBlink = IsDlgButtonChecked(hDlg, IDC_BLINKALARM);
	
	for(i = 0; i < maxAlarm; i++)
	{
		wsprintf(subkey, "Alarm%d", i + 1);
		SetMyRegLong(subkey, "Alarm", pAS[i].bAlarm);
	
		SetMyRegLong(subkey, "Hour", pAS[i].hour);
		SetMyRegLong(subkey, "Minute", pAS[i].minute);
		
		SetMyRegStr(subkey, "File", pAS[i].fname);
	
		SetMyRegLong(subkey, "Hour12", pAS[i].bHour12);
		SetMyRegLong(subkey, "Repeat", pAS[i].bRepeat);
		SetMyRegLong(subkey, "Blink", pAS[i].bBlink);
		SetMyRegLong(subkey, "Days", pAS[i].days);
	}
	SetMyRegLong("", "AlarmNum", maxAlarm);

	SetMyRegLong("", "Jihou",
		IsDlgButtonChecked(hDlg, IDC_JIHOU));
	
	GetDlgItemText(hDlg, IDC_FILEJIHOU, s, 1024);
	SetMyRegStr("", "JihouFile", s);
	
	SetMyRegLong("", "JihouRepeat",
		IsDlgButtonChecked(hDlg, IDC_REPEATJIHOU));
	SetMyRegLong("", "JihouBlink",
		IsDlgButtonChecked(hDlg, IDC_BLINKJIHOU));
}

/*------------------------------------------------
@A[pf[^Rg[ɐݒ
--------------------------------------------------*/
void OnChangeAlarm(HWND hDlg)
{
	int n;
	
	n = CBGetCurSel(hDlg, IDC_COMBOALARM);
	if(n > maxAlarm) return;
	
	if(n == maxAlarm)
	{
		PALARMSTRUCT pASOld;
		pASOld = pAS;
		pAS = malloc(sizeof(ALARMSTRUCT) * (maxAlarm+1));
		memcpy(pAS, pASOld, sizeof(ALARMSTRUCT) * maxAlarm);
		free(pASOld);
		pAS[n].bAlarm = FALSE;
		pAS[n].hour = 12;
		pAS[n].minute = 0;
		pAS[n].fname[0] = 0;
		pAS[n].bHour12 = TRUE;
		pAS[n].bRepeat = FALSE;
		pAS[n].bBlink = FALSE;
		pAS[n].days = 0x7f;
		CBDeleteString(hDlg, IDC_COMBOALARM, n);
		CBAddString(hDlg, IDC_COMBOALARM, (LPARAM)"12:00");
		CBAddString(hDlg, IDC_COMBOALARM, (LPARAM)MyString(IDS_ADDALARM));
		CBSetCurSel(hDlg, IDC_COMBOALARM, n);
		maxAlarm++;
	}
	
	if(n != curAlarm)
	{
		pAS[curAlarm].bAlarm = IsDlgButtonChecked(hDlg, IDC_ALARM);
		pAS[curAlarm].hour = 
			SendDlgItemMessage(hDlg, IDC_SPINHOUR, UDM_GETPOS, 0, 0);
		pAS[curAlarm].minute =
			SendDlgItemMessage(hDlg, IDC_SPINMINUTE, UDM_GETPOS, 0, 0);
		GetDlgItemText(hDlg, IDC_FILEALARM, pAS[curAlarm].fname, MAX_PATH);
		pAS[curAlarm].bHour12 = IsDlgButtonChecked(hDlg, IDC_12HOURALARM);
		pAS[curAlarm].bRepeat = IsDlgButtonChecked(hDlg, IDC_REPEATALARM);
		pAS[curAlarm].bBlink = IsDlgButtonChecked(hDlg, IDC_BLINKALARM);
	}
	
	CheckDlgButton(hDlg, IDC_ALARM, pAS[curAlarm].bAlarm);
	
	SendDlgItemMessage(hDlg, IDC_SPINHOUR, UDM_SETRANGE, 0,
		MAKELONG(23, 0));
	SendDlgItemMessage(hDlg, IDC_SPINHOUR, UDM_SETPOS, 0,
		pAS[n].hour);
	
	SendDlgItemMessage(hDlg, IDC_SPINMINUTE, UDM_SETRANGE, 0,
		MAKELONG(59, 0));
	SendDlgItemMessage(hDlg, IDC_SPINMINUTE, UDM_SETPOS, 0,
		pAS[n].minute);
	
	SetDlgItemText(hDlg, IDC_FILEALARM, pAS[n].fname);

	CheckDlgButton(hDlg, IDC_12HOURALARM, pAS[n].bHour12);
	CheckDlgButton(hDlg, IDC_REPEATALARM, pAS[n].bRepeat);
	CheckDlgButton(hDlg, IDC_BLINKALARM, pAS[n].bBlink);
	
	EnableDlgItem(hDlg, IDC_DELALARM, (maxAlarm >= 2));

	OnAlermJihou(hDlg, IDC_ALARM);
	On12Hour(hDlg);

	curAlarm = n;
}

/*------------------------------------------------
@A̕ύX
--------------------------------------------------*/
void OnChangeTime(HWND hDlg)
{
	int n, hour, minute;
	char s[20];

	n = CBGetCurSel(hDlg, IDC_COMBOALARM);
	
	hour = SendDlgItemMessage(hDlg, IDC_SPINHOUR, UDM_GETPOS, 0, 0);
	minute = SendDlgItemMessage(hDlg, IDC_SPINMINUTE, UDM_GETPOS, 0, 0);
	
	wsprintf(s, "%02d:%02d", hour, minute);
	CBDeleteString(hDlg, IDC_COMBOALARM, n);
	CBInsertString(hDlg, IDC_COMBOALARM, n, (LPARAM)s);
	CBSetCurSel(hDlg, IDC_COMBOALARM, n);
}

/*------------------------------------------------
  "Day..."
--------------------------------------------------*/
void OnDay(HWND hDlg)
{
	int n;
	
	n = SetAlarmDay(hDlg, pAS[curAlarm].days);
	if(n != pAS[curAlarm].days)
	{
		pAS[curAlarm].days = n;
		SendPSChanged(hDlg);
	}
}

/*------------------------------------------------
@uװт炷vu炷v
--------------------------------------------------*/
void OnAlermJihou(HWND hDlg, WORD id)
{
	int s, e, i;
	BOOL b;

	if(id == IDC_ALARM)
	{
		s = IDC_LABTIMEALARM; e = IDC_BLINKALARM;
	}
	else
	{
		s = IDC_LABSOUNDJIHOU; e = IDC_BLINKJIHOU;
	}

	b = IsDlgButtonChecked(hDlg, id);
	for(i = s; i <= e; i++)	EnableDlgItem(hDlg, i, b);

	if(id == IDC_ALARM)
		OnFileChange(hDlg, IDC_FILEALARM);
	else
		OnFileChange(hDlg, IDC_FILEJIHOU);
	
	SendPSChanged(hDlg);
}

/*------------------------------------------------
@u...v@TEht@C̎Q
--------------------------------------------------*/
void OnSanshoAlarm(HWND hDlg, WORD id)
{
	OPENFILENAME ofn;
	char filter[1024], mmfileexts[1024];
	char fname[MAX_PATH], ftitle[MAX_PATH], initdir[MAX_PATH];
	
	memset(&ofn, '\0', sizeof(OPENFILENAME));
	
	filter[0] = filter[1] = 0;
/*
	str0cat(filter, MyString(IDS_SOUNDFILE));
	str0cat(filter, "*.wav");
*/
	str0cat(filter, MyString(IDS_MMFILE));
	GetMMFileExts(mmfileexts);
	str0cat(filter, mmfileexts);
	str0cat(filter, MyString(IDS_ALLFILE));
	str0cat(filter, "*.*");
	
	GetDlgItemText(hDlg, id - 1, initdir, MAX_PATH);
	if(initdir[0] == 0 || /* ext_cmp(initdir, "wav") == 0)
		ofn.nFilterIndex = 1;
	else if(*/ IsMMFile(initdir)) ofn.nFilterIndex = 1;
	else ofn.nFilterIndex = 2;

	if(initdir[0])
	{
		WIN32_FIND_DATA fd;
		HANDLE hfind;
		hfind = FindFirstFile(initdir, &fd);
		if(hfind != INVALID_HANDLE_VALUE)
		{
			FindClose(hfind);
			del_title(initdir);
		}
		else strcpy(initdir, mydir);
	}
	else strcpy(initdir, mydir);
	
	fname[0] = 0;
	ofn.lStructSize = sizeof(OPENFILENAME);
	ofn.hwndOwner = hDlg;
	ofn.hInstance = hInst;
	ofn.lpstrFilter = filter;
	ofn.lpstrFile= fname;
	ofn.nMaxFile = MAX_PATH;
	ofn.lpstrFileTitle = ftitle;
	ofn.nMaxFileTitle = MAX_PATH;
	ofn.lpstrInitialDir = initdir;
	ofn.lpfnHook = HookProcAlarm;
	ofn.lpTemplateName = MAKEINTRESOURCE(IDD_TESTSOUND);
	ofn.Flags = OFN_HIDEREADONLY|OFN_EXPLORER|OFN_FILEMUSTEXIST|
		OFN_ENABLEHOOK| OFN_ENABLETEMPLATE;
	
	if(!GetOpenFileName(&ofn)) return;
	
	SetDlgItemText(hDlg, id - 1, ofn.lpstrFile);
	PostMessage(hDlg, WM_NEXTDLGCTL, 1, FALSE);
}

/*------------------------------------------------
@u12Ԑv
--------------------------------------------------*/
void On12Hour(HWND hDlg)
{
	WORD h, u, l;
	
	h = (WORD)SendDlgItemMessage(hDlg, IDC_SPINHOUR, UDM_GETPOS, 0, 0);
	if(h > 23) h = 23;
	if(h <  0) h = 0;
	
	//Xs{^Rg[̍őlƍŏl̐ݒ
	u = 23; l = 0;
	if(IsDlgButtonChecked(hDlg, IDC_12HOURALARM))
	{
		if(h > 12) h -= 12;
		if(h == 0) h = 12;
		u = 12; l = 1;
	}
	SendDlgItemMessage(hDlg, IDC_SPINHOUR, UDM_SETPOS, 0, h);
	SendDlgItemMessage(hDlg, IDC_SPINHOUR, UDM_SETRANGE, 0,
		MAKELONG(u, l));
	SendPSChanged(hDlg);
}

/*------------------------------------------------
@A[폜
--------------------------------------------------*/
void OnDelAlarm(HWND hDlg)
{
	int n;
	PALARMSTRUCT pASOld;
	
	if(maxAlarm < 2) return;
	
	n = CBGetCurSel(hDlg, IDC_COMBOALARM);
	
	pASOld = pAS;
	pAS = malloc(sizeof(ALARMSTRUCT) * (maxAlarm-1));

	if(n > 0) memcpy(pAS, pASOld, sizeof(ALARMSTRUCT) * n);
	if(n < maxAlarm - 1)
		memcpy((pAS + n), (pASOld + (n+1)),
			sizeof(ALARMSTRUCT) * (maxAlarm - n - 1));
	maxAlarm--;
	free(pASOld);

	PostMessage(hDlg, WM_NEXTDLGCTL, 1, FALSE);
	CBDeleteString(hDlg, IDC_COMBOALARM, n);
	if(n > 0) { n--; curAlarm--; }
	CBSetCurSel(hDlg, IDC_COMBOALARM, n);
	OnChangeAlarm(hDlg);
}

/*------------------------------------------------
@PLAY/STOP{^̗L/
--------------------------------------------------*/
void OnFileChange(HWND hDlg, WORD id)
{
	char fname[MAX_PATH];
	BOOL b = FALSE;

	GetDlgItemText(hDlg, id, fname, MAX_PATH);
	if(IsWindowEnabled(GetDlgItem(hDlg, id)))
		b = TRUE;
	EnableDlgItem(hDlg, id + 3, b);
	
	EnableDlgItem(hDlg,
		(id==IDC_FILEALARM)?IDC_REPEATALARM:IDC_REPEATJIHOU,
		b?IsMMFile(fname):FALSE);
}

/*------------------------------------------------
@TEhPLAY/STOP
--------------------------------------------------*/
void OnTest(HWND hDlg, WORD id)
{
	char fname[MAX_PATH];
	
	GetDlgItemText(hDlg, id - 3, fname, MAX_PATH);
	if(fname[0] == 0) return;

	if((HICON)SendDlgItemMessage(hDlg, id, BM_GETIMAGE, IMAGE_ICON, 0)
		== hIconPlay)
	{
		if(PlayFile(hDlg, fname, 0))
		{
			SendDlgItemMessage(hDlg, id, BM_SETIMAGE, IMAGE_ICON,
				(LPARAM)hIconStop);
			InvalidateRect(GetDlgItem(hDlg, id), NULL, FALSE);
			bPlaying = TRUE;
		}
	}
	else
	{
		StopFile();
		bPlaying = FALSE;
	}
}

/*------------------------------------------------
@R_CAÕtbNvV[W
@QlFVisual C++ 4.x̃TvCOMDLG32
--------------------------------------------------*/
BOOL CALLBACK HookProcAlarm(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch(message)
	{
		case WM_INITDIALOG:
			SendDlgItemMessage(hDlg, IDC_TESTSOUND, BM_SETIMAGE, IMAGE_ICON,
				(LPARAM)hIconPlay);
			EnableDlgItem(hDlg, IDC_TESTSOUND, FALSE);
			break;
		case WM_DESTROY:
			if(bPlaying) StopFile(); bPlaying = FALSE;
			break;
		case WM_NOTIFY:
			switch(((LPOFNOTIFY)lParam)->hdr.code)
			{
				case CDN_SELCHANGE:
				case CDN_FOLDERCHANGE:
				{
					char fname[MAX_PATH];
					if (CommDlg_OpenSave_GetFilePath(GetParent(hDlg),
						fname, sizeof(fname)) <= sizeof(fname))
					{
						EnableDlgItem(hDlg, IDC_TESTSOUND,
							fname[0]);
					}
				}
				break;
			}
			return FALSE;
		case WM_COMMAND:
			if(LOWORD(wParam) == IDC_TESTSOUND)
			{
				char fname[MAX_PATH];
				if(CommDlg_OpenSave_GetFilePath(GetParent(hDlg),
					fname, sizeof(fname)) <= sizeof(fname))
				{
					if((HICON)SendDlgItemMessage(hDlg, IDC_TESTSOUND, BM_GETIMAGE, IMAGE_ICON, 0)
						== hIconPlay)
					{
						if(PlayFile(hDlg, fname, 0))
						{
							SendDlgItemMessage(hDlg, IDC_TESTSOUND, BM_SETIMAGE, IMAGE_ICON,
								(LPARAM)hIconStop);
							InvalidateRect(GetDlgItem(hDlg, IDC_TESTSOUND), NULL, FALSE);
							bPlaying = TRUE;
						}
					}
					else
					{
						StopFile(); bPlaying = FALSE;
					}
				}
			}
			return FALSE;
		case MM_MCINOTIFY:
		case MM_WOM_DONE:
			StopFile(); bPlaying = FALSE;
			SendDlgItemMessage(hDlg, IDC_TESTSOUND, BM_SETIMAGE, IMAGE_ICON,
				(LPARAM)hIconPlay);
			InvalidateRect(GetDlgItem(hDlg, IDC_TESTSOUND), NULL, FALSE);
			return FALSE;
		default:
			return FALSE;
	}
	return TRUE;
}

/*------------------------------------------------
@WIN.INIMCIt@C̊gq擾
--------------------------------------------------*/
void GetMMFileExts(char* dst)
{
	char s[1024], *sp, *dp;
	
	GetProfileString("mci extensions", NULL, "",
		s, 1024);

	sp = s; dp = dst;
	while(*sp)
	{
		if(dp != dst) *dp++ = ';';
		*dp++ = '*'; *dp++ = '.';
		while(*sp) *dp++ = *sp++;
		sp++;
	}
	*dp = 0;
}

/*------------------------------------------------
@MCIt@Cǂ
--------------------------------------------------*/
BOOL IsMMFile(char* fname)
{
	char s[1024], *sp;
	
	if(lstrcmpi(fname, "cdaudio") == 0) return TRUE;

	GetProfileString("mci extensions", NULL, "",
		s, 1024);
	
	sp = s;
	while(*sp)
	{
		if(ext_cmp(fname, sp) == 0) return TRUE;
		while(*sp) sp++; sp++;
	}
	return FALSE;
}
