/*-------------------------------------------
  pageabout.c
     uo[Wv
     KAZUBON 1997-1998
---------------------------------------------*/

#include "tclock.h"

static void OnInit(HWND hDlg);
static void OnLinkClicked(HWND hDlg, UINT id);

static HFONT hfontLink;  //NxtHg
// NxpTuNXvV[W
static WNDPROC oldLabProc = NULL;
LRESULT CALLBACK LabLinkProc(HWND, UINT, WPARAM, LPARAM);
static HCURSOR hCurHand = NULL;

/*------------------------------------------------
@uo[Wvy[Wp_CAOvV[W
--------------------------------------------------*/

BOOL CALLBACK PageAboutProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch(message)
	{
		case WM_INITDIALOG:
			OnInit(hDlg);
			return TRUE;
		case WM_CTLCOLORSTATIC:
		{
			int id; HDC hdc;
			hdc = (HDC)wParam;
			id = GetDlgCtrlID((HWND)lParam);
			if(id == IDC_MAILTO || id == IDC_HOMEPAGE)
			{
				SetTextColor(hdc, RGB(0,0,255));
				SetBkMode(hdc, TRANSPARENT);
				return (int)GetSysColorBrush(COLOR_3DFACE);
			}
			break;
		}
		case WM_COMMAND:
		{
			WORD id, code;
			id = LOWORD(wParam); code = HIWORD(wParam);
			// eLXg{bNX
			if((id == IDC_MAILTO || id == IDC_HOMEPAGE) 
				&& code == STN_CLICKED)
			{
				OnLinkClicked(hDlg, id);
			}
			return TRUE;
		}
		case WM_NOTIFY:
			switch(((NMHDR *)lParam)->code)
			{
				case PSN_APPLY: break;
				case PSN_HELP: MyHelp(GetParent(hDlg), 7); break;
			}
			return TRUE;
		case WM_DESTROY:
			DeleteObject(hfontLink);
			break;
	}
	return FALSE;
}

/*------------------------------------------------
@@|@NpxTuNX
--------------------------------------------------*/
static void OnInit(HWND hDlg)
{
	LOGFONT logfont;
	
	hfontLink = (HFONT)SendMessage(hDlg, WM_GETFONT, 0, 0);
	GetObject(hfontLink, sizeof(LOGFONT), &logfont);
	logfont.lfUnderline = 1;
	hfontLink = CreateFontIndirect(&logfont);
	SendDlgItemMessage(hDlg, IDC_MAILTO, WM_SETFONT, (WPARAM)hfontLink, 0);
	SendDlgItemMessage(hDlg, IDC_HOMEPAGE, WM_SETFONT, (WPARAM)hfontLink, 0);
	if(hCurHand == NULL)
		hCurHand = LoadCursor(hInst, MAKEINTRESOURCE(IDC_HAND));
	oldLabProc = (WNDPROC)GetWindowLong(GetDlgItem(hDlg, IDC_MAILTO),
		GWL_WNDPROC);
	SetWindowLong(GetDlgItem(hDlg, IDC_MAILTO),
		GWL_WNDPROC, (LONG)LabLinkProc);
	SetWindowLong(GetDlgItem(hDlg, IDC_HOMEPAGE),
		GWL_WNDPROC, (LONG)LabLinkProc);
	
	//hbrback = CreateSolidBrush(GetSysColor(COLOR_3DFACE));
}

/*------------------------------------------------
@NpxNbNꂽ
--------------------------------------------------*/
void OnLinkClicked(HWND hDlg, UINT id)
{
	char str[1024], *p;
	BOOL bOutlook = FALSE;
	
	if(id == IDC_MAILTO)
	{
		GetRegStr(HKEY_CLASSES_ROOT, "mailto\\shell\\open\\command", "",
			str, 1024, "");
		p = str;
		while(*p)
		{
			if(_strnicmp(p, "MSIMN.EXE", 9) == 0)
			{
				bOutlook = TRUE; break;
			}
			p++;
		}
		
		strcpy(str, "mailto:");
		if(bOutlook)
		{
			strcat(str, "Kazubon <");
			GetDlgItemText(hDlg, id, str + strlen(str), 80);
			strcat(str, ">?subject=About%20TClock");
		}
		else
			GetDlgItemText(hDlg, id, str + strlen(str), 80);
	}
	else GetDlgItemText(hDlg, id, str, 80);
	
	ShellExecute(hDlg, NULL, str, NULL, "", SW_SHOW);
}

/*------------------------------------------------
@Npx̃TuNXvV[W
--------------------------------------------------*/
LRESULT CALLBACK LabLinkProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch(message)
	{
		case WM_SETCURSOR:
			SetCursor(hCurHand);
			return 1;
	}
	return CallWindowProc(oldLabProc, hwnd, message, wParam, lParam);
}

