/*-------------------------------------------------------------
  main.c
  WinMain, window procedure, and functions for initializing
  KAZUBON 1997-1999
---------------------------------------------------------------*/

#include "tclock.h"
#include <winver.h>

#define VERSIONM 0x20002
#define VERSIONL 0x0008

LRESULT CALLBACK WndProc(HWND, UINT, WPARAM, LPARAM);

char szClassName[] = "TClockMainClass"; // window class name
char szWindowText[] = "TClock";         // caption of the window

void CheckCommandLine(HWND hwnd);
static void SetStringsForDLL(void);
static BOOL CheckDLL(void);
static void InitHTMLHelp(void);
static void EndHTMLHelp(void);

static BOOL bStartTimer = FALSE;

/*-------------------------------------------
  entry point of program
  not use "WinMain" for compacting the file size
---------------------------------------------*/
void WINAPI WinMainCRTStartup(void)
{
	MSG msg;
	WNDCLASS wndclass;
	HWND hwnd;
	
	// not to execute the program twice
	hwnd = FindWindow(szClassName, szWindowText);
	if(hwnd != NULL)
	{
		CheckCommandLine(hwnd);
		ExitProcess(1); return;
	}
	
	hInst = GetModuleHandle(NULL);
	
	// get the path where .exe is positioned
	GetModuleFileName(hInst, mydir, MAX_PATH);
	del_title(mydir);
	
	if(!CheckDLL())
	{
		ExitProcess(1); return;
	}
	
	InitCommonControls();
	
	InitHTMLHelp();
	
	SetStringsForDLL();
	
	hIconTClock = LoadIcon(hInst, MAKEINTRESOURCE(IDI_ICON1));
	hIconPlay = LoadImage(hInst, MAKEINTRESOURCE(IDI_PLAY), IMAGE_ICON,
		16, 16, LR_DEFAULTCOLOR);
	hIconStop = LoadImage(hInst, MAKEINTRESOURCE(IDI_STOP), IMAGE_ICON,
		16, 16, LR_DEFAULTCOLOR);
	hIconDel = LoadImage(hInst, MAKEINTRESOURCE(IDI_DEL), IMAGE_ICON,
		16, 16, LR_DEFAULTCOLOR);
	
	hwndSheet = hDlgTimer = NULL;
	
	// register a window class
	wndclass.style         = CS_HREDRAW | CS_VREDRAW | CS_DBLCLKS;
	wndclass.lpfnWndProc   = WndProc;
	wndclass.cbClsExtra    = 0;
	wndclass.cbWndExtra    = 0;
	wndclass.hInstance     = hInst;
	wndclass.hIcon         = hIconTClock;
	wndclass.hCursor       = LoadCursor(NULL, IDC_ARROW);
	wndclass.hbrBackground = (HBRUSH)(COLOR_WINDOW+1);
	wndclass.lpszMenuName  = NULL;
	wndclass.lpszClassName = szClassName;
	RegisterClass(&wndclass);
	
	// create a hidden window
	hwnd = CreateWindow(szClassName, szWindowText,
		0, CW_USEDEFAULT,CW_USEDEFAULT,CW_USEDEFAULT,CW_USEDEFAULT,
		NULL, NULL, hInst, NULL);
	//ShowWindow(hwnd, SW_SHOW);
	//UpdateWindow(hwnd);
	
	hwndMain = hwnd;
	
	CheckCommandLine(hwnd);
	
	while(GetMessage(&msg, NULL, 0, 0))
	{
		if(hwndSheet && IsWindow(hwndSheet)
			&& IsDialogMessage(hwndSheet, &msg))
			;
		else if(hDlgTimer && IsWindow(hDlgTimer)
			&& IsDialogMessage(hDlgTimer, &msg))
			;
		else
		{
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
	}
	EndHTMLHelp();
	
	ExitProcess(msg.wParam);
}

/*-------------------------------------------
   Command Line Option
   /prop : Show TClock Properties
   /exit : Exit TClock
---------------------------------------------*/
void CheckCommandLine(HWND hwnd)
{
	char *p;
	p = GetCommandLine();
	while(*p)
	{
		if(*p == '/')
		{
			p++;
			if(_strnicmp(p, "prop", 4) == 0)
			{
				PostMessage(hwnd, WM_USER+1, 0, 0);
				p += 4;
			}
			else if(_strnicmp(p, "exit", 4) == 0)
			{
				PostMessage(hwnd, WM_CLOSE, 0, 0);
				p += 4;
			}
		}
		p++;
	}
}

/*-------------------------------------------
   the window procedure
---------------------------------------------*/
LRESULT CALLBACK WndProc(HWND hwnd,	UINT message, WPARAM wParam, LPARAM lParam)
{
	switch (message)
	{
		case WM_CREATE:
		{
			int nDelay;
			InitAlarm();  // initialize alarms
			InitFormat(); // initialize a Date/Time format
			nDelay = GetMyRegLong("", "DelayStart", 0);
			if(nDelay > 0)
			{
				SetTimer(hwnd, 2, nDelay * 1000, NULL); bStartTimer = TRUE;
			}
			else SendMessage(hwnd, WM_TIMER, 2, 0);
			InitSyncTime(hwnd);
			InitWatchWallpaper();
			SetTimer(hwnd, 3, 1000, NULL);
			return 0;
		}
		case WM_TIMER:
			if(wParam == 2)
			{
				if(bStartTimer) KillTimer(hwnd, 2);
				bStartTimer = FALSE;
				HookStart(hwnd); // install a hook
			}
			else if(wParam == 3)
			{
				SYSTEMTIME st;
				GetLocalTime(&st);
				OnTimerSNTP(hwnd, &st);
				CheckAlarm(hwnd, &st);
				CheckTimer(hwnd, &st);
				CheckWallpaper(hwnd, &st);
			}
			return 0;

		case WM_DESTROY:
			EndSyncTime(hwnd);
			EndAlarm();
			EndTimer();
			EndWatchWallpaper();
			MyHelp(hwnd, -1);
			KillTimer(hwnd, 3);
			if(bStartTimer)
			{
				KillTimer(hwnd, 2); bStartTimer = FALSE;
			}
			else HookEnd();  // uninstall a hook
			PostQuitMessage(0);
			return 0;
		case WM_ENDSESSION:
			if(wParam)
			{
				EndSyncTime(hwnd);
				EndAlarm();
				EndTimer();
				if(bStartTimer)
				{
					KillTimer(hwnd, 2); bStartTimer = FALSE;
				}
				else HookEnd();  // uninstall a hook
			}
			break;
		case WM_PAINT:
		{
			PAINTSTRUCT ps;
			HDC hdc;
			hdc = BeginPaint(hwnd, &ps);
			EndPaint(hwnd, &ps);
			return 0;
		}

		// Messages sent/posted from TCDLL.dll
		case WM_USER:
			hwndClock = (HWND)lParam;
			return 0;
		case (WM_USER+1):   // "TClock properties"
			MyPropertySheet();
			return 0;
		case (WM_USER+2):   // "Exit TClock"
			if(hwndSheet && !IsWindow(hwndSheet))
				PostMessage(hwndSheet, WM_CLOSE, 0, 0);
			if(hDlgTimer && !IsWindow(hDlgTimer))
				PostMessage(hDlgTimer, WM_CLOSE, 0, 0);
			hwndSheet = NULL;
			PostMessage(hwnd, WM_CLOSE, 0, 0);
			return 0;
		case MM_MCINOTIFY:
			OnMCINotify(hwnd);
			return 0;
		case MM_WOM_DONE: // stop playing wave
		case (WM_USER+3):
			StopFile();
			return 0;
		case (WM_USER+5): // "TClock Help"
			MyHelp(hwnd, 0);
			return 0;
		case (WM_USER+6): // "Timer"
			DialogTimer(hwnd);
			return 0;
		case (WM_USER+8): // Syncronize Time
			StartSyncTime(hwndMain, NULL, 0);
			return 0;
		case (WM_USER+11):  // to display countdown of timer
			return OnQueryTimerInfo(hwnd, (HWND)wParam, (int)lParam);
		case (WM_USER+12):  // stop timer
			StopTimer(hwnd, wParam);
			return 0;
		case WM_WININICHANGE:
		/*
		{
			char s[160];
			strcpy(s, "WM_WININICHANGE ");
			if(lParam) strcat(s, (char*)lParam);
			else strcat(s, "(null)");
			WriteDebug(s);
		}
		*/
		{
			char *p;
			BOOL b;

			p = (char*)lParam;
			b = GetMyRegLong("", "DeskcalTonikaku", FALSE);
			
			// Update Destop Calendar automatically
			if(p && (strcmp(p, "Desktop") == 0 ||
				 strcmp(p, "RefreshDesktop") == 0)) ; // fall through
			else if(b && (p == 0 || *p == 0)) ; // fall through
			else return 0;
		}
		case WM_SYSCOLORCHANGE:
			PostMessage(hwnd, WM_USER+10, 1,0);
			return 0;
		case (WM_USER+10):
		{
			if(wParam && GetMyRegLong("", "DeskcalOnlyDate", FALSE)) ;
			else ExecDeskcal(hwnd);
			return 0;
		}
		
		// return from power saving
		case WM_POWERBROADCAST:
		{
			if(wParam == 7) //PBT_APMRESUMESUSPEND
			{
				if(GetMyRegLong("", "DeskcalResumeSuspend", FALSE))
					PostMessage(hwnd, WM_USER+10, 0,0);
			}
			break;
		}
		
		// messages transfered from the dll
		case WM_DROPFILES:
			OnDropFiles(hwnd, (HDROP)wParam);
			return 0;
		case WM_LBUTTONDOWN:
		case WM_RBUTTONDOWN:
		case WM_MBUTTONDOWN:
			if(!bPlayingNonstop)
				PostMessage(hwnd, WM_USER+3, 0, 0);
		case WM_LBUTTONDBLCLK:
		case WM_RBUTTONDBLCLK:
		case WM_MBUTTONDBLCLK:
			OnClick(hwnd, message, wParam, LOWORD(lParam), HIWORD(lParam));
			return 0;
	}
	return DefWindowProc(hwnd, message, wParam, lParam);
}

/*------------------------------------------------
  load and save strings for TCDLL.dll
--------------------------------------------------*/
void SetStringsForDLL(void)
{
	int i;
	char s[80];
	
	for(i = IDS_DLL_DATETIME; i <= IDS_DLL_EXIT; i++)
	{
		wsprintf(s, "%02d", i-IDS_DLL_DATETIME);
		SetMyRegStr("DLL", s, MyString(i));
	}
	
	if(GetMyRegStr(NULL, "Font", s, 80, "") == 0)
	{
		HFONT hfont;
		LOGFONT lf;
		hfont = (HFONT)GetStockObject(DEFAULT_GUI_FONT);
		if(hfont)
		{
			GetObject(hfont, sizeof(lf),(LPVOID)&lf);
			SetMyRegStr("", "Font", lf.lfFaceName);
		}
	}
}

/*-------------------------------------------
  Check version of TCDLL.dll
---------------------------------------------*/
BOOL CheckDLL(void)
{
	DWORD size;
	char *pBlock;
	VS_FIXEDFILEINFO *pffi;
	char fname[MAX_PATH];
	BOOL br = FALSE;

	strcpy(fname, mydir); add_title(fname, MyString(IDS_DLLNAME));

	size = GetFileVersionInfoSize(fname, 0);
	if(size > 0)
	{
		pBlock = malloc(size);
		if(GetFileVersionInfo(fname, 0, size, pBlock))
		{
			UINT tmp;
			if(VerQueryValue(pBlock, "\\", &pffi, &tmp))
			{
				if(pffi->dwFileVersionMS == VERSIONM &&
					pffi->dwFileVersionLS == VERSIONL)
				{
					br = TRUE;
				}
			}
		}
		free(pBlock);
	}
	if(!br)
	{
		char title[80];
		
		strcpy(title, MyString(IDS_CAUTION));
		MyMessageBox(NULL, MyString(IDS_DLLVER),
			title, MB_OK, MB_ICONEXCLAMATION);
	}
	return br;
}

/*-------------------------------------------
  Initialize Compiled HTML Help
---------------------------------------------*/

HMODULE hmodDLL = NULL;
HWND (WINAPI *HtmlHelp)(HWND, LPCSTR, UINT, DWORD) = NULL;

void InitHTMLHelp(void)
{
	hmodDLL = LoadLibrary("HHCTRL.OCX");
	if(hmodDLL != NULL)
	{
		(FARPROC)HtmlHelp = GetProcAddress(hmodDLL, "HtmlHelpA");
		if(HtmlHelp == NULL)
		{
			FreeLibrary(hmodDLL); hmodDLL = NULL;
		}
	}
}
void EndHTMLHelp(void)
{
	if(hmodDLL != NULL) FreeLibrary(hmodDLL);
}

#define HH_DISPLAY_TOPIC  0x0000
#define HH_HELP_CONTEXT   0x000F
#define HH_CLOSE_ALL      0x0012

/*-------------------------------------------
  Show "TClock Help"
---------------------------------------------*/
void MyHelp(HWND hwnd, int id)
{
	char helpfile[MAX_PATH];
	WIN32_FIND_DATA fd;
	HANDLE hfind;
	int command;
	
	strcpy(helpfile, mydir);
	add_title(helpfile, MyString(IDS_CHMFILE));
	hfind = FindFirstFile(helpfile, &fd);
	
	// Compiled HTML Help (.chm)
	if(HtmlHelp != NULL && hfind != INVALID_HANDLE_VALUE)
	{
		HWND hwndHelp;
		
		if(id < 0) { command = HH_CLOSE_ALL; id = 0; }
		else if(id == 0) command = HH_DISPLAY_TOPIC;
		else command = HH_HELP_CONTEXT;
		hwndHelp = HtmlHelp(hwnd, helpfile, command, id);
		if(command != HH_CLOSE_ALL)
			SetForegroundWindow(hwndHelp);
	}
	else // Windows Help (.hlp)
	{
		strcpy(helpfile, mydir);
		add_title(helpfile, MyString(IDS_HELPFILE));
		if(id < 0) { command = HELP_QUIT; id = 0; }
		else if(id == 0) command = HELP_CONTENTS;
		else command = HELP_CONTEXT;
		WinHelp(hwnd, helpfile, command, id);
	}
	if(hfind != INVALID_HANDLE_VALUE)
		FindClose(hfind);
}

