/*-----------------------------------------------------
  wndproc.c
    v̉
                                    KAZUBON 1997-1998
-------------------------------------------------------*/

#include "tcdll.h"

LRESULT CALLBACK WndProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam);
void InitClock(HWND hwnd);
void EndClock(void);
BOOL IsIE4(HWND hwnd);
void CreateClockMenu(void);
void CreateTip(HWND hwnd);
void CreateClockDC(HWND hwnd);
void ReadData(HWND hwnd);
void OnTimer(HWND hwnd);
void DrawClockSub(HWND hwnd, HDC hdc, SYSTEMTIME* pt, int beat100);
void DrawClock(HWND hwnd, HDC hdc);
LRESULT OnCalcRect(HWND hwnd);
void OnTooltipNeedText(UINT code, LPARAM lParam);
void OnCopy(HWND hwnd);

/*------------------------------------------------
@evZXŋʂ̃f[^
--------------------------------------------------*/
#pragma data_seg(".MYDATA")
HHOOK hhook = 0;
HWND hwndTClockMain = NULL;
HWND hwndClock = NULL;
char szShareBuf[81] = { 0 };
#pragma data_seg()

/*------------------------------------------------
@Globals
--------------------------------------------------*/
HANDLE hmod = 0;
WNDPROC oldWndProc = NULL;
HDC hdcClock = NULL;
HBITMAP hbmpClock = NULL;
HFONT hFon = NULL;
HMENU hMenu = NULL;
HWND hwndTip = NULL;
COLORREF colback, colback2, colfore;
char format[1024];
BOOL bHour12, bHourZero;
SYSTEMTIME LastTime;
int beatLast = -1;
BOOL bDispSecond = FALSE;
int nDispBeat = 0;
BOOL bNoClock = FALSE;
int nBlink = 0;
int buttondown = 0;
BOOL bStartMenuClock = FALSE;
BOOL bIE4 = FALSE;
int dwidth = 0, dheight = 0, dvpos = 0, dlineheight = 0;
int iClockWidth = -1;
BOOL bPlaying = FALSE;

extern HWND hwndStart;
extern HWND hwndStartMenu;

extern int codepage;

/*------------------------------------------------
   copy string to szShareBuf
--------------------------------------------------*/
int WINAPI CopyToShareBuf(const char* src)
{
	int len;
	len = strlen(src);
	if(len > 80)
	{
		len = 80;
		memcpy(szShareBuf, src, len);
		szShareBuf[len] = 0;
	}
	else strcpy(szShareBuf, src);
	return len;
}

/*------------------------------------------------
@v̏
--------------------------------------------------*/
void InitClock(HWND hwnd)
{
	BOOL b;
	
	hwndClock = hwnd;
	
	PostMessage(hwndTClockMain, WM_USER, 0, (LPARAM)hwnd);
	
	//WXgǂݍ
	ReadData(hwndClock);
	//TuNX
	oldWndProc = (WNDPROC)GetWindowLong(hwndClock, GWL_WNDPROC);
	SetWindowLong(hwndClock, GWL_WNDPROC, (LONG)WndProc);
	//_uNbN󂯕t
	SetClassLong(hwndClock, GCL_STYLE,
		GetClassLong(hwndClock, GCL_STYLE) | CS_DBLCLKS);
	//X^[g{^̏
	SetStartButton(hwndClock);
	//X^[gj[̏
	SetStartMenu(hwndClock);
	
	//c[`bv쐬
	CreateTip(hwndClock);
	
	b = GetMyRegLong(NULL, "DropFiles", FALSE);
	DragAcceptFiles(hwnd, b);
	
	bIE4 = IsIE4(hwndClock);
	if(bIE4)
	{
		InitStartMenuIE4();
		InitTaskSwitch(hwndClock);
	}
	
	//^XNo[̍XV
	PostMessage(GetParent(GetParent(hwndClock)), WM_SIZE,
		SIZE_RESTORED, 0);
	InvalidateRect(GetParent(GetParent(hwndClock)), NULL, TRUE);
}

/*------------------------------------------------
@v̏I
--------------------------------------------------*/
void DeleteClockRes(void)
{
	if(hFon) DeleteObject(hFon); hFon = NULL;
	if(hdcClock) DeleteDC(hdcClock); hdcClock = NULL;
	if(hbmpClock) DeleteObject(hbmpClock); hbmpClock = NULL;
}
void EndClock(void)
{
	DragAcceptFiles(hwndClock, FALSE);
	if(hwndTip) DestroyWindow(hwndTip); hwndTip = NULL;
	EndTaskSwitch();
	EndStartButton();
	EndStartMenu();
	if(hMenu) DestroyMenu(hMenu); hMenu = NULL;
	ClearStartMenuIE4();
	
	DeleteClockRes();
	
	if(hwndClock && IsWindow(hwndClock))
	{
		KillTimer(hwndClock, 1);
		SetWindowLong(hwndClock, GWL_WNDPROC, (LONG)oldWndProc);
		oldWndProc = NULL;
	}
	//TClockEBhEI
	if(IsWindow(hwndTClockMain))
		PostMessage(hwndTClockMain, WM_USER+2, 0, 0);
}

/*------------------------------------------------
@IE4ǂ
--------------------------------------------------*/
BOOL IsIE4(HWND hwnd)
{
	char classname[80];
	DWORD dw;
	
	dw = GetRegLong(HKEY_CURRENT_USER,
		"Software\\Microsoft\\Windows\\CurrentVersion\\Policies\\Explorer",
		"ClassicShell", 0);
	if(dw) return TRUE;
	
	hwnd = GetParent(GetParent(hwnd));
	if(hwnd == NULL) return FALSE;
	hwnd = GetWindow(hwnd, GW_CHILD);
	while(hwnd)
	{
		GetClassName(hwnd, classname, 80);
		if(lstrcmpi(classname, "ReBarWindow32") == 0)
			return TRUE;
		hwnd = GetWindow(hwnd, GW_HWNDNEXT);
	}
	return FALSE;
}

/*------------------------------------------------
@vEBhẼTuNXvV[W
--------------------------------------------------*/
LRESULT CALLBACK WndProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch(message) // c[`bvΉ
	{
		case WM_LBUTTONDOWN:
		case WM_RBUTTONDOWN:
		case WM_MBUTTONDOWN:
		case WM_LBUTTONUP:
		case WM_RBUTTONUP:
		case WM_MBUTTONUP:
		case WM_MOUSEMOVE:
		{
			MSG msg;
			msg.hwnd = hwnd;
			msg.message = message;
			msg.wParam = wParam;
			msg.lParam = lParam;
			msg.time = GetMessageTime();
			msg.pt.x = LOWORD(GetMessagePos());
			msg.pt.y = HIWORD(GetMessagePos());
			if(hwndTip)
				SendMessage(hwndTip, TTM_RELAYEVENT, 0, (LPARAM)&msg);
		}
	}
	
	switch(message)
	{
		case WM_DESTROY:
			DeleteClockRes();
			break;
		// eEBhE瑗ATCYԂbZ[W
		case (WM_USER+100):
			if(bNoClock) break;
			return OnCalcRect(hwnd);
		// VXe̐ݒ𔽉f
		case WM_SYSCOLORCHANGE:
			CreateClockDC(hwnd); //hdcClock蒼
		case WM_WININICHANGE:
		case WM_TIMECHANGE:
		// eEBhE瑗
		case (WM_USER+101):
		{
			HDC hdc;
			if(bNoClock) break;
			hdc = GetDC(hwnd);
			DrawClock(hwnd, hdc);
			ReleaseDC(hwnd, hdc);
			return 0;
		}
		case WM_SIZE:
			CreateClockDC(hwnd); //hdcClock蒼
			break;
		case WM_ERASEBKGND:
			break;
		case WM_PAINT:
		{
			PAINTSTRUCT ps;
			HDC hdc;
			if(bNoClock) break;
			hdc = BeginPaint(hwnd, &ps);
			DrawClock(hwnd, hdc);
			EndPaint(hwnd, &ps);
			return 0;
		}
		case WM_TIMER:
			if(wParam == 1)
			{
				OnTimer(hwnd); return 0;
			}
			else
			{
				if(bNoClock) break;
				else return 0;
			}
		// }EX_E
		case WM_LBUTTONDOWN:
		case WM_RBUTTONDOWN:
		case WM_MBUTTONDOWN:
			if(nBlink)
			{
				nBlink = 0; InvalidateRect(hwnd, NULL, TRUE);
			}
			if(message == WM_LBUTTONDOWN && bStartMenuClock &&
				hwndStart && IsWindow(hwndStart))
			{
				SetWindowPos(hwndStart, NULL, 0, 0, 0, 0,
					SWP_NOSIZE|SWP_NOZORDER|SWP_NOACTIVATE);
				// X^[gj[
				PostMessage(hwndStart, WM_LBUTTONDOWN, 0, 0);
			}
			buttondown = message;
			return 0;
		// }EXAbv
		case WM_LBUTTONUP:
			if(buttondown == WM_LBUTTONDOWN)
				PostMessage(hwndTClockMain, buttondown, wParam, lParam);
			buttondown = 0;
			return 0;
		case WM_RBUTTONUP:
			if(buttondown == WM_RBUTTONDOWN)
				PostMessage(hwndTClockMain, buttondown, wParam, lParam);
			buttondown = 0;
			break;
		case WM_MBUTTONUP:
			if(buttondown == WM_MBUTTONDOWN)
				PostMessage(hwndTClockMain, buttondown, wParam, lParam);
			buttondown = 0;
			return 0;
		// _uNbN
		case WM_LBUTTONDBLCLK:
			if(bStartMenuClock) return 0;
		case WM_RBUTTONDBLCLK:
		case WM_MBUTTONDBLCLK:
			PostMessage(hwndTClockMain, message, wParam, lParam);
			return 0;
		case WM_MOUSEMOVE:
			return 0;
		case WM_CONTEXTMENU:   // ENbNj[
			CreateClockMenu();
			TrackPopupMenu(hMenu, TPM_LEFTALIGN|TPM_RIGHTBUTTON,
				LOWORD(lParam), HIWORD(lParam), 0, hwnd, NULL);
			return 0;
		case WM_NCHITTEST: // oldWndProcɏȂ
			return DefWindowProc(hwnd, message, wParam, lParam);
		case WM_MOUSEACTIVATE:
			return MA_ACTIVATE;
		// t@C̃hbv
		case WM_DROPFILES:
			PostMessage(hwndTClockMain, WM_DROPFILES, wParam, lParam);
			return 0;
		case WM_COMMAND:
		{
			WORD wID;
			wID = LOWORD(wParam);
			switch (wID)
			{
				case 100: // TClockè
					PostMessage(hwndTClockMain, WM_USER+1, 0, 0);
					return 0;
				case 101: // TClock
					PostMessage(hwndTClockMain, WM_USER+5, 0, 0);
					return 0;
				case 102: // TClock̏I
					EndClock();
					return 0;
				case 103: // ^C}[
					PostMessage(hwndTClockMain, WM_USER+6, (WPARAM)hwnd, 0);
					return 0;
				case 104: // Syncronize time
					PostMessage(hwndTClockMain, WM_USER+8, 0, 0);
					return 0;
				case 105: // Copy
					OnCopy(hwnd);
					return 0;
				case 106: // Stop playing
					OnCopy(hwnd);
					return 0;
				case 408:
				case 403:
				case 404:
				case 405:
				case 415:
				case 420:
				case 413:
					PostMessage(GetParent(GetParent(hwnd)), message,
						wParam, lParam);
					return 0;
			}
			if(wID >= 110)
			{
				// stop timer
				SendMessage(hwndTClockMain, WM_USER+12, wID - 110, 0);
				return 0;
			}
			break;
		}
		
		case WM_NOTIFY: //c[`bṽeLXg\
		{
			UINT code;
			code = ((LPNMHDR)lParam)->code;
			if(code == TTN_NEEDTEXT || code == TTN_NEEDTEXTW)
			{
				OnTooltipNeedText(code, lParam);
				return 0;
			}
			break;
		}
		case (WM_USER+1): // RefreshTClock() 瑗
		{
			BOOL b;
			if(hMenu) DestroyMenu(hMenu); hMenu = NULL;
			ReadData(hwnd);
			SetStartButton(hwnd);
			SetStartMenu(hwnd);
			InitTaskSwitch(hwnd);
			CreateClockDC(hwnd);
			b = GetMyRegLong(NULL, "DropFiles", FALSE);
			DragAcceptFiles(hwnd, b);
			InvalidateRect(hwnd, NULL, FALSE);
			PostMessage(GetParent(GetParent(hwnd)), WM_SIZE,
				SIZE_RESTORED, 0);
			InvalidateRect(GetParent(GetParent(hwndClock)), NULL, TRUE);
			return 0;
		}
		case (WM_USER+2): // BlinkTClock() 瑗
		{
			if(wParam) { if(nBlink == 0) nBlink = 4; }
			else nBlink = 2;
			return 0;
		}
		
		case WM_WINDOWPOSCHANGING:  // TCY
		{
			LPWINDOWPOS pwp;
			if(bNoClock) break;
			pwp = (LPWINDOWPOS)lParam;
			if(IsWindowVisible(hwnd) && !(pwp->flags & SWP_NOSIZE))
			{
				int h;
				h = (int)HIWORD(OnCalcRect(hwnd));
				if(pwp->cy > h) pwp->cy = h;
			}
			break;
		}
	}
	/*
	{
		char s[80];
		wsprintf(s, "%X", message);
		WriteDebug(s);
	}
	*/
	return CallWindowProc(oldWndProc, hwnd, message, wParam, lParam);
}

/*------------------------------------------------
@ݒ̓ǂݍ݂ƃf[^̏
--------------------------------------------------*/
void ReadData(HWND hwnd)
{
	char fontname[80];
	int fontsize;
	LONG weight, italic;
	SYSTEMTIME lt;
	
	colfore = GetMyRegLong(NULL, "ForeColor", 
		0x80000000 | COLOR_BTNTEXT);
	colback = GetMyRegLong(NULL, "BackColor",
		0x80000000 | COLOR_3DFACE);
	colback2 = GetMyRegLong(NULL, "BackColor2",
		0x80000000 | COLOR_3DFACE);
	
	GetMyRegStr(NULL, "Font", fontname, 80, "");
	
	fontsize = GetMyRegLong(NULL, "FontSize", 9);
	weight = GetMyRegLong(NULL, "Bold", 0);
	if(weight) weight = FW_BOLD;
	else weight = 0;
	italic = GetMyRegLong(NULL, "Italic", 0);
	
	if(hFon) DeleteObject(hFon);
	hFon = CreateMyFont(fontname, fontsize, weight, italic);
	
	dheight = (int)(short)GetMyRegLong(NULL, "ClockHeight", 0);
	dwidth = (int)(short)GetMyRegLong(NULL, "ClockWidth", 0);
	dvpos = (int)(short)GetMyRegLong(NULL, "VertPos", 0);
	dlineheight = (int)(short)GetMyRegLong(NULL, "LineHeight", 0);

	bNoClock = GetMyRegLong(NULL, "NoClock", FALSE);
	
	if(!GetMyRegStr(NULL, "Format", format, 1024, "") || !format[0])
	{
		bNoClock = TRUE;
	}
	
	bDispSecond = IsDispSecond(format);
	KillTimer(hwndClock, 1);
	SetTimer(hwndClock, 1, bDispSecond?500:1000, NULL);
	nDispBeat = IsDispBeat(format);
	
	bHour12 = GetMyRegLong(NULL, "Hour12", 0);
	bHourZero = GetMyRegLong(NULL, "HourZero", 0);
	
	bStartMenuClock = FALSE;
	if(GetMyRegLong(NULL, "StartButtonHide", FALSE))
		bStartMenuClock = 
			GetMyRegLong(NULL, "StartMenuClock", FALSE);
	
	GetLocalTime(&lt);
	LastTime.wDay = lt.wDay;
	
	InitFormat(&lt);      // format.c
	
	iClockWidth = -1;
}

/*------------------------------------------------
@ENbÑ|bvAbvj[̍쐬
--------------------------------------------------*/
void CreateClockMenu(void)
{
	char entry[10];
	char s[12][80];
	int i;
	
	if(hMenu) DestroyMenu(hMenu);
	hMenu = CreatePopupMenu();
	
	for(i = 0; i < 12; i++)
	{
		wsprintf(entry, "%02d", i);
		GetMyRegStr("DLL", entry, s[i], 80, "");
	}
	
	AppendMenu(hMenu, MF_STRING, 408, s[0]);
	AppendMenu(hMenu, MF_STRING, 403, s[1]);
	AppendMenu(hMenu, MF_STRING, 404, s[2]);
	AppendMenu(hMenu, MF_STRING, 405, s[3]);
	AppendMenu(hMenu, MF_SEPARATOR, 0, 0);
	AppendMenu(hMenu, MF_STRING, 415, s[4]);
	AppendMenu(hMenu, MF_SEPARATOR, 0, 0);
	if(!(GetVersion() & 0x80000000))
	{
		AppendMenu(hMenu, MF_STRING, 420, s[5]);
		AppendMenu(hMenu, MF_SEPARATOR, 0, 0);
	}
	AppendMenu(hMenu, MF_STRING, 413, s[6]);
	AppendMenu(hMenu, MF_SEPARATOR, 0, 0);
	AppendMenu(hMenu, MF_STRING, 103, s[7]);
	
	for(i = 0; ;i++)
	{
		if(SendMessage(hwndTClockMain, (WM_USER+11), (WPARAM)hwndClock, i))
			AppendMenu(hMenu, MF_STRING, 110+i, szShareBuf);
		else break;
	}
	
	{
		char server[80];
		GetMyRegStr("SNTP", "Server", server, 80, "");
		if(server[0])
			AppendMenu(hMenu, MF_STRING, 104, s[8]);
	}
	AppendMenu(hMenu, MF_SEPARATOR, 0, 0);
	AppendMenu(hMenu, MF_STRING, 100, s[9]);
	AppendMenu(hMenu, MF_STRING, 101, s[10]);
	if(hhook)
		AppendMenu(hMenu, MF_STRING, 102, s[11]);
	SetMenuDefaultItem(hMenu, 408, FALSE);
}

/*------------------------------------------------
@c[`bvEBhE̍쐬
--------------------------------------------------*/
void CreateTip(HWND hwnd)
{
	TOOLINFO ti;
	
	hwndTip = CreateWindow(TOOLTIPS_CLASS, (LPSTR)NULL,
		TTS_ALWAYSTIP,
		CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT,
		NULL, NULL, hmod, NULL); 
	if(!hwndTip) return;

	ti.cbSize = sizeof(TOOLINFO); 
	ti.uFlags = 0;
	ti.hwnd = hwnd;
	ti.hinst = NULL;
	ti.uId = 1;
	ti.lpszText = LPSTR_TEXTCALLBACK;
	ti.rect.left = 0;
	ti.rect.top = 0;
	ti.rect.right = 480; 
	ti.rect.bottom = 480;
	
	SendMessage(hwndTip, TTM_ADDTOOL, 0, (LPARAM) (LPTOOLINFO)&ti);
	SendMessage(hwndTip, TTM_ACTIVATE, TRUE, 0);
}

/*------------------------------------------------
@`pDC̍쐬
--------------------------------------------------*/
void CreateClockDC(HWND hwnd)
{
	RECT rc;
	COLORREF col;
	HDC hdc;
	
	if(hdcClock) DeleteDC(hdcClock); hdcClock = NULL;
	if(hbmpClock) DeleteObject(hbmpClock); hbmpClock = NULL;
	
	if(bNoClock) return;

	GetClientRect(hwnd, &rc);
	
	hdc = GetDC(NULL);
	
	hdcClock = CreateCompatibleDC(hdc);
	if(!hdcClock) return;
	hbmpClock = CreateCompatibleBitmap(hdc, rc.right, rc.bottom);
	if(!hbmpClock) return;
	SelectObject(hdcClock, hbmpClock);
	
	SelectObject(hdcClock, hFon);
	SetBkMode(hdcClock, TRANSPARENT);
	SetTextAlign(hdcClock, TA_CENTER|TA_TOP);
	col = colfore;
	if(col & 0x80000000) col = GetSysColor(col & 0x00ffffff);
	SetTextColor(hdcClock, col);
	
	ReleaseDC(NULL, hdc);
}

/*------------------------------------------------
   get date/time and beat to display
--------------------------------------------------*/
void GetDisplayTime(SYSTEMTIME* pt, int* beat100)
{
	FILETIME ft, lft;
	SYSTEMTIME lt;
	
	GetSystemTimeAsFileTime(&ft);
	
	if(beat100)
	{
		DWORDLONG dl;
		SYSTEMTIME st;
		int sec;
		
		dl = *(DWORDLONG*)&ft + 36000000000;
		FileTimeToSystemTime((FILETIME*)&dl, &st);
		
		sec = st.wHour * 3600 + st.wMinute * 60 + st.wSecond;
		*beat100 = (sec * 1000) / 864;
	}
	
	FileTimeToLocalFileTime(&ft, &lft);
	FileTimeToSystemTime(&lft, &lt);
	memcpy(pt, &lt, sizeof(lt));
}

/*------------------------------------------------
@WM_TIMER ̏
--------------------------------------------------*/
void OnTimer(HWND hwnd)
{
	SYSTEMTIME t;
	int beat100;
	HDC hdc;
	BOOL bRedraw;
	
	GetDisplayTime(&t, nDispBeat?(&beat100):NULL);
	
	bRedraw = FALSE;
	if(!bNoClock)
	{
		if(nBlink > 0) bRedraw = TRUE;
		else if(bDispSecond) bRedraw = TRUE;
		else if(nDispBeat == 1 && beatLast != (beat100/100)) bRedraw = TRUE;
		else if(nDispBeat == 2 && beatLast != beat100) bRedraw = TRUE;
		else if(LastTime.wHour != (int)t.wHour 
			|| LastTime.wMinute != (int)t.wMinute) bRedraw = TRUE;
	}
	
	if(LastTime.wDay != t.wDay || LastTime.wMonth != t.wMonth ||
		LastTime.wYear != t.wYear) InitFormat(&t); // format.c
	
	hdc = NULL;
	if(bRedraw) hdc = GetDC(hwnd);
	
	memcpy(&LastTime, &t, sizeof(t));
	
	if(nDispBeat == 1) beatLast = beat100/100;
	else if(nDispBeat > 1) beatLast = beat100;
	
	if(nBlink >= 3 && t.wMinute == 1) nBlink = 0;
	
	if(hdc)
	{
		DrawClockSub(hwnd, hdc, &t, beat100); //`
		ReleaseDC(hwnd, hdc);
	}
	
	if(nBlink)
	{
		if(nBlink % 2) nBlink++;
		else nBlink--;
	}
	
	CheckCursorOnStartButton();
}

/*------------------------------------------------
@v̕`
--------------------------------------------------*/
void DrawClock(HWND hwnd, HDC hdc)
{
	SYSTEMTIME t;
	int beat100;
	
	GetDisplayTime(&t, nDispBeat?(&beat100):NULL);
	DrawClockSub(hwnd, hdc, &t, beat100);
}

#if _MSC_VER < 1200

typedef USHORT COLOR16;

typedef struct _TRIVERTEX
{
    LONG    x;
    LONG    y;
    COLOR16 Red;
    COLOR16 Green;
    COLOR16 Blue;
    COLOR16 Alpha;
}TRIVERTEX,*PTRIVERTEX,*LPTRIVERTEX;

typedef struct _GRADIENT_RECT
{
    ULONG UpperLeft;
    ULONG LowerRight;
}GRADIENT_RECT,*PGRADIENT_RECT,*LPGRADIENT_RECT;

#define GRADIENT_FILL_RECT_H    0x00000000
#define GRADIENT_FILL_RECT_V    0x00000001
#define GRADIENT_FILL_TRIANGLE  0x00000002
#define GRADIENT_FILL_OP_FLAG   0x000000ff

WINGDIAPI BOOL  WINAPI GradientFill(HDC,PTRIVERTEX,ULONG,PVOID,ULONG,ULONG);
#endif

void DrawClockSub(HWND hwnd, HDC hdc, SYSTEMTIME* pt, int beat100)
{
	COLORREF col;
	HBRUSH hbr;
	RECT rc;
	TEXTMETRIC tm;
	int hf, y, w;
	char s[1024], *p, *sp;
	SIZE sz;
	
	if(!hdcClock) CreateClockDC(hwnd);
	
	if(!hdcClock || !hbmpClock) return;
	
	MakeFormat(s, pt, beat100, format);
	
	GetClientRect(hwnd, &rc);
	GetTextMetrics(hdcClock, &tm);
	
	if(nBlink == 0 || (nBlink % 2)) col = colfore;
	else col = colback;
	if(col & 0x80000000) col = GetSysColor(col & 0x00ffffff);
	SetTextColor(hdcClock, col);
/*
	if(nBlink || colback == colback2)
	{
*/		if(nBlink == 0 || (nBlink % 2)) col = colback;
		else col = colfore;
		if(col & 0x80000000) col = GetSysColor(col & 0x00ffffff);
		hbr = CreateSolidBrush(col);
		FillRect(hdcClock, &rc, hbr);
		DeleteObject(hbr);
/*
	}
	else
	{
		COLORREF col2;
		TRIVERTEX vert[2];
		GRADIENT_RECT gRect;
		
		col = colback;
		if(col & 0x80000000) col = GetSysColor(col & 0x00ffffff);
		col2 = colback2;
		if(col2 & 0x80000000) col2 = GetSysColor(col2 & 0x00ffffff);
		
		vert[0].x      = 0;
		vert[0].y      = 0;
		vert[0].Red    = (COLOR16)GetRValue(col) * 256;
		vert[0].Green  = (COLOR16)GetGValue(col) * 256;
		vert[0].Blue   = (COLOR16)GetBValue(col) * 256;
		vert[0].Alpha  = 0x0000;
		vert[1].x      = rc.right;
		vert[1].y      = rc.bottom; 
		vert[1].Red    = (COLOR16)GetRValue(col2) * 256;
		vert[1].Green  = (COLOR16)GetGValue(col2) * 256;
		vert[1].Blue   = (COLOR16)GetBValue(col2) * 256;
		vert[1].Alpha  = 0x0000;
		gRect.UpperLeft  = 0;
		gRect.LowerRight = 1;
		GradientFill(hdcClock, vert, 2, &gRect, 1, GRADIENT_FILL_RECT_H);
/*
	}
*/
	
	hf = tm.tmHeight - tm.tmInternalLeading;
	p = s;
	y = hf / 4 - tm.tmInternalLeading / 2;
	w = 0;
	while(*p)
	{
		sp = p;
		while(*p && *p != 0x0d) p++;
		if(*p == 0x0d) { *p = 0; p += 2; }
		if(*p == 0 && sp == s)
			y = (rc.bottom - tm.tmHeight) / 2  - tm.tmInternalLeading / 4;
		TextOut(hdcClock, rc.right/2, y + dvpos, sp, strlen(sp));
		
		if(GetTextExtentPoint32(hdcClock, sp, strlen(sp), &sz) == 0)
			sz.cx = strlen(sp) * tm.tmAveCharWidth;
		if(w < sz.cx) w = sz.cx;
		
		y += hf; if(*p) y += 2 + dlineheight;
	}
	BitBlt(hdc, 0, 0, rc.right, rc.bottom, hdcClock, 0, 0, SRCCOPY);
	
	w += tm.tmAveCharWidth * 2;
	w += dwidth;
	if(w > iClockWidth)
	{
		iClockWidth = w;
		PostMessage(GetParent(GetParent(hwndClock)), WM_SIZE,
			SIZE_RESTORED, 0);
	}
}

/*------------------------------------------------
@vɕKvȃTCYԂ
@߂lFWORD @WORD 
--------------------------------------------------*/
LRESULT OnCalcRect(HWND hwnd)
{
	SYSTEMTIME t;
	int beat100;
	LRESULT w, h;
	HDC hdc;
	TEXTMETRIC tm;
	char s[1024], *p, *sp;
	SIZE sz;
	int hf;
	
	if(!IsWindowVisible(hwnd)) return 0;
	
	hdc = GetDC(hwnd);
	
	if(hFon) SelectObject(hdc, hFon);
	GetTextMetrics(hdc, &tm);
	
	GetDisplayTime(&t, nDispBeat?(&beat100):NULL);
	MakeFormat(s, &t, beat100, format);
	
	p = s; w = 0; h = 0;
	hf = tm.tmHeight - tm.tmInternalLeading;
	while(*p)
	{
		sp = p;
		while(*p && *p != 0x0d) p++;
		if(*p == 0x0d) { *p = 0; p += 2; }
		if(GetTextExtentPoint32(hdc, sp, strlen(sp), &sz) == 0)
			sz.cx = strlen(sp) * tm.tmAveCharWidth;
		if(w < sz.cx) w = sz.cx;
		h += hf; if(*p) h += 2 + dlineheight;
	}
	w += tm.tmAveCharWidth * 2;
	if(iClockWidth < 0) iClockWidth = w;
	else w = iClockWidth;
	w += dwidth;
	
	h += hf / 2 + dheight;
	if(h < 4) h = 4;
	
	ReleaseDC(hwnd, hdc);
	
	return (h << 16) + w;
}

/*------------------------------------------------
@c[`bv̕\
--------------------------------------------------*/
void OnTooltipNeedText(UINT code, LPARAM lParam)
{
	SYSTEMTIME t;
	int beat100;
	char fmt[1024], s[1024];
	
	GetMyRegStr("Tooltip", "Tooltip", fmt, 1024, "");
	if(fmt[0] == 0) strcpy(fmt, "\"TClock\" LDATE");
	GetDisplayTime(&t, &beat100);
	MakeFormat(s, &t, beat100, fmt);
	
	if(code == TTN_NEEDTEXT)
		strcpy(((LPTOOLTIPTEXT)lParam)->szText, s);
	else
		MultiByteToWideChar(CP_ACP, 0, s, -1,
			((LPTOOLTIPTEXTW)lParam)->szText, 80);
	SetWindowPos(hwndTip, HWND_TOPMOST, 0, 0, 0, 0,
		SWP_NOSIZE|SWP_NOMOVE|SWP_NOACTIVATE);
}


/*------------------------------------------------
  copy date/time text to clipboard
--------------------------------------------------*/
void OnCopy(HWND hwnd)
{
	SYSTEMTIME t;
	int beat100;
	char s[1024], fmt[1024], *pbuf;
	HGLOBAL hg;
	
	GetDisplayTime(&t, &beat100);
	GetMyRegStr("Mouse", "ClipFormat", fmt, 1024, "");
	if(fmt[0] == 0) strcpy(fmt, format);
	MakeFormat(s, &t, beat100, fmt);
	
	if(!OpenClipboard(hwnd)) return;
	EmptyClipboard();
	hg = GlobalAlloc(GMEM_DDESHARE, strlen(s) + 1);
	pbuf = (char*)GlobalLock(hg);
	strcpy(pbuf, s);
	GlobalUnlock(hg);
	SetClipboardData(CF_TEXT, hg);
	CloseClipboard(); 
}
