/*-------------------------------------------
  utl.c
  misc functions
  KAZUBON 1997-1999
---------------------------------------------*/

#include <windows.h>

void WriteDebug(LPSTR s);

extern HANDLE hmod;

int _strncmp(const char* d, const char* s, size_t n)
{
	unsigned int i;
	for(i = 0; i < n; i++)
	{
		if(*s == 0 && *d == 0) break;
		if(*d != *s) return (*d - *s);
		d++; s++;
	}
	return 0;
}

/*-------------------------------------------
@pXɃt@C
---------------------------------------------*/
void add_title(char *path, char *title)
{
	char *p;
	
	p = path;

	if(*title && *(title + 1) == ':') ;
	else if(*title == '\\')
	{
		if(*p && *(p + 1) == ':') p += 2;
	}
	else
	{
		while(*p)
		{
			if((*p == '\\' || *p == '/') && *(p + 1) == 0)
			{
				break;
			}
			p = CharNext(p);
		}
		*p++ = '\\';
	}
	while(*title) *p++ = *title++;
	*p = 0;
}

/*-------------------------------------------
@pXt@CƂ̂
---------------------------------------------*/
void del_title(char *path)
{
	char *p, *ep;

	p = ep = path;
	while(*p)
	{
		if(*p == '\\' || *p == '/')
		{
			if(p > path && *(p - 1) == ':') ep = p + 1;
			else ep = p;
		}
		p = CharNext(p);
	}
	*ep = 0;
}

/*------------------------------------------------
	J}ŋ؂ꂽo
--------------------------------------------------*/
void parse(char *dst, char *src, int n)
{
	char *dp;
	int i;

	for(i = 0; i < n; i++)
	{
		while(*src && *src != ',') src++;
		if(*src == ',') src++;
	}
	if(*src == 0) 
	{
		*dst = 0; return;
	}
	
	while(*src == ' ') src++;
	
	dp = dst;
	while(*src && *src != ',') *dst++ = *src++;
	*dst = 0;
	
	while(dst != dp)
	{
		dst--;
		if(*dst == ' ') *dst = 0;
		else break;
	}
}

/*-------------------------------------------
  returns a resource string
---------------------------------------------*/
char* MyString(UINT id)
{
	static char buf[80];
	
	if(LoadString(hmod, id, buf, 80) == 0)
		buf[0] = 0;
	
	return buf;
}

char mykey[] = "Software\\Kazubon\\TClock";

/*------------------------------------------------
@̃WXg當𓾂
--------------------------------------------------*/
int GetMyRegStr(char* section, char* entry, char* val, int cbData,
	char* defval)
{
	char keystr[80];
	HKEY hkey;
	DWORD regtype;
	DWORD size;
	BOOL b;
	int r;
	
	strcpy(keystr, mykey);
	if(section && *section)
	{
		strcat(keystr, "\\"); strcat(keystr, section);
	}
	b = FALSE;
	if(RegOpenKey(HKEY_CURRENT_USER, keystr, &hkey) == 0)
	{
		size = cbData;
		if(RegQueryValueEx(hkey, entry, 0, &regtype,
			(LPBYTE)val, &size) == 0)
		{
			if(size == 0) *val = 0;
			r = size;
			b = TRUE;
		}
		RegCloseKey(hkey);
	}
	if(b == FALSE)
	{
		strcpy(val, defval);
		r = strlen(defval);
	}
	return r;
}

/*------------------------------------------------
@̃WXgLONGl𓾂
--------------------------------------------------*/
LONG GetMyRegLong(char* section, char* entry, LONG defval)
{
	char keystr[80];
	HKEY hkey;
	DWORD regtype;
	DWORD size;
	BOOL b;
	LONG r;

	strcpy(keystr, mykey);
	if(section && *section)
	{
		strcat(keystr, "\\"); strcat(keystr, section);
	}
	b = FALSE;
	if(RegOpenKey(HKEY_CURRENT_USER, keystr, &hkey) == 0)
	{
		size = 4;
		if(RegQueryValueEx(hkey, entry, 0, &regtype,
			(LPBYTE)&r, &size) == 0)
		{
			if(size == 4) b = TRUE;
		}
		RegCloseKey(hkey);
	}
	if(b == FALSE) r = defval;
	return r;
}

/*------------------------------------------------
  get DWORD value from registry
--------------------------------------------------*/
LONG GetRegLong(HKEY rootkey, char*subkey, char* entry, LONG defval)
{
	HKEY hkey;
	DWORD regtype;
	DWORD size;
	BOOL b;
	int r;
	
	b = FALSE;
	if(RegOpenKey(rootkey, subkey, &hkey) == 0)
	{
		size = 4;
		if(RegQueryValueEx(hkey, entry, 0, &regtype,
			(LPBYTE)&r, &size) == 0)
		{
			if(size == 4) b = TRUE;
		}
		RegCloseKey(hkey);
	}
	if(b == FALSE) r = defval;
	return r;
}

/*------------------------------------------------
@WXg當𓾂
--------------------------------------------------*/
int GetRegStr(HKEY rootkey, char*subkey, char* entry,
	char* val, int cbData, char* defval)
{
	HKEY hkey;
	DWORD regtype;
	DWORD size;
	BOOL b;
	int r;
	
	b = FALSE;
	if(RegOpenKey(rootkey, subkey, &hkey) == 0)
	{
		size = cbData;
		if(RegQueryValueEx(hkey, entry, 0, &regtype,
			(LPBYTE)val, &size) == 0)
		{
			if(size == 0) *val = 0;
			b = TRUE;
		}
		RegCloseKey(hkey);
	}
	if(b == FALSE)
	{
		strcpy(val, defval);
		r = strlen(defval);
	}
	return r;
}

/*-------------------------------------------
@WXgɕ
---------------------------------------------*/
BOOL SetMyRegStr(char* subkey, char* entry, char* val)
{
	HKEY hkey;
	BOOL r;
	char key[80];
	
	strcpy(key, mykey);
	if(*subkey)
	{
		strcat(key, "\\"); strcat(key, subkey);
	}
	r = FALSE;
	if(RegCreateKey(HKEY_CURRENT_USER, key, &hkey) == 0)
	{
		if(RegSetValueEx(hkey, entry, 0, REG_SZ,
			(CONST BYTE*)val, strlen(val)) == 0)
		{
			r = TRUE;
		}
		RegCloseKey(hkey);
	}
	return r;
}

/*-------------------------------------------
@WXgDWORDl
---------------------------------------------*/
BOOL SetMyRegLong(char* subkey, char* entry, DWORD val)
{
	HKEY hkey;
	BOOL r;
	char key[80];
	
	strcpy(key, mykey);
	if(*subkey)
	{
		strcat(key, "\\"); strcat(key, subkey);
	}
	r = FALSE;
	if(RegCreateKey(HKEY_CURRENT_USER, key, &hkey) == 0)
	{
		if(RegSetValueEx(hkey, entry, 0, REG_DWORD,
			(CONST BYTE*)&val, 4) == 0)
		{
			r = TRUE;
		}
		RegCloseKey(hkey);
	}
	return r;
}

/*------------------------------------------------
@fobOp
--------------------------------------------------*/
void WriteDebug(LPSTR s)
{
	HFILE hf;
	char fname[MAX_PATH], title[] = "DEBUG.TXT";

	GetModuleFileName(hmod, fname, MAX_PATH);
	del_title(fname);
	add_title(fname, title);
	hf = _lopen(fname, OF_WRITE);
	if(hf == HFILE_ERROR) hf = _lcreat(fname, 0);
	if(hf == HFILE_ERROR) return;
	_llseek(hf, 0, 2);
	_lwrite(hf, s, lstrlen(s));
	_lwrite(hf, "\x0d\x0a", 2);
	_lclose(hf);
}
