/*-------------------------------------------
  taskswitch.c
    Customize Task Switcher
    Kazubon 1999
---------------------------------------------*/
#include "tcdll.h"

#define TCS_FLATBUTTONS         0x0008

extern HANDLE hmod;

LRESULT CALLBACK WndProcTab(HWND, UINT, WPARAM, LPARAM);
void EndTaskSwitch(void);
static WNDPROC oldWndProcTab = NULL;
static HWND hwndTab = NULL;
static LONG oldstyle;

/*--------------------------------------------------
   initialize
----------------------------------------------------*/
void InitTaskSwitch(HWND hwndClock)
{
	HANDLE hwnd, hwndTaskSwitch;
	char classname[80];
	
	EndTaskSwitch();
	
	if(!GetMyRegLong(NULL, "TaskSwitchFlat", FALSE))
		return;
	
	// get window handle of MSTaskSwWClass
	hwndTaskSwitch = NULL;
	hwnd = GetParent(hwndClock);  // TrayNotifyWnd
	hwnd = GetParent(hwnd);       // Shell_TrayWnd
	if(hwnd == NULL) return;
	hwnd = GetWindow(hwnd, GW_CHILD);
	while(hwnd)
	{
		GetClassName(hwnd, classname, 80);
		if(lstrcmpi(classname, "ReBarWindow32") == 0)
		{
			hwnd = GetWindow(hwnd, GW_CHILD);
			while(hwnd)
			{
				GetClassName(hwnd, classname, 80);
				if(lstrcmpi(classname, "MSTaskSwWClass") == 0)
				{
					hwndTaskSwitch = hwnd;
					break;
				}
				hwnd = GetWindow(hwnd, GW_HWNDNEXT);
			}
		}
		else if(lstrcmpi(classname, "MSTaskSwWClass") == 0)
		{
			hwndTaskSwitch = hwnd;
			break;
		}
		hwnd = GetWindow(hwnd, GW_HWNDNEXT);
	}
	if(hwndTaskSwitch == NULL)
		return;
	hwndTab = GetWindow(hwndTaskSwitch, GW_CHILD);
	if(hwndTab == NULL)
		return;
	
	oldstyle = GetWindowLong(hwndTab, GWL_STYLE);
	SetWindowLong(hwndTab, GWL_STYLE, oldstyle|TCS_FLATBUTTONS);
	
	oldWndProcTab = (WNDPROC)GetWindowLong(hwndTab, GWL_WNDPROC);
	SetWindowLong(hwndTab, GWL_WNDPROC, (LONG)WndProcTab);
}

/*--------------------------------------------------
    undo
----------------------------------------------------*/
void EndTaskSwitch(void)
{
	if(hwndTab && IsWindow(hwndTab))
	{
		if(oldWndProcTab)
			SetWindowLong(hwndTab, GWL_WNDPROC, (LONG)oldWndProcTab);
		oldWndProcTab = NULL;
		SetWindowLong(hwndTab, GWL_STYLE, oldstyle);
	}
	hwndTab = NULL;
}

/*------------------------------------------------
   subclass procedure of SysTabControl32
--------------------------------------------------*/
LRESULT CALLBACK WndProcTab(HWND hwnd, UINT message,
	WPARAM wParam, LPARAM lParam)
{
	switch(message)
	{
		case TCM_SETITEMSIZE:
			if(LOWORD(lParam)-8 >= 22)
				lParam = MAKELPARAM(LOWORD(lParam)-8, HIWORD(lParam));
			break;
		case TCM_INSERTITEM:
			PostMessage(GetParent(hwnd), WM_SIZE, SIZE_RESTORED, 0);
			break;
	}
	return CallWindowProc(oldWndProcTab, hwnd, message, wParam, lParam);
}

