//---[s]--- For InternetTime 99/03/16@211 M.Takemura -----

/*-----------------------------------------------------
    format.c
    to make a string to display in the clock
    KAZUBON 1997-1998
-------------------------------------------------------*/

#include "tcdll.h"

int codepage = CP_ACP;
static char DayOfWeekShort[11], DayOfWeekLong[31];
static char MonthShort[11], MonthLong[31];
static char *DayOfWeekEng[7] = { "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat" };
static char *MonthEng[12] = { "Jan", "Feb", "Mar", "Apr", "May", "Jun",
	"Jul", "Aug", "Sep", "Oct", "Nov", "Dec" };
static char AM[11], PM[11], SDate[5], STime[5];
static char EraStr[11];
static int AltYear;

extern BOOL bHour12, bHourZero;

/*------------------------------------------------
  GetLocaleInfo() for 95/NT
--------------------------------------------------*/
int GetLocaleInfoWA(WORD wLanguageID, LCTYPE LCType, char* dst, int n)
{
	int r;
	LCID Locale;
	
	*dst = 0;
	Locale = MAKELCID(wLanguageID, SORT_DEFAULT);
	if(GetVersion() & 0x80000000) // 95
		r = GetLocaleInfoA(Locale, LCType, dst, n);
	else  // NT
	{
		WCHAR* pw;
		pw = (WCHAR*)GlobalAllocPtr(GHND, sizeof(WCHAR)*(n+1));
		*pw = 0;
		r = GetLocaleInfoW(Locale, LCType, pw, n);
		if(r)
			WideCharToMultiByte(codepage, 0, pw, -1, dst, n,
				NULL, NULL);
		GlobalFreePtr(pw);
	}
	return r;
}

/*------------------------------------------------
  GetDateFormat() for 95/NT
--------------------------------------------------*/
int GetDateFormatWA(WORD wLanguageID, DWORD dwFlags, CONST SYSTEMTIME *t,
	char* fmt, char* dst, int n)
{
	int r;
	LCID Locale;
	
	*dst = 0;
	Locale = MAKELCID(wLanguageID, SORT_DEFAULT);
	if(GetVersion() & 0x80000000) // 95
		r = GetDateFormatA(Locale, dwFlags, t, fmt, dst, n);
	
	else  // NT
	{
		WCHAR* pw1, *pw2;
		pw1 = NULL;
		if(fmt)
		{
			pw1 = (WCHAR*)GlobalAllocPtr(GHND,
				sizeof(WCHAR)*(strlen(fmt)+1));
			MultiByteToWideChar(CP_ACP, 0, fmt, -1,
				pw1, strlen(fmt));
		}
		pw2 = (WCHAR*)GlobalAllocPtr(GHND, sizeof(WCHAR)*(n+1));
		r = GetDateFormatW(Locale, dwFlags, t, pw1, pw2, n);
		if(r)
			WideCharToMultiByte(CP_ACP, 0, pw2, -1, dst, n,
				NULL, NULL);
		if(pw1) GlobalFreePtr(pw1);
		GlobalFreePtr(pw2);
	}
	return r;
}

/*------------------------------------------------
  GetTimeFormat() for 95/NT
--------------------------------------------------*/
int GetTimeFormatWA(WORD wLanguageID, DWORD dwFlags, CONST SYSTEMTIME *t,
	char* fmt, char* dst, int n)
{
	int r;
	LCID Locale;
	
	*dst = 0;
	Locale = MAKELCID(wLanguageID, SORT_DEFAULT);
	if(GetVersion() & 0x80000000) // 95
		r = GetTimeFormatA(Locale, dwFlags, t, fmt, dst, n);
	
	else  // NT
	{
		WCHAR* pw1, *pw2;
		pw1 = NULL;
		if(fmt)
		{
			pw1 = (WCHAR*)GlobalAllocPtr(GHND,
				sizeof(WCHAR)*(strlen(fmt)+1));
			MultiByteToWideChar(CP_ACP, 0, fmt, -1,
				pw1, strlen(fmt));
		}
		pw2 = (WCHAR*)GlobalAllocPtr(GHND, sizeof(WCHAR)*(n+1));
		r = GetTimeFormatW(Locale, dwFlags, t, pw1, pw2, n);
		if(r)
			WideCharToMultiByte(CP_ACP, 0, pw2, -1, dst, n,
				NULL, NULL);
		if(pw1) GlobalFreePtr(pw1);
		GlobalFreePtr(pw2);
	}
	return r;
}

/*------------------------------------------------
  load strings of day, month
--------------------------------------------------*/
void InitFormat(SYSTEMTIME* lt)
{
	char s[80], *p;
	int i, ilang, ioptcal;
	
	ilang = GetMyRegLong(NULL, "Locale", (int)GetUserDefaultLangID());
	
	codepage = CP_ACP;
	if(GetLocaleInfoWA((WORD)ilang, LOCALE_IDEFAULTANSICODEPAGE,
		s, 10) > 0)
	{
		p = s; codepage = 0;
		while('0' <= *p && *p <= '9')
			codepage = codepage * 10 + *p++ - '0';
		if(!IsValidCodePage(codepage)) codepage = CP_ACP;
	}
	
	i = lt->wDayOfWeek; i--; if(i < 0) i = 6;
	GetLocaleInfoWA((WORD)ilang, LOCALE_SABBREVDAYNAME1 + i,
		DayOfWeekShort, 10);
	GetLocaleInfoWA((WORD)ilang, LOCALE_SDAYNAME1 + i,
		DayOfWeekLong, 30);
	i = lt->wMonth; i--;
	GetLocaleInfoWA((WORD)ilang, LOCALE_SABBREVMONTHNAME1 + i,
		MonthShort, 10);
	GetLocaleInfoWA((WORD)ilang, LOCALE_SMONTHNAME1 + i,
		MonthLong, 30);
	
	GetLocaleInfoWA((WORD)ilang, LOCALE_S1159, AM, 10);
	GetMyRegStr(NULL, "AMsymbol", s, 80, AM);
	if(s[0] == 0) strcpy(s, "AM");
	strcpy(AM, s);
	GetLocaleInfoWA((WORD)ilang, LOCALE_S2359, PM, 10);
	GetMyRegStr(NULL, "PMsymbol", s, 80, PM);
	if(s[0] == 0) strcpy(s, "PM");
	strcpy(PM, s);
	
	GetLocaleInfoWA((WORD)ilang, LOCALE_SDATE, SDate, 4);
	GetLocaleInfoWA((WORD)ilang, LOCALE_STIME, STime, 4);
	
	EraStr[0] = 0;
	AltYear = -1;
	
	ioptcal = 0;
	if(GetLocaleInfoWA((WORD)ilang, LOCALE_IOPTIONALCALENDAR,
		s, 10))
	{
		ioptcal = 0;
		p = s;
		while('0' <= *p && *p <= '9')
			ioptcal = ioptcal * 10 + *p++ - '0';
	}
	if(ioptcal < 3) ilang = LANG_USER_DEFAULT;
	
	if(GetDateFormatWA((WORD)ilang,
		DATE_USE_ALT_CALENDAR, lt, "gg", s, 12) != 0);
		strcpy(EraStr, s);
	
	if(GetDateFormatWA((WORD)ilang,
		DATE_USE_ALT_CALENDAR, lt, "yyyy", s, 6) != 0)
	{
		if(s[0])
		{
			p = s;
			AltYear = 0;
			while('0' <= *p && *p <= '9')
				AltYear = AltYear * 10 + *p++ - '0';
		}
	}
}

/*------------------------------------------------
   make a string from date and time format
--------------------------------------------------*/
void MakeFormat(char* s, SYSTEMTIME* pt, int beat100, char* fmt)
{
	char *sp, *dp, *p;
	
	sp = fmt; dp = s;
	while(*sp)
	{
		if(*sp == '\"')
		{
			sp++;
			while(*sp != '\"' && *sp)
			{
				p = CharNext(sp);
				while(sp != p) *dp++ = *sp++;
			}
			if(*sp == '\"') sp++;
		}
		else if(*sp == '/')
		{
			p = SDate; while(*p) *dp++ = *p++;
			sp++;
		}
		else if(*sp == ':')
		{
			p = STime; while(*p) *dp++ = *p++;
			sp++;
		}
		else if(*sp == 'y' && *(sp + 1) == 'y')
		{
			if(*(sp + 2) == 'y' && *(sp + 3) == 'y')
			{
				*dp++ = (char)((int)pt->wYear / 1000) + '0';
				*dp++ = (char)(((int)pt->wYear % 1000) / 100) + '0';
				sp += 2;
			}
			*dp++ = (char)(((int)pt->wYear % 100) / 10) + '0';
			*dp++ = (char)((int)pt->wYear % 10) + '0';
			sp += 2;
		}
		else if(*sp == 'm')
		{
			if(*(sp + 1) == 'm' && *(sp + 2) == 'e')
			{
				*dp++ = MonthEng[pt->wMonth-1][0];
				*dp++ = MonthEng[pt->wMonth-1][1];
				*dp++ = MonthEng[pt->wMonth-1][2];
				sp += 3;
			}
			else if(*(sp + 1) == 'm' && *(sp + 2) == 'm')
			{
				if(*(sp + 3) == 'm')
				{
					p = MonthLong;
					while(*p) *dp++ = *p++;
					sp += 4;
				}
				else
				{
					p = MonthShort;
					while(*p) *dp++ = *p++;
					sp += 3;
				}
			}
			else
			{
				if(*(sp + 1) == 'm')
				{
					*dp++ = (char)((int)pt->wMonth / 10) + '0';
					sp += 2;
				}
				else
				{
					if(pt->wMonth > 9)
						*dp++ = (char)((int)pt->wMonth / 10) + '0';
					sp++;
				}
				*dp++ = (char)((int)pt->wMonth % 10) + '0';
			}
		}
		else if(*sp == 'a' && *(sp + 1) == 'a' && *(sp + 2) == 'a')
		{
			if(*(sp + 3) == 'a')
			{
				p = DayOfWeekLong;
				while(*p) *dp++ = *p++;
				sp += 4;
			}
			else
			{
				p = DayOfWeekShort;
				while(*p) *dp++ = *p++;
				sp += 3;
			}
		}
		else if(*sp == 'd')
		{
			if(*(sp + 1) == 'd' && *(sp + 2) == 'e')
			{
				p = DayOfWeekEng[pt->wDayOfWeek];
				while(*p) *dp++ = *p++;
				sp += 3;
			}
			else if(*(sp + 1) == 'd' && *(sp + 2) == 'd')
			{
				if(*(sp + 3) == 'd')
				{
					p = DayOfWeekLong;
					while(*p) *dp++ = *p++;
					sp += 4;
				}
				else
				{
					p = DayOfWeekShort;
					while(*p) *dp++ = *p++;
					sp += 3;
				}
			}
			else
			{
				if(*(sp + 1) == 'd')
				{
					*dp++ = (char)((int)pt->wDay / 10) + '0';
					sp += 2;
				}
				else
				{
					if(pt->wDay > 9)
						*dp++ = (char)((int)pt->wDay / 10) + '0';
					sp++;
				}
				*dp++ = (char)((int)pt->wDay % 10) + '0';
			}
		}
		else if(*sp == 'h')
		{
			int hour;
			hour = pt->wHour;
			if(bHour12)
			{
				if(hour > 12) hour -= 12;
				else if(hour == 0) hour = 12;
				if(hour == 12 && bHourZero) hour = 0;
			}
			if(*(sp + 1) == 'h')
			{
				*dp++ = (char)(hour / 10) + '0';
				sp += 2;
			}
			else
			{
				if(hour > 9)
					*dp++ = (char)(hour / 10) + '0';
				sp++;
			}
			*dp++ = (char)(hour % 10) + '0';
		}
		else if(*sp == 'n')
		{
			if(*(sp + 1) == 'n')
			{
				*dp++ = (char)((int)pt->wMinute / 10) + '0';
				sp += 2;
			}
			else
			{
				if(pt->wMinute > 9)
					*dp++ = (char)((int)pt->wMinute / 10) + '0';
				sp++;
			}
			*dp++ = (char)((int)pt->wMinute % 10) + '0';
		}
		else if(*sp == 's')
		{
			if(*(sp + 1) == 's')
			{
				*dp++ = (char)((int)pt->wSecond / 10) + '0';
				sp += 2;
			}
			else
			{
				if(pt->wSecond > 9)
					*dp++ = (char)((int)pt->wSecond / 10) + '0';
				sp++;
			}
			*dp++ = (char)((int)pt->wSecond % 10) + '0';
		}
		else if(*sp == 't' && *(sp + 1) == 't')
		{
			if(pt->wHour < 12) p = AM; else p = PM;
			while(*p) *dp++ = *p++;
			sp += 2;
		}
		else if(*sp == 'A' && *(sp + 1) == 'M')
		{
			if(*(sp + 2) == '/' &&
				*(sp + 3) == 'P' && *(sp + 4) == 'M')
			{
				if(pt->wHour < 12) *dp++ = 'A';
				else *dp++ = 'P';
				*dp++ = 'M'; sp += 5;
			}
			else if(*(sp + 2) == 'P' && *(sp + 3) == 'M')
			{
				if(pt->wHour < 12) p = AM; else p = PM;
				while(*p) *dp++ = *p++;
				sp += 4;
			}
		}
		else if(*sp == 'a' && *(sp + 1) == 'm' && *(sp + 2) == '/' &&
			*(sp + 3) == 'p' && *(sp + 4) == 'm')
		{
			if(pt->wHour < 12) *dp++ = 'a';
			else *dp++ = 'p';
			*dp++ = 'm'; sp += 5;
		}
		else if(*sp == '\\' && *(sp + 1) == 'n')
		{
			*dp++ = 0x0d; *dp++ = 0x0a;
			sp += 2;
		}
		// internet time
		else if (*sp == '@' && *(sp + 1) == '@' && *(sp + 2) == '@')
		{
			*dp++ = '@';
			*dp++ = beat100 / 10000 + '0';
			*dp++ = (beat100 % 10000) / 1000 + '0';
			*dp++ = (beat100 % 1000) / 100 + '0';
			sp += 3;
			if(*sp == '.' && *(sp + 1) == '@')
			{
				*dp++ = '.';
				*dp++ = (beat100 % 100) / 10 + '0';
				sp += 2;
			}
		}
		// alternate calendar
		else if(*sp == 'Y' && AltYear > -1)
		{
			int n = 1;
			while(*sp == 'Y') { n *= 10; sp++; }
			if(n < AltYear)
			{
				n = 1; while(n < AltYear) n *= 10;
			}
			while(1)
			{
				*dp++ = (AltYear % n) / (n/10) + '0';
				if(n == 10) break;
				n /= 10;
			}
		}
		else if(*sp == 'g')
		{
			char *p2;
			p = EraStr;
			while(*p && *sp == 'g')
			{
				p2 = CharNextExA((WORD)codepage, p, 0);
				while(p != p2) *dp++ = *p++;
				sp++;
			}
			while(*sp == 'g') sp++;
		}
		else if(_strncmp(sp, "LDATE", 5) == 0)
		{
			char s[80], *p;
			GetDateFormatWA(MAKELANGID(LANG_NEUTRAL,SUBLANG_DEFAULT),
				DATE_LONGDATE, pt, NULL, s, 80);
			p = s;
			while(*p) *dp++ = *p++;
			sp += 5;
		}
		else if(_strncmp(sp, "DATE", 4) == 0)
		{
			char s[80], *p;
			GetDateFormatWA(MAKELANGID(LANG_NEUTRAL,SUBLANG_DEFAULT),
				DATE_SHORTDATE, pt, NULL, s, 80);
			p = s;
			while(*p) *dp++ = *p++;
			sp += 4;
		}
		else if(_strncmp(sp, "TIME", 4) == 0)
		{
			char s[80], *p;
			GetTimeFormatWA(MAKELANGID(LANG_NEUTRAL,SUBLANG_DEFAULT),
				TIME_FORCE24HOURFORMAT, pt, NULL, s, 80);
			p = s;
			while(*p) *dp++ = *p++;
			sp += 4;
		}
		else
		{
			p = CharNext(sp);
			while(sp != p) *dp++ = *sp++;
		}
	}
	*dp = 0;
}

/*------------------------------------------------
  need to display second?
--------------------------------------------------*/
BOOL IsDispSecond(char* fmt)
{
	char *sp;
	
	sp = fmt;
	while(*sp)
	{
		if(*sp == '\"')
		{
			sp++;
			while(*sp != '\"' && *sp) sp++;
			if(*sp == '\"') sp++;
		}
		else if(*sp == 's')
		{
			return TRUE;
		}
		else sp = CharNext(sp);
	}
	return FALSE;
}

/*------------------------------------------------
  need to display beats?
--------------------------------------------------*/
int IsDispBeat(char* fmt)
{
	char *sp;
	
	sp = fmt;
	while(*sp)
	{
		if(*sp == '\"')
		{
			sp++;
			while(*sp != '\"' && *sp) sp++;
			if(*sp == '\"') sp++;
		}
		else if (*sp == '@' && *(sp + 1) == '@' && *(sp + 2) == '@')
		{
			sp += 3;
			if(*sp == '.' && *(sp + 1) == '@')
				return 2;
			return 1;
		}
		else sp = CharNext(sp);
	}
	return 0;
}
