//---------------------------------------------------------------------------
#include <windows.h>
#pragma hdrstop
//---------------------------------------------------------------------------

#define NAME "StickyHot"
#define MSG_STICKY_NEW    0x8003
#define MSG_STICKY_TO_TOP 0x8022
#define MSG_STICKY_SHOW   0x8019
#define MSG_STICKY_FIND   0x8023
enum {
  STICKY_NEW,
  STICKY_TO_TOP,
  STICKY_SHOW,
  STICKY_FIND
  };

LRESULT CALLBACK HookWndProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam) {
  switch (msg) {
    case WM_HOTKEY: {
      HWND hwndSticky = FindWindow(NULL, "StickyNote");

      if (hwndSticky > 0) {
        SetForegroundWindow(hwndSticky);
        if ((wParam == STICKY_NEW) && (lParam == (MOD_CONTROL | (VK_SPACE << 16)))) {
          SendMessage(hwndSticky, WM_COMMAND, MSG_STICKY_NEW, 0);
          return TRUE;
          }
        else if ((wParam == STICKY_TO_TOP) && (lParam == (MOD_CONTROL | MOD_ALT | (VK_SPACE << 16)))) {
          SendMessage(hwndSticky, WM_COMMAND, MSG_STICKY_TO_TOP, 0);
          return TRUE;
          }
        else if ((wParam == STICKY_SHOW) && (lParam == (MOD_CONTROL | MOD_SHIFT | (VK_SPACE << 16)))) {
          SendMessage(hwndSticky, WM_COMMAND, MSG_STICKY_SHOW, 0);
          return TRUE;
          }
        else if ((wParam == STICKY_FIND) && (lParam == (MOD_CONTROL | MOD_SHIFT | MOD_ALT | (VK_SPACE << 16)))) {
          SendMessage(hwndSticky, WM_COMMAND, MSG_STICKY_FIND, 0);
          return TRUE;
          }
        }
      }
      break;
    case WM_DESTROY:
      PostQuitMessage(0);
    }
  return DefWindowProc(hwnd, msg, wParam, lParam);
  }

WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, PSTR szCmdLine,
  int iCmdShow) {
  HWND hwndHook;
  WNDCLASS wc;
  MSG msg;

  if (FindWindow(NAME, NAME))
    return 1;
  wc.hCursor        = NULL;
  wc.hIcon          = NULL;
  wc.lpszMenuName   = NULL;
  wc.lpszClassName  = NAME;
  wc.hbrBackground  = (HBRUSH)(COLOR_WINDOW + 1);
  wc.hInstance      = hInstance;
  wc.style          = 0;
  wc.lpfnWndProc    = HookWndProc;
  wc.cbWndExtra     = sizeof(HWND) + sizeof(HWND);
  wc.cbClsExtra     = 0;
  if (!RegisterClass(&wc)) {
    MessageBox(NULL,"Error creating window class", NAME, MB_OK | MB_ICONHAND);
    return 2;
    }
  if (!(hwndHook = CreateWindow(NAME, NAME,
    WS_OVERLAPPEDWINDOW,
    0, 0, 0, 0,
    (HWND) NULL,
    (HMENU) NULL,
    (HINSTANCE)hInstance,
    (LPVOID) NULL))) {
    MessageBox(NULL, "Error creating window", NAME, MB_OK | MB_ICONHAND);
    return 3;
    }
  RegisterHotKey(hwndHook, STICKY_NEW, MOD_CONTROL, VK_SPACE);
  RegisterHotKey(hwndHook, STICKY_TO_TOP, MOD_CONTROL | MOD_ALT, VK_SPACE);
  RegisterHotKey(hwndHook, STICKY_SHOW, MOD_CONTROL | MOD_SHIFT, VK_SPACE);
  RegisterHotKey(hwndHook, STICKY_FIND, MOD_CONTROL | MOD_SHIFT | MOD_ALT, VK_SPACE);
  while (IsWindow(hwndHook) && GetMessage(&msg, hwndHook, 0, 0)) {
    TranslateMessage(&msg);
    DispatchMessage(&msg);
    }
  UnregisterHotKey(hwndHook, STICKY_FIND);
  UnregisterHotKey(hwndHook, STICKY_SHOW);
  UnregisterHotKey(hwndHook, STICKY_TO_TOP);
  UnregisterHotKey(hwndHook, STICKY_NEW);
  return 0;
  }
//---------------------------------------------------------------------------

