@echo off
REM
REM   Desktop Engineer's Junk Drawer Original
REM   http://www.info-evolution.com/dejd
REM
REM   Name:    snapreg.bat
REM   Author:  Darwin Sanoy
REM   
REM   Purpose: This batch file can performs a before and
REM            after snapshot of the registry.
REM            It does not require installation, uses utilities
REM            that are on ever Windows 95, 98 and NT computer
REM            and it is only 3K.
REM
REM   Audit history:
REM
REM      12/5/95  - Created Original Version
REM      10/17/97 - Modified to handle reboot
REM      7/1/98 - Changed batch file name and email address 
REM 
REM   Dependencies:
REM      Uses choice.com, fc.exe and notepad.exe.

echo.
echo              ***************************************************************
echo              *                                                             *
echo              *  Snapreg V 1.3 - Quick and Dirty Registry Snapshot Utility  *
echo              *                                                             *
echo              *  By Darwin Sanoy (Darwin@Info-Evolution.com)                *
echo              *                                                             *
echo              ***************************************************************
echo.
echo.

set FILEDIR=%WINDIR%
set FC_COMMAND=FC

if not exist %FILEDIR%\after.txt goto testreboot
goto :startover

:testreboot
echo.
echo A previous "before" snapshot is present...
echo.
if exist %FILEDIR%\before.txt choice /C:CS "Do you want to [C]ontinue with after snapshot or [S]tart over? "
if errorlevel 2 goto :startover
if errorlevel 1 goto :continue

:startover
echo.
echo Deleting Snapshots from Previous Run...
echo.
if exist %FILEDIR%\before.txt del %FILEDIR%\before.txt
if exist %FILEDIR%\after.txt del %FILEDIR%\after.txt 
if exist %FILEDIR%\regcomp.txt del %FILEDIR%\regcomp.txt

echo.
echo Creating Before Registry Snapshot ....
echo.
start /wait regedit /e %FILEDIR%\before.txt 

echo.
echo Before Snapshot Complete...
echo.
echo Now make the changes you wish to examine and execute snapreg.bat again.
echo.
echo (Press "Y" now to skip 10 second message delay)
echo.
choice /N /T:Y,10
exit

:continue
echo.
echo Creating After Registry Snapshot ...
echo.
start /wait regedit /e %FILEDIR%\after.txt

echo.
echo After Snapshot Complete...
echo.

echo Comparing Before and After Registry Snapshots ...
echo.
echo Compare file name: %FILEDIR%\regcomp.txt
echo.
%FC_COMMAND% %FILEDIR%\before.txt %FILEDIR%\after.txt > %FILEDIR%\regcomp.txt
notepad %FILEDIR%\regcomp.txt
exit
