        PAGE    60,132
NAME    SHRIEK
        TITLE   SHRIEK.com version 1.6
COMMENT |


This program may be freely copied and used for any purpose
except military.

Usage:

insert this command near the end of your autoexec.bat file:

SHRIEK
or
SHRIEK duration frequency

e.g.  SHRIEK 250 554
      where duration is measured in milliseconds and frequency in Hertz.

Don't use SHRIEK more than once till you reboot.  Otherwise you
will end up with multiple copies of SHRIEK in RAM chained to
each other.  This will slow down screen paints.

Please report bugs and problems to:

Roedy Green
Canadian Mind Products
#208 - 525 Ninth Street
New Westminster BC Canada
V5H 2N6
tel:(604) 777-1804
mailto:roedy@mindprod.com
http://mindprod.com


Version History


Version 1.6 1998 November 8
- embed Barker address

Version 1.5 1996 October 25
- embed POB 707 Quathiaski Cove address

Version 1.4 released 1993 June 8
- display new address and phone number

Version 1.3 released 1990 June 27
- now properly releases the environment.  Missing INT 21h
- now closes StdIn and StdOut so piping will not lose a handle.

Version 1.2 released 1990 May 15
- now releases environment region to save RAM.
- new address
- slightly faster code to jump to old INT 10
- slightly flashier banner.

Version 1.1 released 1989 March 14

What Is Shriek For
******************

Shriek changes the pitch or duration of the standard system
beep.  When you accelerate your XT or AT clone, sometimes the
ROM BIOS is not prepared for this eventuality.  Beep tones may
start coming out as piercing high-pitched shrieks.  Beep tones
may be too short in duration.  Shriek is a 96-byte TSR that
repairs this defect in your BIOS.  You can configure Shriek for
whatever pitch and duration you like best.


How Does Shriek Work
********************

Shriek is a tiny 96 byte TSR than intercepts the Video INT 10
BIOS interrupt and handles making beep tones properly, while
allowing the normal BIOS routines to handle screen painting
functions.

How Shriek Makes a Tone
***********************

We set the countdown value for the hardware square wave generator
built in to the machine.  The hardware counts down, then pushes
the loudspeaker out.  Then it counts down again and then pushes
the loudspeaker in.  If it does this whole cycle 440 times a
second, you will hear middle A.

Unlike more primitive machines such as the Apple ][, once the
tone is started, the hardware can continue generating the sound
indefinitely without further help from the CPU.  When it is time
to turn off the tone, the CPU must then intervene to shut the
tone off.

Tone versus Frequency
*********************

       middle A Ŀ    Frequency in Hz
 A =  55 110 220 440  880 1760 3520  7040 14080  = A
A# =  58 117 233 466  932 1865 3729  7459 14917  = B flat
 B =  62 123 247 494  988 1976 3951  7902 15804  = B
 C =  65 131 262 523 1047 2093 4186  8372 16744  = C
C# =  69 139 277 554 1109 2217 4434  8870 17740  = D flat   T
 D =  73 147 294 587 1175 2349 4699  9397 18795  = D        o
D# =  78 156 311 622 1245 2489 4978  9956 19912  = E flat   n
 E =  82 165 330 659 1319 2637 5274 10548 21096  = E        e
 F =  87 175 349 698 1397 2794 5588 11175 22351  = F
F# =  92 185 370 740 1480 2960 5920 11840 23680  = G flat
 G =  98 196 392 784 1568 3136 6272 12544 25088  = G
G# = 104 208 415 831 1661 3322 6645 13290 26580  = A flat

| ; end of comment

CODE    SEGMENT PARA

        ASSUME  CS:CODE,DS:CODE
        ORG     100H

;==============================================================

; Configuration EQUATES

CalibTime       EQU     3000d   ; time to spend calibrating in ms
                                ; usually 3 seconds.
CalibTicks      EQU     55d     ; time to spend calibratiing in ticks
                                ; calculate as CalibTime*18.20648193/1000
                                ; MASM has trouble doing such a calculation
                                ; for you.

MinDuration     EQU     10d     ; low bound on Duration in ms
DefaultDuration EQU     250d    ; default duration in ms
MaxDuration     EQU     2000d   ; high bound on Duration in ms

MinFreq         EQU     41d     ; low bound on Freq in Hertz
DefaultFreq     EQU     554d    ; default Frequency in Hertz
                                ; middle D
MaxFreq         EQU     14080d  ; high bound on Freq in Hertz

;==============================================================

;       Register Conventions
;
;       All subroutines are permitted to trash whatever registers
;       they like.  It is the caller's responsibility to save
;       and restore registers.  For speed, callers cheat and only
;       save registers they know the called program changes.
;       In a few cases, subroutines do save/restore some registers.

;==============================================================

SAY     MACRO   Msg
;;      display message on screen
        LEA     DX,&Msg         ;; use LEA rather than
                                ;; MOV Offset for more generality
        MOV     AH,09h          ;; some assemblers will optimise this.
        INT     21h
        ENDM

;==============================================================

; MAINLINE PROGRAM

SHRIEK   PROC    FAR
START:
        JMP     Init
                                ; Mainline disposable Init routine
                                ; uses TRAP to set up vectors to
                                ; FIELD and BEEP which later
                                ; do the real work.

;==============================================================

; VARIABLES

Duration        DW      DefaultDuration
                                ; length of beep in milliseconds
                                ; May be changed on command line.

LoopsPerMs      DW      1066d   ; how many null CX loops execute per ms
                                ; Typically 1066 for 16 MHz 80386
                                ; This is an approximation that
                                ; will be adjusted via
                                ; calibration when SHRIEK is loaded.

; Freq is disposable, and comes later

Divisor         DW      2570    ; 1,131,000/Freq e.g. 2570 for 440 Hz.
                                ; Squarewave count down value.
                                ; Calculated from Frequency

RealInt10Off    DW      0       ; offset of real INT10 BIOS code

RealInt10Seg    DW      0       ; Seg of real INT10 BIOS code


;==============================================================

FIELD   Proc    Far
;       Field (intercept and handle) INT 10 Interrupt
;       Look for BEEP, AH=14 write teletype AL=7 Bel
;       Do not disturb registers or even flags, DS: cannot be trusted
;       We cannot use any DOS services.

        PUSHF
        CMP     AX,0E07h        ; 0E=14 write TTY 07=Bel
        JE      IsBeep

NotBeep:
;   Let BIOS Int 10 handle it.
                                ; We simply want to jump to
                                ; the Real INT 10, but there is no
                                ; such instruction as FAR JMP
                                ; We fake it with
                                ; PUSHes and a RET.
        POPF
        JMP     CS: DWORD PTR [RealInt10Off]

IsBeep:
;   We do the beep and don't tell BIOS
        STI                     ; interrupts back on
        PUSH    AX
        PUSH    BX
        PUSH    CX
        PUSH    DS
        MOV     AX,CS           ; Set up DS so we won't need CS:
                                ; overrides.
        MOV     DS,AX
        Call    Beep
        POP     DS
        POP     CX
        POP     BX
        POP     AX
        POPF
        IRET
FIELD   EndP

;==============================================================

BEEP    Proc    Near            ; emit one beep
        Call    SoundOn
        MOV     BX,Duration     ; delay in milliseconds
        Call    Delay
        Call    SoundOff
        RET
BEEP    ENDP

;==============================================================

SoundOn Proc    Near
;       Turn on the speaker, hide old setting in AH
        MOV     AL,0B6h
        OUT     043h,AL         ; write timer mode register
        MOV     AX,Divisor      ; freq divisor == 1131=1000hz
                                ;                 2570=440hz
        OUT     042h,AL         ; write timer 2 cnt - lsb
        MOV     AL,AH
        OUT     042h,AL         ; write timer 2 cnt - msb
        IN      AL,061h         ; get current port b setting
        MOV     AH,AL           ; save current setting
        OR      AL,003h         ; turn speaker on
        OUT     061h,AL
        RET
SoundOn EndP

;==============================================================

Delay   Proc    Near
;       Delay BX milliseconds
;       Must not disturb AX register
                                ; each iteration of outer loop
                                ; takes 1 millisecond
Outer:                          ; start outer loop
        MOV     CX,LoopsPerMs
        EVEN                    ; ensure inner loop starts at an even byte
Inner:  LOOP    Inner           ; single instruction tight loop
        DEC     BX
        JNZ     Outer
        RET
Delay   EndP

;==============================================================

SoundOff Proc   Near
;       Turn off the speaker
;       old port value in AH
        MOV     AL,AH           ; recover value of port
        OUT     061h,AL
        RET
SoundOff EndP

;==============================================================
;==============================================================
;==============================================================
;==============================================================
;==============================================================
; Everything below this line is disposable initialization code.
; It is thrown away and is not part of the resident code.
;==============================================================
;==============================================================
;==============================================================
;==============================================================
;==============================================================
DISPOSE:
;==============================================================
Init    Proc    Near
;       Intialize Shriek then Terminate and Stay Resident
        Say     CopyRightMsg    ; CopyRight banner
        CALL    Parse           ; parse duration and frequency on
                                ; command line
        Call    ComputeDivisor  ; Compute the divisor as 1,131,000/Freq = 11,41f8 hex
        CALL    Calibrate       ; adjust timing loop parms
        CALL    Trap            ; redirect INT10 vector
        CALL    TSR             ; exit to DOS
Init    EndP

;==============================================================

Parse   Proc    Near
;       Parse the command line for the optional duration and frequency
        Call    CommandLine     ; get first parm - duration
        MOV     BX,1
        Call    NthParm
        JCXZ    NoDuration      ; leave as default
        Call    ASCIIToBin      ; DX:AX is result
        MOV     BX,MinDuration  ; low bound 1/10 sec
        MOV     CX,MaxDuration  ; high bound 2 secs
        Call    Corral
        MOV     Duration,AX

        Call    CommandLine     ; get second parm -- freq
        MOV     BX,2
        Call    NthParm
        JCXZ    NoFreq          ; leave as default
        Call    ASCIIToBin
        MOV     BX,MinFreq      ; low bound on Freq usually 41 Hz
        MOV     CX,MaxFreq      ; high bound on Freq usually 14080 Hz
        Call    Corral
        MOV     Freq,AX
NoDuration:
NoFreq:
        RET
Parse   EndP

;==============================================================

CommandLine Proc        Near
;       Gets command line string into ES:DI
;       Command line does not include the program name.
;       ES already set since we are a COM file
                                ; counted string at HEX 80
                                ; contains command line.
                                ; It has no trailing null.
        MOV     DI,81h
        XOR     CH,CH
        MOV     CL,DS:80h       ; CX contains length of command
        RET
CommandLine EndP

;==============================================================

NthParm Proc    Near
;       Parses string for Nth Parameter delimited by blanks
;       e.g.  "  250 554" with BX=1 would give string "250"
;       ES:DI - string
;       CX - length of string
;       BX - which parm wanted 1=parm1 2=parm2 etc.
;       NthParm only finds one parm per call.
;       On exit ES:SI points to string and CX is its length.
;       If there is no parm, the length will be 0.
;       It also handles multiple leading/trailing blanks on parms.
        MOV     AL,20h          ; AL = blank  -- the search char
ParmLoop:
;       Remove leading blanks on parm
        JCXZ    NullParm        ; jump if null string
        REPE    SCASB           ; scan ES:DI forwards till hit non blank
                                ; DI points just after it
                                ; CX is one too small, or 0 if none found
        JE      NullParm        ; jump if entire string was blank
        INC     CX              ; CX is length of remainder of string
        DEC     DI              ; DI points to non-blank
        MOV     SI,DI           ; remember start of string
;       Search for terminating blank on parm
        JCXZ    NullParm        ; jump if null string
        REPNE   SCASB           ; scan ES:DI forwards till hit blank
                                ; DI points just after it
                                ; CX is one too small, or 0 if none found
        JNE     NoBlank         ; jump if entire string was non blank
        INC     CX              ; CX is length of remainder of string
        DEC     DI              ; backup DI to point to blank at string end
NoBlank:
                                ; DI=addr tail end of command string,
                                ; CX=len tail end of command string
                                ; SI=addr parm just parsed
;       Major loop for each parm
        DEC     BX
        JNZ     ParmLoop        ; loop once for each parm

        MOV     CX,DI
        SUB     CX,SI           ; CX is length of parameter.
        RET
NullParm:                       ; was no nth parameter
        MOV     CX,0
        RET
NthParm EndP

;==============================================================

ASCIIToBin      PROC    Near
;       on entry DS:SI points to start of decimal ASCII string of digits.
;       String should contain only the decimal digits 0..9.
;       If there are bad chars we abort.
;       CX contains length of string > 0
;       On exit DX:AX contains binary equivalent of string.
        PUSH    BX              ; save regs we will trash
        PUSH    CX
        PUSH    SI
        PUSH    DI
        XOR     AX,AX
        MOV     DX,AX           ; accumulate in DX:AX

OneDigitLoop:

; multiply accumulated number by 10
                                ; Works because 10*X = 2*X + 8*X
                                ; use DI:BX as working register
        SHL     AX,1
        RCL     DX,1            ; DX:AX = x*2
        MOV     BX,AX
        MOV     DI,DX
        SHL     BX,1
        RCL     DI,1
        SHL     BX,1
        RCL     DI,1            ; DI:BX = x*8
        ADD     BX,AX
        ADC     DI,DX           ; DI:BX = x*2 + x*8

; add on the next digit
        XOR     DX,DX
        MOV     AH,DH
        LODSB                   ; get next digit in AL
        SUB     AL,"0"          ; convert 1 digit ASCII to bin
        JB      NumTrouble      ; ensure 0..9
        CMP     AL,9
        JA      NumTrouble
        ADD     AX,BX           ; add it onto accumulated product
        ADC     DX,DI

        LOOP    OneDigitLoop    ; loop once for each digit

        POP     DI              ; restore regs
        POP     SI
        POP     CX
        POP     BX

        RET
NumTrouble:
;       Some problem, give standard Error message.
        Say     TroubleMsg
; ABORT
        MOV     AX,4C01H        ; EXIT back to DOS
                                ; with ERRORLEVEL 1
        INT     21H
;
ASCIIToBin      ENDP

;==============================================================

Corral  Proc    Near
;       on entry AX=number BX=low bound CX=high bound
;       on exit AX is safel corralled into the range BX:CX
        CMP     AX,BX
        JAE     BigEnough       ; use unsigned compares
        MOV     AX,BX
BigEnough:
        CMP     CX,AX
        JAE     SmallEnough
        MOV     AX,CX
SmallEnough:
        RET
Corral  EndP

;==============================================================

ComputeDivisor Proc     Near
;       Compute the divisor as 1,131,000/Freq = 11,41f8 hex
        MOV     DX,11h          ; high order word
        MOV     AX,41f8h        ; low order word
        DIV     Freq
        MOV     Divisor,AX
        RET
ComputeDivisor EndP

;==============================================================

Calibrate Proc  Near
;       Measures the speed of the cpu at autoexec time
;       for later use in the beep timing loop.
;       The DOS 2Ch method of timing is very inaccurate.
;       In many cases it is only accurate to the second.
;       We count 1/18.2 second ticks instead
;       These ticks are not very accurate, but they are the best
;       we can do.
        Call    GetTicks
        MOV     StartTime,DX    ; We don't use stack or registers
                                ; to allow easy restart of Calibrate.

        MOV     BX,CalibTime    ; Measure 3 second Calibration
        Call    Delay           ; of our Delay routine

        Call    GetTicks
        MOV     StopTime,DX     ; We don't use stack or registers
                                ; to allow easy restart of Calibrate.

;       Calc elapsed time in ticks for the calibration
        MOV     BX,StopTime
        SUB     BX,StartTime    ; BX now has elapsed time in Ticks

;       Recalibrate Loop delay constant
                                ; now adjust LoopsPerMs * desired dur ticks
                                ;                         -----------------
                                ;                         actual dur ticks
        MOV     AX,LoopsPerMs
        MOV     CX,CalibTicks
        MUL     CX
        CMP     DX,BX           ; Check for divide overflow
        JAE     Calibrate       ; usually caused by stalled clock.
                                ; Just redo the calibrate.
        DIV     BX
        MOV     LoopsPerMs,AX
        RET
Calibrate EndP

;==============================================================

GetTicks        PROC    Near
;       Get time of day in 1/18.2 second clock ticks since midnight.
;       leaves tick count in CX:DX, we will ignore high order part.
;       For accurate results, don't call this too often.
;       In some systems the clock gets behind if you call
;       GetTicks in a tight loop.

        MOV     AH,0
        INT     1Ah             ; BIOS ticks since midnight
                                ; CX:DX is count
        OR      AL,AL
        JNZ     Calibrate       ; redo if midnight trouble
                                ; !!! Non structured code !!!
                                ; !!! Beware if you make changes !!!
        RET
GetTicks        EndP

;==============================================================

TRAP    Proc    Near
;                               ; redirect the INT 10 to FIELD
;       Save real Int 10 vector
        MOV     AX,3510h        ; get vector for video int 10
        INT     21H             ; vector in ES:BX
        MOV     RealInt10Seg,ES ; save real vector
        MOV     RealInt10Off,BX
;       Set up our Int 10 vector
        MOV     AX,CS
        MOV     DS,AX
        MOV     DX,Offset Field
        MOV     AX,2510h        ; set vector for video int 10
        INT     21H             ; set vector from DS:DX
        RET
TRAP    EndP

;==============================================================

TSR     Proc    Near
;       Terminate and Stay Resident

        MOV     ES,DS:[2Ch]     ; pointer to environment
        MOV     AH,49h          ; free allocated RAM
        INT     21H             ; used by SET environment

        MOV     AH,3Eh          ; Close StdIn
        MOV     BX,0            ; otherwise DOS will forget to
        INT     21H             ; and piping will lose a handle.

        MOV     AH,3Eh          ; Close StdOut
        MOV     BX,1
        INT     21H

        MOV     AX,3100H        ; Terminate and Stay Resident
                                ; Exit to DOS
        MOV     DX,((Dispose-Start)+100h+15d)/16d
        INT     21h             ; paragraphs to keep resident
                                ; 100h accounts for PSP.
                                ; 15d rounds up to next para.
                                ; We can throw away
                                ; initialization code.
TSR     EndP

;==============================================================

;       Disposable Variables

Freq            DW      DefaultFreq
                                ; in Hertz, middle A by default
                                ; may be changed on command line.

StartTime       DW      0       ; low order ticks at start of calibration

StopTime        DW      0       ; low order ticks at end of calibration

;==============================================================

; Messages - all disposable

CopyRightMsg    LABEL BYTE
        DB      ' Shriek 1.6 ۲',13,10
        DB      13,10
        DB      'adjusts system beep tone',13,10
        DB      13,10
        DB      'Copyright (c) 1989,1998 Roedy Green',13,10
        DB      'Canadian Mind Products',13,10
        DB      '#208 - 525 Ninth Street, New Westminster, BC Canada V3M 5T9',13,10
        DB      'tel:(604) 777-1804   mailto:roedy@mindprod.com   http://mindprod.com',13,10
        DB      'This program may be freely copied and used for any purpose except military.',13,10,'$'

TroubleMsg      LABEL BYTE
        DB      'Usage:',13,10,7
        DB      'SHRIEK 250 554',13,10
        DB      'to change the system beep to a duration of 250 milliseconds (1/4 second)',13,10
        DB      'and a frequency of 554 Hertz (middle D).',13,10
        DB      13,10,'$'

;==============================================================

SHRIEK  ENDP
CODE    ENDS
        END     START
