//---------------------------------------------------------------------------
#include <windows.h>
#include <dir.h>
#include "rbtray.h"
#pragma hdrstop
//---------------------------------------------------------------------------
#define MAXCOUNT 64
#define MAXTEXT  64

static HWND hwndHook;
static HWND list[MAXCOUNT];
static HMODULE hLib;
static char Buffer[MAXPATH];
static HICON AppIcon;

static int FindInTray(HWND hwnd) {
  int i;

  for (i = MAXCOUNT - 1; i >= 0; i--)
    if (list[i] == hwnd)
      break;
  return i;
  }

static void DelFromTray(int i) {
  NOTIFYICONDATA nid;

  if (i < 0)
    return;
  nid.cbSize = sizeof(NOTIFYICONDATA);
  nid.hWnd   = hwndHook;
  nid.uID    = (UINT)list[i];
  list[i] = 0;
  Shell_NotifyIcon(NIM_DELETE, &nid);
  }

static bool IsWindowConsole(HWND hwnd) {
  GetClassName(hwnd, Buffer, MAXPATH);
  return !strcmp(Buffer, "tty");
  }

static void ShowIt(HWND hwnd) {
  ShowWindow(hwnd, SW_SHOW);
  if (!IsWindowConsole(hwnd))
    ShowWindow(hwnd, SW_RESTORE);
  SetForegroundWindow(hwnd);
  }

static void ShowTheWindow(HWND hwnd) {
  if (GetWindowLong(hwnd, GWL_STYLE) & WS_CHILD) {
    HWND parent = hwnd;
    do 
      parent = GetParent(parent);
      while (parent && FindInTray(parent) < 0);
    if (parent)
      ShowTheWindow(parent);
    }
  ShowIt(hwnd);
  DelFromTray(FindInTray(hwnd));
  }

static void CloseTheWindow(HWND hwnd) {
  SetForegroundWindow(hwnd);
  if (!SendMessage(hwnd, WM_CLOSE, 0, 0) && !IsWindow(hwnd))
    DelFromTray(FindInTray(hwnd));
  }

HICON GetWindowIcon(HWND hwnd) {
  HICON icon;

  if (icon = (HICON)SendMessage(hwnd, WM_GETICON, ICON_SMALL, 0))
    return icon;
  if (icon = (HICON)SendMessage(hwnd, WM_GETICON, ICON_BIG, 0))
    return icon;
  if (icon = (HICON)GetClassLong(hwnd, GCL_HICONSM))
    return icon;
  if (icon = (HICON)GetClassLong(hwnd, GCL_HICON))
    return icon;
  return AppIcon;
  }

char *AskWindowText(HWND hwnd) {
  static char Buff[MAXTEXT];

  memset(Buffer, 0, sizeof(Buffer));
  strcpy(Buffer, "Do you want to close the window\n\"");
  GetWindowText(hwnd, Buff, sizeof(Buff));
  strcat(Buffer, Buff);
  strcat(Buffer, "\"?");
  return Buffer;
  }

typedef bool (*RegHook)(HMODULE hLib);
typedef void (*UnRegHook)(void);

LRESULT CALLBACK HookWndProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam) {
  NOTIFYICONDATA nid;
  int i;

  switch (msg) {
    case WM_MYCMD:
      for (i = MAXCOUNT - 1; i >= 0; i--)
        if (!list[i])
          break;
      if (i < 0)
        break;
      list[i] = (HWND)lParam;
      nid.cbSize           = sizeof(NOTIFYICONDATA);
      nid.hWnd             = hwndHook;
      nid.uID              = (UINT)lParam;
      nid.uFlags           = NIF_MESSAGE | NIF_ICON | NIF_TIP;
      nid.uCallbackMessage = WM_TRAYCMD;
      nid.hIcon            = GetWindowIcon((HWND)lParam);
      GetWindowText((HWND)lParam, nid.szTip, MAXTEXT);
      if (!IsWindowConsole((HWND)lParam))
        ShowWindow((HWND)lParam, SW_MINIMIZE);
      ShowWindow((HWND)lParam, SW_HIDE);
      Shell_NotifyIcon(NIM_ADD, &nid);
      break;
    case WM_DELTRAY:
      CloseTheWindow((HWND)wParam);
      break;
    case WM_TRAYCMD:
      switch ((UINT)lParam) {
        case WM_LBUTTONUP:
          ShowTheWindow((HWND)wParam);
          break;
        case WM_RBUTTONUP:
          if (MessageBox(NULL, AskWindowText((HWND)wParam), "RBTray",
            MB_YESNO | MB_ICONQUESTION | MB_SETFOREGROUND) == IDYES)
            CloseTheWindow((HWND)wParam);
        case WM_MOUSEMOVE:
          if (!IsWindow((HWND)wParam))
            DelFromTray(FindInTray((HWND)wParam));
          else {
            nid.uID              = (UINT)wParam;
            nid.uFlags           = NIF_ICON | NIF_TIP;
            nid.hIcon            = GetWindowIcon((HWND)wParam);
            GetWindowText((HWND)wParam, nid.szTip, MAXTEXT);
            Shell_NotifyIcon(NIM_MODIFY, &nid);
            }
        }
        break;
    case WM_QUERYTRAY:
      return FindInTray((HWND)lParam) >= 0;
    case WM_DESTROY:
      for (i = MAXCOUNT - 1; i >= 0; i--)
        if (list[i]) {
          ShowIt(list[i]);
          DelFromTray(i);
          }
      (UnRegHook)(GetProcAddress(hLib, "_UnRegisterHook"))();
      FreeLibrary(hLib);
      PostQuitMessage(0);
    }
  return DefWindowProc(hwnd, msg, wParam, lParam);
  }

WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, PSTR szCmdLine,
  int iCmdShow) {
  WNDCLASS wc;
  MSG msg;

  if (FindWindow(NAME, NAME))
    return 1;
  if (!(hLib = LoadLibrary("RBHook.dll"))) {
    MessageBox(NULL, "Error loading RBHook.dll", "RBTray", MB_OK
      | MB_ICONHAND);
    return FALSE;
    }
  if (!((RegHook)GetProcAddress(hLib, "_RegisterHook"))(hLib)) {
    MessageBox(NULL, "Error setting hook procedure", "RBTray", MB_OK
      | MB_ICONHAND);
    return FALSE;
    }
  wc.hCursor        = NULL;
  wc.hIcon          = NULL;
  wc.lpszMenuName   = NULL;
  wc.lpszClassName  = NAME;
  wc.hbrBackground  = (HBRUSH)(COLOR_WINDOW + 1);
  wc.hInstance      = hInstance;
  wc.style          = 0;
  wc.lpfnWndProc    = HookWndProc;
  wc.cbWndExtra     = sizeof(HWND) + sizeof(HWND);
  wc.cbClsExtra     = 0;
  if (!RegisterClass(&wc)) {
    MessageBox(NULL,"Error creating window class", "RBTray", MB_OK | MB_ICONHAND);
    return 2;
    }
  if (!(hwndHook = CreateWindow(NAME, NAME,
    WS_OVERLAPPEDWINDOW,
    0, 0, 0, 0,
    (HWND) NULL,
    (HMENU) NULL,
    (HINSTANCE)hInstance,
    (LPVOID) NULL))) {
    MessageBox(NULL, "Error creating window", "RBTray", MB_OK);
    return 3;
    }
  AppIcon = LoadIcon(NULL, IDI_WINLOGO);
  while (IsWindow(hwndHook) && GetMessage(&msg, hwndHook, 0, 0)) {
    TranslateMessage(&msg);
    DispatchMessage(&msg);
    }
  return 0;
  }
//---------------------------------------------------------------------------

