#include <windows.h>
#include "rbtray.h"
#pragma hdrstop

//---------------------------------------------------------------------------

static HHOOK hhook;

LRESULT CALLBACK MouseProc(int nCode, WPARAM wParam, LPARAM lParam) {
  if (wParam == WM_NCRBUTTONDOWN
    && ((MOUSEHOOKSTRUCT*)lParam)->wHitTestCode == HTREDUCE) {
    SendMessage(FindWindow(NAME, NAME), WM_MYCMD, wParam,
      (LPARAM)(((MOUSEHOOKSTRUCT*)lParam)->hwnd));
    return 1;
    }
  return (nCode < 0)? CallNextHookEx(hhook, nCode, wParam, lParam): 0;
  }

extern "C" {
  bool __export RegisterHook(HMODULE hLib);
  void __export UnRegisterHook(void);
  }

bool __export RegisterHook(HMODULE hLib) {
  return hhook = SetWindowsHookEx(WH_MOUSE, (HOOKPROC)MouseProc, hLib, 0);
  }

void __export UnRegisterHook(void) {
  UnhookWindowsHookEx(hhook);
  }
