#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#include <locale.h>

#include <windows.h>
#include <ras.h>
#include <raserror.h>

#ifndef WIN95
BOOL bConsole=FALSE;
SERVICE_STATUS_HANDLE hStatus;
#endif

BOOL bStop=FALSE;

struct Connection
{
 struct Connection *pNext;
 time_t    tStart;
 char      szEntryName[RAS_MaxEntryName + 1]; 
 char      szPhoneNumber[RAS_MaxPhoneNumber + 1];
 char      szRasUserName[UNLEN+1];
 char      szUserName[UNLEN+1];
	BOOL      bFound;
};

struct Connection *cList=NULL;
SERVICE_STATUS ss={SERVICE_WIN32_OWN_PROCESS,SERVICE_RUNNING,SERVICE_ACCEPT_STOP|SERVICE_ACCEPT_SHUTDOWN,0,0,0,10000L};
char logname[_MAX_PATH+100];
char buf[RAS_MaxPhoneNumber+RAS_MaxAreaCode+50];

static void ResolveConn(Connection **pList,RASCONN *conn)
{
 RASDIALPARAMS rd;
#ifndef WIN95
 RASENTRY *re;
 DWORD reSize;
 char *subKey="SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion\\Winlogon";
 char valueName[]="DefaultUserName";
 DWORD	type;
	HKEY	hKey;
	DWORD	cbData;
#endif
 BOOL pw;
	
	for(;;)
	{
		if(!*pList)
		{
			*pList=new Connection;
			if(!*pList)return;
			(*pList)->pNext=NULL;
			time(&(*pList)->tStart);
			memcpy((*pList)->szEntryName,conn->szEntryName,sizeof((*pList)->szEntryName));
   rd.dwSize=sizeof(rd);
   memcpy(rd.szEntryName,conn->szEntryName,sizeof(rd.szEntryName));
   (*pList)->szPhoneNumber[0]='\0';
   (*pList)->szRasUserName[0]='\0';
   (*pList)->szUserName[0]='\0';
   if(RasGetEntryDialParams(NULL,&rd,&pw)==0)
   {
    memcpy((*pList)->szPhoneNumber,rd.szPhoneNumber,sizeof((*pList)->szPhoneNumber));
    memcpy((*pList)->szRasUserName,rd.szUserName,sizeof((*pList)->szRasUserName));
   }
   if((*pList)->szPhoneNumber[0]=='\0') 
   {
#ifdef WIN95
    strcpy((*pList)->szPhoneNumber,"<unknown>");
#else
    reSize=0;
    if(RasGetEntryProperties(NULL,conn->szEntryName,NULL,&reSize,NULL,NULL)==ERROR_BUFFER_TOO_SMALL)
    {
     re=(RASENTRY *)malloc(reSize);
     re->dwSize=sizeof(RASENTRY);
     if(RasGetEntryProperties(NULL,conn->szEntryName,re,&reSize,NULL,NULL)==0) 
     {
      if(re->dwfOptions & RASEO_UseCountryAndAreaCodes)
      {
       if(re->dwCountryCode!=0) 
       {
        sprintf(buf,"++%d ",re->dwCountryCode);
       }
       else
       {
        sprintf(buf,"++%d ",re->dwCountryID);
       }
       if(re->szAreaCode[0])
       {
        strcat(buf,"(");
        if(re->szAreaCode[0]=='0')
        {
         strcat(buf,&re->szAreaCode[1]);
        }
        else
        {
         strcat(buf,re->szAreaCode);
        }
        strcat(buf,") ");
       }
       strcat(buf,re->szLocalPhoneNumber);
       buf[sizeof((*pList)->szPhoneNumber)-1]='\0';
       memcpy((*pList)->szPhoneNumber,buf,sizeof((*pList)->szPhoneNumber));
      }
      else
      {
       memcpy((*pList)->szPhoneNumber,re->szLocalPhoneNumber,sizeof((*pList)->szPhoneNumber));
      }
     }
     free(re);
    }
#endif
   }
   
#ifdef WIN95
   strcpy((*pList)->szUserName,"<local>");
#else
   (*pList)->szUserName[0]='\0';
   // Special thanks to Thorsten for this code fragement
			if(RegOpenKeyEx(HKEY_LOCAL_MACHINE,subKey,0,KEY_QUERY_VALUE,&hKey)==ERROR_SUCCESS) 
   {
    cbData=sizeof((*pList)->szUserName);
				if(RegQueryValueEx(hKey,valueName,NULL,&type,(LPBYTE)((*pList)->szUserName),&cbData)!=ERROR_SUCCESS)
    {
     (*pList)->szUserName[0]='\0';
    }
   }
#endif
 		(*pList)->bFound=TRUE;
			return;
		}
		if(strncmp((*pList)->szEntryName,conn->szEntryName,sizeof((*pList)->szEntryName))==0)
		{
		 (*pList)->bFound=TRUE;
		 return;
		}
		pList=&(*pList)->pNext;
	}
}

static void ClearFound(Connection **pList)
{
 for(;*pList;pList=&(*pList)->pNext)
	{
	 (*pList)->bFound=FALSE;
	}
}

static void DeleteNotFound(Connection **pList)
{
 for(;*pList;pList=&(*pList)->pNext)
	{
	 if(!(*pList)->bFound)
		{
			FILE *f;
			f=fopen(logname,"a");
			if(f)
			{
				time_t end;
    struct tm *tm;
				time(&end);
    fprintf(f,"%s",(*pList)->szUserName);
   	tm=localtime(&(*pList)->tStart);
    // Special thanks to Thorsten for this code fragement
				fprintf(f,";%02.2d.%02.2d.%04.4d;%02.2d:%02.2d:%02.2d",
							tm->tm_mday,tm->tm_mon+1,tm->tm_year+1900,
							tm->tm_hour,tm->tm_min,tm->tm_sec);
				tm=localtime(&end);
				fprintf(f,";%02.2d.%02.2d.%04.4d;%02.2d:%02.2d:%02.2d",
							tm->tm_mday,tm->tm_mon+1,tm->tm_year+1900,
							tm->tm_hour,tm->tm_min,tm->tm_sec);
				fprintf(f,";%s;%s;%s\n",(*pList)->szEntryName,(*pList)->szPhoneNumber,(*pList)->szRasUserName);
				fclose(f);
			}
			Connection *p;
			p=*pList;
			*pList=p->pNext;
			delete p;
			if(!*pList)break;
		}
	}
}

static void DoQuery()
{
 DWORD cb,cConnections,cAlloced=10;
 RASCONN *rasconns; 

	for(;;)
	{
		DWORD r;
 	rasconns=new RASCONN[cAlloced];

		if(!rasconns)return;

		rasconns[0].dwSize=sizeof(RASCONN);
		cb=sizeof(RASCONN)*cAlloced;
		r=RasEnumConnections(rasconns,&cb,&cConnections);
		if(!r)break;
		if(r==ERROR_BUFFER_TOO_SMALL || r==ERROR_NOT_ENOUGH_MEMORY)
		{
		 cAlloced=cb/sizeof(RASCONN);
		 delete [] rasconns;
		}
		else return;
	}

	DWORD i;
	ClearFound(&cList);
	for(i=0;i<cConnections;i++)
	{
		ResolveConn(&cList,&rasconns[i]);
	}
	DeleteNotFound(&cList);

 delete [] rasconns;
}

// Handler
#ifndef WIN95
void __stdcall ServiceHandler(DWORD dwControl)
{
 if(dwControl==SERVICE_CONTROL_STOP || dwControl==SERVICE_CONTROL_SHUTDOWN)bStop=TRUE;
	ss.dwCheckPoint++;
	ss.dwCurrentState=bStop ? SERVICE_STOP_PENDING : SERVICE_RUNNING;
	ss.dwWaitHint=10000L;
	SetServiceStatus(hStatus,&ss);
}
#endif

static void DoLoop()
{
	time_t c;
	time(&c);
	srand(c);
 for(;;)
	{
		if(bStop)break;
		DoQuery();
		Sleep(8000L+(1000L*rand())/RAND_MAX);
#ifndef WIN95
		if(!bConsole)
		{
			ss.dwCheckPoint++;
			ss.dwCurrentState=bStop ? SERVICE_STOP_PENDING : SERVICE_RUNNING;
			ss.dwWaitHint=10000L;
   SetServiceStatus(hStatus,&ss);
		}
#endif
	}
}

#ifndef WIN95
void __stdcall ServiceMain(DWORD dwArgc,LPTSTR *lpszArgv)
{
 hStatus=RegisterServiceCtrlHandler("RasLog",ServiceHandler);
	if(hStatus)
	{
		SetServiceStatus(hStatus,&ss);
		DoLoop();
		ss.dwCheckPoint++;
		ss.dwCurrentState=SERVICE_STOPPED;
		ss.dwWaitHint=10000L;
  SetServiceStatus(hStatus,&ss);
	}
}
#endif

#ifdef WIN95
int WINAPI WinMain(HINSTANCE hInstance,HINSTANCE hPrevInstance,LPSTR lpCmdLine,int nCmdShow)
#else
int main(int argc,char *argv[])
#endif
{
 printf("RasLog Version 2.1 (c) 1997-99 by IMSoft - DI Michael Karg.\n");
	printf("Graf Starhembbergg. 32/2/3, 1040 Wien, Austria, Phone ++43 (1) 5056190\n");
	printf("e-mail: office@imsoft.at, http://www.imsoft.at\n\n");
#ifdef WIN95
 printf("Windows 95 version.\n");
#else
 printf("Windows NT version.\n");
 printf("%s /Help for Usage.\n",argv[0]);
	if(argc==2 && (stricmp(argv[1],"/Help")==0 ||
	               stricmp(argv[1],"/?")==0))
	{
		printf("Usage %s /Register {<domain>|.}\\<username> <password>\n",argv[0]);
		printf("      %s /Deregister | /Console\n",argv[0]);
		printf("Use /Register to register RASLOG as a service.\n");
		printf("Use /Deregister to deregister RASLOG as a service.\n");
		printf("Use /Console to run RASLOG in a console window.\n");
		return(0);
	}
#endif

	if(GetSystemDirectory(logname,_MAX_PATH)==0)
	{
		printf("Could not get system directory.\n");
		return(1);
	}
#ifdef WIN95
 strcat(logname,"\\connect.log");
#else
	strcat(logname,"\\ras\\connect.log");
#endif
	setlocale(LC_ALL,"");

#ifndef WIN95
	if(argc==4 && stricmp(argv[1],"/Register")==0)
	{
		char fn[_MAX_PATH];
	 SC_HANDLE sc,svc;
		sc=OpenSCManager(NULL,NULL,SC_MANAGER_CREATE_SERVICE);
		if(sc==NULL)
		{
		 printf("Could not connect to service control manager, please check your administrator rights.\n");
			return(1);
		}
		if(!GetModuleFileName(NULL,fn,sizeof(fn)))
		{
			printf("Could not get exeutable full path.\n");
			return(1);
		}
		svc=CreateService(sc,"RasLog","Remote Access Logger",SERVICE_ALL_ACCESS,SERVICE_WIN32_OWN_PROCESS,SERVICE_AUTO_START,
		                  SERVICE_ERROR_IGNORE,fn,NULL,NULL,"RasMan\0\0\0",argv[2],argv[3]);
		if(!svc)
		{
		 printf("Could not create service, please check your administrator rights.\n");
			return(1);
		}
		CloseServiceHandle(svc);
		CloseServiceHandle(sc);
		printf("Service successfully registered.\n");
		return(0);
	}
	if(argc==2 && stricmp(argv[1],"/Deregister")==0)
	{
	 SC_HANDLE sc,svc;
		sc=OpenSCManager(NULL,NULL,SC_MANAGER_CREATE_SERVICE);
		if(sc==NULL)
		{
		 printf("Could not connect to service control manager, please check your administrator rights.\n");
			return(1);
		}
		svc=OpenService(sc,"RasLog",SERVICE_ALL_ACCESS);
		if(!svc)
		{
		 printf("Could not open service, please check your administrator rights.\n");
			return(1);
		}
		if(!DeleteService(svc))
		{
		 printf("Could not delete service, please check your administrator rights.\n");
			return(1);
		}
		CloseServiceHandle(svc);
		CloseServiceHandle(sc);
		printf("Service successfully deregistered.\n");
		return(0);
	}
#endif

#ifndef WIN95
	if(argc==2 && stricmp(argv[1],"/Console")==0)
	{
	 bConsole=TRUE;
#endif
		DoLoop();
#ifndef WIN95
		return(0);
	}
	printf("Trying to connect to the Service Control Manager.\n");
	printf("Please wait.\n");
	SERVICE_TABLE_ENTRY st[2]={{"RasLog",ServiceMain},{NULL,NULL}};
	if(!StartServiceCtrlDispatcher(st))
	{
	 printf("Could not connect to the Service Control Manager.\n");
		return(1);
	}
#endif
	return(0);	
}
