
DOSSEG
.MODEL SMALL

SCREEN EQU 0B800h

.DATA

Screenstor DW 2000 dup (?)	; Space to store the screen attributes
Frameno	   DW ?
Linestart  DW ?
Linecount  DB ?

.CODE
PUBLIC _Flash
PUBLIC _Fuzz
public _Retrace

; ---------------------------------------------------------------------------
; Make the screen flash
; ---------------------------------------------------------------------------
_Flash PROC
	push bp
	push ds
	push es
	push si
	push di
	push ax
	push cx

	mov ax, SEG DGROUP
	mov ds, ax

	mov ax, SCREEN
	mov es, ax

	mov cx, 2000
	mov di, OFFSET Screenstor
	mov si, 1

flloop1:
	mov al, [es:si]
	mov [di], al
	add si, 2
	inc di
	loop flloop1

	mov di, 1
	mov al, 119
	mov cx, 2000

flloop2:
	mov [es:di], al
	add di, 2
	loop flloop2

	call _Retrace
	call _Retrace
	call _Retrace

	mov di, 1
	mov al, 0
	mov cx, 2000

flloop3:
	mov [es:di], al
	add di, 2
	loop flloop3

	call _Retrace
	call _Retrace
	call _Retrace
	call _Retrace
	call _Retrace

	mov di, 1
	mov si, OFFSET Screenstor
	mov cx, 2000

flloop4:
	mov al, [si]
	mov [es:di], al
	add di, 2
	inc si
	loop flloop4

	pop cx
	pop ax
	pop di
	pop si
	pop es
	pop ds
	pop bp
	ret
ENDP

; ---------------------------------------------------------------------------
; Make the screen go fuzzy
; ---------------------------------------------------------------------------
_Fuzz PROC
	push bp
	push ds

	mov ax, SCREEN		; Wrong way round!
	mov ds, ax

	mov ax, SEG DGROUP
	mov es, ax

	xor si, si
	mov di, OFFSET Screenstor
	mov cx, 2000
	rep movsw		; Save the screen data

	push es			; Swap es and ds back
	push ds
	pop es
	pop ds

	xor bx, bx
	xor si, si

fzloop1:
	call _Retrace

	xor di, di		; Reset di to start of screen

	mov cx, 2000		; No of chars per line
	rep movsw

	inc bx
	cmp bx, 50
	jnz fzloop1		; Routine finished?

	xor di, di
	mov si, OFFSET Screenstor
	mov cx, 2000
	rep movsw		; Restore the screen data


	pop ds
	pop bp
	ret

ENDP

; ---------------------------------------------------------------------------
; Vertical retrace routine.
; ---------------------------------------------------------------------------

_Retrace PROC
	mov dx, 03DAh

rtloop1:
	in al, dx
	test al, 8
	jnz rtloop1

rtloop2:
	in al, dx
	test al, 8
	jz rtloop2

	ret
ENDP

END