        name    nokey
        page    55,132
cseg    segment para public 'CODE'
        org     100h
        assume  cs:cseg,ds:cseg,es:cseg
nokey   proc    near
;---------------------------------------------------;
; NOKEY.COM - a TSR to disable any desired keys
; Copyright   M.R.  Le Voi Systems Consultants 1990
;---------------------------------------------------;
begintsr:
        jmp     SHORT tsrbit    ; jump to initialise code
;---------------------------------------------------;
;       Some constants and INT 9 save area
;---------------------------------------------------;
DEL     equ     53h             ; Scan code for delete key
GKEY    equ     22h             ; Scan code for G key
KKEY    equ     25h             ; Scan code for K key
RKEY    equ     13h             ; Scan code for R key
BRKEY   equ     1Ah             ; Scan code for [ key
TIKEY   equ     29h             ; Scan code for tilde key
SYKEY   equ     72h             ; Scan code for SysRq key
ALT     equ     08h             ; Flag equates for ALT etc
CTRL    equ     04h
SHIFTA  equ     03h
SHIFTL  equ     02h
SHIFTR  equ     01h
KEYANY  equ     00h             ; Dummy entry
cr      equ     0dh
lf      equ     0ah
i09off  dw      0               ; Real INT 9 offset
i09seg  dw      0               ; Real INT 9 segment
ignkeys db      ALT+CTRL,DEL    ; Alt+Ctrl+DELETE
        db      KEYANY,SYKEY    ; Ctrl+SysRq
;       db      SHIFTA,RKEY     ; Shift+R
;       db      CTRL,GKEY       ; Ctrl+G ie Beep
;       db      ALT,KKEY        ; Alt+K
;       db      KEYANY,TIKEY    ; ` or ~
        dd      0               ; End of table
;---------------------------------------------------;
;       TSR code for our INT 1B handler
;---------------------------------------------------;
start1B:
        iret
;---------------------------------------------------;
;       Start of TSR code for our INT 9 handler
;---------------------------------------------------;
start09:
        sti                     ; Enable interrupts
        push    ax
        push    ds
        push    di
        xor     di,di
        in      al,60h
loop1:
        mov     ah,cs:ignkeys+1[di]     ; Get key byte
        cmp     ah,0                    ; End of table yet?
        je      callint9                ; Yes, exit
        cmp     al,ah                   ; My scancode?
        je      teststat                ; Yes, test flag byte
        inc     di                      ; Point to next
        inc     di                      ; pair of characters
        jmp     SHORT loop1
teststat:
        mov     ah,cs:ignkeys[di]
        cmp     ah,KEYANY       ; Any flag will do?
        je      match           ; Yes, process
        push    ax
        mov     ax,0000
        mov     ds,ax
        pop     ax
        mov     al,ds:[0417h]   ; Move status byte to AL
        and     al,0Fh          ; Turn off high nibble
        test    al,SHIFTA       ; Any shift keys pressed?
        jz      testflag        ; No, carry on
        or      al,SHIFTA       ; Turn on all shift flag bits
testflag:
        cmp     al,ah           ; My flag same as keyboard?
        jne     callint9        ; No, exit
match:
;---------------------------------------------------;
;       This code needed for COMPAQ machines only
;---------------------------------------------------;
        in      al,61h
        mov     ah,al
        or      al,80h
        out     61h,al
        mov     al,ah
        out     61h,al
;---------------------------------------------------;
;       Issue EOI to 8259A controller and return
;---------------------------------------------------;
        mov     al,20h
        out     20h,al
        pop     di
        pop     ds
        pop     ax
        iret
;---------------------------------------------------;
;       Normal exit when nothing to do
;---------------------------------------------------;
callint9:
        pop     di
        pop     ds
        pop     ax
        jmp     cs:DWORD PTR i09off     ; Return to real INT 9
endtsr  equ     $-begintsr
;---------------------------------------------------;
;       Make the preceeding code go TSR
;---------------------------------------------------;
tsrbit:
        mov     dx,offset mess0 ; Copyright message
        mov     ah,9            ; fn 9  - output string
        int     21h             ; DOS call
        mov     si,80h          ; point to command length byte
        xor     cx,cx
        mov     cl,byte ptr [si] ; use si as pointer
        cmp     cx,0            ; no tail?
        je      noparm          ; take defaults
nextchr:
        inc     si              ; point to next char in tail
        inc     si              ; point to next char in tail
        mov     al,byte ptr [si]
        cmp     al,'/'          ; help wanted?
        je      help
        cmp     al,'?'          ; help wanted?
        je      help
        cmp     al,30h          ; is it 0 ie reset the CTRL-C vector
        je      reset           ; Yes, jump to reset code
        cmp     al,31h          ; is it 1 ie set the CTRL-C vector
        jne     set1b           ; No, create our 1B code
        mov     cl,0FFh         ; Set cl as a flag when parm=1
        jmp     SHORT setc      ; Jump to set code
;---------------------------------------------------;
;       Set up our dummy INT 1B vector
;---------------------------------------------------;
set1b:
        mov     dx,offset mess2 ; CTRL-C message
        mov     ah,9            ; fn 9  - output string
        int     21h             ; DOS call
        mov     dx,100h+start1B-begintsr  ; DS:DX points to our INT 1B handler
        mov     ax,251Bh        ; Set INT 1B vector address
        int     21h
;---------------------------------------------------;
;       Corrupt COMMAND.COM by forcing an IRET
;---------------------------------------------------;
setc:
        mov     ax,3523h        ; Get Int 23 vector address
        int     21h
        cmp     es:BYTE PTR [bx],0CFh   ; CF says we are already disabled
        jne     setc1
        mov     dx,offset mess7 ; CTRL-C already disabled message
        mov     ah,9            ; fn 9  - output string
        int     21h             ; DOS call
        cmp     cl,0FFh         ; is the flag set?
        je      endup           ; Yes, exit
        jmp     SHORT noparm    ; No, go TSR
setc1:
        cmp     es:BYTE PTR [bx],02Eh   ; 2E is what we expect to find
        je      setc2
        mov     dx,offset mess5 ; Invalid CTRL-C vector message
        mov     ah,9            ; fn 9  - output string
        int     21h             ; DOS call
setc2:
        mov     es:BYTE PTR [bx],0CFh   ; CF is the IRET opcode
        cmp     cl,0FFh         ; is the flag set?
        jne     noparm
        mov     dx,offset mess4 ; CTRL-C message
        mov     ah,9            ; fn 9  - output string
        int     21h             ; DOS call
        jmp     SHORT endup
noparm:
        mov     dx,offset mess1 ; Action message
        mov     ah,9            ; fn 9  - output string
        int     21h             ; DOS call
        mov     ax,3509h        ; Get Int 9 vector address
        int     21h
        mov     i09off,bx       ; Save offset  of real INT 9
        mov     i09seg,es       ; Save segment of real INT 9
        mov     dx,offset start09        ; DS:DX points to our INT 9 handler
        mov     ax,2509h        ; Set INT 9 vector address
        int     21h
        mov     dx,((endtsr+15)/16)+10h ; Number of paragraphs to reserve
        mov     ax,3100h        ; Go TSR with return code=0
        int     21h
;---------------------------------------------------;
;       Issue help message
;---------------------------------------------------;
help:
        mov     dx,offset hlp   ; help message
        mov     ah,9            ; fn 9  - output string
        int     21h             ; DOS call
        jmp     SHORT endup
;---------------------------------------------------;
;       Reset COMMAND.COM by forcing the 2E back in
;---------------------------------------------------;
reset:
        mov     ax,3523h        ; Get Int 23 vector address
        int     21h
        cmp     es:BYTE PTR [bx],0CFh   ; CF is what we expect to find
        je      reset1
        mov     dx,offset mess6 ; CTRL-C already enabled message
        mov     ah,9            ; fn 9  - output string
        int     21h             ; DOS call
        jmp     SHORT endup
reset1:
        mov     es:BYTE PTR [bx],02Eh   ; 2E is the segment override opcode
        mov     dx,offset mess3 ; CTRL-C message
        mov     ah,9            ; fn 9  - output string
        int     21h             ; DOS call
        jmp     SHORT endup
;---------------------------------------------------;
;       Exit here when not going TSR
;---------------------------------------------------;
endup:
        mov     ax,4C00h        ; fn 4C - exit DOS
        int     21h             ; DOS call
mess0   db      'NOKEY 1.1 - Copyright (C) M. R. Le Voi Systems Consultants'
        db      ' - Use /? for help'
        db      cr,lf,'$'
mess1   db      'Other requested keys have been disabled'
        db      cr,lf,'$'
mess2   db      'CTRL-C and CTRL-BREAK have been disabled'
        db      cr,lf,'$'
mess3   db      'CTRL-C has been enabled'
        db      cr,lf,'$'
mess4   db      'CTRL-C has been disabled'
        db      cr,lf,'$'
mess5   db      'WARNING! The first character in the CTRL-C interrupt',cr,lf
        db      'vector was not 2E! Contact Mike Le Voi for instructions.',cr,lf
        db      'DO NOT attempt to enable CTRL-C. You have been warned!'
        db      cr,lf,'$'
mess6   db      'CTRL-C is already enabled. Request ignored.'
        db      cr,lf,'$'
mess7   db      'CTRL-C is already disabled. Request ignored.'
        db      cr,lf,'$'
hlp     db      lf,'Syntax: NOKEY [parm]'
        db      cr,lf,lf
        db      'Valid values for the parm are:-',cr,lf
        db      ' / or ?  - Display this help message',cr,lf
        db      '   0     - Enable  CTRL-C and exit',cr,lf
        db      '   1     - Disable CTRL-C and exit',cr,lf
        db      ' other   - Disable CTRL-C and CTRL-BREAK',cr,lf,lf
        db      'Unless the parm is 0 or 1, NOKEY will go TSR',cr,lf
        db      'and disable the other selected keys.'
        db      cr,lf,'$'
nokey   endp
cseg    ends
        end     nokey
