//======================================================================
// 
// ioctlcmd.h
//
// Copyright (C) 2002 Mark Russinovich
//
// This file contains driver IOCTLs and definitions shared by the
// driver and the GUI.
//
//======================================================================

#pragma warning( disable : 4100 ) // Unreferenced formal parameter.
#pragma warning( disable : 4127 ) // Conditional expression is constant.

//
// Device type
//
#define FILE_DEVICE_MYFAULT     0x00008336


//
// IOCTLS
//
#define IOCTL_BUFFER_OVERFLOW  (ULONG) CTL_CODE( FILE_DEVICE_MYFAULT, 0x00, METHOD_BUFFERED, FILE_ANY_ACCESS )
#define IOCTL_WILD_POINTER     (ULONG) CTL_CODE( FILE_DEVICE_MYFAULT, 0x01, METHOD_BUFFERED, FILE_ANY_ACCESS )
#define IOCTL_PAGE_FAULT       (ULONG) CTL_CODE( FILE_DEVICE_MYFAULT, 0x02, METHOD_BUFFERED, FILE_ANY_ACCESS )
#define IOCTL_DEADLOCK         (ULONG) CTL_CODE( FILE_DEVICE_MYFAULT, 0x03, METHOD_BUFFERED, FILE_ANY_ACCESS )
#define IOCTL_TRASH_STACK      (ULONG) CTL_CODE( FILE_DEVICE_MYFAULT, 0x04, METHOD_BUFFERED, FILE_ANY_ACCESS )
#define IOCTL_LEAK_PAGED       (ULONG) CTL_CODE( FILE_DEVICE_MYFAULT, 0x05, METHOD_BUFFERED, FILE_ANY_ACCESS )
#define IOCTL_IRQL             (ULONG) CTL_CODE( FILE_DEVICE_MYFAULT, 0x06, METHOD_BUFFERED, FILE_ANY_ACCESS )
#define IOCTL_HANG             (ULONG) CTL_CODE( FILE_DEVICE_MYFAULT, 0x07, METHOD_BUFFERED, FILE_ANY_ACCESS )
#define IOCTL_HANG_IRP         (ULONG) CTL_CODE( FILE_DEVICE_MYFAULT, 0x08, METHOD_BUFFERED, FILE_ANY_ACCESS )
#define IOCTL_LEAK_NONPAGED    (ULONG) CTL_CODE( FILE_DEVICE_MYFAULT, 0x09, METHOD_BUFFERED, FILE_ANY_ACCESS )
#define IOCTL_BSOD_COLOR       (ULONG) CTL_CODE( FILE_DEVICE_MYFAULT, 0x10, METHOD_BUFFERED, FILE_ANY_ACCESS )
#define IOCTL_STACK_OVERFLOW   (ULONG) CTL_CODE( FILE_DEVICE_MYFAULT, 0x11, METHOD_BUFFERED, FILE_ANY_ACCESS )
#define IOCTL_HARD_BREAKPOINT  (ULONG) CTL_CODE( FILE_DEVICE_MYFAULT, 0x12, METHOD_BUFFERED, FILE_ANY_ACCESS )
#define IOCTL_DOUBLE_FREE      (ULONG) CTL_CODE( FILE_DEVICE_MYFAULT, 0x13, METHOD_BUFFERED, FILE_ANY_ACCESS )
#define IOCTL_BUG_CHECK        (ULONG) CTL_CODE( FILE_DEVICE_MYFAULT, 0x14, METHOD_BUFFERED, FILE_ANY_ACCESS )





