/***************************************************************************
|
| MultiTabs16                                        Version 1.11 - FREEWARE
| ~~~~~~~~~~~
| Tab Control for Win 3.1 --- Copyright (c) BG Universal Software, Inc. 1997
|
|
| Developed by: Teodor Angeloff
|               5100 Gorna Orjahoviza, ul. "Struma" No. 4V, BULGARIA
|
|       E-mail: ta@ms3.tu-varna.acad.bg, apl24win@usa.net
|
***************************************************************************/
#ifndef __WINDOWS_H
#include <windows.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

BOOL WINAPI InitMultitabs16( void );
BOOL WINAPI QuitMultitabs16( void );
void WINAPI ColorChangeMT16( void );
WORD WINAPI Multitabs16Version( void );

#ifdef __cplusplus
}
#endif

#define MTS_BUTTON             0
#define MTS_GROUPBOX           1
#define MTS_2D                 8
#define MTS_ALWAYSBOLD         16
#define MTS_DEFBUTTON          64
#define MTS_LEFT               128
#define MTS_RIGHT              256
#define MTS_CENTER             512
#define MTS_VERTICAL           1024
#define MTS_SIMPLE             2048
/* MTS_SIMPLE style is not supported before v1.10 */

#define MTN_CLICKED            BN_CLICKED
#define MT_SETCHECK            BM_SETCHECK
#define MT_GETCHECK            BM_GETCHECK
#define MT_SETSTATE            BM_SETSTATE
#define MT_GETSTATE            BM_GETSTATE


/***************************************************************************

  How To Use MULTITABS16
  ~~~~~~~~~~~~~~~~~~~~~~

  To use this control, follow the steps listed below:

  1. Include this header file (MTabsCtl.H) in each source file that contains
     WinMain() and in each resource file (.RC) that contains "Multitabs16"
     control(s).
  2. Include MTABSCTL.LIB in your project file.
  3. Add a call to the InitMultitabs16() function when the application ini-
     tializes. WinMain() is usually a good place to add this function call.
  4. Add a call to ColorChangeMT16() in your application's WM_SYSCOLORCHANGE
     message handler.
  5. Add a call to QuitMultitabs16() at application destroy time. You may
     call QuitMultitabs16() just before returning from WinMain().


  This Tab control is a group including 3 or more "Multitabs16" controls. A
  MTS_GROUPBOX styled control is the frame, and all other MTS_BUTTON styled
  "Multitabs16" are the tab buttons.  The MTS_BUTTON button has similar be-
  haviour (message control) as a standard pushbutton (see the above MT_*
  message definitions).

  The MTS_GROUPBOX, MTS_BUTTON, and all other controls (shown/hidden by the
  tabs) are associated by using their control ID numbers.  The MTS_GROUPBOX
  control ID can be 1000, 2000, 3000,... n000.  If it is 1000, for example,
  then the MTS_BUTTON IDs must be 1001, 1002, 1003, ..., and the associated
  controls must have IDs between 1100 and 1199 for button 1001;  1200..1299
  for button 1002;  1300..1399 for 1003; ...

  It is recommended to make unvisible (NOT WS_VISIBLE) all dialog controls
  which will be shown/hidden from Multitabs16 MTS_BUTTONs.

  Example (simple dialog using "Multitabs16" control):

  DIALOG_MT16 DIALOG 15, 20, 231, 100
  STYLE DS_MODALFRAME | WS_POPUP | WS_CAPTION | WS_SYSMENU
  CAPTION "MultiTabs16"
  FONT 8, "Helv"
  BEGIN
    CONTROL "&Name", 1001, "MultiTabs16", MTS_BUTTON | WS_CHILD | WS_VISIBLE | WS_GROUP, 11, 10, 50, 12
    CONTROL "&Address", 1002, "MultiTabs16", MTS_BUTTON | WS_CHILD | WS_VISIBLE, 64, 11, 50, 12
    CONTROL "", 1000, "MultiTabs16", MTS_GROUPBOX | WS_CHILD | WS_VISIBLE | WS_GROUP, 7, 24, 152, 60
    LTEXT "&First", 1100, 14, 35, 40, 8, WS_CHILD | NOT WS_VISIBLE | WS_GROUP
    EDITTEXT 1101, 60, 33, 80, 12, ES_LEFT | WS_CHILD | NOT WS_VISIBLE | WS_BORDER | WS_TABSTOP
    LTEXT "&Middle", 1102, 14, 49, 40, 8, WS_CHILD | NOT WS_VISIBLE | WS_GROUP
    EDITTEXT 1103, 60, 47, 80, 12, ES_LEFT | WS_CHILD | NOT WS_VISIBLE | WS_BORDER | WS_TABSTOP
    LTEXT "&Last", 1104, 14, 63, 40, 8, WS_CHILD | NOT WS_VISIBLE | WS_GROUP
    EDITTEXT 1105, 60, 61, 80, 12, ES_LEFT | WS_CHILD | NOT WS_VISIBLE | WS_BORDER | WS_TABSTOP
    LTEXT "Line &1", 1200, 14, 35, 40, 8, WS_CHILD | NOT WS_VISIBLE | WS_GROUP
    EDITTEXT 1201, 60, 33, 80, 12, ES_LEFT | WS_CHILD | NOT WS_VISIBLE | WS_BORDER | WS_TABSTOP
    LTEXT "Line &2", 1202, 14, 49, 40, 8, WS_CHILD | NOT WS_VISIBLE | WS_GROUP
    EDITTEXT 1203, 60, 47, 80, 12, ES_LEFT | WS_CHILD | NOT WS_VISIBLE | WS_BORDER | WS_TABSTOP
    LTEXT "Line &3", 1204, 14, 63, 40, 8, WS_CHILD | NOT WS_VISIBLE | WS_GROUP
    EDITTEXT 1205, 60, 61, 80, 12, ES_LEFT | WS_CHILD | NOT WS_VISIBLE | WS_BORDER | WS_TABSTOP
    CONTROL "OK", IDOK, "BUTTON", BS_DEFPUSHBUTTON | WS_CHILD | WS_VISIBLE | WS_GROUP | WS_TABSTOP, 169, 24, 50, 14
    PUSHBUTTON "Cancel", IDCANCEL, 169, 40, 50, 14, WS_CHILD | WS_VISIBLE | WS_TABSTOP
  END


  You can choose the active button by using CheckDlgButton() function.

============================================================================

  GroupBox Styles
  ~~~~~~~~~~~~~~~

  MTS_LEFT

  +----------+-----------+-----------+
  |   Btn1   |   Btn2    |   Btn3    |
  +----------+-----------+-----------+---------+
  |                                            |
  |                                            |


  MTS_CENTER

  +----------+-----------+-----------+
  |   Btn1   |   Btn2    |   Btn3    |
  +----------+-----------+-----------+
  |                                  |
  |                                  |


  MTS_RIGHT
            +----------+-----------+-----------+
            |   Btn1   |   Btn2    |   Btn3    |
  +---------+----------+-----------+-----------+
  |                                            |
  |                                            |


  MTS_VERTICAL               MTS_VERTICAL               MTS_VERTICAL
  MTS_LEFT                   MTS_RIGHT                  MTS_CENTER

  +--------+---------                 +---------        +--------+---------
  | Btn1   |                          |                 | Btn1   |
  +--------+                          |                 +--------+         
  | Btn2   |                          |                 | Btn2   |
  +--------+                 +--------+                 +--------+
  | Btn3   |                 | Btn1   |                 | Btn3   |
  +--------+                 +--------+                 +--------+---------
           |                 | Btn2   |
           |                 +--------+
           |                 | Btn3   |
           +---------        +--------+---------

  MTS_2D            Disables the 3D view of the lines (there are no shadows)
  MTS_SIMPLE        Simple buttons. There is no middle state (New for v1.10)
  MTS_ALWAYSBOLD    The font is always bold (otherwise the font is bold only
                    for the selected button)

============================================================================

  Button Styles
  ~~~~~~~~~~~~~

  MTS_LEFT
  MTS_CENTER  (by default)
  MTS_RIGHT

  +-----------+------------+------------+
  | Left      |   Center   |      Right |
  +-----------+------------+------------+---------+
  |                                               |
  |                                               |


  MTS_VERTICAL  (MTS_LEFT by default)

  +------------+---------                                                        
  | Left       |                                                        
  +------------+                                                               
  |   Center   |                                                          
  +------------+                                                           
  |      Right |                                                        
  +------------+                                                                  
               |                             
               |                              
               |                             
               +---------                              

============================================================================

Type Bits/KeyID    Date       User ID
pub  1024/CB416311 1997/06/16 Teodor Angeloff <ta@ms3.tu-varna.acad.bg>

-----BEGIN PGP PUBLIC KEY BLOCK-----
Version: 2.6.3ia

mQCNAzOlh0wAAAEEANWnL2MmxCRtfW7WqsGgV7fF2P5S6ruDXOnYTRJO6SMx/71I
G4fO7axO6sx6xh5yOXje6Nkn8QRGxDg6n80+ik2gQdBonZhuAhRodwvoQPLclVZm
zYFDOsFxLaDkQRmGoivCbxj0HFgdvZSuQv0Q9kg+e1lDlot/veu2bkrLQWMRAAUR
tClUZW9kb3IgQW5nZWxvZmYgPHRhQG1zMy50dS12YXJuYS5hY2FkLmJnPokAlQMF
EDOlh1Hrtm5Ky0FjEQEBQkID/3o3e4d6i6Q3Vi6K4y8i/xLD0paJt5uiqD7shlDB
DLvF/k90P2mNF1BUpCLyYGb/W7lamyD03lBTnNnk3TuFbuflSg5Re7NPdlzlSubY
pEubEK2HIbjmXI+Oi+AG/zkYVmvpgGCgcTzB8QtGliYUOpRXfgZ6OKaKxOi8VqPg
SJFM
=FA7/
-----END PGP PUBLIC KEY BLOCK-----

***************************************************************************/
