REM file: Dirs.bas - Public Domain DOS Utility
REM Version 1.0a created 06/08/1995
REM Version 1.1a created 02/01/1997
REM Version 1.2a created 12/24/1999
REM Version 1.3a created 03/26/2001

' default integer variables
DEFINT A-Z
REM $DYNAMIC

' define boolean values
CONST True = -1
CONST False = NOT True
CONST TrueD = -1#
CONST FalseD = NOT TrueD
CONST NUL = ""

' define color values
CONST Black = 0
CONST Green = 10
CONST Plain = 7
CONST Red = 12
CONST White = 15
CONST Yellow = 14

' get include files
REM $INCLUDE: 'qbx.bi'
REM $INCLUDE: 'dta.bi'
REM $INCLUDE: 'wdta.bi'

' declare functions
DECLARE FUNCTION ParseLine (S$)
DECLARE FUNCTION BreakIS()
DECLARE FUNCTION ClearBreak()
DECLARE FUNCTION KeyIS()

' initialize filename buffer
COMMON SHARED ASCIIZ AS STRING * 260, ASCIIZ1 AS STRING * 260
COMMON SHARED ASCIIZ2 AS STRING * 260, DTAfile AS DTAtype
COMMON SHARED WDTAfile AS WDTAtype, Wfile.Handle AS INTEGER
COMMON SHARED Attribute AS INTEGER, First.Dir AS INTEGER

' initialize drive variables
COMMON SHARED Drive.Number AS INTEGER, Current.Drive AS INTEGER

' declare program dta
DIM BASIC.DTA.SEG AS INTEGER, BASIC.DTA.OFF AS INTEGER

' declare registers
COMMON SHARED InregsX AS RegTypeX, OutregsX AS RegTypeX
COMMON SHARED InregsX2 AS RegTypeX, InregsX3 AS RegTypeX

' declare work variables
COMMON SHARED Continuous.Display AS INTEGER, Display.Errors AS INTEGER
COMMON SHARED Root.Display AS INTEGER, Short.Display AS INTEGER
COMMON SHARED Append.Slash AS INTEGER, Files.Counter AS INTEGER
COMMON SHARED Continue.Listing AS INTEGER, Quit.Searching AS INTEGER
COMMON SHARED Parent.Display AS INTEGER, Windows.Detected AS INTEGER
COMMON SHARED No.Display.Drive AS INTEGER, Display.Lowercase AS INTEGER
COMMON SHARED Total.Dirs AS INTEGER, Dont.Append AS INTEGER

' declare command line work variables
COMMON SHARED Command.Line AS STRING, Command.Line.Redirect AS STRING
COMMON SHARED Command.Work AS STRING, Control.Break AS INTEGER
COMMON SHARED Last.Switch AS INTEGER, Pipe.Buffer AS STRING * 1
COMMON SHARED Redirected.Input AS INTEGER

' declare external procedures
DECLARE SUB SetInt
DECLARE SUB RestInt

' backwards compatible for bc 7.1
REM $INCLUDE: 'bc7.inc'

' increase stack size
STACK STACK

' install new interrupt service routine
CALL SetInt

' declare standard error trap
ON ERROR GOTO Error.Routine

' command line parser
FUNCTION ParseLine (X$)
 Imbedded = INSTR(Command.Line, LCASE$(X$))
 IF Imbedded THEN
    Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + LEN(X$))
    Last.Switch = Imbedded - 1
    ParseLine = True
 ELSE
    Imbedded = INSTR(Command.Line, UCASE$(X$))
    IF Imbedded THEN
       Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + LEN(X$))
       Last.Switch = Imbedded - 1
       ParseLine = True
    ELSE
       ParseLine = False
    END IF
 END IF
END FUNCTION 

' store basic dta
InregsX.AX = &H2F00
CALL InterruptX(&H21, InregsX, OutregsX)
BASIC.DTA.SEG = OutregsX.ES
BASIC.DTA.OFF = OutregsX.BX

' get current drive
InregsX.AX = &H1900
CALL InterruptX(&H21, InregsX, OutregsX)
Current.Drive = OutregsX.AX AND &HFF

' check windows
Windows.Detected = True
If Load.Windows = False Then
   InregsX.AX = &H160A
   CALL InterruptX(&H2F, InregsX, OutregsX)
   IF OutregsX.AX > 0 THEN
      InregsX.AX = &H4A33
      CALL InterruptX(&H2F, InregsX, OutregsX)
      IF OutregsX.AX = 0 THEN
         Windows.Detected = 0 ' DOS 7.00
      END IF
   END IF
END IF
IF INSTR(COMMAND$, "/_") THEN
   Windows.Detected = True
END IF

' check command line
SELECT CASE COMMAND$
CASE "/?"
   GOTO Boot.Usage
END SELECT

' read command line from PSP
Command.line = NUL
InregsX.AX = &H6200
CALL InterruptX(&H21, InregsX, OutregsX)
PSPsegment = OutregsX.BX
PSPoffset = 128
DEF SEG = PSPsegment
FOR Count = 1 TO 127
   Command.Char = PEEK(PSPoffset + Count)
   SELECT CASE Command.Char
   CASE 0, 10, 13
      EXIT FOR
   CASE ELSE
      Command.line = Command.line + CHR$(Command.Char)
   END SELECT
NEXT
DEF SEG
IF Command.Line = NUL THEN
   Command.Line = ENVIRON$("DIRS")
END IF
Command.Line = RTRIM$(Command.Line)

' get switches from command line
Append.Slash = ParseLine ("/A")
No.Display.Drive = ParseLine ("/B")
Continuous.Display = ParseLine ("/C")
Short.Filename = ParseLine ("/U")
Parent.Display = ParseLine ("/V")
Display.Lowercase = ParseLine ("/W")
Root.Display = ParseLine ("/X")
Short.Display = ParseLine ("/Y")
Display.Errors = ParseLine ("/Z")
Control.Break = ParseLine ("/~")
Var = ParseLine("/_")

' recheck command line
IF INSTR(Command.Line, "/") THEN
   GOTO Boot.Error
END IF
Command.Line = RTRIM$(Command.Line)
IF Last.Switch THEN
   IF LEN(Command.Line) > Last.Switch THEN
      GOTO Boot.Error
   END IF
END IF

' remove blanks from command line
Command.Line = RTRIM$(Command.Line)
Command.Line = LTRIM$(Command.Line)
Command.Line.Redirect = Command.Line

' reset some variables
Files.Counter = False
Continue.Listing = False
Quit.Searching = False

' restore directory search dta
InregsX.AX = &H1A00
InregsX.DS = VARSEG(DTAfile)
InregsX.DX = VARPTR(DTAfile)
CALL InterruptX(&H21, InregsX, OutregsX)

' check break flag override
IF Control.Break THEN
   Var = ClearBreak
END IF

' search through all input filenames
Redirected.Input = False

' check pipe length
InregsX.AX = &H4202 ' eof
InregsX.BX = 0 ' stdin
InregsX.CX = 0
InregsX.DX = 0
Call InterruptX(&H21, InregsX, OutregsX)
If OutregsX.AX > 0 Then
   Pipe.Redirect = True
   InregsX.AX = &H4200
   InregsX.BX = 0 ' stdin
   InregsX.CX = 0
   InregsX.DX = 0
   Call InterruptX(&H21, InregsX, OutregsX)
Endif
If Pipe.Redirect = False Then
   DEF SEG = &H40
   X = PEEK(&H71)
   DEF SEG
   IF X = 64 THEN
      DEF SEG = &H40
      POKE &H71, 0
      DEF SEG
   END IF
Endif
DO
   ' check control break
   IF BreakIS THEN
      EXIT DO
   END IF

   ' get standard input
   Standard.Input$ = NUL

   If Pipe.Redirect Then
      DO

         ' read from device
         InregsX.AX = &H3F00
         InregsX.BX = 0 ' stdin
         InregsX.CX = 1 ' char
         InregsX.DS = VARSEG(Pipe.Buffer)
         InregsX.DX = VARPTR(Pipe.Buffer)
         Call InterruptX(&H21, InregsX, OutregsX)
         If (OutregsX.Flags AND &H1) = &H1 Then
            Exit Do
         Endif
         If (OutregsX.Flags AND &H1) = &H0 Then
            If OutregsX.AX = 0 Then
               Exit Do
            Endif

            ' store input flag
            Redirected.Input = True

            ' store character
            Char$ = Pipe.Buffer

            ' check character
            SELECT CASE ASC(Char$)
            CASE 10, 26
            CASE 13
               EXIT DO
            CASE ELSE
               Standard.Input$ = Standard.Input$ + Char$
            END SELECT
         END IF
      LOOP
   END IF

   ' clear break flag
   IF Redirected.Input = False THEN
      IF Cleared = False THEN
         Cleared = True
         Var = ClearBreak
      END IF
   END IF

   ' check control break
   IF BreakIS THEN
      EXIT DO
   END IF

   ' check nul filename input
   IF Redirected.Input = False THEN
      IF Standard.Input$ = NUL THEN
         CALL RestInt ' restore Control-Break
         X$ = Inkey$ ' quits here
         CALL SetInt ' reset Control-Break
         IF X$ = CHR$(0) + CHR$(0) THEN
            EXIT DO
         END IF
      END IF
   END IF

   ' check standard input
   IF Redirected.Input THEN
      IF Standard.Input$ = NUL THEN
	 EXIT DO
      END IF
   END IF

   ' display header
   GOSUB Header

   ' store original command line
   Command.Line = Command.Line.Redirect

   ' filename processing loop
   DO
      ' store redirected input
      Standard.Input$ = RTRIM$(Standard.Input$)
      Standard.Input$ = LTRIM$(Standard.Input$)
      IF LEFT$(Standard.Input$, 1) = CHR$(34) THEN
         Standard.Input$ = MID$(Standard.Input$, 2)
      END IF
      IF RIGHT$(Standard.Input$, 1) = CHR$(34) THEN
         Standard.Input$ = LEFT$(Standard.Input$, LEN(Standard.Input$) - 1)
      END IF

      ' store entire command
      IF LEFT$(Command.Line, 1) = CHR$(34) THEN
         Imbedded = INSTR(2, Command.Line, CHR$(34))
         IF Imbedded THEN
            Command.Work = Standard.Input$ + MID$(Command.Line, 2, Imbedded - 2)
            Command.Line = MID$(Command.Line, Imbedded + 1)
         ELSE
            Command.Work = Standard.Input$ + Command.Line
            Command.Line = NUL
         END IF
      ELSE
         Imbedded = INSTR(Command.Line, " ")
         IF Imbedded THEN
            Command.Work = Standard.Input$ + LEFT$(Command.Line, Imbedded - 1)
            Command.Line = MID$(Command.Line, Imbedded + 1)
         ELSE
            Command.Work = Standard.Input$ + Command.Line
            Command.Line = NUL
         END IF
      END IF
      Command.Line = LTRIM$(Command.Line)
      Command.Line = RTRIM$(Command.Line)

      ' store current drive
      IF MID$(Command.Work, 2, 1) = ":" THEN
         Drive.Number = ASC(UCASE$(LEFT$(Command.Work, 1))) - 65
         Command.Work = MID$(Command.Work, 3)
      ELSE
	 Drive.Number = Current.Drive
      END IF

      ' check windows dos
      IF Windows.Detected THEN
         ' get current directory
         InregsX.AX = &H7147
         InregsX.DX = Drive.Number + 1
         InregsX.DS = VARSEG(ASCIIZ)
         InregsX.SI = VARPTR(ASCIIZ)
         CALL InterruptX(&H21, InregsX, OutregsX)
      ELSE
         ' get current directory
         InregsX.AX = &H4700
         InregsX.DX = Drive.Number + 1
         InregsX.DS = VARSEG(ASCIIZ)
         InregsX.SI = VARPTR(ASCIIZ)
         CALL InterruptX(&H21, InregsX, OutregsX)
      END IF

      ' display any errors
      CALL DisplayError ("Error accessing drive.")

      ' check carry flag error
      IF (OutregsX.Flags AND &H1) = &H0 THEN
         ' store current directory
         Directory.Search$ = "\" + LEFT$(ASCIIZ, INSTR(ASCIIZ, CHR$(0)) - 1)
         Imbedded = INSTR(Command.Work, "\")
         Imbedded2 = Imbedded
         WHILE Imbedded
            Imbedded2 = Imbedded
            Imbedded = INSTR(Imbedded + 1, Command.Work, "\")
         WEND
         IF Imbedded2 THEN
            Directory.Search$ = LEFT$(Command.Work, Imbedded2)
            Command.Work = MID$(Command.Work, Imbedded2 + 1)
         END IF
   
         ' get filename spec
         Filename.Search$ = Command.Work
         IF Filename.Search$ = NUL THEN
            IF RIGHT$(Directory.Search$, 1) <> "\" THEN
               Directory.Search$ = Directory.Search$ + "\"
            END IF
         ELSE
            IF RIGHT$(Directory.Search$, 1) = "\" THEN
               Directory.Search$ = Directory.Search$ + Filename.Search$
            ELSE
               Directory.Search$ = Directory.Search$ + "\" + Filename.Search$
            END IF
         END IF
         Command.Work = NUL

         ' change to drive
         InregsX.AX = &HE00
         InregsX.DX = Drive.Number
         CALL InterruptX(&H21, InregsX, OutregsX)
   
         ' make directory filename
         IF RIGHT$(Directory.Search$, 1) <> "\" THEN
            Directory.Search$ = Directory.Search$ + "\"
         END IF
         Directory.File$ = Directory.Search$
         ASCIIZ = Directory.Search$ + "*.*" + CHR$(0)

         ' make directory path filename
         IF RIGHT$(Directory.File$, 1) <> "\" THEN
            Imbedded = LEN(Directory.File$)
            DO WHILE Imbedded > False
               Imbedded = Imbedded - 1
               IF MID$(Directory.File$, Imbedded, 1) = "\" THEN
                  Directory.File$ = LEFT$(Directory.File$, Imbedded)
                  EXIT DO
               END IF
            LOOP
         END IF

         IF Continuous.Display = False THEN
            COLOR Yellow, Black
            PRINT "Searching: " + Directory.Search$
         END IF

         ' check windows dos
         IF Windows.Detected THEN
            ' find first long filename
            InregsX.AX = &H714E
            InregsX.CX = &H37
            InregsX.SI = &H1
            InregsX.DS = VARSEG(ASCIIZ)
            InregsX.DX = VARPTR(ASCIIZ)
            InregsX.ES = VARSEG(WDTAfile)
            InregsX.DI = VARPTR(WDTAfile)
            CALL InterruptX(&H21, InregsX, OutregsX)
            Wfile.Handle = OutregsX.AX
         ELSE
            ' find first directory
            InregsX.AX = &H4E00
            InregsX.CX = &H37
            InregsX.DS = VARSEG(ASCIIZ)
            InregsX.DX = VARPTR(ASCIIZ)
            CALL InterruptX(&H21, InregsX, OutregsX)
         END IF

         ' check findirst error
         IF (OutregsX.Flags AND &H1) = &H1 THEN
            IF OutregsX.Ax <> &H12 THEN
               CALL DisplayError ("Error reading directory.")
            END IF
            EXIT DO
         END IF

         ' display root directories
         IF Parent.Display = False THEN
            Directory$ = Directory.File$
            IF RIGHT$(Directory$, 1) = "\" THEN
               Directory$ = LEFT$(Directory$, LEN(Directory$) - 1)
            END IF
            IF Directory$ = NUL THEN
               Directory$ = "\"
            END IF
            IF Short.Display THEN
               Directory$ = Nul
            END IF
            IF Short.Filename THEN
               IF No.Display.Drive = False THEN
                  IF LEFT$(Directory$, 2) <> "\\" THEn
                     Directory$ = CHR$(Drive.Number + 65) + ":" + Directory$
                  END IF
               END IF
            END IF
            GOSUB Display.Parent
         END IF

         ' check root display flag
         IF Root.Display = False THEN
            Dont.Append = True
            ' display .
            Directory.Name$ = "."
            IF Short.Filename THEN
               IF No.Display.Drive = False THEN
                  IF Short.Display THEN
                     IF LEFT$(Directory.Search$, 2) <> "\\" THEN
                        Directory.Name$ = CHR$(Drive.Number + 65) + ":" + Directory.Name$
                     END IF
                  ELSE
                     IF LEFT$(Directory.Search$, 2) = "\\" THEN
                        Directory.Name$ = Directory.File$ + Directory.Name$
                     ELSE
                        Directory.Name$ = CHR$(Drive.Number + 65) + ":" + Directory.File$ + Directory.Name$
                     END IF
                  END IF
               ELSE
                  IF Short.Display = False THEN
                     Directory.Name$ = Directory.File$ + Directory.Name$
                  END IF
               END IF
            END IF
            GOSUB Display.Directory

            ' display ..
            IF Directory.File$ <> "\" THEN
               First.Dir = True
               Directory.Name$ = ".."
               IF Short.Filename THEN
                  IF No.Display.Drive = False THEN
                     IF Short.Display THEN
                        IF LEFT$(Directory.Search$, 2) <> "\\" THEN
                           Directory.Name$ = CHR$(Drive.Number + 65) + ":" + Directory.Name$
                        END IF
                     ELSE
                        IF LEFT$(Directory.Search$, 2) = "\\" THEN
                           Directory.Name$ = Directory.File$ + Directory.Name$
                        ELSE
                           Directory.Name$ = CHR$(Drive.Number + 65) + ":" + Directory.File$ + Directory.Name$
                        END IF
                     END IF
                  ELSE
                     IF Short.Display = False THEN
                        Directory.Name$ = Directory.File$ + Directory.Name$
                     END IF
                  END IF
               END IF
               GOSUB Display.Directory
            END IF
         END IF
         IF Root.Display AND Short.Filename THEN
            IF Directory.File$ <> "\" THEN
               First.Dir = True
            END IF
         END IF
         Dont.Append = False

         ' list directories
         DO
            ' check for directory
            IF Windows.Detected THEN
               Attribute = ASC(WDTAfile.FileBits)
            ELSE
               Attribute = ASC(DTAfile.FileBits)
            END IF
            IF (Attribute AND &H10) = &H10 THEN
               ' make directory name
               IF Windows.Detected THEN
                  Directory.Name$ = WDTAfile.ASCIIZfull
                  ' get windows short filename
                  IF Short.Filename THEN
                     ASCIIZ1 = Directory.Name$ + CHR$(0)
                     InregsX.AX = &H7160
                     InregsX.CX = &H8001
                     InregsX.DS = VARSEG(ASCIIZ1)
                     InregsX.SI = VARPTR(ASCIIZ1)
                     InregsX.ES = VARSEG(ASCIIZ2)
                     InregsX.DI = VARPTR(ASCIIZ2)
                     CALL InterruptX(&H21, InregsX, OutregsX)

                     ' check carry flag error
                     IF (OutregsX.Flags AND &H1) = &H1 THEN
                        Directory.Name$ = NUL
                     ELSE
                        ' store windows short filename
                        Directory.Name$ = ASCIIZ2
                        Imbedded = INSTR(Directory.Name$, CHR$(0))
                        Directory.Name$ = LEFT$(Directory.Name$, Imbedded - 1)
                        IF RIGHT$(Directory.Name$, 2) = ":\" THEN
                           Directory.Name$ = Nul
                        END IF
                        IF LEN(Directory.Name$) THEN
                           IF Short.Display THEN
                              FOR Temp = LEN(Directory.Name$) TO 1 STEP -1
                                 IF MID$(Directory.Name$, Temp, 1) = "\" THEN
                                    EXIT FOR
                                 END IF
                              NEXT
                              Directory.Name$ = LEFT$(Directory.Name$, 2) + MID$(Directory.Name$, Temp + 1)
                           END IF
                           IF No.Display.Drive THEN
                              Directory.Name$ = MID$(Directory.Name$, 3)
                           END IF
                        END IF
                     END IF
                     IF First.Dir THEN
                        Directory.Name$ = Nul
                        First.Dir = False
                     END IF
                  END IF
               ELSE
                  Directory.Name$ = DTAfile.ASCIIZfilename
               END IF
               Imbedded = INSTR(Directory.Name$, CHR$(0))
               IF Imbedded THEN
                  Directory.Name$ = LEFT$(Directory.Name$, Imbedded - 1)
               END IF

               ' check directory display type
               IF Directory.Name$ <> "." AND Directory.Name$ <> ".." THEN
                  ' display directory
                  GOSUB Display.Directory

                  ' check search flag
                  IF Quit.Searching THEN
                     EXIT DO
                  END IF
               END IF
            END IF

            ' check windows dos
            IF Windows.Detected THEN
               ' find next long filename
               InregsX.AX = &H714F
               InregsX.BX = Wfile.Handle
               InregsX.SI = &H1
               InregsX.ES = VARSEG(WDTAfile)
               InregsX.DI = VARPTR(WDTAfile)
               CALL InterruptX(&H21, InregsX, OutregsX)
            ELSE
               ' find next directory
               InregsX.AX = &H4F00
               CALL InterruptX(&H21, InregsX, OutregsX)
            END IF

            ' check findnext error
            IF (OutregsX.Flags AND &H1) = &H1 THEN
               EXIT DO
            END IF
         LOOP
      END IF

      ' check search filename
      IF Command.Line = NUL THEN
	 EXIT DO
      END IF

      ' check quit searching
      IF Quit.Searching THEN
         EXIT DO
      END IF
   LOOP

   ' check search filename
   IF Standard.Input$ = NUL THEN
      EXIT DO
   END IF

   ' check quit searching
   IF Quit.Searching THEN
      EXIT DO
   END IF
LOOP

' check windows dos
IF Windows.Detected THEN
   ' close long filename search
   InregsX.AX = &H71A1
   InregsX.BX = Wfile.Handle
   CALL InterruptX(&H21, InregsX, OutregsX)
END IF

End.Dirs:

' restore basic dta
InregsX.AX = &H1A00
InregsX.DS = BASIC.DTA.SEG
InregsX.DX = BASIC.DTA.OFF
CALL InterruptX(&H21, InregsX, OutregsX)

' restore current drive
InregsX.AX = &HE00
InregsX.DX = Current.Drive
CALL InterruptX(&H21, InregsX, OutregsX)

' display end program
IF Continuous.Display = False THEN
   COLOR White, Black
   PRINT "Directories counted:" + STR$(Total.Dirs)
   Prompt$ = "Press <enter> to exit to DOS:"
   CALL MorePrompt(Prompt$, CHR$(13), Outpt$)
END IF

' restore key trapping
CALL RestInt

COLOR Plain, Black
END

Display.Directory:
 ' check directory display type
 IF Short.Display OR Short.Filename THEN
    Directory$ = Directory.Name$
 ELSE
    Directory$ = Directory.File$ + Directory.Name$
 END IF
Display.Parent:
 ' check directory
 IF Short.Filename THEN
    IF Directory$ = Nul THEN
       RETURN
    END IF
 END IF

 ' check drive display type
 IF No.Display.Drive OR Short.Filename THEN
    File.List$ = Directory$
 ELSE
    IF LEFT$(Directory$, 2) <> "\\" THEN
       File.List$ = CHR$(Drive.Number + 65) + ":" + Directory$
    ELSE
       File.List$ = Directory$
    END IF
 END IF

 ' check filename
 IF File.List$ = Nul THEN
    RETURN
 END IF

 ' check directory display type
 IF Append.Slash THEN
    IF Dont.Append = False THEN
       IF RIGHT$(File.List$, 1) <> "\" THEN
          File.List$ = File.List$ + "\"
       END IF
    END IF
 END IF

 ' increment counter
 Total.Dirs = Total.Dirs + 1

 ' display directory
 COLOR Yellow, Black
 IF Display.Lowercase THEN
    PRINT LCASE$(File.List$)
 ELSE
    IF Windows.Detected THEN
       PRINT File.List$
    ELSE
       PRINT UCASE$(File.List$)
    END IF
 END IF

 ' check files counter
 Files.Counter = Files.Counter + 1
 IF Files.Counter >= 21 THEN
    Files.Counter = False
    IF Continuous.Display = False THEN
       IF Continue.Listing = False THEN
          Prompt$ = "More(y/n/c)?"
          CALL MorePrompt(Prompt$, "ync", Outpt$)
          IF BreakIS THEN
             Outpt$ = "n"
          END IF
          SELECT CASE Outpt$
	  CASE "c"
             Continue.Listing = True
	  CASE "n"
             Quit.Searching = True
	  END SELECT
       END IF
    END IF
 END IF
 RETURN

' display program usage
Boot.Usage:
 ' restore key trapping
 CALL RestInt
 Var$=Inkey$
 ' make header
 COLOR White, Black
 PRINT "Dirs v1.3a: Directory display utility; "
 COLOR Yellow, Black
 PRINT "Usage:"
 PRINT "   Dirs [d:][\path\][/abcuvwxyz]"
 PRINT "Where:"
 PRINT "   /a  append directory path."
 PRINT "   /b  dont display drive letter."
 PRINT "   /c  continuous display."
 PRINT "   /u  short filename display."
 PRINT "   /v  don't display parent."
 PRINT "   /w  display lowercase."
 PRINT "   /x  don't display . or .."
 PRINT "   /y  short directory display."
 PRINT "   /z  suppress error messages."
 COLOR Plain, Black
 END

Boot.Error:
 CALL RestInt
 Var$=Inkey$
 COLOR White, Black
 PRINT "Command line error. Type Dirs /? for help."
 COLOR Plain, Black
 END

' make header
Header:
 IF Header.Flag THEN
    RETURN
 END IF
 Header.Flag = True
 IF Continuous.Display = False THEN
    COLOR White, Black
    PRINT "Dirs v1.3a: Directory display utility; "
 END IF
 RETURN

' critical error trap
Error.Routine:
 Data.Error = ERR
 IF Display.Errors THEN
    Error.Level = True
    OutregsX.Flags = &H1
    RESUME NEXT
 END IF
 SELECT CASE Data.Error
 CASE 53
    Temp.Outpt$ = "File not found."
 CASE 61
    Temp.Outpt$ = "Disk full."
 CASE 70
    Temp.Outpt$ = "Permission denied."
 CASE 71
    Temp.Outpt$ = "Disk not ready."
 CASE ELSE
    Temp.Outpt$ = "Untrapped error" + STR$(Data.Error) + "."
 END SELECT
 COLOR Green, Black
 PRINT Temp.Outpt$
 Prompt$ = "Press R to retry, Q to quit, C to continue:"
 CALL MorePrompt(Prompt$, "rqc", Outpt$)
 IF BreakIS THEN
    Outpt$ = "q"
 END IF
 SELECT CASE Outpt$
 CASE "r"
    RESUME
 CASE "q"
    Error.Level = True
    RESUME End.Dirs
 CASE "c"
    OutregsX.Flags = &H1
    RESUME NEXT
 END SELECT
 COLOR Plain, Black
 ' restore key trapping
 CALL RestInt
 END 0

SUB MorePrompt (Input.String$, Input.Mask$, Output.String$)
 COLOR White, Black
 PRINT Input.String$ + " ";
 Input.Char$ = NUL
 DO
    LOCATE , , 1
    InregsX2 = InregsX
    DO
       IF BreakIS THEN
          EXIT DO
       END IF
       IF KeyIS THEN
          IF OutregsX.AX <> 0 THEN
             InregsX.AX = &H0000
             CALL InterruptX(&H16, InregsX, OutregsX)
             Input.Char$=CHR$(OutregsX.AX AND &HFF)
             EXIT DO
          END IF
       END IF
       ' release time slice.
       InregsX.AX = &H1680
       InregsX.BX = &H0000
       CALL InterruptX(&H2F, InregsX, OutregsX)
    LOOP
    InregsX = InregsX2
    IF BreakIS THEN
       EXIT DO
    END IF
    IF LEN(Input.Char$) THEN
       Input.Char$ = LCASE$(Input.Char$)
       IF INSTR(Input.Mask$, Input.Char$) THEN
	  PRINT Input.Char$
	  Output.String$ = Input.Char$
	  EXIT DO
       END IF
    END IF
 LOOP
END SUB

' clears Control-Break flag
FUNCTION ClearBreak
 DEF SEG = &H40
 POKE &H71, &H0
 DEF SEG
 ClearBreak = True
END FUNCTION

' checks Control-Break flag
FUNCTION BreakIS
 STATIC Var AS INTEGER
 IF Redirected.Input THEN
    DEF SEG = &H40
    X = PEEK(&H71)
    DEF SEG
    IF X = 64 THEN
       Var = True
    END IF
 END IF
 IF KeyIS THEN
    IF OutregsX.AX = 0 THEN
       Var = True
       DEF SEG = &H40
       POKE &H71, 64
       DEF SEG
    END IF
 END IF
 IF Var THEN
    Continuous.Display = True
 END IF
 BreakIS = Var
END FUNCTION

' checks keyboard buffer
FUNCTION KeyIS
 InregsX3 = InregsX
 InregsX.AX = &H0100
 CALL InterruptX(&H16, InregsX, OutregsX)
 InregsX = InregsX3
 IF (OutregsX.Flags AND &H40) = &H40 THEN
    KeyIS = False
 ELSE
    KeyIS = True
 END IF
END FUNCTION

' displays carry flag error
SUB DisplayError (Temp$)
 ' check carry flag error
 IF (OutregsX.Flags AND &H1) = &H1 THEN
    ' check display errors flag
    IF Display.Errors = False THEN
       ' display error
       COLOR Red, Black
       PRINT Temp$
    END IF
 END IF
END SUB
