unit Memdef;
{TMemoryDefragmenter component by Nick Asenov, Sofia, Bulgaria
http://members.fortunecity.com/myeraser/
mailto:<eraser@sexmagnet.com>
}

interface

uses
Windows,Messages,SysUtils,Classes,Forms;

const
  WM_STOPDEF = WM_USER + 15;

type
  TMemdef = class(TComponent)
  private
    { Private declarations }
  FActivated: Boolean;
  FMyHandle: THandle;
  Flimit: Integer;
  FOnCreate: TNotifyEvent;
  FOnDestroy: TNotifyEvent;
  FOnAbortDef: TNotifyEvent;
  FOnGo: TNotifyEvent;
  FOnFinished: TNotifyEvent;
  FOnErr: TNotifyEvent;
  function Getlimit: Integer;
  function GetMyHandle: THandle;
  function GetActivated: Boolean;
  procedure SetActivated(const bVal: Boolean);
  protected
    { Protected declarations }
  procedure MyWndProc(var Msg: TMessage);
  procedure DoOnDestroy;
  procedure DoOnCreate;
  procedure DoOnGo;
  procedure DoOnAbortDef;
  procedure DoOnFinished;
  procedure DoOnErr;
  public
    { Public declarations }
  constructor Create(AOwner: TComponent); override;
  destructor Destroy; override;
  procedure Defrag;
  property limit: Integer read Getlimit;
  property MyHandle: THandle read GetMyHandle;
  published
    { Published declarations }
  property OnCreate: TNotifyEvent read FOnCreate write FOnCreate;
  property OnDestroy: TNotifyEvent read FOnDestroy write FOnDestroy;
  property OnAbortDef: TNotifyEvent read FOnAbortDef write FOnAbortDef;
  property OnFinished: TNotifyEvent read FOnFinished write FOnFinished;
  property Activated: Boolean read GetActivated write SetActivated;
  property OnGo: TNotifyEvent read FOnGo write FOnGo;
  property OnErr: TNotifyEvent read FOnErr write FOnErr;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('Max', [TMemdef]);
end;

constructor TMemdef.Create(AOwner: TComponent);
var
msx: TMemoryStatus;
begin
inherited Create(AOwner);
FMyHandle:= Classes.AllocateHWnd(MyWndProc);
FActivated:= true;
FillChar(msx,sizeof(msx),0);
msx.dwLength:= sizeof(msx);
GlobalMemoryStatus(msx);
Flimit:= (msx.dwTotalPhys) div 1048576;
DoOnCreate;
end;

destructor TMemdef.Destroy;
begin
FActivated:= False;
Classes.DeallocateHWnd(FMyHandle);
FOnAbortDef:= Nil;
FOnGo:= Nil;
FOnFinished:= Nil;
DoOnDestroy;
FOnDestroy:= Nil;
inherited Destroy;
end;

function TMemdef.Getlimit: Integer;
begin
Result:= Flimit;
end;

function TMemdef.GetMyHandle: THandle;
begin
Result:= FMyHandle;
end;

function TMemdef.GetActivated: Boolean;
begin
Result:= FActivated;
end;

procedure TMemdef.SetActivated(const bVal: Boolean);
begin
FActivated:= bVal;
end;

procedure TMemdef.DoOnErr;
begin
if FActivated then
  if Assigned(FOnErr) then
    FOnErr(Self);
end;

procedure TMemdef.DoOnCreate;
begin
if Assigned(FOnCreate) then
  FOnCreate(Self);
end;

procedure TMemdef.DoOnDestroy;
begin
if Assigned(FOnDestroy) then
  FOnDestroy(Self);
end;

procedure TMemdef.DoOnGo;
begin
if FActivated then
if Assigned(FOnGo) then
FOnGo(Self);
end;

procedure TMemdef.DoOnAbortDef;
begin
FActivated:= False;
if Assigned(FOnAbortDef) then
  FOnAbortDef(Self);
end;

procedure TMemdef.DoOnFinished;
begin
if FActivated then
if Assigned(FOnFinished) then
FOnFinished(Self);
end;

procedure TMemdef.Defrag;
var
pmem: Array of Pointer;
i: Integer;
begin
SetLength(pmem,Flimit);
i:= 0;
while (FActivated) and (i <= High(pmem)) do
  begin
  Application.ProcessMessages;
  pmem[i]:= AllocMem(1048576);
  Inc(i);
  DoOnGo;
  end;
i:= 0;
while (FActivated) and (i <= High(pmem)) do
  begin
  Application.ProcessMessages;
  if pmem[i] <> Nil then
    try
    FreeMem(pmem[i],1048576);
    except
      DoOnErr;
    end;
  DoOnGo;
  Inc(i);
  end;
SetLength(pmem,0);
pmem:= Nil;
DoOnFinished;
end;

procedure TMemdef.MyWndProc(var Msg: TMessage);
begin
inherited;
if Msg.Msg = WM_STOPDEF then
  begin
  DoOnAbortDef;
  Msg.Result:= 0;
  Exit;
  end;
Msg.Result:= DefWindowProc(FMyHandle,Msg.Msg,Msg.WParam,Msg.LParam);
end;

end.

