        PAGE    60,132
NAME    LPTSWAP
        TITLE   LPTSWAP.com version 1.3
COMMENT 

Precis:

LPTSWAP 1.3 swaps LPT1: and LPT2:

Copyrighted, but may be freely copied for non-military use only.


Usage:

LPTSWAP.Com

To put the printers back the way there were, just run LPTSWAP again.

LPTSWAP is a clone of Quadram's QSWAP written by William B. McCormick.


Please report bugs and problems to:

Roedy Green
Canadian Mind Products
#208 - 525 Ninth Street
New Westminster BC Canada
V5H 2N6
tel:(604) 777-1804
mailto:roedy@mindprod.com
http://mindprod.com


Version 1.3 1998 November 8
- embed Barker address

Version 1.2 1996 October 25
- embed POB 707 Quathiaski Cove address

version 1.1 1993 June 30
- display new address and phone number



stack   segment stack           ; keep MS link happy by providing null stack
stack   ends

CODE    SEGMENT PARA            ; start off in code.

;==============================================================

data    segment byte            ; provide a separate DATA segment
                                ; actually comes after the code

;==============================================================


;  C O N S T A N T S

NoPrinters      DB      13,10,'No printers to swap.',13,10,'$'
OnePrinter      DB      13,10,'Only one printer.  Cannot swap.',13,10,'$'
TwoPrinters     DB      13,10,'LPT1: and LPT2: now swapped.',13,10,'$'

CopyrightMsg    label byte


        DB      ' LPTSWAP 1.3 ۲'
        db      10,13
        DB      'Swaps LPT1: and LPT2:'
        db      10,13
        DB      'Copyright (c) 1991,1998 Roedy Green Canadian Mind Products'
        db      10,13
        DB      '#208 - 525 Ninth Street, New Westminster, BC Canada V3M 5T9',13,10
        DB      'tel:(604) 777-1804   mailto:roedy@mindprod.com   http://mindprod.com',13,10
        DB      'May be freely distributed and used for any purpose except military.'
        db      10,13,"$"

;========================

data            ends
;======================================

SAY     MACRO   Msg
;       display message on screen
        LEA     DX,&Msg         ; use LEA rather than
                                ; MOV Offset for more generality
        MOV     AH,09h
        INT     21h
        ENDM

;======================================

BIOSDATA    segment AT 40h      ; dummy segment in low RAM
        org     0h
BIOSComAddrs    dw      ?       ; 4 words of COM1: .. COM4:
                dw      ?       ; device addresses
                dw      ?
                dw      ?
BIOSLPTAddrs    dw      ?       ; 4 words of LPT1: .. LPT4:
                dw      ?
                dw      ?
                dw      ?
BIOSDATA        ends

com     group   code,data       ; force data segment to go at the end

        ASSUME  CS:com,DS:com,ES:com,SS:com
                                ; seg regs cover everything
        ORG     100H            ; in Code segment

;==========================

Main    proc    far

;       M A I N L I N E   R O U T I N E

Start:
        say     CopyRightMsg
        push    DS
        mov     ax,BIOSDATA
        mov     DS,ax
        assume  DS:BIOSDATA
        lea     si,BIOSLPTAddrs ; 4 words of device address

        lodsw                   ; LPT1:
        mov     cx,ax           ; save LPT1: in CX
        test    ax,ax           ; is there an LPT1:?
        jnz     GotLPT1

        pop     DS              ; oops, no printers at all
        Say     NoPrinters
        mov     ax,4c01h        ; DIE
        INT     21H

GotLPT1:
        lodsw                   ; LPT2:
        test    ax,ax           ; is there an LPT2:?
        jnz     GotLPT2

        pop     DS              ; oops, only one printer.
        Say     OnePrinter
        mov     ax,4c01h        ; DIE
        INT     21H

GotLPT2:
                                ; have both LPT1: and LPT2:
        lea     di,BIOSLPTAddrs ; 4 words of device address
                                ; cx=lpt1: ax=lpt2:
        mov     DS:[di],ax      ; save LPT2: in LPT1: slot
        mov     DS:[di+2],cx    ; save LPT1: in LPT2: slot
        pop     DS
        Say     TwoPrinters
        mov     ax,4c00h        ; exit BACK TO dos normally
        INT     21H

Main    EndP

;=======================================

Code    EndS

        End     Start
