// LockCheck
// A Simple utility for use in Win32 command line batch files to determine if a file is in use

// NOTE:
// Written for the Watcom C/C++ compiler version 10.6 or higher
// Compiled with Watcom C/C++ 10.6

#include <io.h>
#include <fcntl.h>
#include <share.h>
#include <stdio.h>
#include <errno.h>
#include <dos.h>
#include <string.h>

void ProcessErrorMessage(int &err, char filespec[]);

int main(int argc, char *argv[])
{
    struct find_t  fileinfo;

    int handle, err, x, y;
    int wild;
    char *noparam, *toolarge, *free;
    char filespec[256];
    char path[256];
    
    noparam = "\nLockCheck 1.20\nUsage: LockChk <filename>\n";
    toolarge = "\nThe filespec exceeds the maximum allowable command line\n";
    free = "\n\nThe specified files are not locked.\n";
    
    if (argc != 2)
    {
        printf("%s\n", noparam);
        return (1);
    }
    
    x = (strlen(argv[1]) - 1);

    if (x > 256)
    {
        printf("%s", toolarge);
        return (1);
    }

    while (x >= 0 && x <= 256)
    {
        if (argv[1][x] == 47 || argv[1][x] == 58 || argv[1][x] == 92)
        {
            break;
        }   
        x = x - 1;
    }

   
    for (y = 0; y <= x; y++)
    {
        path[y] = argv[1][y];
    }
    path[x+1] = '\0';

    wild = _dos_findfirst(argv[1], _A_NORMAL, &fileinfo);
    
    while (wild == 0)
    {
        sprintf(filespec, "%s%s", path, fileinfo.name);
        handle = sopen(filespec, O_EXCL, SH_DENYRW);
        printf("\n%s", filespec);
        if (handle == -1)
        {
             err = errno;
             ProcessErrorMessage(err, filespec);

             #if defined (__OS2__)
             _dos_findclose(&fileinfo);
             #endif
             
             close (handle);
             return (1);
        }
        close (handle);
        wild = _dos_findnext(&fileinfo);
    }

    #if defined (__OS2__)
    _dos_findclose(&fileinfo);
    #endif
    
    close (handle);
    printf("%s", free);
    return (0);
}


// +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-

void ProcessErrorMessage(int &err, char filespec[])
{
    char *errmsg;
    int errnum = err;
                
    switch(errnum)
    {
        case -1:
                errmsg = " <-- is currently in use by another process\n";
                printf("\n%s %s", filespec, errmsg);
                break;
        case 1:
                errmsg = " <-- is an invalid file name\n";
                printf("\n%s %s", filespec, errmsg);
                break;
        case 2:
        case 3:
        case 4:
                errmsg = " <-- Something strange happened here!  Invalid file handle\n";
                printf("\n%s %s", filespec, errmsg);
                break;
        case 5:
                errmsg = "Not enough memory to run LockCheck!!\n";
                printf("\n%s", errmsg);
                break;
        case 6:
                errmsg = " <-- You do not have sufficient rights to access this file\n";
                printf("\n%s %s", filespec, errmsg);
                break;
        case 7:
        case 8:
        case 9:
        case 10:
                errmsg = "File table overflow.  Close some programs and try again\n";
                printf("\n%s", errmsg);
                break;
        case 11:
                errmsg = "Insufficient file handles to continue.  Increase 'FILES=' in CONFIG.SYS\n";
                printf("\n%s", errmsg);
                break;
        case 12:
        case 13:
        case 14:
        case 15:
                errmsg = "Operation aborted.  A resource deadlock would occur\n";
                printf("\n%s", errmsg);
                break;
        default:
                errmsg = "An unspecified error has occured.  Please contact the author\nError Code: ";
                printf("\n%s%d\n", errmsg, errnum);
                break;
    }

    return;
}
