unit vBmp;

interface
Uses Windows,Classes, Graphics,  SysUtils, vDither;

procedure ConvertBmp256(Source: TBitmap; Target: TBitmap; aNumColors:Integer);

implementation

procedure writeBMP(hMem:THandle;aInfo:PBitMapInfo;Stream:TStream);
var
  aSize:Integer;
  BMF:TBitmapFileHeader;
  buf:pointer;
begin
  aSize:=SizeOf(aInfo^.bmiHeader);
  if aInfo^.bmiHeader.biBitCount<=8 then
  begin
    aSize:=aSize+256*Sizeof(TRGBQuad);
  end;

  Buf:=GlobalLock(hMem);
  FillChar(BMF, sizeof(BMF), 0);
  BMF.bfType := $4D42;
  BMF.bfSize := aInfo^.bmiHeader.biSizeImage;
  BMF.bfOffBits := aSize;
  if Stream=nil then Stream:=TMemoryStream.create;
  Stream.writebuffer(BMF,Sizeof(BMF));
  Stream.writeBuffer(aInfo^,aSize);
  stream.writeBuffer(Buf^,aInfo^.bmiHeader.biSizeImage);

  GlobalUnlock(hMem);
end;


procedure ConvertBmp256(Source: TBitmap; Target: TBitmap; aNumColors:Integer);
var
  BMF:TBitmapFileHeader;
  aInfo,aInfo1:PBitMapInfo;
  SizeHeader,SizeImage:Integer;
  hMem,hMem1:THandle;
  Buf,Buf1:PChar;
  S:TMemoryStream;
begin
  S := TMemoryStream.Create;
  Source.SaveToStream(S);
  S.Seek(0, soFromBeginning);
  S.ReadBuffer(BMF,Sizeof(BMF));
  S.ReadBuffer(SizeHeader,sizeof(SizeHeader));
  S.Seek(-4,soFromCurrent);
  New(aInfo);
  S.ReadBuffer(aINFO^,Sizeof(aInfo^));
  SizeImage:=BMF.bfSize;
  aInfo^.bmiheader.biSizeImage:=SizeImage;
  HMem:=GlobalAlloc(GMEM_FIXED,SizeImage);
  Buf:=GlobalLock(HMem);
  S.Seek(BMF.bfOffBits,soFromBeginning);
  S.ReadBuffer(BUf^,SizeImage-S.Position);
  GlobalUnLock(HMem);
  S.Clear;

  SizeHeader:=Sizeof(TBitmapInfo)+sizeof(TRGBQuad)*256;
  GetMem(aInfo1,SizeHeader);
  aInfo1^:=aInfo^;

  aInfo1.bmiHeader.biSizeImage:=aInfo1.bmiHeader.biWidth*aInfo1.bmiHeader.biHeight;
  hMem1:=GlobalAlloc(GPTR,aInfo1.bmiHeader.biSizeImage);
  buf1:=GlobalLock(hMem1);
  buf:=GlobalLock(hMem);

  Fillchar(buf1^,aInfo1.bmiHeader.biSizeImage,#0);

  dither (aInfo1,Buf,buf1,aNumColors);

  GlobalUnlock(hMem1);
  GlobalUnlock(hMem);
  GlobalFree(hMem);

  aInfo1^.bmiheader.biBitcount:=8;

  writeBMP(hMem1,aInfo1,S);
  GlobalFree(hMem1);
  Dispose(aInfo);
  S.Seek(0, soFromBeginning);
  Target.LoadFromStream(S);
  S.Free;
end;

end.

