unit Stretch;
// -----------------------------------------------------------------------------
// Project:	bitmap resampler demo
// Module:	stretch
// Description: Interpolated Bitmap Resampling using filters.
// Version:	01.02
// Release:	3
// Date:	15-MAR-1998
// Target:	Win32, Delphi 2 & 3
// Author(s):	anme: Anders Melander, anders@melander.dk
// Copyright	(c) 1997,98 by Anders Melander
// Formatting:	2 space indent, 8 space tabs, 80 columns.
// -----------------------------------------------------------------------------
// This software is copyrighted as noted above.  It may be freely copied,
// modified, and redistributed, provided that the copyright notice(s) is
// preserved on all copies.
//
// There is no warranty or other guarantee of fitness for this software,
// it is provided solely "as is".  Bug reports or fixes may be sent
// to the author, who may or may not act on them as he desires.
//
// You may not include this software in a program or other software product
// without supplying the source, or without informing the end-user that the
// source is available for no extra charge.
//
// If you modify this software, you should include a notice in the "Revision
// history" section giving the name of the person performing the modification,
// the date of modification, and the reason for such modification.
// -----------------------------------------------------------------------------
// See resample.pas for further comments.
// -----------------------------------------------------------------------------
// Revision history:
//
// 0101	110198	anme	- Demo separated from resampler.
// -----------------------------------------------------------------------------

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls;

type
{$IFDEF VER900}
  // TSplitter only exists in Delphi 3 and later
  // This class is just a dummy that will allow the source to compile
  TSplitter = class(TPanel)
  private
    FIgnore: TNotifyEvent;
  public
    constructor Create(AOwner: TComponent); override;
  published
    property OnMoved: TNotifyEvent read FIgnore write FIgnore;
  end;
{$ENDIF}

  TFormStretch = class(TForm)
    Panel1: TPanel;
    Panel2: TPanel;
    ImageInput: TImage;
    ButtonLoad: TButton;
    ButtonStretch: TButton;
    OpenPictureDialog: TOpenDialog;
    Splitter1: TSplitter;
    PanelOutput: TPanel;
    Label1: TLabel;
    procedure ButtonLoadClick(Sender: TObject);
    procedure ButtonStretchClick(Sender: TObject);
    procedure FormResize(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  FormStretch: TFormStretch;

implementation

uses
  resample;

{$R *.DFM}

{$IFDEF VER900}
constructor TSplitter.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  Caption := '';
end;
{$ENDIF}

// -----------------------------------------------------------------------------
//
//			Stretch demo
//
// -----------------------------------------------------------------------------
procedure TFormStretch.ButtonStretchClick(Sender: TObject);
var
  i			: integer;
  Panel			: TPanel;
  Image			: TImage;
  Lab			: TLabel;
  StartTime		,
  EndTime		: DWORD;
begin
  for i := PanelOutput.ComponentCount-1 downto 0 do
    PanelOutput.Components[i].Free;

  // Loop to resample an image with different filters
  for i := low(ResampleFilters) to high(ResampleFilters) do
  begin
    Panel := TPanel.Create(PanelOutput);
    Panel.Caption := '';
    Panel.Width := PanelOutput.Width DIV (high(ResampleFilters) - low(ResampleFilters) + 1);
    Panel.Left := Panel.Width * i;
    Panel.Align := alLeft;
    Panel.Parent := PanelOutput;
    Lab := TLabel.Create(Panel);
    Lab.Align := alTop;
    Lab.Parent := Panel;
    Image := TImage.Create(Panel);
    Image.Align := alClient;
    Image.Parent := Panel;
    Image.Picture.Bitmap.Height := Image.Height;
    Image.Picture.Bitmap.Width := Image.Width;
    Image.Stretch := True;

    // Resample a single image
    StartTime := GetTickCount;
    Strecth(ImageInput.Picture.Bitmap, Image.Picture.Bitmap,
      ResampleFilters[i].Filter, ResampleFilters[i].Width);
    EndTime := GetTickCount;

    Lab.Caption := ResampleFilters[i].Name+': '+IntToStr(EndTime-StartTime)+'mS';
    Application.ProcessMessages;
  end;
end;

procedure TFormStretch.FormResize(Sender: TObject);
var
  Width			: integer;
  i			: integer;
begin
  Width := PanelOutput.Width;
  for i := 0 to PanelOutput.ComponentCount-1 do
  begin
    TControl(PanelOutput.Components[i]).Width := Width DIV (PanelOutput.ComponentCount-i);
    dec(Width, TControl(PanelOutput.Components[i]).Width);
  end;
end;

procedure TFormStretch.ButtonLoadClick(Sender: TObject);
begin
  // Set default file extension to BMP
  OpenPictureDialog.DefaultExt := GraphicExtension(TBitmap);
  // Only use BMP file filter
  OpenPictureDialog.Filter :=  GraphicFilter(TBitmap);
  if (OpenPictureDialog.Execute) then
    ImageInput.Picture.LoadFromFile(OpenPictureDialog.Filename);
end;

end.
