program LogoRand;

uses
  Graphics,
  Resample,
  Classes,
  vbmp,
  Windows,
  SysUtils,
  JPEG,
  registry,
  inifiles;

{$R *.RES}

const
  General = 'General';
  Desktop = 'Desktop';
  Colors: array[0..15] of TColor = (clBlack,
  clMaroon, clGreen, clOlive, clNavy, clPurple, clTeal, clGray, clSilver,
  clRed, clLime, clYellow, clBlue, clFuchsia, clAqua, clWhite);

var
  FileList: TStringList;
  Buffer: array[0..MAX_PATH] of char;
  WindowsDir, Startup, Wait, Shutdown, Wallpaper: String;
  IniFile: TIniFile;
  MakeBackup: Boolean;

function NViewLibLoad(FileName: PChar; ShowProgress: Boolean): hBitmap; stdcall; external 'NViewLib.dll';

procedure ConvertFile(Source, Target, Text, FontName: String; TextColor: TColor;
  TxtHeight: Integer);
var
  Bitmap, Bitmap2: Graphics.TBitmap;
  JPEG: TJPEGImage;
  FileType, Temp: String;
  F: file;
  Buffer: array[0..256] of char;
begin
  Bitmap := Graphics.TBitmap.Create;
  Bitmap2 := Graphics.TBitmap.Create;
  FileType := UpperCase(ExtractFileExt(Source));
  StrPCopy(Buffer, Source);
  if (FileType = '.JPG') or (FileType = '.JPEG') or (FileType = '.JPE') then begin
    JPEG := TJPEGImage.Create;
    JPEG.LoadFromFile(Source);
    Bitmap.Assign(JPEG);
    JPEG.Free;
    end
  else
    Bitmap.Handle := NViewLibLoad(Buffer, False);
  Bitmap2.Height := Trunc(Bitmap.Height * 5 / 3);
  if Bitmap2.Height > 400 then begin
    Bitmap2.Width := Trunc(Bitmap.Width * 400 / Bitmap2.Height);
    Bitmap2.Height := 400;
    end
  else
    Bitmap2.Width := Bitmap.Width;
  if Bitmap2.Width > 320 then begin
    Bitmap2.Height := Trunc(Bitmap2.Height * 320 / Bitmap2.Width);
    Bitmap2.Width := 320;
    end;
  Strecth(Bitmap, Bitmap2, ResampleFilters[6].Filter, ResampleFilters[6].Width);
  Bitmap.Free;
  Bitmap := Graphics.TBitmap.Create;
  with Bitmap do begin
    Width := 320;
    Height := 400;
    PixelFormat := pf24bit;
    with Canvas do begin
      Brush.Color := clBlack;
      FillRect(Rect(0, 0, 320, 400));
      Brush.Style := bsClear;
      with Font do begin
        Name := FontName;
        Height := TxtHeight;
        end;
      end;
    end;
  BitBlt(Bitmap.Canvas.Handle, 160 - Bitmap2.Width div 2, 200 - Bitmap2.Height div 2,
    Bitmap2.Width, Bitmap2.Height, Bitmap2.Canvas.Handle, 0, 0, SrcCopy);
  with Bitmap.Canvas do begin
    Font.Color := clBlack;
    TextOut(2, 1, Text);
    TextOut(1, 2, Text);
    TextOut(2, 3, Text);
    TextOut(3, 2, Text);
    Font.Color := TextColor;
    TextOut(2, 2, Text);
    end;
  ConvertBmp256(Bitmap, Bitmap2, 256);
  if FileExists(Target) then begin
    Temp := Target + '.bak';
    if FileExists(Temp) then
      DeleteFile(Temp);
    RenameFile(Target, Temp);
    end;
  Bitmap2.SaveToFile(Target);
  AssignFile(F, Target);
  Reset(F, 1);
  Seek(F, FileSize(F));
  BlockWrite(F, Buffer, Length(Source) + 1);
  CloseFile(F);
end;

procedure ConvertWallpaper(Source: String);
var
  Bitmap, Bitmap2: Graphics.TBitmap;
  JPEG: TJPEGImage;
  FileType, Temp, Target: String;
  F: file;
  Buffer: array[0..256] of char;
  Max: Integer;
begin
  Bitmap := Graphics.TBitmap.Create;
  Bitmap2 := Graphics.TBitmap.Create;
  FileType := UpperCase(ExtractFileExt(Source));
  StrPCopy(Buffer, Source);
  if (FileType = '.JPG') or (FileType = '.JPEG') or (FileType = '.JPE') then begin
    JPEG := TJPEGImage.Create;
    JPEG.LoadFromFile(Source);
    Bitmap.Assign(JPEG);
    JPEG.Free;
    end
  else
    Bitmap.Handle := NViewLibLoad(Buffer, False);
  Max := GetSystemMetrics(SM_CYSCREEN);
  Bitmap2.Height := Bitmap.Height;
  if Bitmap2.Height > Max then begin
    Bitmap2.Width := Trunc(Bitmap.Width * Max / Bitmap2.Height);
    Bitmap2.Height := Max;
    end
  else
    Bitmap2.Width := Bitmap.Width;
  Max := GetSystemMetrics(SM_CXSCREEN);
  if Bitmap2.Width > Max then begin
    Bitmap2.Height := Trunc(Bitmap2.Height * Max / Bitmap2.Width);
    Bitmap2.Width := Max;
    end;
  Strecth(Bitmap, Bitmap2, ResampleFilters[6].Filter, ResampleFilters[6].Width);
  Target := WindowsDir + 'LOGORAND.BMP';
  if FileExists(Target) then
    if MakeBackup then begin
      Temp := Target + '.bak';
      if FileExists(Temp) then
        DeleteFile(Temp);
      RenameFile(Target, Temp);
      end
    else
      DeleteFile(Target);
  Bitmap2.SaveToFile(Target);
  AssignFile(F, Target);
  Reset(F, 1);
  Seek(F, FileSize(F));
  BlockWrite(F, Buffer, Length(Source) + 1);
  CloseFile(F);
  StrPCopy(Buffer, Target);
  SystemParametersInfo(SPI_SETDESKWALLPAPER, 0, @Buffer, SPIF_UPDATEINIFILE);
end;

function AddBackSlash(Path: String): String;
begin
  if (Path[Length(Path)] = '\') or (Path[Length(Path)] = ':') then
    Result := Path
  else
    Result := Path + '\';
end;

function GetBootDir: String;
var
  Registry: TRegistry;
  function CheckRoot(Path: String): Boolean;
  begin
    Result := FileExists(AddBackSlash(Path) + 'msdos.sys');
  end;
begin
  Registry := TRegistry.Create;
  try
    with Registry do begin
      RootKey := HKEY_LOCAL_MACHINE;
      if OpenKey('SOFTWARE\Microsoft\Windows\CurrentVersion\Setup',
        False) then begin
        Result := ReadString('BootDir');
        if CheckRoot(Result) then
          Exit;
        Result := ReadString('BootHost');
        if CheckRoot(Result) then
          Exit;
        end;
      end;
      Result := IniFile.ReadString(General, 'BootDir', 'c:\');
      if CheckRoot(Result) then
        Exit;
      Result := '\';
  finally
    Registry.Destroy;
    Result := AddBackSlash(Result);
  end;
end;

function FillDirList(Section: String): Boolean;
const
  Ext: array [0..7] of String = ('.BMP', '.DIB', '.RLE', '.PCX', '.GIF',
    '.JPG', '.JPE', '.JPEG');
var
  F: TSearchRec;
  DirList: TStringlist;
  i, j: Integer;
  Path: String;
  function GetValue(S: String): String;
  begin
    Result := Trim(Copy(S, Pos('=', S) + 1, 255));
  end;
begin
  DirList := TStringList.Create;
  DirList.Duplicates := dupIgnore;
  IniFile.ReadSectionValues(Section, DirList);
  Result := False;
  if DirList.Count = 0 then
    Exit;
  for i := DirList.Count - 1 downto 0 do begin
    Path := AddBackSlash(GetValue(DirList.Strings[i]));
    if FindFirst(Path + '*.*', faReadOnly + faHidden + faSysFile + faArchive,
      F) = 0 then
      repeat
        for j := Low(Ext) to High(Ext) do
          if UpperCase(ExtractFileExt(F.Name)) = Ext[j] then begin
            FileList.Add(Path + F.Name);
            Break;
            end;
        until FindNext(F) <> 0;
    FindClose(F);
    end;
  DirList.Free;
  if FileList.Count = 0 then
    Exit;
  Result := True;
end;

function GetColor(IniName: String; DefColor: TColor): TColor;
var
  ColorIndex: Integer;
begin
  ColorIndex := IniFile.ReadInteger(General, IniName, -1);
  if (ColorIndex < Low(Colors)) or (ColorIndex > High(Colors)) then
    Result := DefColor
  else
    Result := Colors[ColorIndex];
end;

procedure MakeWaitLogo;
begin
  with FileList do
    ConvertFile(Strings[Random(Count)], WindowsDir + 'logow.sys',
      IniFile.ReadString(General, 'WaitText', 'Please, wait...'),
      IniFile.ReadString(General, 'WaitFont', 'Arial'),
      GetColor('WaitColor', clYellow),
      IniFile.ReadInteger(General, 'WaitSize', 24));
end;

procedure MakeWallpaper;
begin
  with FileList do
    ConvertWallpaper(Strings[Random(Count)]);
end;

procedure MakeShutdownLogo;
begin
  with FileList do
    ConvertFile(Strings[Random(Count)], WindowsDir + 'logos.sys',
      IniFile.ReadString(General, 'ShutdownText', 'Turn your computer off'),
      IniFile.ReadString(General, 'ShutdownFont', 'Arial'),
      GetColor('ShutdownColor', clLime),
      IniFile.ReadInteger(General, 'ShutdownSize', 24));
end;

begin
  Randomize;
  IniFile := TIniFile.Create(ChangeFileExt(ParamStr(0), '.ini'));
  MakeBackup := IniFile.ReadBool(General, 'MakeBackup', True);
  Startup := IniFile.ReadString(General, 'StartupList', '');
  Wait := IniFile.ReadString(General, 'WaitList', '');
  Shutdown := IniFile.ReadString(General, 'ShutdownList', '');
  Wallpaper := IniFile.ReadString(General, 'WallpaperList', '');
  GetWindowsDirectory(@Buffer, MAX_PATH);
  WindowsDir := AddBackSlash(StrPas(@Buffer));
  FileList := TStringList.Create;
  FileList.Duplicates := dupIgnore;
  with FileList do begin
    if (Startup <> '') then begin
      if FillDirList(Startup) then begin
        ConvertFile(Strings[Random(Count)], GetBootDir + 'logo.sys',
          IniFile.ReadString(General, 'StartupText', 'Windows''95'),
          IniFile.ReadString(General, 'StartupFont', 'Arial'),
          GetColor('StartupColor', clAqua),
          IniFile.ReadInteger(General, 'StartupSize', 24));
        if Wait = Startup then
          MakeWaitLogo;
        if Shutdown = Startup then
          MakeShutdownLogo;
        if Wallpaper = Startup then
          MakeWallpaper;
        Clear;
        end;
      if Wait = Startup then
        Wait := '';
      if Shutdown = Startup then
        Shutdown := '';
      if Wallpaper = Startup then
        Wallpaper := '';
      end;
    if Wait <> '' then begin
      if FillDirList(Wait) then begin
        MakeWaitLogo;
        if Shutdown = Wait then
          MakeShutdownLogo;
        if Wallpaper = Wait then
          MakeWallpaper;
        Clear;
        end;
      if Shutdown = Wait then
        Shutdown := '';
      if Wallpaper = Wait then
        Wallpaper := '';
      end;
    if Shutdown <> '' then begin
      if FillDirList(Shutdown) then begin
        MakeShutdownLogo;
        if Wallpaper = Shutdown then
          MakeWallpaper;
        Clear;
        end;
      if Wallpaper = Shutdown then
        Wallpaper := '';
      end;
    if Wallpaper <> '' then begin
      if FillDirList(Wallpaper) then begin
        MakeWallpaper;
        Clear;
        end;
      end;
    Free;
    end;
end.

