unit vBmp;

interface
Uses Windows,Classes, Graphics,  SysUtils, vDither;

const
   DoQuantize:Boolean=False;
   NumColors:Integer=256;

function  ConvertBMP256(aFile:string;Stream:TStream;aQuantize:Boolean;aNumColors:Integer):Boolean;

function  LoadBmp(aFile:String;aQuantize:Boolean;aNumColors:Integer):TBitMap;

function  AutoLoadBmp(aFile:String):TBitMap;

procedure writeBMP(hMem:THandle;aInfo:PBitMapInfo;Stream:TStream);

procedure InitQuantize;

implementation

procedure writeBMP(hMem:THandle;aInfo:PBitMapInfo;Stream:TStream);
var
  aSize:Integer;
  BMF:TBitmapFileHeader;
  buf:pointer;
begin
  aSize:=SizeOf(aInfo^.bmiHeader);
  if aInfo^.bmiHeader.biBitCount<=8 then
  begin
    aSize:=aSize+256*Sizeof(TRGBQuad);
  end;

  Buf:=GlobalLock(hMem);
  FillChar(BMF, sizeof(BMF), 0);
  BMF.bfType := $4D42;
  BMF.bfSize := aInfo^.bmiHeader.biSizeImage;
  BMF.bfOffBits := aSize;
  if Stream=nil then Stream:=TMemoryStream.create;
  Stream.writebuffer(BMF,Sizeof(BMF));
  Stream.writeBuffer(aInfo^,aSize);
  stream.writeBuffer(Buf^,aInfo^.bmiHeader.biSizeImage);

  GlobalUnlock(hMem);
end;


function ConvertBmp256(aFile:string;Stream:TStream;aQuantize:Boolean;aNumColors:Integer):Boolean;
var
  BMF:TBitmapFileHeader;
  TF:TFileStream;
  aInfo,aInfo1:PBitMapInfo;
  SizeHeader,SizeImage:Integer;
  hMem,hMem1:THandle;
  Buf,Buf1:PChar;
begin
  (*  bmp *)
  result:=True;
  try
    TF:=TFileStream.Create(aFile,fmOpenRead);
    try
      TF.ReadBuffer(BMF,Sizeof(BMF));
      TF.ReadBuffer(SizeHeader,sizeof(SizeHeader));
      TF.Seek(-4,soFromCurrent);
      New(aInfo);
      TF.ReadBuffer(aINFO^,Sizeof(aInfo^));

      SizeImage:=BMF.bfSize;
      aInfo^.bmiheader.biSizeImage:=SizeImage;

      HMem:=GlobalAlloc(GMEM_FIXED,SizeImage);
      Buf:=GlobalLock(HMem);
      TF.Seek(BMF.bfOffBits,soFromBeginning);
      TF.ReadBuffer(BUf^,SizeImage-TF.Position);
      GlobalUnLock(HMem);
    finally
      TF.Free;
    end;
    except
      on EFOpenError do
        result:=False;
  end;
  (*   *)
//  Quantize:=aInfo^.bmiHeader.biBitCount>8;
  if aQuantize and (aInfo^.bmiHeader.biBitCount<=8) then
  begin
    TF:=TFileStream.Create(aFile,fmOpenRead);
    Stream.CopyFrom(TF,TF.Size);
    TF.Free;
  end
  else
  if aQuantize then
  begin
    SizeHeader:=Sizeof(TBitmapInfo);
    SizeHeader:=SizeHeader+sizeof(TRGBQuad)*256;
    GetMem(aInfo1,SizeHeader);
    aInfo1^:=aInfo^;

    aInfo1.bmiHeader.biSizeImage:=aInfo1.bmiHeader.biWidth*aInfo1.bmiHeader.biHeight;

    hMem1:=GlobalAlloc(GPTR,aInfo1.bmiHeader.biSizeImage);
    buf1:=GlobalLock(hMem1);
    buf:=GlobalLock(hMem);

    Fillchar(buf1^,aInfo1.bmiHeader.biSizeImage,#0);

    dither (aInfo1,Buf,buf1,aNumColors);

    GlobalUnlock(hMem1);
    GlobalUnlock(hMem);

    aInfo1^.bmiheader.biBitcount:=8;
    writeBMP(hMem1,aInfo1,Stream);
    GlobalFree(hMem1);
  end
  else
    writeBMP(hMem,aInfo,Stream);


  GlobalFree(hMem);
  Dispose(aInfo);
end;


function  LoadBmp(aFile:String;aQuantize:Boolean;aNumColors:Integer):TBitMap;
var
  S:TMemoryStream;
begin
  S:=TMemoryStream.create;
  if ConvertBmp256(aFile,S,aQuantize,aNumColors) then
  begin
    S.Position:=0;
    result:=TBitMap.create;
    result.loadfromstream(S);
  end
  else
    result:=nil;
  S.Free;
end;

procedure InitQuantize;
var
  BitCount:Integer;
begin
  BitCount:=GetDeviceCaps(GetDC(0),BITSPIXEL);
  DoQuantize:=BitCount<=8;
  if DoQuantize then
    case bitCount of
      8: NumColors:=256;
      1: begin
           NumColors:=16;
           GetSystemPaletteEntries(GetDC(0),0,15,SystemPalette);
           UseSystemPalette:=True;
         end;
    end;
end;

function  AutoLoadBmp(aFile:String):TBitMap;
begin
  result:=LoadBmp(aFile,DoQuantize,NumColors);
end;

end.
 