/*
 * Decompiled with CFR 0.152.
 */
package com.sparework.kronos.components.memo;

import com.sparework.kronos.KronosUI;
import com.sparework.kronos.Language;
import com.sparework.kronos.components.ComponentUtility;
import com.sparework.kronos.components.html.HTMLObject;
import com.sparework.kronos.components.memo.MemoXMLUtility;
import com.sparework.kronos.components.sticky.StickyMenu;
import com.sparework.kronos.inputs.Input;
import com.sparework.kronos.inputs.InputUtility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

class MemoUtility {
    private static JPanel memoPane;
    private static JButton addButton;
    private static JButton deleteButton;
    private static JButton changeButton;
    private static JButton recoverButton;
    private static ArrayList deletedMemoList;
    private static String[] inputs;
    private static JComboBox inputCombo;

    MemoUtility() {
    }

    protected static JPanel getMemoPane() {
        if (memoPane == null) {
            memoPane = new JPanel();
            memoPane.setLayout(new BoxLayout(memoPane, 1));
            memoPane.setInheritsPopupMenu(true);
        }
        return memoPane;
    }

    protected static JToolBar getButtonPane() {
        inputs = InputUtility.getInstalledInputs();
        inputCombo = new JComboBox();
        for (int i = 0; i < inputs.length; ++i) {
            inputCombo.addItem(Language.get((String)inputs[i], (String)inputs[i]));
        }
        addButton = KronosUI.createButton((String)"images/add.png", (String)"Add", (String)Language.get((String)"kronos", (String)"add"), (ActionListener)new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MemoUtility.newMemo(inputs[inputCombo.getSelectedIndex()]);
            }
        });
        deleteButton = KronosUI.createButton((String)"images/delete.png", (String)"Delete", (String)Language.get((String)"kronos", (String)"delete"), (ActionListener)new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MemoUtility.deleteMemo();
                if (deletedMemoList != null) {
                    recoverButton.setEnabled(true);
                }
            }
        });
        changeButton = KronosUI.createButton((String)"images/save.png", (String)"Save", (String)Language.get((String)"memo", (String)"saveall"), (ActionListener)new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MemoUtility.saveAllMemo();
            }
        });
        recoverButton = KronosUI.createButton((String)"images/recover.png", (String)"Recover", (String)Language.get((String)"kronos", (String)"recover"), (ActionListener)new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MemoUtility.recoverMemo();
                recoverButton.setEnabled(false);
            }
        });
        recoverButton.setEnabled(false);
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        jToolBar.add(inputCombo);
        jToolBar.add(addButton);
        jToolBar.addSeparator();
        jToolBar.add(deleteButton);
        jToolBar.add(changeButton);
        jToolBar.add(recoverButton);
        jToolBar.add(Box.createHorizontalGlue());
        return jToolBar;
    }

    private static void newMemo(String string) {
        Input input = new Input(string);
        MemoUtility.addMemo(input);
        input.addComponentListener((ComponentListener)new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                Input input = (Input)componentEvent.getSource();
                input.useInput(true);
            }
        });
        Element element = MemoXMLUtility.createXMLElement(input);
        MemoXMLUtility.addXMLElement(element);
    }

    private static void addMemo(Input input) {
        JComponent jComponent;
        JComponent jComponent2;
        if (ComponentUtility.hasComponent((String)"sticky")) {
            jComponent2 = new JPopupMenu();
            jComponent = StickyMenu.createStickyMenuItem();
            ((JPopupMenu)jComponent2).add((JMenuItem)jComponent);
            input.setComponentPopupMenu((JPopupMenu)jComponent2);
        } else {
            input.setComponentPopupMenu(null);
        }
        jComponent2 = new JCheckBox(Language.get((String)"kronos", (String)"delete") + "?");
        ((AbstractButton)jComponent2).setVerticalTextPosition(3);
        ((AbstractButton)jComponent2).setHorizontalTextPosition(0);
        jComponent = new JPanel(new BorderLayout());
        jComponent.add((Component)input, "Center");
        jComponent.add((Component)jComponent2, "East");
        memoPane.add(jComponent);
        memoPane.revalidate();
        memoPane.repaint();
    }

    private static void recoverMemo() {
        int n = deletedMemoList.size();
        for (int i = 0; i < n; ++i) {
            Input input = (Input)deletedMemoList.get(i);
            MemoUtility.addMemo(input);
            input.useInput(true);
            Element element = MemoXMLUtility.createXMLElement(input);
            MemoXMLUtility.addXMLElement(element);
        }
        deletedMemoList = null;
    }

    private static Input getInputFromMemo(JPanel jPanel) {
        return (Input)jPanel.getComponent(0);
    }

    private static boolean isDeleteFromMemo(JPanel jPanel) {
        return ((JCheckBox)jPanel.getComponent(1)).isSelected();
    }

    private static void deleteMemo() {
        int n = memoPane.getComponentCount();
        if (deletedMemoList != null) {
            deletedMemoList.clear();
        }
        for (int i = 0; i < n; ++i) {
            JPanel jPanel = (JPanel)memoPane.getComponent(i);
            if (!MemoUtility.isDeleteFromMemo(jPanel)) continue;
            MemoXMLUtility.deleteXMLElement(i);
            Input input = MemoUtility.getInputFromMemo(jPanel);
            input.useInput(false);
            if (deletedMemoList == null) {
                deletedMemoList = new ArrayList();
            }
            deletedMemoList.add(input);
            memoPane.remove(i);
            --i;
            --n;
        }
        memoPane.revalidate();
        memoPane.repaint();
    }

    protected static void saveAllMemo() {
        int n;
        if (memoPane == null) {
            return;
        }
        NodeList nodeList = MemoXMLUtility.getNodeList();
        int n2 = nodeList.getLength();
        int n3 = memoPane.getComponentCount();
        for (n = 0; n < n2; ++n) {
            MemoXMLUtility.deleteXMLElement(0);
        }
        for (n = 0; n < n3; ++n) {
            Input input = MemoUtility.getInputFromMemo((JPanel)memoPane.getComponent(n));
            input.useInput(true);
            Element element = MemoXMLUtility.createXMLElement(input);
            MemoXMLUtility.addXMLElement(element);
        }
    }

    protected static void openAllMemo() {
        try {
            NodeList nodeList = MemoXMLUtility.getNodeList();
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Element element = (Element)nodeList.item(i);
                String string = MemoXMLUtility.getInputName(element);
                String string2 = MemoXMLUtility.getInputValue(element);
                Input input = new Input(string, (Object)string2);
                MemoUtility.addMemo(input);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected static void exportHTML() {
        if (ComponentUtility.hasComponent((String)"html")) {
            HTMLObject hTMLObject = new HTMLObject();
            hTMLObject.setTitle(Language.get((String)"memo", (String)"memo"));
            hTMLObject.addHeadings((Object[])new String[]{Language.get((String)"memo", (String)"memo")});
            NodeList nodeList = MemoXMLUtility.getNodeList();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element = (Element)nodeList.item(i);
                Input input = new Input(MemoXMLUtility.getInputName(element), (Object)MemoXMLUtility.getInputValue(element));
                hTMLObject.addData(new Object[]{hTMLObject.createDataElement(input.getXMLValue(), input.getMimeType())});
            }
            hTMLObject.promptToSave("memo.htm");
        }
    }
}

