/*
 * Decompiled with CFR 0.152.
 */
package com.sparework.kronos.components.memo;

import com.sparework.kronos.Configuration;
import com.sparework.kronos.KronosUI;
import com.sparework.kronos.Language;
import com.sparework.kronos.components.ComponentUtility;
import com.sparework.kronos.components.html.HTMLMenu;
import com.sparework.kronos.components.memo.MemoTimer;
import com.sparework.kronos.components.memo.MemoUtility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;

public class MemoTab {
    private JTextField minuteText;
    private JPanel memoTab;

    public MemoTab() {
        ComponentUtility.addDocument((String)"memo.xml");
        if (ComponentUtility.hasComponent((String)"html")) {
            HTMLMenu.addToMenu((JMenuItem)this.getHTMLMenu());
        }
        JMenu jMenu = new JMenu(Language.get((String)"memo", (String)"memo"));
        jMenu.add(this.createTimerConfigMenuItem());
        KronosUI.addToConfigMenu(null);
        KronosUI.addToConfigMenu((JComponent)jMenu);
        JToggleButton jToggleButton = KronosUI.createNavButton((String)"memo", (String)"", (String)Language.get((String)"memo", (String)"memo"), (ActionListener)new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (MemoTab.this.memoTab == null) {
                    MemoTab.this.setupLayout();
                }
                KronosUI.setContentPane((JComponent)MemoTab.this.memoTab);
            }
        });
        KronosUI.addToNavPane((JToggleButton)jToggleButton);
    }

    private void setupLayout() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)MemoUtility.getButtonPane(), "North");
        jPanel.add((Component)MemoUtility.getMemoPane(), "Center");
        this.memoTab = new JPanel(new BorderLayout());
        this.memoTab.add((Component)jPanel, "North");
        MemoUtility.openAllMemo();
    }

    private JPanel createTimerConfigMenuItem() {
        int n = Integer.parseInt(Configuration.getConfig((String)"memo:autosave", (String)"5"));
        MemoTimer.startTimer(n);
        this.minuteText = new JTextField();
        this.minuteText.setColumns(5);
        this.minuteText.setText(String.valueOf(n));
        this.minuteText.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                if (MemoTab.this.minuteText.getText().matches("[1-9]+[0-9]*")) {
                    int n = Integer.parseInt(MemoTab.this.minuteText.getText());
                    Configuration.setConfig((String)"memo:autosave", (String)String.valueOf(n));
                    MemoTimer.cancelTimer();
                    if (n > 0) {
                        MemoTimer.startTimer(n);
                    }
                    KronosUI.setTaskBarText((String)Language.get((String)"kronos", (String)"configok"));
                } else {
                    MemoTab.this.minuteText.setText(Configuration.getConfig((String)"memo:autosave", (String)"5"));
                    KronosUI.setTaskBarText((String)(Language.get((String)"kronos", (String)"configerror") + " 1, 2, ..."));
                }
            }
        });
        JLabel jLabel = new JLabel("   " + Language.get((String)"memo", (String)"autosave"));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(jLabel);
        jPanel.add(this.minuteText);
        return jPanel;
    }

    private JMenuItem getHTMLMenu() {
        JMenuItem jMenuItem = new JMenuItem(Language.get((String)"memo", (String)"memo"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MemoUtility.exportHTML();
            }
        });
        return jMenuItem;
    }
}

