/*
 * Decompiled with CFR 0.152.
 */
package com.sparework.kronos.inputs;

import com.sparework.kronos.Configuration;
import com.sparework.kronos.ExtensionFilenameFilter;
import com.sparework.kronos.KronosUtility;
import java.io.File;
import java.util.ArrayList;
import java.util.jar.Attributes;
import java.util.jar.JarFile;

public class InputUtility {
    private static String[] installedInputs;

    public static String[] getInstalledInputs() {
        installedInputs = new File("inputs").list(new ExtensionFilenameFilter("Directory"));
        return installedInputs;
    }

    private static String[] getInputs() {
        int n;
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = Configuration.getConfig("kronos:inputorder", "text,write,voice").split(",");
        for (n = 0; n < stringArray.length; ++n) {
            if (arrayList.contains(stringArray[n])) continue;
            arrayList.add(stringArray[n]);
        }
        stringArray = InputUtility.getInstalledInputs();
        for (n = 0; n < stringArray.length; ++n) {
            if (arrayList.contains(stringArray[n])) continue;
            arrayList.add(stringArray[n]);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private static void loadInputJar(String string) throws Exception {
        if (new File(string).exists()) {
            Attributes attributes = new JarFile(string).getManifest().getMainAttributes();
            String string2 = attributes.getValue(Attributes.Name.CLASS_PATH);
            String[] stringArray = string2 == null ? new String[]{} : string2.split("[\\s]");
            for (int i = 0; i < stringArray.length; ++i) {
                if (KronosUtility.isInClassPath(stringArray[i])) continue;
                InputUtility.loadInputJar(stringArray[i]);
            }
            String string3 = attributes.getValue(Attributes.Name.MAIN_CLASS);
            if (!KronosUtility.isInClassPath(string)) {
                KronosUtility.addToClassPath(string);
                KronosUtility.loadJar(string.toString(), string3, null);
            }
        }
    }

    public static void setupInputs() {
        String[] stringArray = InputUtility.getInputs();
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                InputUtility.loadInputJar("inputs/" + stringArray[i] + "/input.jar");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static boolean hasInput(String string) {
        for (int i = 0; i < installedInputs.length; ++i) {
            if (!installedInputs[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    protected static String getInputMainClass(String string) {
        String string2 = "inputs/" + string + "/input.jar";
        if (new File(string2).exists()) {
            try {
                Attributes attributes = new JarFile(string2).getManifest().getMainAttributes();
                String string3 = attributes.getValue(Attributes.Name.MAIN_CLASS);
                return string3;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }
}

