/*
 * Decompiled with CFR 0.152.
 */
package com.sparework.kronos.inputs;

import com.sparework.kronos.KronosUtility;
import com.sparework.kronos.Language;
import com.sparework.kronos.inputs.InputInterface;
import com.sparework.kronos.inputs.InputUtility;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class Input
extends JPanel
implements InputInterface {
    private InputInterface currentInput;
    private JPopupMenu inputPopup;
    private String currentInputName;

    public Input(String string) {
        super(new GridLayout(1, 1));
        this.setupPopupMenu();
        this.setPreferredSize(new Dimension(175, 75));
        this.setInput(string, null);
    }

    public Input(String string, Object object) {
        super(new GridLayout(1, 1));
        this.setupPopupMenu();
        this.setPreferredSize(new Dimension(175, 75));
        this.setInput(string, object);
    }

    public void useInput(boolean bl) {
        this.currentInput.useInput(bl);
    }

    public Object getListValue() {
        return this.currentInput.getListValue();
    }

    public String getXMLValue() {
        return this.currentInput.getXMLValue();
    }

    public Object getRawData() {
        return this.currentInput.getRawData();
    }

    public String getMimeType() {
        return this.currentInput.getMimeType();
    }

    public boolean isEqual(String string, Object object) {
        return this.currentInput.isEqual(string, object);
    }

    public boolean isEmpty() {
        return this.currentInput.isEmpty();
    }

    public String getName() {
        return this.currentInputName;
    }

    private void setupPopupMenu() {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Input.this.removeAll();
                Input.this.setInput(actionEvent.getActionCommand(), null);
                Input.this.repaint();
                Input.this.revalidate();
            }
        };
        this.inputPopup = new JPopupMenu();
        String[] stringArray = InputUtility.getInstalledInputs();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = Language.get(stringArray[i], stringArray[i]);
            if (string == null) {
                string = stringArray[i];
            }
            JMenuItem jMenuItem = new JMenuItem(string);
            jMenuItem.setActionCommand(stringArray[i]);
            jMenuItem.addActionListener(actionListener);
            this.inputPopup.add(jMenuItem);
        }
        this.setComponentPopupMenu(this.inputPopup);
    }

    public void setInput(String string, Object object) {
        try {
            this.currentInputName = string;
            String string2 = InputUtility.getInputMainClass(string);
            String string3 = "inputs/" + string + "/input.jar";
            Object object2 = KronosUtility.loadJar(string3, string2, object);
            this.currentInput = (InputInterface)object2;
            this.add((JComponent)object2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

