/*
 * Decompiled with CFR 0.152.
 */
package com.sparework.kronos.components;

import com.sparework.kronos.Configuration;
import com.sparework.kronos.ExtensionFilenameFilter;
import com.sparework.kronos.KronosUI;
import com.sparework.kronos.KronosUtility;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ComponentUtility {
    private static HashMap documentMap;
    private static String dataDir;

    public static String getDataDirectory(boolean bl) {
        return bl ? new File(dataDir).getAbsolutePath() : dataDir;
    }

    public static String[] getInstalledComponents() {
        String[] stringArray = new File("components").list(new ExtensionFilenameFilter("Directory"));
        return stringArray;
    }

    private static String[] getComponents() {
        int n;
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = Configuration.getConfig("kronos:componentorder", "reminder,todo,todo2,memo,admin").split(",");
        for (n = 0; n < stringArray.length; ++n) {
            if (arrayList.contains(stringArray[n])) continue;
            arrayList.add(stringArray[n]);
        }
        stringArray = ComponentUtility.getInstalledComponents();
        for (n = 0; n < stringArray.length; ++n) {
            if (arrayList.contains(stringArray[n])) continue;
            arrayList.add(stringArray[n]);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private static void loadComponentJar(String string) throws Exception {
        if (new File(string).exists()) {
            Attributes attributes = new JarFile(string).getManifest().getMainAttributes();
            String string2 = attributes.getValue(Attributes.Name.CLASS_PATH);
            String[] stringArray = string2 == null ? new String[]{} : string2.split("[\\s]");
            for (int i = 0; i < stringArray.length; ++i) {
                if (KronosUtility.isInClassPath(stringArray[i])) continue;
                ComponentUtility.loadComponentJar(stringArray[i]);
            }
            String string3 = attributes.getValue(Attributes.Name.MAIN_CLASS);
            if (!KronosUtility.isInClassPath(string)) {
                KronosUtility.addToClassPath(string);
                KronosUtility.loadJar(string.toString(), string3, null);
            }
            KronosUI.revalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int setupComponents() {
        String[] stringArray = ComponentUtility.getComponents();
        try {
            documentMap = new HashMap(stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                ComponentUtility.loadComponentJar("components/" + stringArray[i] + "/component.jar");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            return stringArray.length;
        }
    }

    public static boolean hasComponent(String string) {
        return KronosUtility.isInClassPath("components/" + string + "/component.jar");
    }

    public static Document newDocument(String string) {
        documentMap.put(string, KronosUtility.getFromFile(""));
        return ComponentUtility.getDocument(string);
    }

    public static void addDocument(String string) {
        documentMap.put(string, KronosUtility.getFromFile(dataDir + "/" + string));
    }

    public static Document getDocument(String string) {
        return (Document)documentMap.get(string);
    }

    public static Element createElement(String string) {
        return ComponentUtility.getDocument(string).createElement("data");
    }

    public static String[] getComponentDataFiles() {
        return documentMap.keySet().toArray(new String[0]);
    }

    public static NodeList getNodeList(String string) {
        return ComponentUtility.getDocument(string).getElementsByTagName("data");
    }

    public static void saveDocument(String string) {
        KronosUtility.saveToFile(ComponentUtility.getDocument(string), dataDir + "/" + string);
    }

    public static void validateData(String string, String[] stringArray, String[] stringArray2) {
        NodeList nodeList = ComponentUtility.getNodeList(string);
        boolean bl = false;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element = (Element)nodeList.item(i);
            for (int j = 0; j < stringArray.length; ++j) {
                if (!element.getAttribute(stringArray[j]).equals("")) continue;
                element.setAttribute(stringArray[j], stringArray2[j]);
                bl = true;
            }
        }
        if (bl) {
            ComponentUtility.saveDocument(string);
        }
    }

    static {
        dataDir = "data";
    }
}

