/*
 * Decompiled with CFR 0.152.
 */
package com.sparework.kronos;

import com.sparework.kronos.Language;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class KronosUtility {
    private static DocumentBuilder xmlDocBuild;
    private static Transformer xmlTrans;
    private static String currentPath;

    public static String getCurrentPath() {
        return new File(".").getAbsoluteFile().getParent();
    }

    protected static void setupUtility() {
        try {
            xmlTrans = TransformerFactory.newInstance().newTransformer();
            xmlTrans.setOutputProperty("omit-xml-declaration", "yes");
            xmlDocBuild = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            xmlDocBuild.setEntityResolver(new EntityResolver(){

                public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
                    if (string2.equals("http://java.sun.com/dtd/properties.dtd")) {
                        return new InputSource(new ByteArrayInputStream("<?xml version=\"1.0\" encoding=\"UTF-8\"?>".getBytes()));
                    }
                    return null;
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
            JOptionPane.showMessageDialog(null, Language.get("kronos", "startuperror") + "\n" + Language.get("kronos", "errorreport"), Language.get("kronos", "error"), 0);
            System.exit(0);
        }
        currentPath = new File(".").getAbsoluteFile().getParent();
    }

    public static void saveToFile(Document document, String string) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            xmlTrans.transform(new DOMSource(document), new StreamResult(fileOutputStream));
            fileOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            JOptionPane.showMessageDialog(null, Language.get("kronos", "writeerror") + " " + string + ".", Language.get("kronos", "error"), 0);
        }
    }

    public static Document getFromFile(Object object) {
        Document document = null;
        try {
            document = object instanceof String ? xmlDocBuild.parse((String)object) : xmlDocBuild.parse((InputStream)object);
        }
        catch (Exception exception) {
            if (object instanceof String) {
                document = KronosUtility.createNewDocument("root");
            }
            exception.printStackTrace();
            JOptionPane.showMessageDialog(null, Language.get("kronos", "readerror") + " " + object + ".", Language.get("kronos", "error"), 0);
            System.exit(0);
        }
        return document;
    }

    public static Document createNewDocument(String string) {
        Document document = xmlDocBuild.newDocument();
        Element element = document.createElement(string);
        element.appendChild(document.createTextNode("\n"));
        document.appendChild(element);
        return document;
    }

    public static void addToClassPath(String string) {
        try {
            if (!KronosUtility.isInClassPath(string)) {
                URL uRL = new URL("file:///" + currentPath + "/" + string);
                Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
                method.setAccessible(true);
                method.invoke((Object)((URLClassLoader)ClassLoader.getSystemClassLoader()), uRL);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static boolean isInClassPath(String string) {
        try {
            URL uRL = new URL("file:///" + currentPath + "/" + string);
            Method method = URLClassLoader.class.getDeclaredMethod("getURLs", new Class[0]);
            method.setAccessible(true);
            URL[] uRLArray = (URL[])method.invoke((Object)((URLClassLoader)ClassLoader.getSystemClassLoader()), new Object[0]);
            for (int i = 0; i < uRLArray.length; ++i) {
                if (!uRL.sameFile(uRLArray[i])) continue;
                return true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }

    public static Object loadJar(String string, String string2, Object object) {
        Object var3_3 = null;
        try {
            Class<?> clazz = Class.forName(string2);
            var3_3 = object == null ? clazz.newInstance() : clazz.getConstructor(object.getClass()).newInstance(object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return var3_3;
    }
}

