/*
 * Decompiled with CFR 0.152.
 */
package com.sparework.kronos;

import com.sparework.kronos.Configuration;
import com.sparework.kronos.Language;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import org.jdesktop.jdic.tray.SystemTray;
import org.jdesktop.jdic.tray.TrayIcon;

public class KronosUI {
    private static JPanel navPane;
    private static JMenu fileMenu;
    private static JMenu configMenu;
    private static JMenu helpMenu;
    private static JScrollPane contentScrollPane;
    private static JScrollPane navScrollPane;
    private static ButtonGroup navGroup;
    private static JFrame progFrame;
    private static ImageIcon progIcon;
    private static JPopupMenu trayPopup;
    private static TrayIcon progTrayIcon;
    private static SystemTray tray;
    private static JLabel statusBarLabel;
    private static JSplitPane progSplitPane;

    public static JFrame getProgFrame() {
        if (progFrame == null) {
            KronosUI.setupProgFrame();
        }
        return progFrame;
    }

    private static void setupProgFrame() {
        progFrame = new JFrame("Kronos");
        progFrame.setIconImage(KronosUI.getProgIcon().getImage());
        progFrame.setJMenuBar(KronosUI.getMenuBar());
        progSplitPane = new JSplitPane(1, KronosUI.getNavPane(), KronosUI.getContentPane());
        progSplitPane.setDividerLocation(Integer.parseInt(Configuration.getConfig("kronos:splitx", "100")));
        ((BasicSplitPaneUI)progSplitPane.getUI()).getDivider().addComponentListener(new ComponentAdapter(){

            public void componentMoved(ComponentEvent componentEvent) {
                if (progSplitPane.getDividerLocation() != progSplitPane.getLastDividerLocation()) {
                    Configuration.setConfig("kronos:splitx", String.valueOf(progSplitPane.getDividerLocation()));
                }
            }
        });
        progFrame.setLayout(new BorderLayout());
        progFrame.add((Component)progSplitPane, "Center");
        progFrame.add((Component)KronosUI.getTaskBar(), "South");
        progFrame.setDefaultCloseOperation(3);
        int n = Integer.parseInt(Configuration.getConfig("kronos:xcoord", "0"));
        int n2 = Integer.parseInt(Configuration.getConfig("kronos:ycoord", "0"));
        progFrame.setLocation(n, n2);
        int n3 = Integer.parseInt(Configuration.getConfig("kronos:height", "600"));
        int n4 = Integer.parseInt(Configuration.getConfig("kronos:width", "800"));
        progFrame.setPreferredSize(new Dimension(n4, n3));
        progFrame.pack();
        int n5 = 0;
        if (KronosUI.hasTray() && Configuration.getConfig("kronos:startup", "false").equals("true")) {
            ++n5;
        }
        if (Configuration.getConfig("kronos:extendedstate", "normal").equals("maximize")) {
            n5 += 6;
        }
        progFrame.setExtendedState(n5);
        progFrame.addWindowStateListener(new WindowAdapter(){

            public void windowStateChanged(WindowEvent windowEvent) {
                if (KronosUI.hasTray() && (windowEvent.getNewState() & 1) == 1) {
                    progFrame.setVisible(false);
                }
            }
        });
        progFrame.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                if (progFrame.getExtendedState() == 6) {
                    Configuration.setConfig("kronos:extendedstate", "maximize");
                } else if (progFrame.getExtendedState() == 0) {
                    Configuration.setConfig("kronos:extendedstate", "normal");
                    Configuration.setConfig("kronos:height", String.valueOf(progFrame.getHeight()));
                    Configuration.setConfig("kronos:width", String.valueOf(progFrame.getWidth()));
                }
            }

            public void componentMoved(ComponentEvent componentEvent) {
                if (progFrame.getExtendedState() == 0) {
                    int n = progFrame.getLocationOnScreen().x;
                    int n2 = progFrame.getLocationOnScreen().y;
                    if (n > -1 && n2 > -1) {
                        Configuration.setConfig("kronos:xcoord", String.valueOf(n));
                        Configuration.setConfig("kronos:ycoord", String.valueOf(n2));
                    }
                }
            }
        });
    }

    public static ImageIcon getProgIcon() {
        if (progIcon == null) {
            progIcon = new ImageIcon("images/kronos.png");
        }
        return progIcon;
    }

    public static void addToNavPane(JToggleButton jToggleButton) {
        navGroup.add(jToggleButton);
        if (navGroup.getButtonCount() == 1) {
            jToggleButton.doClick();
        }
        navPane.setLayout(new GridLayout(navPane.getComponentCount() + 1, 1));
        navPane.add(jToggleButton);
        navPane.revalidate();
        navPane.repaint();
    }

    public static void revalidate() {
        progFrame.validate();
        progFrame.repaint();
    }

    private static JScrollPane getNavPane() {
        navGroup = new ButtonGroup();
        navPane = new JPanel();
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)navPane, "North");
        jPanel.add(Box.createVerticalGlue(), "Center");
        navScrollPane = new JScrollPane(jPanel);
        return navScrollPane;
    }

    public static JToggleButton createNavButton(String string, String string2, String string3, ActionListener actionListener) {
        JToggleButton jToggleButton = new JToggleButton(string3, new ImageIcon("components/" + string + "/nav.png"));
        jToggleButton.setVerticalTextPosition(3);
        jToggleButton.setHorizontalTextPosition(0);
        jToggleButton.setActionCommand(string);
        jToggleButton.addActionListener(actionListener);
        jToggleButton.setName(String.valueOf(navGroup.getButtonCount()));
        DropTarget dropTarget = new DropTarget(){

            public void drop(DropTargetDropEvent dropTargetDropEvent) {
                try {
                    int n;
                    dropTargetDropEvent.acceptDrop(2);
                    String string = dropTargetDropEvent.getTransferable().getTransferData(DataFlavor.stringFlavor).toString();
                    int n2 = Integer.parseInt(string);
                    JToggleButton jToggleButton = (JToggleButton)navPane.getComponent(n2);
                    navPane.remove(n2);
                    if (navPane.getComponentAt(dropTargetDropEvent.getLocation()) instanceof JPanel) {
                        return;
                    }
                    JToggleButton jToggleButton2 = (JToggleButton)navPane.getComponentAt(dropTargetDropEvent.getLocation());
                    StringBuilder stringBuilder = new StringBuilder();
                    String[] stringArray = Configuration.getConfig("kronos:componentorder", "reminder,todo,todo2,memo,admin").split(",");
                    ArrayList<String> arrayList = new ArrayList<String>();
                    for (n = 0; n < stringArray.length; ++n) {
                        arrayList.add(stringArray[n]);
                    }
                    for (n = 0; n < navPane.getComponentCount(); ++n) {
                        if (navPane.getComponent(n).equals(jToggleButton2)) {
                            int n3 = n2 <= n ? n + 1 : n;
                            navPane.add((Component)jToggleButton, n3);
                            jToggleButton2 = null;
                        }
                        JToggleButton jToggleButton3 = (JToggleButton)navPane.getComponent(n);
                        jToggleButton3.setName(String.valueOf(n));
                        arrayList.remove(jToggleButton3.getActionCommand());
                        stringBuilder.append(jToggleButton3.getActionCommand()).append(",");
                    }
                    for (n = 0; n < arrayList.size(); ++n) {
                        stringBuilder.append(arrayList.get(n).toString()).append(",");
                    }
                    dropTargetDropEvent.dropComplete(true);
                    navPane.revalidate();
                    navPane.repaint();
                    Configuration.setConfig("kronos:componentorder", stringBuilder.toString());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        };
        dropTarget.setComponent(navPane);
        navPane.setDropTarget(dropTarget);
        DragSource dragSource = new DragSource();
        dragSource.createDefaultDragGestureRecognizer(jToggleButton, 2, new DragGestureListener(){

            public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
                dragGestureEvent.startDrag(DragSource.DefaultMoveDrop, new StringSelection(((JComponent)dragGestureEvent.getComponent()).getName()));
            }
        });
        return jToggleButton;
    }

    public static void setContentPane(JComponent jComponent) {
        contentScrollPane.setViewportView(jComponent);
    }

    private static JScrollPane getContentPane() {
        contentScrollPane = new JScrollPane();
        return contentScrollPane;
    }

    private static JMenuBar getMenuBar() {
        fileMenu = new JMenu(Language.get("kronos", "filemenu"));
        configMenu = new JMenu(Language.get("kronos", "configmenu"));
        helpMenu = new JMenu(Language.get("kronos", "helpmenu"));
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(fileMenu);
        jMenuBar.add(configMenu);
        jMenuBar.add(helpMenu);
        return jMenuBar;
    }

    public static void addToFileMenu(JComponent jComponent) {
        if (jComponent == null) {
            fileMenu.addSeparator();
        } else {
            fileMenu.add(jComponent);
        }
    }

    public static void addToConfigMenu(JComponent jComponent) {
        if (jComponent == null) {
            configMenu.addSeparator();
        } else {
            configMenu.add(jComponent);
        }
    }

    public static void addToHelpMenu(JComponent jComponent) {
        if (jComponent == null) {
            helpMenu.addSeparator();
        } else {
            helpMenu.add(jComponent);
        }
    }

    public static boolean hasTray() {
        return progTrayIcon.getLocationOnScreen() != null;
    }

    protected static void setupSystemTray(ActionListener actionListener) {
        tray = SystemTray.getDefaultSystemTray();
        trayPopup = new JPopupMenu();
        progTrayIcon = new TrayIcon(KronosUI.getProgIcon(), "Kronos", trayPopup);
        progTrayIcon.addActionListener(actionListener);
        tray.addTrayIcon(progTrayIcon);
    }

    public static Point getSystemTrayLocation() {
        return progTrayIcon.getLocationOnScreen();
    }

    protected static void takedownSystemTray() {
        tray.removeTrayIcon(progTrayIcon);
    }

    public static void addToSystemTrayPopup(JComponent jComponent) {
        trayPopup.add(jComponent);
    }

    public static JButton createButton(String string, String string2, String string3, ActionListener actionListener) {
        JButton jButton = new JButton(new ImageIcon(string));
        jButton.setToolTipText(string3);
        jButton.setActionCommand(string2);
        jButton.addActionListener(actionListener);
        return jButton;
    }

    protected static JLabel getTaskBar() {
        statusBarLabel = new JLabel();
        statusBarLabel.setPreferredSize(new Dimension(1, 25));
        statusBarLabel.setBorder(BorderFactory.createLoweredBevelBorder());
        return statusBarLabel;
    }

    public static void setTaskBarText(String string) {
        statusBarLabel.setText(" " + string);
    }

    public static JPanel createLabelComponent(String string, JComponent jComponent, String string2) {
        JLabel jLabel = new JLabel(" " + string + ": ");
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), string + ":", 1, 3));
        jPanel.add((Component)jComponent, "Center");
        return jPanel;
    }
}

