/*
 * Decompiled with CFR 0.152.
 */
package com.sparework.kronos;

import com.jgoodies.looks.FontPolicies;
import com.jgoodies.looks.FontSets;
import com.jgoodies.looks.plastic.Plastic3DLookAndFeel;
import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.plastic.PlasticTheme;
import com.jgoodies.looks.plastic.theme.ExperienceBlue;
import com.sparework.kronos.AuthorPane;
import com.sparework.kronos.Configuration;
import com.sparework.kronos.ContactPane;
import com.sparework.kronos.KronosUI;
import com.sparework.kronos.KronosUtility;
import com.sparework.kronos.Language;
import com.sparework.kronos.components.ComponentUtility;
import com.sparework.kronos.inputs.InputUtility;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.PrintStream;
import java.util.List;
import java.util.Locale;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.UIManager;

public class Kronos
implements ActionListener {
    private static JFrame progFrame;

    public Kronos() {
        try {
            PlasticTheme plasticTheme;
            System.setErr(new PrintStream(new File("error.log")));
            Configuration.parse();
            String string = Configuration.getConfig("kronos:theme", "ExperienceBlue");
            try {
                plasticTheme = (PlasticTheme)Class.forName("com.jgoodies.looks.plastic.theme." + string).newInstance();
            }
            catch (Exception exception) {
                Configuration.setConfig("kronos:theme", "ExperienceBlue");
                plasticTheme = new ExperienceBlue();
            }
            PlasticLookAndFeel.setPlasticTheme(plasticTheme);
            PlasticLookAndFeel.setFontPolicy(FontPolicies.createFixedPolicy(FontSets.getLogicalFontSet()));
            UIManager.setLookAndFeel(new Plastic3DLookAndFeel());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        Locale.setDefault(new Locale(Language.get("kronos", "locale"), Language.get("kronos", "country")));
        KronosUtility.setupUtility();
        InputUtility.setupInputs();
        this.setupSystemTrayIcon();
        progFrame = KronosUI.getProgFrame();
        KronosUI.setTaskBarText(Language.get("kronos", "loading") + " ...");
        this.setupMenuBar();
        boolean bl = Configuration.getConfig("kronos:startup", "false").equals("true");
        progFrame.setVisible(!KronosUI.hasTray() || !bl);
        progFrame.toFront();
        progFrame.requestFocus();
        this.setupComponents();
        KronosUI.setTaskBarText("");
    }

    public static void main(String[] stringArray) {
        new Kronos();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(Language.get("kronos", "exit"))) {
            this.closeWindow();
        } else {
            Kronos.showWindow();
        }
    }

    public static void showWindow() {
        if ((progFrame.getExtendedState() & 1) == 1) {
            progFrame.setExtendedState(progFrame.getExtendedState() - 1);
        }
        progFrame.setVisible(true);
        progFrame.toFront();
        progFrame.requestFocus();
    }

    private void closeWindow() {
        KronosUI.takedownSystemTray();
        progFrame.dispose();
        System.exit(0);
    }

    private void setupMenuBar() {
        JMenuItem jMenuItem = new JMenuItem(Language.get("kronos", "exit"));
        jMenuItem.addActionListener(this);
        KronosUI.addToFileMenu(jMenuItem);
        this.setupConfigMenu();
        JMenuItem jMenuItem2 = new JMenuItem(Language.get("kronos", "aboutkronos"));
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JOptionPane.showMessageDialog(progFrame, new AuthorPane(), actionEvent.getActionCommand(), -1);
            }
        });
        KronosUI.addToHelpMenu(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem(Language.get("kronos", "contact"));
        jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                new ContactPane();
            }
        });
        KronosUI.addToHelpMenu(jMenuItem3);
    }

    private void setupComponents() {
        int n = ComponentUtility.setupComponents();
        if (n == 0) {
            KronosUI.setContentPane(new JLabel(Language.get("kronos", "notabs")));
        }
    }

    private void setupSystemTrayIcon() {
        KronosUI.setupSystemTray(this);
        JMenuItem jMenuItem = new JMenuItem(Language.get("kronos", "exit"));
        jMenuItem.addActionListener(this);
        KronosUI.addToSystemTrayPopup(jMenuItem);
    }

    private void setupConfigMenu() {
        String string = Configuration.getConfig("kronos:theme", "ExperienceBlue");
        ButtonGroup buttonGroup = new ButtonGroup();
        JMenu jMenu = new JMenu(Language.get("kronos", "colortheme"));
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Configuration.setConfig("kronos:theme", actionEvent.getActionCommand());
            }
        };
        List list = PlasticLookAndFeel.getInstalledThemes();
        for (int i = 0; i < list.size(); ++i) {
            String string2 = list.get(i).getClass().getName().substring(33);
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(((PlasticTheme)list.get(i)).getName());
            jRadioButtonMenuItem.setActionCommand(string2);
            jRadioButtonMenuItem.addActionListener(actionListener);
            if (string2.equals(string)) {
                jRadioButtonMenuItem.setSelected(true);
            }
            jMenu.add(jRadioButtonMenuItem);
            buttonGroup.add(jRadioButtonMenuItem);
        }
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(Language.get("kronos", "startup"));
        boolean bl = KronosUI.hasTray();
        jCheckBoxMenuItem.setSelected(bl && Configuration.getConfig("kronos:startup", "false").equals("true"));
        jCheckBoxMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = String.valueOf(((JMenuItem)actionEvent.getSource()).isSelected());
                Configuration.setConfig("kronos:startup", string);
            }
        });
        jCheckBoxMenuItem.setEnabled(bl);
        KronosUI.addToConfigMenu(jMenu);
        KronosUI.addToConfigMenu(jCheckBoxMenuItem);
        KronosUI.addToConfigMenu(Language.getMenu());
    }
}

