/*
 * Decompiled with CFR 0.152.
 */
package com.sparework.kronos.components.sticky;

import com.sparework.kronos.Language;
import com.sparework.kronos.components.ComponentUtility;
import com.sparework.kronos.components.html.HTMLObject;
import com.sparework.kronos.components.sticky.Sticky;
import com.sparework.kronos.components.sticky.StickyXMLUtility;
import com.sparework.kronos.inputs.Input;
import com.sparework.kronos.inputs.InputUtility;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

class StickyUtility {
    private static ArrayList stickyList = new ArrayList();

    StickyUtility() {
    }

    protected static void addToList(Sticky sticky) {
        stickyList.add(sticky);
    }

    protected static void removeFromList(Sticky sticky) {
        stickyList.remove(sticky);
    }

    protected static JMenu getMenu() {
        JMenuItem jMenuItem;
        JMenu jMenu = new JMenu(Language.get((String)"sticky", (String)"sticky"));
        JMenu jMenu2 = new JMenu(Language.get((String)"sticky", (String)"new"));
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Sticky sticky = new Sticky(actionEvent.getActionCommand());
                sticky.setLocationRelativeTo((JMenuItem)actionEvent.getSource());
                sticky.pack();
                sticky.setVisible(true);
                sticky.toFront();
                sticky.requestFocus();
            }
        };
        String[] stringArray = InputUtility.getInstalledInputs();
        for (int i = 0; i < stringArray.length; ++i) {
            jMenuItem = new JMenuItem(Language.get((String)stringArray[i], (String)stringArray[i]));
            jMenuItem.setActionCommand(stringArray[i]);
            jMenuItem.addActionListener(actionListener);
            jMenu2.add(jMenuItem);
        }
        jMenu.add(jMenu2);
        JMenuItem jMenuItem2 = new JMenuItem(Language.get((String)"sticky", (String)"saveall"));
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StickyUtility.saveAll();
            }
        });
        jMenu.add(jMenuItem2);
        jMenuItem = new JMenuItem(Language.get((String)"sticky", (String)"showall"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StickyUtility.setVisibleAll(true);
            }
        });
        jMenu.add(jMenuItem);
        JMenuItem jMenuItem3 = new JMenuItem(Language.get((String)"sticky", (String)"hideall"));
        jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StickyUtility.setVisibleAll(false);
            }
        });
        jMenu.add(jMenuItem3);
        return jMenu;
    }

    protected static void saveAll() {
        StickyXMLUtility.eraseAllXMLData();
        int n = stickyList.size();
        for (int i = 0; i < n; ++i) {
            Sticky sticky = (Sticky)stickyList.get(i);
            if (!sticky.isDisplayable()) continue;
            sticky.save();
            Element element = StickyXMLUtility.createXMLElement(sticky.x, sticky.y, sticky.width, sticky.height, sticky.currentInput);
            StickyXMLUtility.addXMLElement(element);
        }
    }

    private static void setVisibleAll(boolean bl) {
        int n = stickyList.size();
        for (int i = 0; i < n; ++i) {
            Sticky sticky = (Sticky)stickyList.get(i);
            if (!sticky.isDisplayable()) continue;
            sticky.setVisible(bl);
            if (!bl) continue;
            sticky.toFront();
        }
    }

    protected static void openAll() {
        try {
            NodeList nodeList = StickyXMLUtility.getNodeList();
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Element element = (Element)nodeList.item(i);
                int n2 = StickyXMLUtility.getXCoord(element);
                int n3 = StickyXMLUtility.getYCoord(element);
                int n4 = StickyXMLUtility.getWidth(element);
                int n5 = StickyXMLUtility.getHeight(element);
                String string = StickyXMLUtility.getInputName(element);
                String string2 = StickyXMLUtility.getInputValue(element);
                Sticky sticky = new Sticky(string, (Object)string2);
                sticky.save();
                sticky.setLocation(n2, n3);
                sticky.setPreferredSize(new Dimension(n4, n5));
                sticky.pack();
                sticky.setVisible(true);
                sticky.toFront();
                sticky.requestFocus();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected static void exportHTML() {
        if (ComponentUtility.hasComponent((String)"html")) {
            HTMLObject hTMLObject = new HTMLObject();
            hTMLObject.setTitle(Language.get((String)"sticky", (String)"sticky"));
            hTMLObject.addHeadings((Object[])new String[]{Language.get((String)"sticky", (String)"sticky")});
            NodeList nodeList = StickyXMLUtility.getNodeList();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element = (Element)nodeList.item(i);
                Input input = new Input(StickyXMLUtility.getInputName(element), (Object)StickyXMLUtility.getInputValue(element));
                hTMLObject.addData(new Object[]{hTMLObject.createDataElement(input.getXMLValue(), input.getMimeType())});
            }
            hTMLObject.promptToSave("sticky.htm");
        }
    }
}

