/*
 * Decompiled with CFR 0.152.
 */
package com.sparework.kronos.components.sticky;

import com.sparework.kronos.Configuration;
import com.sparework.kronos.KronosUI;
import com.sparework.kronos.Language;
import com.sparework.kronos.components.ComponentUtility;
import com.sparework.kronos.components.html.HTMLMenu;
import com.sparework.kronos.components.sticky.Sticky;
import com.sparework.kronos.components.sticky.StickyTimer;
import com.sparework.kronos.components.sticky.StickyUtility;
import com.sparework.kronos.inputs.Input;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;

public class StickyMenu {
    private JTextField minuteText;

    public StickyMenu() {
        ComponentUtility.addDocument((String)"sticky.xml");
        StickyUtility.openAll();
        if (ComponentUtility.hasComponent((String)"html")) {
            HTMLMenu.addToMenu((JMenuItem)this.getHTMLMenu());
        }
        KronosUI.addToFileMenu(null);
        KronosUI.addToFileMenu((JComponent)StickyUtility.getMenu());
        JMenu jMenu = new JMenu(Language.get((String)"sticky", (String)"sticky"));
        jMenu.add(this.createTimerConfigMenuItem());
        KronosUI.addToConfigMenu(null);
        KronosUI.addToConfigMenu((JComponent)jMenu);
    }

    public static JMenuItem createStickyMenuItem() {
        String string = Language.get((String)"sticky", (String)"new");
        JMenuItem jMenuItem = new JMenuItem(Language.get((String)"sticky", (String)"makesticky"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JComponent jComponent = (JComponent)((JPopupMenu)((JMenuItem)actionEvent.getSource()).getParent()).getInvoker();
                while (!(jComponent instanceof Input)) {
                    jComponent = (JComponent)jComponent.getParent();
                }
                Sticky sticky = new Sticky(((Input)jComponent).getName(), ((Input)jComponent).getRawData());
                sticky.setLocationRelativeTo(jComponent);
                sticky.setPreferredSize(new Dimension(jComponent.getWidth(), jComponent.getHeight() + 30));
                sticky.pack();
                sticky.setVisible(true);
                sticky.toFront();
                sticky.requestFocus();
            }
        });
        return jMenuItem;
    }

    private JPanel createTimerConfigMenuItem() {
        int n = Integer.parseInt(Configuration.getConfig((String)"sticky:autosave", (String)"5"));
        StickyTimer.startTimer(n);
        this.minuteText = new JTextField();
        this.minuteText.setColumns(5);
        this.minuteText.setText(String.valueOf(n));
        this.minuteText.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                if (StickyMenu.this.minuteText.getText().matches("[1-9]+[0-9]*")) {
                    int n = Integer.parseInt(StickyMenu.this.minuteText.getText());
                    Configuration.setConfig((String)"sticky:autosave", (String)String.valueOf(n));
                    StickyTimer.cancelTimer();
                    if (n > 0) {
                        StickyTimer.startTimer(n);
                    }
                    KronosUI.setTaskBarText((String)Language.get((String)"kronos", (String)"configok"));
                } else {
                    StickyMenu.this.minuteText.setText(Configuration.getConfig((String)"sticky:autosave", (String)"5"));
                    KronosUI.setTaskBarText((String)(Language.get((String)"kronos", (String)"configerror") + " 1, 2, ..."));
                }
            }
        });
        JLabel jLabel = new JLabel("   " + Language.get((String)"sticky", (String)"autosave"));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(jLabel);
        jPanel.add(this.minuteText);
        return jPanel;
    }

    private JMenuItem getHTMLMenu() {
        JMenuItem jMenuItem = new JMenuItem(Language.get((String)"sticky", (String)"sticky"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StickyUtility.exportHTML();
            }
        });
        return jMenuItem;
    }
}

