/*
 * Decompiled with CFR 0.152.
 */
package com.sparework.kronos.components.sticky;

import com.sparework.kronos.Language;
import com.sparework.kronos.components.sticky.StickyUtility;
import com.sparework.kronos.inputs.Input;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;

class Sticky
extends JDialog {
    protected int x;
    protected int y;
    protected int width;
    protected int height;
    protected Input currentInput;

    public Sticky(String string) {
        super(new JFrame());
        this.setupDialog();
        this.setupInput(string, null);
        this.setupPopupMenu();
        this.setupLayout();
        StickyUtility.addToList(this);
    }

    public Sticky(String string, Object object) {
        super(new JFrame());
        this.setupDialog();
        this.setupInput(string, object);
        this.setupPopupMenu();
        this.setupLayout();
        StickyUtility.addToList(this);
    }

    protected void save() {
        this.currentInput.useInput(true);
    }

    private void setupLayout() {
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent componentEvent) {
                Sticky.this.x = Sticky.this.getX();
                Sticky.this.y = Sticky.this.getY();
                Sticky.this.width = Sticky.this.getWidth();
                Sticky.this.height = Sticky.this.getHeight();
                Sticky.this.removeComponentListener(this);
            }
        });
    }

    private void setupInput(String string, Object object) {
        this.currentInput = object == null ? new Input(string) : new Input(string, object);
        this.getContentPane().add((Component)this.currentInput);
    }

    private void setupDialog() {
        this.setUndecorated(true);
        this.getRootPane().setWindowDecorationStyle(2);
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Sticky.this.currentInput.useInput(false);
                StickyUtility.removeFromList((Sticky)windowEvent.getSource());
                StickyUtility.saveAll();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentMoved(ComponentEvent componentEvent) {
                Sticky.this.x = ((Window)componentEvent.getComponent()).getX();
                Sticky.this.y = ((Window)componentEvent.getComponent()).getY();
                Sticky.this.setLocation(Sticky.this.x, Sticky.this.y);
            }

            public void componentResized(ComponentEvent componentEvent) {
                Sticky.this.width = ((Window)componentEvent.getComponent()).getWidth();
                Sticky.this.height = ((Window)componentEvent.getComponent()).getHeight();
                Sticky.this.setPreferredSize(new Dimension(Sticky.this.width, Sticky.this.height));
            }
        });
    }

    private void setupPopupMenu() {
        JMenuItem jMenuItem = new JMenuItem(Language.get((String)"sticky", (String)"stick"));
        jMenuItem.setActionCommand("stick");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getActionCommand().equals("stick")) {
                    Sticky.this.setAlwaysOnTop(true);
                    ((JMenuItem)actionEvent.getSource()).setText(Language.get((String)"sticky", (String)"unstick"));
                    ((JMenuItem)actionEvent.getSource()).setActionCommand("unstick");
                } else {
                    Sticky.this.setAlwaysOnTop(false);
                    ((JMenuItem)actionEvent.getSource()).setText(Language.get((String)"sticky", (String)"stick"));
                    ((JMenuItem)actionEvent.getSource()).setActionCommand("stick");
                }
            }
        });
        JMenuItem jMenuItem2 = new JMenuItem(Language.get((String)"sticky", (String)"hide"));
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Sticky.this.setVisible(false);
            }
        });
        JPopupMenu jPopupMenu = this.currentInput.getComponentPopupMenu();
        jPopupMenu.removeAll();
        JMenu jMenu = StickyUtility.getMenu();
        MenuElement[] menuElementArray = jMenu.getPopupMenu().getSubElements();
        for (int i = 0; i < menuElementArray.length; ++i) {
            jPopupMenu.add((JMenuItem)menuElementArray[i]);
        }
        jPopupMenu.addSeparator();
        jPopupMenu.add(jMenuItem);
        jPopupMenu.add(jMenuItem2);
    }
}

