/*
 * Decompiled with CFR 0.152.
 */
package com.sparework.kronos.components.todo;

import com.sparework.kronos.components.ComponentUtility;
import com.sparework.kronos.inputs.Input;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class ToDoXMLUtility {
    public static String getGroup(Element element) {
        String string = element.getAttribute("group");
        return string.equals("") ? " " : string;
    }

    public static int getUrgency(Element element) {
        String string = element.getAttribute("urgency");
        return string.equals("") ? 0 : Integer.parseInt(string);
    }

    public static int getProgress(Element element) {
        String string = element.getAttribute("progress");
        return string.equals("") ? 0 : Integer.parseInt(string);
    }

    public static Integer getPriority(Element element) {
        String string = element.getAttribute("priority");
        return new Integer(string.equals("") ? "1" : string);
    }

    public static String getInputName(Element element) {
        String string = element.getAttribute("input");
        return string.equals("") ? "text" : string;
    }

    public static String getInputValue(Element element) {
        Text text = (Text)element.getFirstChild();
        return text == null ? " " : text.getNodeValue();
    }

    public static Element createXMLElement(String string, int n, String string2, int n2, Input input) {
        Document document = ComponentUtility.getDocument((String)"todo.xml");
        Element element = ComponentUtility.createElement((String)"todo.xml");
        element.setAttribute("group", string);
        element.setAttribute("urgency", String.valueOf(n));
        element.setAttribute("priority", string2);
        element.setAttribute("progress", String.valueOf(n2));
        element.setAttribute("input", input.getName());
        element.appendChild(document.createTextNode(input.getXMLValue()));
        return element;
    }

    public static int addXMLElement(Element element) {
        int n;
        Document document = ComponentUtility.getDocument((String)"todo.xml");
        NodeList nodeList = ComponentUtility.getNodeList((String)"todo.xml");
        int n2 = nodeList.getLength();
        String string = element.getAttribute("group");
        int n3 = Integer.parseInt(element.getAttribute("urgency"));
        int n4 = Integer.parseInt(element.getAttribute("priority"));
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        for (n = 0; n < n2; ++n) {
            Element element2 = (Element)nodeList.item(n);
            if (element2.getAttribute("group").equals(string)) {
                bl = true;
                int n5 = Integer.parseInt(element2.getAttribute("urgency"));
                if (n3 == n5) {
                    bl2 = true;
                    int n6 = Integer.parseInt(element2.getAttribute("priority"));
                    if (n4 == n6) {
                        bl3 = true;
                        continue;
                    }
                    if (!bl3 && n4 >= n6) continue;
                    break;
                }
                if (!bl2 && n3 >= n5) continue;
                break;
            }
            if (bl) break;
        }
        if (n2 == 0 || n == n2) {
            document.getDocumentElement().appendChild(element);
            document.getDocumentElement().appendChild(document.createTextNode("\n"));
        } else {
            document.getDocumentElement().insertBefore(element, nodeList.item(n));
            document.getDocumentElement().insertBefore(document.createTextNode("\n"), nodeList.item(n + 1));
        }
        ComponentUtility.saveDocument((String)"todo.xml");
        return n;
    }

    public static int addXMLElement(Element element, int n) {
        int n2;
        Document document = ComponentUtility.getDocument((String)"todo.xml");
        NodeList nodeList = ComponentUtility.getNodeList((String)"todo.xml");
        int n3 = n2 = n == -1 ? nodeList.getLength() + 1 : n + 1;
        if (n > -1) {
            document.getDocumentElement().insertBefore(element, nodeList.item(n2 - 1));
            document.getDocumentElement().insertBefore(document.createTextNode("\n"), nodeList.item(n2));
        } else {
            document.getDocumentElement().appendChild(element);
            document.getDocumentElement().appendChild(document.createTextNode("\n"));
        }
        ComponentUtility.saveDocument((String)"todo.xml");
        return n2;
    }

    public static Element deleteXMLElement(int n) {
        Document document = ComponentUtility.getDocument((String)"todo.xml");
        Element element = (Element)ComponentUtility.getNodeList((String)"todo.xml").item(n);
        document.getDocumentElement().removeChild(element.getNextSibling());
        document.getDocumentElement().removeChild(element);
        ComponentUtility.saveDocument((String)"todo.xml");
        return element;
    }

    public static int deleteXMLElement(Element element) {
        int n;
        Document document = ComponentUtility.getDocument((String)"todo.xml");
        NodeList nodeList = ComponentUtility.getNodeList((String)"todo.xml");
        int n2 = nodeList.getLength();
        for (n = 0; n < n2 && !element.isEqualNode(nodeList.item(n)); ++n) {
        }
        document.getDocumentElement().removeChild(nodeList.item(n).getNextSibling());
        document.getDocumentElement().removeChild(nodeList.item(n));
        ComponentUtility.saveDocument((String)"todo.xml");
        return n;
    }

    public static NodeList getNodeList() {
        return ComponentUtility.getNodeList((String)"todo.xml");
    }
}

