/*
 * Decompiled with CFR 0.152.
 */
package com.sparework.kronos.components.todo;

import com.sparework.kronos.Configuration;
import com.sparework.kronos.KronosUI;
import com.sparework.kronos.Language;
import com.sparework.kronos.components.ComponentUtility;
import com.sparework.kronos.components.TabsListCellRenderer;
import com.sparework.kronos.components.sticky.StickyMenu;
import com.sparework.kronos.components.todo.ToDoXMLUtility;
import com.sparework.kronos.inputs.Input;
import com.sparework.kronos.inputs.InputUtility;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JToolBar;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

class ToDoUtility
implements ActionListener {
    private Element xmlDelete;
    private JButton addButton;
    private JButton deleteButton;
    private JButton recoverButton;
    private JButton searchButton;
    private JButton changeButton;
    private JButton refreshButton;
    private JProgressBar todoProgressBar;
    private JList todoList;
    private DefaultListModel todoListModel;
    private Input currentInput = new Input("text");
    private Input deletedInput;
    private boolean show;
    private JSpinner todoPrioritySpinner;
    private JComboBox groupComboBox;
    private JComboBox urgencyComboBox;

    public ToDoUtility() {
        this.currentInput.addContainerListener((ContainerListener)new ContainerAdapter(){

            public void componentAdded(ContainerEvent containerEvent) {
                if (ToDoUtility.this.show) {
                    ToDoUtility.this.changeButton.setEnabled(true);
                    ToDoUtility.this.deleteButton.setEnabled(true);
                    ToDoUtility.this.searchButton.setEnabled(false);
                    ToDoUtility.this.recoverButton.setEnabled(false);
                    ToDoUtility.this.show = false;
                } else {
                    ToDoUtility.this.changeButton.setEnabled(false);
                    ToDoUtility.this.deleteButton.setEnabled(false);
                    ToDoUtility.this.searchButton.setEnabled(true);
                    if (ToDoUtility.this.xmlDelete != null) {
                        ToDoUtility.this.recoverButton.setEnabled(true);
                    }
                }
            }
        });
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.todoList.setValueIsAdjusting(true);
        String string = actionEvent.getActionCommand();
        this.deleteButton.setEnabled(false);
        if (string.equals("Add")) {
            this.addToDo();
        } else if (string.equals("Delete")) {
            this.recoverButton.setEnabled(true);
            this.deleteToDo();
        } else if (string.equals("Recover")) {
            this.recoverButton.setEnabled(false);
            this.recoverToDo();
        } else if (string.equals("Save")) {
            this.changeToDo();
        } else if (string.equals("Search")) {
            this.searchToDo();
        } else if (string.equals("Clear")) {
            this.resetInput();
            this.refreshList();
        }
        this.todoProgressBar.setValue(0);
        this.todoProgressBar.setString("0%");
        this.todoPrioritySpinner.setValue(1);
        this.urgencyComboBox.setSelectedIndex(-1);
        this.groupComboBox.setSelectedIndex(-1);
        this.todoList.setValueIsAdjusting(false);
    }

    private void addToDo() {
        if (!this.todoList.isSelectionEmpty()) {
            this.currentInput.setInput(this.currentInput.getName(), this.currentInput.getRawData());
        }
        if (this.groupComboBox.getSelectedIndex() == -1 || this.urgencyComboBox.getSelectedIndex() == -1) {
            return;
        }
        Element element = ToDoXMLUtility.createXMLElement(this.groupComboBox.getSelectedItem().toString(), this.urgencyComboBox.getSelectedIndex(), this.todoPrioritySpinner.getValue().toString(), this.todoProgressBar.getValue(), this.currentInput);
        this.currentInput.useInput(true);
        int n = ToDoXMLUtility.addXMLElement(element);
        this.resetInput();
        this.refreshList();
        this.todoList.ensureIndexIsVisible(n);
    }

    private void deleteToDo() {
        this.xmlDelete = ToDoXMLUtility.deleteXMLElement(this.todoList.getSelectedIndex());
        this.deletedInput = new Input(this.currentInput.getName(), (Object)this.currentInput.getXMLValue());
        this.currentInput.useInput(false);
        this.resetInput();
        this.refreshList();
    }

    private void recoverToDo() {
        ToDoXMLUtility.addXMLElement(this.xmlDelete);
        this.deletedInput.useInput(true);
        Object object = this.currentInput.getRawData();
        this.refreshList();
        this.xmlDelete = null;
        this.currentInput.removeAll();
        this.currentInput.setInput(this.currentInput.getName(), object);
        this.currentInput.repaint();
        this.currentInput.revalidate();
    }

    private void changeToDo() {
        Element element = ToDoXMLUtility.deleteXMLElement(this.todoList.getSelectedIndex());
        element = ToDoXMLUtility.createXMLElement(this.groupComboBox.getSelectedItem().toString(), this.urgencyComboBox.getSelectedIndex(), this.todoPrioritySpinner.getValue().toString(), this.todoProgressBar.getValue(), this.currentInput);
        this.currentInput.useInput(true);
        int n = ToDoXMLUtility.addXMLElement(element);
        this.resetInput();
        this.refreshList();
        this.todoList.ensureIndexIsVisible(n);
    }

    private void showToDo() {
        Element element = (Element)ToDoXMLUtility.getNodeList().item(this.todoList.getSelectedIndex());
        String string = ToDoXMLUtility.getGroup(element);
        this.groupComboBox.setSelectedItem(string);
        int n = ToDoXMLUtility.getUrgency(element);
        this.urgencyComboBox.setSelectedIndex(n);
        int n2 = ToDoXMLUtility.getProgress(element);
        this.todoProgressBar.setValue(n2);
        this.todoProgressBar.setString(n2 + "%");
        this.todoPrioritySpinner.setValue(ToDoXMLUtility.getPriority(element));
        this.currentInput.removeAll();
        this.currentInput.setInput(ToDoXMLUtility.getInputName(element), (Object)ToDoXMLUtility.getInputValue(element));
        this.currentInput.repaint();
        this.currentInput.revalidate();
    }

    private void searchToDo() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        NodeList nodeList = ToDoXMLUtility.getNodeList();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Element element = (Element)nodeList.item(i);
            if (!this.currentInput.isEqual(ToDoXMLUtility.getInputName(element), (Object)ToDoXMLUtility.getInputValue(element))) continue;
            arrayList.add(new Integer(i));
        }
        this.refreshList(arrayList);
    }

    private void resetInput() {
        this.show = false;
        this.currentInput.removeAll();
        this.currentInput.setInput(this.currentInput.getName(), null);
        this.currentInput.repaint();
        this.currentInput.revalidate();
    }

    private void refreshList() {
        this.todoListModel.clear();
        NodeList nodeList = ToDoXMLUtility.getNodeList();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Element element = (Element)nodeList.item(i);
            if (InputUtility.hasInput((String)ToDoXMLUtility.getInputName(element))) {
                Input input = new Input(ToDoXMLUtility.getInputName(element), (Object)ToDoXMLUtility.getInputValue(element));
                this.todoListModel.addElement(input.getListValue());
                continue;
            }
            this.todoListModel.addElement(null);
        }
    }

    protected void refreshList(ArrayList arrayList) {
        this.currentInput.removeAll();
        this.currentInput.setInput(this.currentInput.getName(), this.currentInput.getRawData());
        this.currentInput.repaint();
        this.currentInput.revalidate();
        this.todoListModel.clear();
        if (arrayList == null || arrayList.size() == 0) {
            return;
        }
        NodeList nodeList = ToDoXMLUtility.getNodeList();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Element element = (Element)nodeList.item(i);
            if (arrayList.contains(new Integer(i)) && InputUtility.hasInput((String)ToDoXMLUtility.getInputName(element))) {
                Input input = new Input(ToDoXMLUtility.getInputName(element), (Object)ToDoXMLUtility.getInputValue(element));
                this.todoListModel.addElement(input.getListValue());
                continue;
            }
            this.todoListModel.addElement(null);
        }
    }

    protected JPanel getToDoInputPane() {
        if (ComponentUtility.hasComponent((String)"sticky")) {
            this.currentInput.getComponentPopupMenu().add(StickyMenu.createStickyMenuItem());
        }
        return this.currentInput;
    }

    protected JPanel getProgressBar() {
        this.todoProgressBar = new JProgressBar();
        this.todoProgressBar.setString("0%");
        this.todoProgressBar.setStringPainted(true);
        this.todoProgressBar.setToolTipText(Language.get((String)"todo", (String)"drag"));
        this.todoProgressBar.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent mouseEvent) {
                int n = mouseEvent.getX() * 100 / ToDoUtility.this.todoProgressBar.getWidth() / 5 * 5;
                if (n < 0) {
                    n = 0;
                } else if (n > 100) {
                    n = 100;
                }
                ToDoUtility.this.todoProgressBar.setValue(n);
                ToDoUtility.this.todoProgressBar.setString(n + "%");
            }
        });
        return KronosUI.createLabelComponent((String)Language.get((String)"todo", (String)"progress"), (JComponent)this.todoProgressBar, (String)"West");
    }

    protected JPanel getGroupComboBox() {
        String string = Configuration.getConfig((String)"todo:groups", (String)"Home;Office;School;Shopping");
        this.groupComboBox = new JComboBox<String>(string.split(";"));
        this.groupComboBox.setSelectedIndex(-1);
        this.groupComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ToDoUtility.this.addButton.setEnabled(ToDoUtility.this.groupComboBox.getSelectedIndex() != -1 && ToDoUtility.this.urgencyComboBox.getSelectedIndex() != -1);
                if (!ToDoUtility.this.todoList.getValueIsAdjusting() && ToDoUtility.this.todoList.getSelectedIndex() == -1) {
                    ToDoUtility.this.urgencyComboBox.setSelectedIndex(-1);
                    ArrayList<Integer> arrayList = new ArrayList<Integer>();
                    NodeList nodeList = ToDoXMLUtility.getNodeList();
                    int n = nodeList.getLength();
                    for (int i = 0; i < n; ++i) {
                        Element element = (Element)nodeList.item(i);
                        String string = ToDoXMLUtility.getGroup(element);
                        Object object = ToDoUtility.this.groupComboBox.getSelectedItem();
                        if (ToDoUtility.this.groupComboBox.getSelectedIndex() <= -1 || !string.equals(object.toString())) continue;
                        arrayList.add(new Integer(i));
                    }
                    ToDoUtility.this.refreshList(arrayList);
                }
            }
        });
        return KronosUI.createLabelComponent((String)Language.get((String)"todo", (String)"groups"), (JComponent)this.groupComboBox, (String)"West");
    }

    protected JPanel getUrgencyComboBox() {
        this.urgencyComboBox = new JComboBox<String>(new String[]{Language.get((String)"todo", (String)"highurgency"), Language.get((String)"todo", (String)"mediumurgency"), Language.get((String)"todo", (String)"lowurgency"), Language.get((String)"todo", (String)"nourgency")});
        this.urgencyComboBox.setSelectedIndex(-1);
        this.urgencyComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ToDoUtility.this.addButton.setEnabled(ToDoUtility.this.groupComboBox.getSelectedIndex() != -1 && ToDoUtility.this.urgencyComboBox.getSelectedIndex() != -1);
                if (!ToDoUtility.this.todoList.getValueIsAdjusting() && ToDoUtility.this.todoList.getSelectedIndex() == -1) {
                    ArrayList<Integer> arrayList = new ArrayList<Integer>();
                    NodeList nodeList = ToDoXMLUtility.getNodeList();
                    int n = nodeList.getLength();
                    for (int i = 0; i < n; ++i) {
                        Element element = (Element)nodeList.item(i);
                        String string = ToDoXMLUtility.getGroup(element);
                        int n2 = ToDoXMLUtility.getUrgency(element);
                        Object object = ToDoUtility.this.groupComboBox.getSelectedItem();
                        int n3 = ToDoUtility.this.urgencyComboBox.getSelectedIndex();
                        if (ToDoUtility.this.groupComboBox.getSelectedIndex() <= -1 || !string.equals(object.toString()) || n2 != n3) continue;
                        arrayList.add(new Integer(i));
                    }
                    ToDoUtility.this.refreshList(arrayList);
                }
            }
        });
        return KronosUI.createLabelComponent((String)Language.get((String)"todo", (String)"urgency"), (JComponent)this.urgencyComboBox, (String)"West");
    }

    protected JPanel getPrioritySpinner() {
        this.todoPrioritySpinner = new JSpinner(new SpinnerNumberModel(1, 1, 10, 1));
        this.todoPrioritySpinner.setValue(new Integer(1));
        return KronosUI.createLabelComponent((String)Language.get((String)"todo", (String)"priority"), (JComponent)this.todoPrioritySpinner, (String)"West");
    }

    protected JToolBar getButtonPane() {
        this.addButton = KronosUI.createButton((String)"images/add.png", (String)"Add", (String)Language.get((String)"kronos", (String)"add"), (ActionListener)this);
        this.addButton.setEnabled(false);
        this.deleteButton = KronosUI.createButton((String)"images/delete.png", (String)"Delete", (String)Language.get((String)"kronos", (String)"delete"), (ActionListener)this);
        this.deleteButton.setEnabled(false);
        this.changeButton = KronosUI.createButton((String)"images/save.png", (String)"Save", (String)Language.get((String)"kronos", (String)"save"), (ActionListener)this);
        this.changeButton.setEnabled(false);
        this.recoverButton = KronosUI.createButton((String)"images/recover.png", (String)"Recover", (String)Language.get((String)"kronos", (String)"recover"), (ActionListener)this);
        this.recoverButton.setEnabled(false);
        this.searchButton = KronosUI.createButton((String)"images/search.png", (String)"Search", (String)Language.get((String)"kronos", (String)"search"), (ActionListener)this);
        this.refreshButton = KronosUI.createButton((String)"images/new.png", (String)"Clear", (String)Language.get((String)"kronos", (String)"clear"), (ActionListener)this);
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        jToolBar.add(this.addButton);
        jToolBar.add(this.deleteButton);
        jToolBar.add(this.changeButton);
        jToolBar.add(this.recoverButton);
        jToolBar.add(this.searchButton);
        jToolBar.add(this.refreshButton);
        jToolBar.add(Box.createHorizontalGlue());
        return jToolBar;
    }

    protected JScrollPane getToDoListScroll() {
        this.todoListModel = new DefaultListModel();
        this.refreshList();
        this.todoList = new JList(this.todoListModel);
        this.todoList.setSelectionMode(0);
        this.todoList.setCellRenderer(new TabsListCellRenderer());
        this.todoList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting() && ToDoUtility.this.todoList.getSelectedIndex() > -1) {
                    ToDoUtility.this.show = true;
                    ToDoUtility.this.showToDo();
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.todoList, 20, 30);
        jScrollPane.setPreferredSize(new Dimension(1, 100));
        return jScrollPane;
    }
}

