/*
 * Decompiled with CFR 0.152.
 */
package com.sparework.kronos.components.todo;

import com.sparework.kronos.Configuration;
import com.sparework.kronos.KronosUI;
import com.sparework.kronos.Language;
import com.sparework.kronos.components.ComponentUtility;
import com.sparework.kronos.components.todo.ToDoSharedUtility;
import com.sparework.kronos.components.todo.ToDoUtility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;

public class ToDoTab {
    protected static ToDoUtility todoUtil;
    private JPanel todoPane;
    private JTextField groupText;

    public ToDoTab() {
        ComponentUtility.addDocument((String)"todo.xml");
        todoUtil = new ToDoUtility();
        ToDoSharedUtility.setupHTMLMenu();
        JMenu jMenu = new JMenu(Language.get((String)"todo", (String)"todo"));
        jMenu.add(this.createGroupsTextField());
        KronosUI.addToConfigMenu(null);
        KronosUI.addToConfigMenu((JComponent)jMenu);
        JToggleButton jToggleButton = KronosUI.createNavButton((String)"todo", (String)"", (String)Language.get((String)"todo", (String)"todo"), (ActionListener)new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ToDoTab.this.todoPane == null) {
                    ToDoTab.this.setupLayout();
                }
                KronosUI.setContentPane((JComponent)ToDoTab.this.todoPane);
            }
        });
        KronosUI.addToNavPane((JToggleButton)jToggleButton);
    }

    private void setupLayout() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)todoUtil.getToDoInputPane(), "North");
        jPanel.add((Component)todoUtil.getButtonPane(), "South");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jPanel, "North");
        jPanel2.add((Component)todoUtil.getToDoListScroll(), "Center");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel3.add(todoUtil.getGroupComboBox());
        jPanel3.add(Box.createRigidArea(new Dimension(1, 10)));
        jPanel3.add(todoUtil.getUrgencyComboBox());
        jPanel3.add(Box.createRigidArea(new Dimension(1, 10)));
        jPanel3.add(todoUtil.getPrioritySpinner());
        jPanel3.add(Box.createRigidArea(new Dimension(1, 10)));
        jPanel3.add(todoUtil.getProgressBar());
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.add((Component)jPanel3, "North");
        jPanel4.setPreferredSize(new Dimension(220, 1));
        this.todoPane = new JPanel();
        this.todoPane.setLayout(new BorderLayout());
        this.todoPane.add((Component)jPanel2, "Center");
        this.todoPane.add((Component)jPanel4, "East");
    }

    private JPanel createGroupsTextField() {
        String string = Configuration.getConfig((String)"todo:groups", (String)"Home;Office;School;Shopping");
        this.groupText = new JTextField(string);
        this.groupText.setColumns(20);
        this.groupText.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                String string = ToDoTab.this.groupText.getText();
                if (string.matches("([\\w\\s]+[;]?)+")) {
                    Configuration.setConfig((String)"todo:groups", (String)string);
                    KronosUI.setTaskBarText((String)Language.get((String)"kronos", (String)"configok"));
                } else {
                    ToDoTab.this.groupText.setText(Configuration.getConfig((String)"todo:groups", (String)"Home;Office;School;Shopping"));
                    KronosUI.setTaskBarText((String)(Language.get((String)"kronos", (String)"configerror") + " group;group;..."));
                }
            }
        });
        JLabel jLabel = new JLabel("   " + Language.get((String)"todo", (String)"groups") + ": ");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(jLabel);
        jPanel.add(this.groupText);
        return jPanel;
    }
}

